# Data Retention System - User & Admin Guide

## 🔧 What Was Added

### 1. **"View My Data" Button** ✅
- Shows user's complete data summary
- Lists all data categories with record counts
- Displays retention periods and last update dates
- Shows total data size and account information

### 2. **Enhanced Export & Erasure** ✅
- Quick export buttons (Personal Data / Complete Data)
- Detailed erasure request form with category selection
- Real-time status updates and notifications

### 3. **Admin Management Panel** ✅
- Review and approve/reject erasure requests
- Monitor data exports across all users
- Search and filter capabilities
- Compliance guidelines and audit trails

---

## 👤 **USER GUIDE**

### How to Use as a Regular User

#### **Step 1: Access Your Data Dashboard**
```
Navigate to: /data-retention or click "My Data" in user menu
```

#### **Step 2: View Your Data Summary**
1. Click **"My Data"** tab
2. See your data breakdown:
   - **User Profiles**: Personal information (1 record)
   - **Property Views**: Viewing history (X records)
   - **Search History**: Search queries (X records) 
   - **Visit Schedules**: Property visits (X records)
3. Check total data size and retention periods

#### **Step 3: Export Your Data** 
1. In "My Data" section, find "Export My Data" card
2. Choose export type:
   - **"Export Personal Data"**: Basic profile info only
   - **"Export All Data"**: Complete data including activity logs
3. Click button → "Export request submitted! You will be notified when it's ready."
4. Check back later for download link (processing takes 1-5 minutes)

#### **Step 4: Request Data Erasure**
1. Click **"Request Erasure"** button
2. Choose erasure type:
   - **Partial**: Select specific categories to delete
   - **Complete**: Delete all data (account closure)
3. Select data categories (for partial erasure)
4. Provide reason (required): "No longer need this service"
5. Submit → "Erasure request submitted! It will be reviewed by our team."

#### **Step 5: Monitor Request Status**
- Erasure requests: Pending → Approved → Completed (3-7 days)
- Export requests: Processing → Completed (1-5 minutes)

---

## 👨‍💼 **ADMIN GUIDE**

### How to Use as an Administrator

#### **Step 1: Access Admin Panel**
```
Navigate to: /admin/data-retention (requires admin role)
```

#### **Step 2: Review Erasure Requests**
1. Click **"Erasure Requests"** tab
2. See pending requests with:
   - User ID (anonymized: 41c529de...)
   - Request type (partial/complete)
   - Data categories requested for deletion
   - Reason provided by user
   - Request date

#### **Step 3: Process Erasure Requests**
**For Each Request:**
1. **Review Details**: Click 👁️ to see full request
2. **Verify Legitimacy**: Check if reason is valid
3. **Check Legal Obligations**: Ensure no legal hold on data
4. **Take Action**:
   - ✅ **Approve**: Data will be automatically deleted
   - ❌ **Reject**: Provide reason to user
   
**Processing Timeline:**
- Review within 30 days (GDPR requirement)
- Approved requests auto-execute within 24 hours
- User gets email notification of decision

#### **Step 4: Monitor Data Exports**
1. Click **"Data Exports"** tab
2. Track export status:
   - **Pending**: Just submitted
   - **Processing**: Creating export file
   - **Completed**: Ready for download
   - **Failed**: Error occurred
3. Download exports for verification if needed

#### **Step 5: Use Admin Tools**
**Search & Filter:**
- Search by user ID or reason
- Filter by status (pending/approved/rejected)
- Sort by date or priority

**Bulk Actions:**
- Approve multiple requests
- Export admin reports
- Run data cleanup manually

---

## 📋 **WORKFLOW EXAMPLES**

### **User Workflow: Complete Data Export**
```
1. User clicks "Export All Data"
2. System creates background job
3. Collects: profiles + property views + search history + visits
4. Creates ZIP file with JSON data + README
5. User gets notification: "Export ready for download"
6. Download expires after 7 days
```

### **Admin Workflow: Erasure Request**
```
1. User submits erasure request for "search_history" 
2. Admin sees request in pending queue
3. Admin reviews: User reason = "Privacy concerns"
4. Admin approves request
5. System automatically deletes search_history records
6. User gets email: "Your data has been erased"
7. Admin logs action for compliance audit
```

### **Emergency Complete Erasure**
```
1. User requests complete account deletion
2. Admin verifies no legal holds (contracts, disputes)
3. Admin approves with 48-hour delay
4. System deletes: profiles, views, searches, visits, notifications
5. Keeps: transaction records (legal requirement)
6. User account marked as "erased" but not deleted
```

---

## 🔒 **COMPLIANCE FEATURES**

### **GDPR Compliance**
- ✅ Right to Access (View My Data)
- ✅ Right to Portability (Export Data) 
- ✅ Right to Erasure (Delete Data)
- ✅ Right to Rectification (Update Profile)
- ✅ 30-day response time tracking
- ✅ Audit logs for all actions

### **Data Retention Policies**
- User profiles: 7 years after account closure
- Property views: 6 months after last activity
- Search history: 3 months rolling window
- Visit schedules: 2 years for booking history

### **Security Measures**
- All exports encrypted and password protected
- Admin actions require two-factor authentication
- Data erasure is irreversible with confirmation steps
- Complete audit trail for compliance reporting

---

## 🚀 **QUICK START**

### **For Users:**
1. Go to "My Data" tab
2. Click "View My Data" to see what we have
3. Use "Export" or "Request Erasure" as needed

### **For Admins:**
1. Check pending requests daily
2. Approve legitimate erasure requests within 30 days
3. Monitor export success rates
4. Run monthly compliance reports

**Need Help?** Contact support with your request ID for assistance.