# Google Places API Integration Guide

## Overview
Google Places Autocomplete has been integrated into the Metro Projects, Infrastructure Projects, and Zoning Changes forms to automatically fill coordinates when typing location names.

## Setup Instructions

### 1. Environment Configuration
Make sure your `.env` file contains the Google Maps API key:
```
VITE_GOOGLE_MAPS_API_KEY=your_actual_google_maps_api_key_here
```

### 2. Google Cloud Console Setup
**CRITICAL: You must enable billing on your Google Cloud project for the API to work.**

1. **Enable Billing**: Go to Google Cloud Console → Billing → Link a billing account
2. **Enable APIs**: Enable these APIs in your project:
   - **Places API (New)** - Recommended for new projects
   - **Places API** - Legacy API (still works but deprecated)
   - **Maps JavaScript API** - For map display
   - **Geocoding API** - For coordinate conversion

### 3. API Key Restrictions (Recommended)
For security, restrict your API key to:
- **HTTP referrers**: Add your domain (e.g., `localhost:5173/*`, `yourdomain.com/*`)
- **API restrictions**: Enable only the required APIs listed above

### 4. Troubleshooting API Issues
If you see "BillingNotEnabledMapError" or "LegacyApiNotActivatedMapError":
1. **Enable billing** in Google Cloud Console
2. **Enable the Places API (New)** for better performance
3. **Wait 5-10 minutes** for changes to propagate
4. **Clear browser cache** and reload the page

## How It Works

### Metro Projects Form
- **Search Field**: "Search metro station..." 
- **Types**: Searches specifically for transit stations and subway stations
- **Auto-fill**: When you select a metro station, it automatically fills:
  - Project coordinates (lat/lng)
  - Project name (if empty)
  - City (if empty)

### Infrastructure Projects Form
- **Search Field**: "Search for project location..."
- **Types**: Searches for all types of places and addresses
- **Auto-fill**: When you select a location, it automatically fills:
  - Project coordinates (lat/lng)
  - Project name (if empty)
  - City (if empty)

### Zoning Changes Form
- **Search Field**: "Search for area location..."
- **Types**: Searches for all types of places and addresses
- **Auto-fill**: When you select a location, it automatically fills:
  - Area coordinates (lat/lng)
  - Area name (if empty)
  - City (if empty)

## Usage Instructions

1. **Open any of the three forms** (Metro Projects, Infrastructure Projects, or Zoning Changes)
2. **Click "Add" button** to open the form modal
3. **Start typing** in the search field at the top of the form
4. **Select from dropdown** - Google will show relevant suggestions
5. **Coordinates auto-fill** - The map location and coordinate fields will be automatically populated
6. **Complete the form** - Fill in remaining required fields and submit

## Features

- **Real-time search**: As you type, Google Places API provides live suggestions
- **Smart filtering**: Metro form searches specifically for transit stations
- **Automatic coordinate filling**: No need to manually set map coordinates
- **City detection**: Automatically extracts city from the selected address
- **Fallback support**: Manual coordinate selection still available via map picker

## Troubleshooting

### ⚠️ "BillingNotEnabledMapError" Error
**This is the most common issue!**
1. Go to Google Cloud Console → Billing
2. Link a valid billing account to your project
3. Wait 5-10 minutes for changes to take effect
4. Refresh the page

### ⚠️ "LegacyApiNotActivatedMapError" Error
1. Enable **Places API (New)** in Google Cloud Console
2. Keep the legacy **Places API** enabled for fallback
3. Wait for API activation (5-10 minutes)
4. Clear browser cache and reload

### Search not working?
1. Check if Google Maps API key is properly set in `.env`
2. Verify billing is enabled (most common issue)
3. Enable both Places API (New) and Places API (Legacy)
4. Check browser console for specific API errors
5. Ensure API key has proper domain restrictions

### Coordinates not updating?
1. Make sure you select an option from the dropdown (don't just type)
2. Check if the selected place has valid coordinates
3. Verify the map picker component is working
4. Look for API errors in browser console

### API quota exceeded?
1. Check your Google Cloud Console for API usage
2. Consider implementing request throttling
3. Review your API key restrictions
4. Upgrade your billing plan if needed

### Fallback Mode
If the API is unavailable, the component will show:
- Regular text input with manual entry
- Warning message about API unavailability
- You can still manually enter location names and use the map picker

## Technical Details

- **Component**: `PlacesAutocomplete.tsx`
- **Service**: Uses existing `googleMapsService` utility
- **Libraries**: Loads Google Maps with 'places' and 'geometry' libraries
- **Types**: Configurable search types (transit_station, establishment, geocode)
- **New API**: Attempts to use `PlaceAutocompleteElement` (recommended)
- **Fallback**: Falls back to legacy `Autocomplete` if new API unavailable
- **Error Handling**: Graceful fallback to manual input if API fails
- **Billing Check**: Shows helpful error messages for billing issues

## API Migration Notes

Google is migrating from the legacy Places API to the new Places API:
- **New API**: `google.maps.places.PlaceAutocompleteElement` (recommended)
- **Legacy API**: `google.maps.places.Autocomplete` (deprecated but still works)
- **Timeline**: Legacy API will be supported for at least 12 months
- **Benefits**: New API has better performance and features

The component automatically detects and uses the best available API.