# Security Incidents - Admin Dashboard Location

## ✅ Frontend Integration Complete

### Where to Find Security Incidents

**URL**: `http://localhost:5173/admin/dashboard/security`

**Navigation Path**:
1. Login as Admin
2. Go to Admin Dashboard
3. Click "Security & Audit" in sidebar
4. Click "Security Incidents" tab

### What You'll See

#### 1. **Statistics Cards** (Top of page)
- Total Incidents
- Active Incidents (red)
- Resolved Incidents (green)
- Last 24 Hours (orange)

#### 2. **Incidents Table**
Columns:
- **Type**: brute_force, unauthorized_access
- **Severity**: Critical, High, Medium, Low
- **Description**: What happened
- **IP Address**: Source of incident
- **Status**: Detected or Resolved
- **Date**: When it occurred
- **Actions**: Resolve button

### Features

✅ **Real-time Data**: Fetches from backend API
✅ **Color-coded Severity**: Visual indicators
✅ **One-click Resolve**: Mark incidents as resolved
✅ **Auto-refresh**: Updates when tab is selected
✅ **Responsive Design**: Works on all screen sizes

### Backend API Endpoints Used

```javascript
// Fetch incidents
GET http://localhost:8090/api/admin/security/incidents

// Get statistics
GET http://localhost:8090/api/admin/security/dashboard/stats

// Resolve incident
POST http://localhost:8090/api/admin/security/incidents/{id}/resolve
```

### Incident Types Displayed

1. **Brute Force Attacks**
   - Multiple failed login attempts
   - Account lockouts
   - Severity: High

2. **Unauthorized Access**
   - 401 (Unauthorized) responses
   - 403 (Forbidden) responses
   - Severity: Medium to High

### Testing

1. **Create Test Incident**:
   ```bash
   # Make unauthorized API call
   curl http://localhost:8090/api/properties
   ```

2. **View in Admin**:
   - Go to Security & Audit → Security Incidents tab
   - Should see the incident listed

3. **Resolve Incident**:
   - Click "Resolve" button
   - Status changes to "Resolved"
   - Moves to resolved count

### File Modified

**Frontend**: `src/components/admin-dashboard/SecurityAudit.tsx`
- Added "Security Incidents" tab
- Integrated API calls
- Added incident table with resolve functionality

### Status

✅ **COMPLETE** - Security incidents are now visible in admin dashboard at:
`http://localhost:5173/admin/dashboard/security` → "Security Incidents" tab
