# Seller Legal Health Reports - Frontend Implementation

## Overview
This feature allows sellers to manage legal health report requests from buyers, upload required documents, and track verification status.

## Pages Implemented

### 1. Legal Health Requests (`/seller/legal-health-requests`)
**Purpose**: Main dashboard showing all legal health report requests from buyers

**Features**:
- Stats cards: Total Requests, Pending Action, In Verification, Completed
- Filter buttons: All, Pending, In Progress, Completed
- Table view with columns: Property, Buyer, Request Date, Documents, Status, Action
- Status badges with icons: Pending Documents, Documents Submitted, Under Verification, Completed
- Click "View Details" to go to request details page

**Mock Data**: 3 sample requests with different statuses

---

### 2. Request Details (`/seller/legal-health-requests/:id`)
**Purpose**: Detailed view of a specific request with document upload functionality

**Features**:
- **Buyer Information Card**: Name, Email, Request Date
- **Required Documents Section**: 
  - 5 documents: Sale Deed, Title Deed, Tax Receipts, NOC Certificates, Encumbrance Certificate
  - Each document shows: Upload status (checkmark/clock icon), Status badge (Verified/Pending Review)
  - File upload input with Upload button for pending documents
  - View Document button for uploaded documents
- **Verification Team Notes**: Blue banner with messages from verification team
- **Verification Status Timeline**: 3-step progress (Request Received → Documents Upload → Verification)
- **Quick Actions**: Contact Verification Team, Download All Documents buttons

**Layout**: 2-column grid (main content + sidebar)

---

### 3. Verified Properties (`/seller/verified-properties`)
**Purpose**: List of properties that passed legal health verification with verified badge

**Features**:
- **Benefits Banner**: Green gradient banner explaining benefits of verified badge
  - Shows "Legal Health Verified" tag to buyers
  - Faster sales, Higher price, Transparency
- **Property Cards**: Each card shows:
  - Property title with Verified badge
  - Status badge (Active/Expiring Soon/Expired)
  - Report ID, Verified On date, Valid Until date
  - View Report button
  - Renew button (for expiring properties)
- **Empty State**: Shown when no verified properties exist

**Mock Data**: 2 sample verified properties

---

## Navigation Integration

### Sidebar Menu Item Added
- **Name**: "Legal Health Reports"
- **Icon**: Checkmark in circle (SVG)
- **Position**: After "Legal & Loan", before "Schedules"
- **File**: `src/components/seller-dashboard/src/components/Sidebar.tsx`

---

## Routes Added to App.tsx

```tsx
// Seller Legal Health Routes
/seller/legal-health-requests          → LegalHealthRequests
/seller/legal-health-requests/:id      → RequestDetails
/seller/verified-properties            → VerifiedProperties
```

---

## File Structure

```
src/pages/seller/legal-health/
├── LegalHealthRequests.tsx    (Main dashboard)
├── RequestDetails.tsx         (Document upload & tracking)
└── VerifiedProperties.tsx     (Verified properties list)
```

---

## UI Design Principles
- **Minimal & Compact**: Small boxes, tight spacing, clean layout
- **Visible Text**: All text in black/dark gray for readability
- **Status Indicators**: Color-coded badges with icons
- **Responsive Tables**: Horizontal scroll for mobile
- **Action-Oriented**: Clear CTAs (View Details, Upload, Contact Team)

---

## Status Types

### Request Status
- `pending_documents` → Yellow badge, Clock icon
- `documents_submitted` → Blue badge, Upload icon
- `under_verification` → Purple badge, FileText icon
- `completed` → Green badge, CheckCircle icon

### Document Status
- `verified` → Green badge
- `pending_review` → Yellow badge
- `rejected` → Red badge

### Property Verification Status
- `active` → Green badge
- `expiring_soon` → Yellow badge
- `expired` → Red badge

---

## Backend Integration (To Be Implemented)

### API Endpoints Needed
1. `GET /api/seller/legal-health-requests` - List all requests
2. `GET /api/seller/legal-health-requests/:id` - Get request details
3. `POST /api/seller/legal-health-requests/:id/upload` - Upload document
4. `GET /api/seller/verified-properties` - List verified properties
5. `POST /api/seller/verified-properties/:id/renew` - Renew verification

### Data Models
- LegalHealthRequest: id, property, buyer, status, documents, dates
- Document: id, type, file, status, upload_date
- VerifiedProperty: id, property, report_id, verified_date, expiry_date, status

---

## Next Steps (Backend)
1. Create database tables for legal health requests
2. Implement file upload API with S3/storage
3. Add notification system for new requests
4. Implement verification team workflow
5. Add email notifications for status changes
6. Create verified badge display on property listings
