# Tenant-Aware Navigation Flow Diagram

## System Architecture

```
┌─────────────────────────────────────────────────────────────────┐
│                     Browser Tab 1                                │
│  URL: /admin/dashboard?tenant=school-a                          │
│  Theme: Blue (#1E40AF)                                           │
│  sessionStorage: { tenant_theme_color: '#1E40AF' }              │
└─────────────────────────────────────────────────────────────────┘

┌─────────────────────────────────────────────────────────────────┐
│                     Browser Tab 2                                │
│  URL: /admin/dashboard?tenant=school-b                          │
│  Theme: Red (#DC2626)                                            │
│  sessionStorage: { tenant_theme_color: '#DC2626' }              │
└─────────────────────────────────────────────────────────────────┘
```

## Navigation Flow

```
┌──────────────────┐
│  User Opens URL  │
│  ?tenant=abc     │
└────────┬─────────┘
         │
         ▼
┌──────────────────────────────┐
│  AdminDashboard Component    │
│  - Reads URL parameter       │
│  - Calls loadTenantTheme()   │
└────────┬─────────────────────┘
         │
         ▼
┌──────────────────────────────┐
│  Fetch Tenant Config         │
│  GET /api/admin/config/      │
│  tenants?tenant=abc          │
└────────┬─────────────────────┘
         │
         ▼
┌──────────────────────────────┐
│  Apply Theme                 │
│  - Set CSS variable          │
│  - Save to sessionStorage    │
│  - Update document.title     │
└────────┬─────────────────────┘
         │
         ▼
┌──────────────────────────────┐
│  User Clicks Sidebar Link    │
│  (e.g., "Properties")        │
└────────┬─────────────────────┘
         │
         ▼
┌──────────────────────────────┐
│  getTenantAwareHref()        │
│  - Reads current URL         │
│  - Extracts tenant param     │
│  - Appends to new path       │
└────────┬─────────────────────┘
         │
         ▼
┌──────────────────────────────┐
│  Navigate to New Path        │
│  /properties?tenant=abc      │
└────────┬─────────────────────┘
         │
         ▼
┌──────────────────────────────┐
│  Theme Reloads               │
│  (useEffect triggered)       │
└──────────────────────────────┘
```

## Tab Switching Flow

```
┌─────────────────────────────────────────────────────────────┐
│                    User Switches Tabs                        │
└────────┬────────────────────────────────────────────────────┘
         │
         ▼
┌─────────────────────────────────────────────────────────────┐
│  visibilitychange Event Fired                                │
│  document.hidden = false                                     │
└────────┬────────────────────────────────────────────────────┘
         │
         ▼
┌─────────────────────────────────────────────────────────────┐
│  loadTenantTheme() Called                                    │
│  - Reads URL parameter from current tab                      │
│  - Fetches tenant config                                     │
└────────┬────────────────────────────────────────────────────┘
         │
         ▼
┌─────────────────────────────────────────────────────────────┐
│  Apply Theme for Current Tab                                 │
│  - Updates CSS variables                                     │
│  - Reads from tab's sessionStorage                           │
│  - Updates document.title                                    │
└─────────────────────────────────────────────────────────────┘
```

## Component Interaction

```
┌─────────────────────────────────────────────────────────────┐
│                    tenantNavigation.ts                       │
│  ┌─────────────────────────────────────────────────────┐   │
│  │  getTenantAwareHref(path)                           │   │
│  │  - Reads window.location.search                     │   │
│  │  - Extracts tenant parameter                        │   │
│  │  - Returns path with tenant param                   │   │
│  └─────────────────────────────────────────────────────┘   │
└────────────────────────┬────────────────────────────────────┘
                         │
                         │ Used by
                         │
         ┌───────────────┼───────────────┐
         │               │               │
         ▼               ▼               ▼
┌────────────────┐ ┌────────────┐ ┌──────────────┐
│   Sidebar.tsx  │ │ Header.tsx │ │ Any Component│
│                │ │            │ │              │
│ handleNav()    │ │ navigate() │ │ navigate()   │
│ uses utility   │ │ uses util  │ │ uses utility │
└────────────────┘ └────────────┘ └──────────────┘
```

## Storage Strategy

```
┌─────────────────────────────────────────────────────────────┐
│                    localStorage                              │
│  ❌ Shared across all tabs                                   │
│  ❌ Causes theme interference                                │
│  ❌ Tab 1 changes affect Tab 2                               │
└─────────────────────────────────────────────────────────────┘

┌─────────────────────────────────────────────────────────────┐
│                    sessionStorage                            │
│  ✅ Isolated per tab                                         │
│  ✅ No cross-tab interference                                │
│  ✅ Each tab maintains its own theme                         │
│  ✅ Automatically cleared on tab close                       │
└─────────────────────────────────────────────────────────────┘
```

## Event Listeners

```
┌─────────────────────────────────────────────────────────────┐
│  Event: visibilitychange                                     │
│  Trigger: User switches to this tab                          │
│  Action: Reload tenant theme for current tab                 │
└─────────────────────────────────────────────────────────────┘

┌─────────────────────────────────────────────────────────────┐
│  Event: popstate                                             │
│  Trigger: Browser back/forward button                        │
│  Action: Reload tenant theme for new URL                     │
└─────────────────────────────────────────────────────────────┘

┌─────────────────────────────────────────────────────────────┐
│  Event: location.pathname change                             │
│  Trigger: Navigation to new page                             │
│  Action: Reload tenant theme                                 │
└─────────────────────────────────────────────────────────────┘

┌─────────────────────────────────────────────────────────────┐
│  Event: location.search change                               │
│  Trigger: URL query parameters change                        │
│  Action: Reload tenant theme                                 │
└─────────────────────────────────────────────────────────────┘
```

## API Flow

```
┌─────────────────────────────────────────────────────────────┐
│  Step 1: Get All Tenants                                     │
│  GET /api/admin/configuration/tenants                        │
│  Response: { tenants: [...] }                                │
└────────┬────────────────────────────────────────────────────┘
         │
         ▼
┌─────────────────────────────────────────────────────────────┐
│  Step 2: Find Tenant by Parameter                            │
│  Match tenant.domain or tenant.name with URL param           │
└────────┬────────────────────────────────────────────────────┘
         │
         ▼
┌─────────────────────────────────────────────────────────────┐
│  Step 3: Get Tenant Config                                   │
│  GET /api/admin/configuration/tenants/{tenant_id}            │
│  Response: { configs: { theme_color, server_name, ... } }    │
└────────┬────────────────────────────────────────────────────┘
         │
         ▼
┌─────────────────────────────────────────────────────────────┐
│  Step 4: Apply Configuration                                 │
│  - document.documentElement.style.setProperty()              │
│  - sessionStorage.setItem()                                  │
│  - document.title = server_name                              │
└─────────────────────────────────────────────────────────────┘
```

## URL Examples

```
┌─────────────────────────────────────────────────────────────┐
│  Scenario 1: With Tenant                                     │
│  Input:  /admin/dashboard?tenant=school-a                    │
│  Click:  "Properties"                                        │
│  Output: /admin/dashboard/properties?tenant=school-a         │
└─────────────────────────────────────────────────────────────┘

┌─────────────────────────────────────────────────────────────┐
│  Scenario 2: Without Tenant                                  │
│  Input:  /admin/dashboard                                    │
│  Click:  "Properties"                                        │
│  Output: /admin/dashboard/properties                         │
└─────────────────────────────────────────────────────────────┘

┌─────────────────────────────────────────────────────────────┐
│  Scenario 3: With Existing Query Params                      │
│  Input:  /admin/dashboard?tenant=school-a                    │
│  Click:  "Users?page=2"                                      │
│  Output: /admin/dashboard/users?page=2&tenant=school-a       │
└─────────────────────────────────────────────────────────────┘
```

## Benefits Summary

```
┌─────────────────────────────────────────────────────────────┐
│  ✅ Automatic tenant parameter preservation                  │
│  ✅ No manual URL manipulation needed                        │
│  ✅ Tab-isolated theme colors                                │
│  ✅ Dynamic theme updates on tab switch                      │
│  ✅ Browser back/forward support                             │
│  ✅ Single source of truth (utility function)                │
│  ✅ Easy to maintain and extend                              │
│  ✅ No cross-tab interference                                │
└─────────────────────────────────────────────────────────────┘
```
