# API Contract Documentation

## Endpoints

### GET /api/banks/loan-rates
**Purpose**: Fetch bank loan rates by location
**Parameters**:
- `state` (optional): State name (e.g., "karnataka")
- `city` (optional): City name (e.g., "bangalore") 
- `loanAmount` (optional): Loan amount for personalized rates
- `tenure` (optional): Loan tenure in years

**Response**:
```json
{
  "success": true,
  "data": {
    "banks": [
      {
        "bankId": "sbi",
        "bankName": "State Bank of India",
        "logo": "https://example.com/sbi-logo.png",
        "rates": {
          "minRate": 8.50,
          "maxRate": 9.50,
          "rateByTenure": {
            "5": 8.50,
            "10": 8.70,
            "15": 8.90,
            "20": 9.10,
            "25": 9.30,
            "30": 9.50
          }
        },
        "processingFee": {
          "type": "percentage",
          "value": 0.35,
          "gst": true
        },
        "features": ["Low Processing Fee", "Quick Approval"],
        "eligibility": {
          "minAmount": 100000,
          "maxAmount": 50000000,
          "minTenure": 5,
          "maxTenure": 30
        }
      }
    ],
    "lastUpdated": "2024-01-15T10:00:00Z",
    "location": "Karnataka"
  }
}
```

### POST /api/banks/calculate-emi
**Purpose**: Calculate EMI for specific bank and loan details
**Request Body**:
```json
{
  "bankId": "sbi",
  "loanAmount": 5000000,
  "tenure": 20,
  "interestRate": 8.75
}
```

**Response**:
```json
{
  "success": true,
  "data": {
    "emi": 43289,
    "totalInterest": 5389360,
    "totalAmount": 10389360,
    "monthlyRate": 0.007292,
    "numPayments": 240
  }
}
```

### GET /api/banks/health
**Purpose**: Health check for bank service
**Response**: HTTP 200 OK

## Error Codes
- `400`: Bad Request - Invalid parameters
- `404`: Not Found - Bank not found
- `500`: Internal Server Error
- `503`: Service Unavailable - Bank service down

## Data Standards
- **Interest Rate**: 2 decimal precision (e.g., 8.75%)
- **Processing Fee**: "percentage" or "fixed" type
- **Tenure**: Always in years (5-30)
- **Amount**: In INR, minimum ₹1L, maximum ₹10Cr