import type IntWrapper from "./intWrapper";
import { type StreamMetadata } from "../metadata/tile/streamMetadataDecoder";
import BitVector from "../vector/flat/bitVector";
import { VectorType } from "../vector/vectorType";
import type GeometryScaling from "./geometryScaling";
export declare function decodeIntStream(data: Uint8Array, offset: IntWrapper, streamMetadata: StreamMetadata, isSigned: boolean, scalingData?: GeometryScaling, nullabilityBuffer?: BitVector): Int32Array;
export declare function decodeLengthStreamToOffsetBuffer(data: Uint8Array, offset: IntWrapper, streamMetadata: StreamMetadata): Uint32Array;
export declare function decodeConstIntStream(data: Uint8Array, offset: IntWrapper, streamMetadata: StreamMetadata, isSigned: boolean): number;
export declare function decodeSequenceIntStream(data: Uint8Array, offset: IntWrapper, streamMetadata: StreamMetadata): [baseValue: number, delta: number];
export declare function decodeSequenceLongStream(data: Uint8Array, offset: IntWrapper, streamMetadata: StreamMetadata): [baseValue: bigint, delta: bigint];
export declare function decodeLongStream(data: Uint8Array, offset: IntWrapper, streamMetadata: StreamMetadata, isSigned: boolean, nullabilityBuffer?: BitVector): BigInt64Array;
export declare function decodeLongFloat64Stream(data: Uint8Array, offset: IntWrapper, streamMetadata: StreamMetadata, isSigned: boolean): Float64Array;
export declare function decodeConstLongStream(data: Uint8Array, offset: IntWrapper, streamMetadata: StreamMetadata, isSigned: boolean): bigint;
export declare function decodeFloat64(values: Float64Array, streamMetadata: StreamMetadata, isSigned: boolean): Float64Array;
export declare function getVectorType(streamMetadata: StreamMetadata, sizeOrNullabilityBuffer: number | BitVector, data: Uint8Array, offset: IntWrapper): VectorType;
