import { IntFlatVector } from "./flat/intFlatVector";
import { DoubleFlatVector } from "./flat/doubleFlatVector";
import { IntSequenceVector } from "./sequence/intSequenceVector";
import { IntConstVector } from "./constant/intConstVector";
export default class FeatureTable {
    _name;
    _geometryVector;
    _idVector;
    _propertyVectors;
    _extent;
    propertyVectorsMap;
    constructor(_name, _geometryVector, _idVector, _propertyVectors, _extent = 4096) {
        this._name = _name;
        this._geometryVector = _geometryVector;
        this._idVector = _idVector;
        this._propertyVectors = _propertyVectors;
        this._extent = _extent;
    }
    get name() {
        return this._name;
    }
    get idVector() {
        return this._idVector;
    }
    get geometryVector() {
        return this._geometryVector;
    }
    get propertyVectors() {
        return this._propertyVectors;
    }
    getPropertyVector(name) {
        if (!this.propertyVectorsMap) {
            this.propertyVectorsMap = new Map(this._propertyVectors.map((vector) => [vector.name, vector]));
        }
        return this.propertyVectorsMap.get(name);
    }
    *[Symbol.iterator]() {
        const geometryIterator = this.geometryVector[Symbol.iterator]();
        let index = 0;
        while (index < this.numFeatures) {
            let id;
            if (this.idVector) {
                id = this.containsMaxSaveIntegerValues(this.idVector)
                    ? Number(this.idVector.getValue(index))
                    : this.idVector.getValue(index);
            }
            const geometry = geometryIterator?.next().value;
            const properties = {};
            for (const propertyColumn of this.propertyVectors) {
                if (!propertyColumn) {
                    continue;
                }
                const columnName = propertyColumn.name;
                const propertyValue = propertyColumn.getValue(index);
                if (propertyValue !== null) {
                    properties[columnName] = propertyValue;
                }
            }
            index++;
            yield { id, geometry, properties };
        }
    }
    get numFeatures() {
        return this.geometryVector.numGeometries;
    }
    get extent() {
        return this._extent;
    }
    /**
     * Returns all features as an array
     */
    getFeatures() {
        const features = [];
        const geometries = this.geometryVector.getGeometries();
        for (let i = 0; i < this.numFeatures; i++) {
            let id;
            if (this.idVector) {
                id = this.containsMaxSaveIntegerValues(this.idVector)
                    ? Number(this.idVector.getValue(i))
                    : this.idVector.getValue(i);
            }
            const geometry = {
                coordinates: geometries[i],
                type: this.geometryVector.geometryType(i),
            };
            const properties = {};
            for (const propertyColumn of this.propertyVectors) {
                if (!propertyColumn)
                    continue;
                const columnName = propertyColumn.name;
                const propertyValue = propertyColumn.getValue(i);
                if (propertyValue !== null) {
                    properties[columnName] = propertyValue;
                }
            }
            features.push({ id, geometry, properties });
        }
        return features;
    }
    containsMaxSaveIntegerValues(intVector) {
        return (intVector instanceof IntFlatVector ||
            (intVector instanceof IntConstVector && intVector instanceof IntSequenceVector) ||
            intVector instanceof DoubleFlatVector);
    }
}
//# sourceMappingURL=featureTable.js.map