import { GeometryVector, type MortonSettings } from "./geometryVector";
import type TopologyVector from "../../vector/geometry/topologyVector";
import { VertexBufferType } from "./vertexBufferType";
export declare function createConstGeometryVector(numGeometries: number, geometryType: number, topologyVector: TopologyVector, vertexOffsets: Int32Array, vertexBuffer: Int32Array): ConstGeometryVector;
export declare function createMortonEncodedConstGeometryVector(numGeometries: number, geometryType: number, topologyVector: TopologyVector, vertexOffsets: Int32Array, vertexBuffer: Int32Array, mortonInfo: MortonSettings): ConstGeometryVector;
export declare class ConstGeometryVector extends GeometryVector {
    private readonly _numGeometries;
    private readonly _geometryType;
    constructor(_numGeometries: number, _geometryType: number, vertexBufferType: VertexBufferType, topologyVector: TopologyVector, vertexOffsets: Int32Array, vertexBuffer: Int32Array, mortonSettings?: MortonSettings);
    geometryType(index: number): number;
    get numGeometries(): number;
    containsPolygonGeometry(): boolean;
    containsSingleGeometryType(): boolean;
}
