import { GeometryVector, type MortonSettings } from "./geometryVector";
import type TopologyVector from "../../vector/geometry/topologyVector";
import { VertexBufferType } from "./vertexBufferType";
export declare function createFlatGeometryVector(geometryTypes: Int32Array, topologyVector: TopologyVector, vertexOffsets: Int32Array, vertexBuffer: Int32Array): FlatGeometryVector;
export declare function createFlatGeometryVectorMortonEncoded(geometryTypes: Int32Array, topologyVector: TopologyVector, vertexOffsets: Int32Array, vertexBuffer: Int32Array, mortonInfo: MortonSettings): FlatGeometryVector;
export declare class FlatGeometryVector extends GeometryVector {
    private readonly _geometryTypes;
    constructor(vertexBufferType: VertexBufferType, _geometryTypes: Int32Array, topologyVector: TopologyVector, vertexOffsets: Int32Array, vertexBuffer: Int32Array, mortonSettings?: MortonSettings);
    geometryType(index: number): number;
    get numGeometries(): number;
    containsPolygonGeometry(): boolean;
    containsSingleGeometryType(): boolean;
}
