import type TopologyVector from "../../vector/geometry/topologyVector";
import { type GEOMETRY_TYPE } from "./geometryType";
import { type VertexBufferType } from "./vertexBufferType";
import type Point from "@mapbox/point-geometry";
export type CoordinatesArray = Array<Array<Point>>;
export type Geometry = {
    coordinates: CoordinatesArray;
    type: GEOMETRY_TYPE;
};
export interface MortonSettings {
    numBits: number;
    coordinateShift: number;
}
export declare abstract class GeometryVector implements Iterable<Geometry> {
    private readonly _vertexBufferType;
    private readonly _topologyVector;
    private readonly _vertexOffsets;
    private readonly _vertexBuffer;
    private readonly _mortonSettings?;
    protected constructor(_vertexBufferType: VertexBufferType, _topologyVector: TopologyVector, _vertexOffsets: Int32Array, _vertexBuffer: Int32Array, _mortonSettings?: MortonSettings);
    get vertexBufferType(): VertexBufferType;
    get topologyVector(): TopologyVector;
    get vertexOffsets(): Int32Array;
    get vertexBuffer(): Int32Array;
    [Symbol.iterator](): Iterator<Geometry>;
    getSimpleEncodedVertex(index: number): [number, number];
    getVertex(index: number): [number, number];
    getGeometries(): CoordinatesArray[];
    get mortonSettings(): MortonSettings | undefined;
    abstract containsPolygonGeometry(): boolean;
    abstract geometryType(index: number): number;
    abstract get numGeometries(): number;
    abstract containsSingleGeometryType(): boolean;
}
