import { type CoordinatesArray } from "./geometryVector";
import type TopologyVector from "./topologyVector";
export declare abstract class GpuVector implements Iterable<CoordinatesArray> {
    private readonly _triangleOffsets;
    private readonly _indexBuffer;
    private readonly _vertexBuffer;
    private readonly _topologyVector?;
    protected constructor(_triangleOffsets: Uint32Array, _indexBuffer: Int32Array, _vertexBuffer: Int32Array, _topologyVector?: TopologyVector | null);
    abstract geometryType(index: number): number;
    abstract get numGeometries(): number;
    abstract containsSingleGeometryType(): boolean;
    get triangleOffsets(): Uint32Array;
    get indexBuffer(): Int32Array;
    get vertexBuffer(): Int32Array;
    get topologyVector(): TopologyVector | null;
    /**
     * Returns geometries as coordinate arrays by extracting polygon outlines from topology.
     * The vertexBuffer contains the outline vertices, separate from the tessellated triangles.
     */
    getGeometries(): CoordinatesArray[];
    [Symbol.iterator](): Iterator<CoordinatesArray>;
}
