/**
 * @monogrid/gainmap-js v3.4.0
 * With ❤️, by MONOGRID <gainmap@monogrid.com>
 */
import{Q as e}from"./QuadRenderer-BoQMkXLf.js";import{c as t,L as r,e as n,X as i,G as s}from"./Loader-CKVwvejH.js";export{M as MPFExtractor,a as extractXMP}from"./Loader-CKVwvejH.js";import{ShaderMaterial as o,NoBlending as d,Vector3 as h,WebGLRenderer as f,FileLoader as m}from"three";class p extends o{_maxDisplayBoost;_hdrCapacityMin;_hdrCapacityMax;constructor({gamma:e,offsetHdr:a,offsetSdr:t,gainMapMin:r,gainMapMax:n,maxDisplayBoost:i,hdrCapacityMin:s,hdrCapacityMax:o,sdr:f,gainMap:m}){super({name:"GainMapDecoderMaterial",vertexShader:"\nvarying vec2 vUv;\n\nvoid main() {\n  vUv = uv;\n  gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);\n}\n",fragmentShader:"\n// min half float value\n#define HALF_FLOAT_MIN vec3( -65504, -65504, -65504 )\n// max half float value\n#define HALF_FLOAT_MAX vec3( 65504, 65504, 65504 )\n\nuniform sampler2D sdr;\nuniform sampler2D gainMap;\nuniform vec3 gamma;\nuniform vec3 offsetHdr;\nuniform vec3 offsetSdr;\nuniform vec3 gainMapMin;\nuniform vec3 gainMapMax;\nuniform float weightFactor;\n\nvarying vec2 vUv;\n\nvoid main() {\n  vec3 rgb = texture2D( sdr, vUv ).rgb;\n  vec3 recovery = texture2D( gainMap, vUv ).rgb;\n  vec3 logRecovery = pow( recovery, gamma );\n  vec3 logBoost = gainMapMin * ( 1.0 - logRecovery ) + gainMapMax * logRecovery;\n  vec3 hdrColor = (rgb + offsetSdr) * exp2( logBoost * weightFactor ) - offsetHdr;\n  vec3 clampedHdrColor = max( HALF_FLOAT_MIN, min( HALF_FLOAT_MAX, hdrColor ));\n  gl_FragColor = vec4( clampedHdrColor , 1.0 );\n}\n",uniforms:{sdr:{value:f},gainMap:{value:m},gamma:{value:new h(1/e[0],1/e[1],1/e[2])},offsetHdr:{value:(new h).fromArray(a)},offsetSdr:{value:(new h).fromArray(t)},gainMapMin:{value:(new h).fromArray(r)},gainMapMax:{value:(new h).fromArray(n)},weightFactor:{value:(Math.log2(i)-s)/(o-s)}},blending:d,depthTest:!1,depthWrite:!1}),this._maxDisplayBoost=i,this._hdrCapacityMin=s,this._hdrCapacityMax=o,this.needsUpdate=!0,this.uniformsNeedUpdate=!0}get sdr(){return this.uniforms.sdr.value}set sdr(e){this.uniforms.sdr.value=e}get gainMap(){return this.uniforms.gainMap.value}set gainMap(e){this.uniforms.gainMap.value=e}get offsetHdr(){return this.uniforms.offsetHdr.value.toArray()}set offsetHdr(e){this.uniforms.offsetHdr.value.fromArray(e)}get offsetSdr(){return this.uniforms.offsetSdr.value.toArray()}set offsetSdr(e){this.uniforms.offsetSdr.value.fromArray(e)}get gainMapMin(){return this.uniforms.gainMapMin.value.toArray()}set gainMapMin(e){this.uniforms.gainMapMin.value.fromArray(e)}get gainMapMax(){return this.uniforms.gainMapMax.value.toArray()}set gainMapMax(e){this.uniforms.gainMapMax.value.fromArray(e)}get gamma(){const e=this.uniforms.gamma.value;return[1/e.x,1/e.y,1/e.z]}set gamma(e){const a=this.uniforms.gamma.value;a.x=1/e[0],a.y=1/e[1],a.z=1/e[2]}get hdrCapacityMin(){return this._hdrCapacityMin}set hdrCapacityMin(e){this._hdrCapacityMin=e,this.calculateWeight()}get hdrCapacityMax(){return this._hdrCapacityMax}set hdrCapacityMax(e){this._hdrCapacityMax=e,this.calculateWeight()}get maxDisplayBoost(){return this._maxDisplayBoost}set maxDisplayBoost(e){this._maxDisplayBoost=Math.max(1,Math.min(65504,e)),this.calculateWeight()}calculateWeight(){const e=(Math.log2(this._maxDisplayBoost)-this._hdrCapacityMin)/(this._hdrCapacityMax-this._hdrCapacityMin);this.uniforms.weightFactor.value=Math.max(0,Math.min(1,e))}}const c=t({renderer:f,createMaterial:e=>new p(e),createQuadRenderer:a=>new e(a)}),l=e=>{if(!e.renderer)throw new Error("Renderer is required for decode function");const a=c({...e,renderer:e.renderer});try{a.render()}catch(e){throw a.disposeOnDemandRenderer(),e}return a};class u extends r{constructor(a,t){super({renderer:a,createMaterial:e=>new p(e),createQuadRenderer:a=>new e(a)},t)}async render(e,a,t,r){const{sdrImage:n,gainMapImage:i,needsFlip:s}=await this.processImages(t,r,"flipY"),{gainMap:o,sdr:d}=this.createTextures(n,i,s);this.updateQuadRenderer(e,n,o,d,a),e.render()}}class g extends u{load([e,a,t],r,n,i){const s=this.prepareQuadRenderer();let o,d,h;const f=async()=>{if(o&&d&&h){try{await this.render(s,h,o,d)}catch(r){return this.manager.itemError(e),this.manager.itemError(a),this.manager.itemError(t),"function"==typeof i&&i(r),void s.disposeOnDemandRenderer()}"function"==typeof r&&r(s),this.manager.itemEnd(e),this.manager.itemEnd(a),this.manager.itemEnd(t),s.disposeOnDemandRenderer()}};let p=!0,c=0,l=0,u=!0,g=0,M=0,y=!0,v=0,x=0;const w=()=>{if("function"==typeof n){n(new ProgressEvent("progress",{lengthComputable:p&&u&&y,loaded:l+M+x,total:c+g+v}))}};this.manager.itemStart(e),this.manager.itemStart(a),this.manager.itemStart(t);const C=new m(this._internalLoadingManager);C.setResponseType("arraybuffer"),C.setRequestHeader(this.requestHeader),C.setPath(this.path),C.setWithCredentials(this.withCredentials),C.load(e,async e=>{if("string"==typeof e)throw new Error("Invalid sdr buffer");o=e,await f()},e=>{p=e.lengthComputable,l=e.loaded,c=e.total,w()},a=>{this.manager.itemError(e),"function"==typeof i&&i(a)});const _=new m(this._internalLoadingManager);_.setResponseType("arraybuffer"),_.setRequestHeader(this.requestHeader),_.setPath(this.path),_.setWithCredentials(this.withCredentials),_.load(a,async e=>{if("string"==typeof e)throw new Error("Invalid gainmap buffer");d=e,await f()},e=>{u=e.lengthComputable,M=e.loaded,g=e.total,w()},e=>{this.manager.itemError(a),"function"==typeof i&&i(e)});const R=new m(this._internalLoadingManager);return R.setRequestHeader(this.requestHeader),R.setPath(this.path),R.setWithCredentials(this.withCredentials),R.load(t,async e=>{if("string"!=typeof e)throw new Error("Invalid metadata string");h=JSON.parse(e),await f()},e=>{y=e.lengthComputable,x=e.loaded,v=e.total,w()},e=>{this.manager.itemError(t),"function"==typeof i&&i(e)}),s}}class y extends u{load(e,a,t,r){const o=this.prepareQuadRenderer(),d=new m(this._internalLoadingManager);return d.setResponseType("arraybuffer"),d.setRequestHeader(this.requestHeader),d.setPath(this.path),d.setWithCredentials(this.withCredentials),this.manager.itemStart(e),d.load(e,async t=>{if("string"==typeof t)throw new Error("Invalid buffer, received [string], was expecting [ArrayBuffer]");const d=new Uint8Array(t);let h,f,m;try{const e=await n(d);h=e.sdr,f=e.gainMap,m=e.metadata}catch(a){if(!(a instanceof i||a instanceof s))throw a;console.warn(`Failure to reconstruct an HDR image from ${e}: Gain map metadata not found in the file, HDRJPGLoader will render the SDR jpeg`),m={gainMapMin:[0,0,0],gainMapMax:[1,1,1],gamma:[1,1,1],hdrCapacityMin:0,hdrCapacityMax:1,offsetHdr:[0,0,0],offsetSdr:[0,0,0]},h=d}try{await this.render(o,m,h.buffer,f?.buffer)}catch(a){return this.manager.itemError(e),"function"==typeof r&&r(a),void o.disposeOnDemandRenderer()}"function"==typeof a&&a(o),this.manager.itemEnd(e),o.disposeOnDemandRenderer()},t,a=>{this.manager.itemError(e),"function"==typeof r&&r(a)}),o}}export{p as GainMapDecoderMaterial,g as GainMapLoader,s as GainMapNotFoundError,y as HDRJPGLoader,y as JPEGRLoader,r as LoaderBaseShared,e as QuadRenderer,i as XMPMetadataNotFoundError,t as createDecodeFunction,l as decode,n as extractGainmapFromJPEG};
