/**
 * MapLibre GL JS
 * @license 3-Clause BSD. Full text of license: https://github.com/maplibre/maplibre-gl-js/blob/v5.17.0/LICENSE.txt
 */
var maplibregl=function(){"use strict";function e(e,t,r,n){return new(r||(r=Promise))((function(i,s){function o(e){try{l(n.next(e))}catch(e){s(e)}}function a(e){try{l(n.throw(e))}catch(e){s(e)}}function l(e){var t;e.done?i(e.value):(t=e.value,t instanceof r?t:new r((function(e){e(t)}))).then(o,a)}l((n=n.apply(e,t||[])).next())}))}function t(e,t){this.x=e,this.y=t}function r(e){return e&&e.__esModule&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e}var n,i;"function"==typeof SuppressedError&&SuppressedError,t.prototype={clone(){return new t(this.x,this.y)},add(e){return this.clone()._add(e)},sub(e){return this.clone()._sub(e)},multByPoint(e){return this.clone()._multByPoint(e)},divByPoint(e){return this.clone()._divByPoint(e)},mult(e){return this.clone()._mult(e)},div(e){return this.clone()._div(e)},rotate(e){return this.clone()._rotate(e)},rotateAround(e,t){return this.clone()._rotateAround(e,t)},matMult(e){return this.clone()._matMult(e)},unit(){return this.clone()._unit()},perp(){return this.clone()._perp()},round(){return this.clone()._round()},mag(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals(e){return this.x===e.x&&this.y===e.y},dist(e){return Math.sqrt(this.distSqr(e))},distSqr(e){const t=e.x-this.x,r=e.y-this.y;return t*t+r*r},angle(){return Math.atan2(this.y,this.x)},angleTo(e){return Math.atan2(this.y-e.y,this.x-e.x)},angleWith(e){return this.angleWithSep(e.x,e.y)},angleWithSep(e,t){return Math.atan2(this.x*t-this.y*e,this.x*e+this.y*t)},_matMult(e){const t=e[2]*this.x+e[3]*this.y;return this.x=e[0]*this.x+e[1]*this.y,this.y=t,this},_add(e){return this.x+=e.x,this.y+=e.y,this},_sub(e){return this.x-=e.x,this.y-=e.y,this},_mult(e){return this.x*=e,this.y*=e,this},_div(e){return this.x/=e,this.y/=e,this},_multByPoint(e){return this.x*=e.x,this.y*=e.y,this},_divByPoint(e){return this.x/=e.x,this.y/=e.y,this},_unit(){return this._div(this.mag()),this},_perp(){const e=this.y;return this.y=this.x,this.x=-e,this},_rotate(e){const t=Math.cos(e),r=Math.sin(e),n=r*this.x+t*this.y;return this.x=t*this.x-r*this.y,this.y=n,this},_rotateAround(e,t){const r=Math.cos(e),n=Math.sin(e),i=t.y+n*(this.x-t.x)+r*(this.y-t.y);return this.x=t.x+r*(this.x-t.x)-n*(this.y-t.y),this.y=i,this},_round(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this},constructor:t},t.convert=function(e){if(e instanceof t)return e;if(Array.isArray(e))return new t(+e[0],+e[1]);if(void 0!==e.x&&void 0!==e.y)return new t(+e.x,+e.y);throw new Error("Expected [x, y] or {x, y} point format")};var s=function(){if(i)return n;function e(e,t,r,n){this.cx=3*e,this.bx=3*(r-e)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*t,this.by=3*(n-t)-this.cy,this.ay=1-this.cy-this.by,this.p1x=e,this.p1y=t,this.p2x=r,this.p2y=n}return i=1,n=e,e.prototype={sampleCurveX:function(e){return((this.ax*e+this.bx)*e+this.cx)*e},sampleCurveY:function(e){return((this.ay*e+this.by)*e+this.cy)*e},sampleCurveDerivativeX:function(e){return(3*this.ax*e+2*this.bx)*e+this.cx},solveCurveX:function(e,t){if(void 0===t&&(t=1e-6),e<0)return 0;if(e>1)return 1;for(var r=e,n=0;n<8;n++){var i=this.sampleCurveX(r)-e;if(Math.abs(i)<t)return r;var s=this.sampleCurveDerivativeX(r);if(Math.abs(s)<1e-6)break;r-=i/s}var o=0,a=1;for(r=e,n=0;n<20&&(i=this.sampleCurveX(r),!(Math.abs(i-e)<t));n++)e>i?o=r:a=r,r=.5*(a-o)+o;return r},solve:function(e,t){return this.sampleCurveY(this.solveCurveX(e,t))}},n}(),o=r(s);let a,l;var u,c="undefined"!=typeof Float32Array?Float32Array:Array;function h(e,t,r){var n=t[0],i=t[1],s=t[2],o=t[3];return e[0]=r[0]*n+r[4]*i+r[8]*s+r[12]*o,e[1]=r[1]*n+r[5]*i+r[9]*s+r[13]*o,e[2]=r[2]*n+r[6]*i+r[10]*s+r[14]*o,e[3]=r[3]*n+r[7]*i+r[11]*s+r[15]*o,e}u=new c(4),c!=Float32Array&&(u[0]=0,u[1]=0,u[2]=0,u[3]=0);const p=8192;function f(e,t,r){return Math.min(r,Math.max(t,e))}function d(e,...t){for(const r of t)for(const t in r)e[t]=r[t];return e}function y(e,t,r){const n={};for(const r in e)n[r]=t.call(this,e[r],r,e);return n}function m(e){return Array.isArray(e)?e.map(m):"object"==typeof e&&e?y(e,m):e}new o(.25,.1,.25,1);const g={};function x(e){g[e]||("undefined"!=typeof console&&console.warn(e),g[e]=!0)}function v(e,t,r){return(r.y-e.y)*(t.x-e.x)>(t.y-e.y)*(r.x-e.x)}function b(e){return"undefined"!=typeof WorkerGlobalScope&&void 0!==e&&e instanceof WorkerGlobalScope}function w(e){return"undefined"!=typeof ImageBitmap&&e instanceof ImageBitmap}let _,S;function A(e,t,r,n){return e.addEventListener(t,r,n),{unsubscribe:()=>{e.removeEventListener(t,r,n)}}}function I(e){return e*Math.PI/180}class T{constructor(e,t,r){const n=this.cells=[];if(e instanceof ArrayBuffer){this.arrayBuffer=e;const i=new Int32Array(this.arrayBuffer);e=i[0],this.d=(t=i[1])+2*(r=i[2]);for(let e=0;e<this.d*this.d;e++){const t=i[3+e],r=i[3+e+1];n.push(t===r?null:i.subarray(t,r))}const s=i[3+n.length+1];this.keys=i.subarray(i[3+n.length],s),this.bboxes=i.subarray(s),this.insert=this._insertReadonly}else{this.d=t+2*r;for(let e=0;e<this.d*this.d;e++)n.push([]);this.keys=[],this.bboxes=[]}this.n=t,this.extent=e,this.padding=r,this.scale=t/e,this.uid=0;const i=r/t*e;this.min=-i,this.max=e+i}insert(e,t,r,n,i){this._forEachCell(t,r,n,i,this._insertCell,this.uid++,void 0,void 0),this.keys.push(e),this.bboxes.push(t),this.bboxes.push(r),this.bboxes.push(n),this.bboxes.push(i)}_insertReadonly(){throw new Error("Cannot insert into a GridIndex created from an ArrayBuffer.")}_insertCell(e,t,r,n,i,s){this.cells[i].push(s)}query(e,t,r,n,i){const s=this.min,o=this.max;if(e<=s&&t<=s&&o<=r&&o<=n&&!i)return Array.prototype.slice.call(this.keys);{const s=[];return this._forEachCell(e,t,r,n,this._queryCell,s,{},i),s}}_queryCell(e,t,r,n,i,s,o,a){const l=this.cells[i];if(null!==l){const i=this.keys,u=this.bboxes;for(let c=0;c<l.length;c++){const h=l[c];if(void 0===o[h]){const l=4*h;(a?a(u[l+0],u[l+1],u[l+2],u[l+3]):e<=u[l+2]&&t<=u[l+3]&&r>=u[l+0]&&n>=u[l+1])?(o[h]=!0,s.push(i[h])):o[h]=!1}}}}_forEachCell(e,t,r,n,i,s,o,a){const l=this._convertToCellCoord(e),u=this._convertToCellCoord(t),c=this._convertToCellCoord(r),h=this._convertToCellCoord(n);for(let p=l;p<=c;p++)for(let l=u;l<=h;l++){const u=this.d*l+p;if((!a||a(this._convertFromCellCoord(p),this._convertFromCellCoord(l),this._convertFromCellCoord(p+1),this._convertFromCellCoord(l+1)))&&i.call(this,e,t,r,n,u,s,o,a))return}}_convertFromCellCoord(e){return(e-this.padding)/this.scale}_convertToCellCoord(e){return Math.max(0,Math.min(this.d-1,Math.floor(e*this.scale)+this.padding))}toArrayBuffer(){if(this.arrayBuffer)return this.arrayBuffer;const e=this.cells,t=3+this.cells.length+1+1;let r=0;for(let e=0;e<this.cells.length;e++)r+=this.cells[e].length;const n=new Int32Array(t+r+this.keys.length+this.bboxes.length);n[0]=this.extent,n[1]=this.n,n[2]=this.padding;let i=t;for(let t=0;t<e.length;t++){const r=e[t];n[3+t]=i,n.set(r,i),i+=r.length}return n[3+e.length]=i,n.set(this.keys,i),i+=this.keys.length,n[3+e.length+1]=i,n.set(this.bboxes,i),i+=this.bboxes.length,n.buffer}static serialize(e,t){const r=e.toArrayBuffer();return t&&t.push(r),{buffer:r}}static deserialize(e){return new T(e.buffer)}}var k={$version:8,$root:{version:{required:!0,type:"enum",values:[8]},name:{type:"string"},metadata:{type:"*"},center:{type:"array",value:"number",length:2},centerAltitude:{type:"number"},zoom:{type:"number"},bearing:{type:"number",default:0,period:360,units:"degrees"},pitch:{type:"number",default:0,units:"degrees"},roll:{type:"number",default:0,units:"degrees"},state:{type:"state",default:{}},light:{type:"light"},sky:{type:"sky"},projection:{type:"projection"},terrain:{type:"terrain"},sources:{required:!0,type:"sources"},sprite:{type:"sprite"},glyphs:{type:"string"},"font-faces":{type:"fontFaces"},transition:{type:"transition"},layers:{required:!0,type:"array",value:"layer"}},sources:{"*":{type:"source"}},source:["source_vector","source_raster","source_raster_dem","source_geojson","source_video","source_image"],source_vector:{type:{required:!0,type:"enum",values:{vector:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},attribution:{type:"string"},promoteId:{type:"promoteId"},volatile:{type:"boolean",default:!1},encoding:{type:"enum",values:{mvt:{},mlt:{}},default:"mvt"},"*":{type:"*"}},source_raster:{type:{required:!0,type:"enum",values:{raster:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},attribution:{type:"string"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster_dem:{type:{required:!0,type:"enum",values:{"raster-dem":{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},attribution:{type:"string"},encoding:{type:"enum",values:{terrarium:{},mapbox:{},custom:{}},default:"mapbox"},redFactor:{type:"number",default:1},blueFactor:{type:"number",default:1},greenFactor:{type:"number",default:1},baseShift:{type:"number",default:0},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_geojson:{type:{required:!0,type:"enum",values:{geojson:{}}},data:{required:!0,type:"*"},maxzoom:{type:"number",default:18},attribution:{type:"string"},buffer:{type:"number",default:128,maximum:512,minimum:0},filter:{type:"filter"},tolerance:{type:"number",default:.375},cluster:{type:"boolean",default:!1},clusterRadius:{type:"number",default:50,minimum:0},clusterMaxZoom:{type:"number"},clusterMinPoints:{type:"number"},clusterProperties:{type:"*"},lineMetrics:{type:"boolean",default:!1},generateId:{type:"boolean",default:!1},promoteId:{type:"promoteId"}},source_video:{type:{required:!0,type:"enum",values:{video:{}}},urls:{required:!0,type:"array",value:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},source_image:{type:{required:!0,type:"enum",values:{image:{}}},url:{required:!0,type:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},layer:{id:{type:"string",required:!0},type:{type:"enum",values:{fill:{},line:{},symbol:{},circle:{},heatmap:{},"fill-extrusion":{},raster:{},hillshade:{},"color-relief":{},background:{}},required:!0},metadata:{type:"*"},source:{type:"string"},"source-layer":{type:"string"},minzoom:{type:"number",minimum:0,maximum:24},maxzoom:{type:"number",minimum:0,maximum:24},filter:{type:"filter"},layout:{type:"layout"},paint:{type:"paint"}},layout:["layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_symbol","layout_raster","layout_hillshade","layout_color-relief","layout_background"],layout_background:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible",expression:{interpolated:!1,parameters:["global-state"]},"property-type":"data-constant"}},layout_fill:{"fill-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible",expression:{interpolated:!1,parameters:["global-state"]},"property-type":"data-constant"}},layout_circle:{"circle-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible",expression:{interpolated:!1,parameters:["global-state"]},"property-type":"data-constant"}},layout_heatmap:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible",expression:{interpolated:!1,parameters:["global-state"]},"property-type":"data-constant"}},"layout_fill-extrusion":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible",expression:{interpolated:!1,parameters:["global-state"]},"property-type":"data-constant"}},layout_line:{"line-cap":{type:"enum",values:{butt:{},round:{},square:{}},default:"butt",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-join":{type:"enum",values:{bevel:{},round:{},miter:{}},default:"miter",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{type:"number",default:2,requires:[{"line-join":"miter"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-round-limit":{type:"number",default:1.05,requires:[{"line-join":"round"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible",expression:{interpolated:!1,parameters:["global-state"]},"property-type":"data-constant"}},layout_symbol:{"symbol-placement":{type:"enum",values:{point:{},line:{},"line-center":{}},default:"point",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-spacing":{type:"number",default:250,minimum:1,units:"pixels",requires:[{"symbol-placement":"line"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"symbol-avoid-edges":{type:"boolean",default:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{type:"enum",values:{auto:{},"viewport-y":{},source:{}},default:"auto",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-allow-overlap":{type:"boolean",default:!1,requires:["icon-image",{"!":"icon-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-ignore-placement":{type:"boolean",default:!1,requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-optional":{type:"boolean",default:!1,requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-rotation-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-size":{type:"number",default:1,minimum:0,units:"factor of the original icon size",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit":{type:"enum",values:{none:{},width:{},height:{},both:{}},default:"none",requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-text-fit-padding":{type:"array",value:"number",length:4,default:[0,0,0,0],units:"pixels",requires:["icon-image","text-field",{"icon-text-fit":["both","width","height"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-image":{type:"resolvedImage",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{type:"padding",default:[2],units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-keep-upright":{type:"boolean",default:!1,requires:["icon-image",{"icon-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-offset":{type:"array",value:"number",length:2,default:[0,0],requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotation-alignment":{type:"enum",values:{map:{},viewport:{},"viewport-glyph":{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-field":{type:"formatted",default:"",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-font":{type:"array",value:"string",default:["Open Sans Regular","Arial Unicode MS Regular"],requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-size":{type:"number",default:16,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-width":{type:"number",default:10,minimum:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{type:"number",default:1.2,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-letter-spacing":{type:"number",default:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-justify":{type:"enum",values:{auto:{},left:{},center:{},right:{}},default:"center",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{type:"number",units:"ems",default:0,requires:["text-field"],"property-type":"data-driven",expression:{interpolated:!0,parameters:["zoom","feature"]}},"text-variable-anchor":{type:"array",value:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-variable-anchor-offset":{type:"variableAnchorOffsetCollection",requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["text-field",{"!":"text-variable-anchor"}],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{type:"number",default:45,units:"degrees",requires:["text-field",{"symbol-placement":["line","line-center"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-writing-mode":{type:"array",value:"enum",values:{horizontal:{},vertical:{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-padding":{type:"number",default:2,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-keep-upright":{type:"boolean",default:!0,requires:["text-field",{"text-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-transform":{type:"enum",values:{none:{},uppercase:{},lowercase:{}},default:"none",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-offset":{type:"array",value:"number",units:"ems",length:2,default:[0,0],requires:["text-field",{"!":"text-radial-offset"}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{type:"boolean",default:!1,requires:["text-field",{"!":"text-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-ignore-placement":{type:"boolean",default:!1,requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-optional":{type:"boolean",default:!1,requires:["text-field","icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible",expression:{interpolated:!1,parameters:["global-state"]},"property-type":"data-constant"}},layout_raster:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible",expression:{interpolated:!1,parameters:["global-state"]},"property-type":"data-constant"}},layout_hillshade:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible",expression:{interpolated:!1,parameters:["global-state"]},"property-type":"data-constant"}},"layout_color-relief":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible",expression:{interpolated:!1,parameters:["global-state"]},"property-type":"data-constant"}},filter:{type:"boolean",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},filter_operator:{type:"enum",values:{"==":{},"!=":{},">":{},">=":{},"<":{},"<=":{},in:{},"!in":{},all:{},any:{},none:{},has:{},"!has":{}}},geometry_type:{type:"enum",values:{Point:{},LineString:{},Polygon:{}}},function:{expression:{type:"expression"},stops:{type:"array",value:"function_stop"},base:{type:"number",default:1,minimum:0},property:{type:"string",default:"$zoom"},type:{type:"enum",values:{identity:{},exponential:{},interval:{},categorical:{}},default:"exponential"},colorSpace:{type:"enum",values:{rgb:{},lab:{},hcl:{}},default:"rgb"},default:{type:"*",required:!1}},function_stop:{type:"array",minimum:0,maximum:24,value:["number","color"],length:2},expression:{type:"array",value:"expression_name",minimum:1},light:{anchor:{type:"enum",default:"viewport",values:{map:{},viewport:{}},"property-type":"data-constant",transition:!1,expression:{interpolated:!1,parameters:["zoom"]}},position:{type:"array",default:[1.15,210,30],length:3,value:"number","property-type":"data-constant",transition:!0,expression:{interpolated:!0,parameters:["zoom"]}},color:{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},intensity:{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},sky:{"sky-color":{type:"color","property-type":"data-constant",default:"#88C6FC",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-ground-blend":{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-fog-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"sky-horizon-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"atmosphere-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},terrain:{source:{type:"string",required:!0},exaggeration:{type:"number",minimum:0,default:1}},projection:{type:{type:"projectionDefinition",default:"mercator","property-type":"data-constant",transition:!1,expression:{interpolated:!0,parameters:["zoom"]}}},paint:["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_symbol","paint_raster","paint_hillshade","paint_color-relief","paint_background"],paint_fill:{"fill-antialias":{type:"boolean",default:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-outline-color":{type:"color",transition:!0,requires:[{"!":"fill-pattern"},{"fill-antialias":!0}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-extrusion-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-extrusion-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"fill-extrusion-height":{type:"number",default:0,minimum:0,units:"meters",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{type:"number",default:0,minimum:0,units:"meters",transition:!0,requires:["fill-extrusion-height"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-vertical-gradient":{type:"boolean",default:!0,transition:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_line:{"line-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"line-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["line-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-width":{type:"number",default:1,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-gap-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-offset":{type:"number",default:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-dasharray":{type:"array",value:"number",minimum:0,transition:!0,units:"line widths",requires:[{"!":"line-pattern"}],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"line-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"line-gradient":{type:"color",transition:!1,requires:[{"!":"line-dasharray"},{"!":"line-pattern"},{source:"geojson",has:{lineMetrics:!0}}],expression:{interpolated:!0,parameters:["line-progress"]},"property-type":"color-ramp"}},paint_circle:{"circle-radius":{type:"number",default:5,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-blur":{type:"number",default:0,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"circle-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["circle-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-scale":{type:"enum",values:{map:{},viewport:{}},default:"map",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-alignment":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-stroke-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"}},paint_heatmap:{"heatmap-radius":{type:"number",default:30,minimum:1,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-weight":{type:"number",default:1,minimum:0,transition:!1,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-intensity":{type:"number",default:1,minimum:0,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"heatmap-color":{type:"color",default:["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",.1,"royalblue",.3,"cyan",.5,"lime",.7,"yellow",1,"red"],transition:!1,expression:{interpolated:!0,parameters:["heatmap-density"]},"property-type":"color-ramp"},"heatmap-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_symbol:{"icon-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-color":{type:"color",default:"#000000",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["icon-image","icon-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-color":{type:"color",default:"#000000",transition:!0,overridable:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["text-field","text-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_raster:{"raster-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-hue-rotate":{type:"number",default:0,period:360,transition:!0,units:"degrees",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-min":{type:"number",default:0,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-max":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-saturation":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-contrast":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-resampling":{type:"enum",values:{linear:{},nearest:{}},default:"linear",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"raster-fade-duration":{type:"number",default:300,minimum:0,transition:!1,units:"milliseconds",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_hillshade:{"hillshade-illumination-direction":{type:"numberArray",default:335,minimum:0,maximum:359,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-altitude":{type:"numberArray",default:45,minimum:0,maximum:90,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-anchor":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-exaggeration":{type:"number",default:.5,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-shadow-color":{type:"colorArray",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-highlight-color":{type:"colorArray",default:"#FFFFFF",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-accent-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-method":{type:"enum",values:{standard:{},basic:{},combined:{},igor:{},multidirectional:{}},default:"standard",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},"paint_color-relief":{"color-relief-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"color-relief-color":{type:"color",transition:!1,expression:{interpolated:!0,parameters:["elevation"]},"property-type":"color-ramp"}},paint_background:{"background-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"background-pattern"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"background-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"background-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},transition:{duration:{type:"number",default:300,minimum:0,units:"milliseconds"},delay:{type:"number",default:0,minimum:0,units:"milliseconds"}},"property-type":{"data-driven":{type:"property-type"},"cross-faded":{type:"property-type"},"cross-faded-data-driven":{type:"property-type"},"color-ramp":{type:"property-type"},"data-constant":{type:"property-type"},constant:{type:"property-type"}},promoteId:{"*":{type:"string"}},interpolation:{type:"array",value:"interpolation_name",minimum:1},interpolation_name:{type:"enum",values:{linear:{syntax:{overloads:[{parameters:[],"output-type":"interpolation"}],parameters:[]}},exponential:{syntax:{overloads:[{parameters:["base"],"output-type":"interpolation"}],parameters:[{name:"base",type:"number literal"}]}},"cubic-bezier":{syntax:{overloads:[{parameters:["x1","y1","x2","y2"],"output-type":"interpolation"}],parameters:[{name:"x1",type:"number literal"},{name:"y1",type:"number literal"},{name:"x2",type:"number literal"},{name:"y2",type:"number literal"}]}}}}};const E=["type","source","source-layer","minzoom","maxzoom","filter","layout"];class M{constructor(e,t,r,n){this.message=(e?`${e}: `:"")+r,n&&(this.identifier=n),null!=t&&t.__line__&&(this.line=t.__line__)}}function D(e,...t){for(const r of t)for(const t in r)e[t]=r[t];return e}class P extends Error{constructor(e,t){super(t),this.message=t,this.key=e}}class z{constructor(e,t=[]){this.parent=e,this.bindings={};for(const[e,r]of t)this.bindings[e]=r}concat(e){return new z(this,e)}get(e){if(this.bindings[e])return this.bindings[e];if(this.parent)return this.parent.get(e);throw new Error(`${e} not found in scope.`)}has(e){return!!this.bindings[e]||!!this.parent&&this.parent.has(e)}}const F={kind:"null"},B={kind:"number"},C={kind:"string"},V={kind:"boolean"},L={kind:"color"},O={kind:"projectionDefinition"},R={kind:"object"},N={kind:"value"},$={kind:"collator"},U={kind:"formatted"},q={kind:"padding"},G={kind:"colorArray"},j={kind:"numberArray"},X={kind:"resolvedImage"},Y={kind:"variableAnchorOffsetCollection"};function Z(e,t){return{kind:"array",itemType:e,N:t}}function H(e){if("array"===e.kind){const t=H(e.itemType);return"number"==typeof e.N?`array<${t}, ${e.N}>`:"value"===e.itemType.kind?"array":`array<${t}>`}return e.kind}const W=[F,B,C,V,L,O,U,R,Z(N),q,j,G,X,Y];function J(e,t){if("error"===t.kind)return null;if("array"===e.kind){if("array"===t.kind&&(0===t.N&&"value"===t.itemType.kind||!J(e.itemType,t.itemType))&&("number"!=typeof e.N||e.N===t.N))return null}else{if(e.kind===t.kind)return null;if("value"===e.kind)for(const e of W)if(!J(e,t))return null}return`Expected ${H(e)} but found ${H(t)} instead.`}function K(e,t){return t.some((t=>t.kind===e.kind))}function Q(e,t){return t.some((t=>"null"===t?null===e:"array"===t?Array.isArray(e):"object"===t?e&&!Array.isArray(e)&&"object"==typeof e:t===typeof e))}function ee(e,t){return"array"===e.kind&&"array"===t.kind?e.itemType.kind===t.itemType.kind&&"number"==typeof e.N:e.kind===t.kind}const te=.96422,re=.82521,ne=4/29,ie=6/29,se=3*ie*ie,oe=ie*ie*ie,ae=Math.PI/180,le=180/Math.PI;function ue(e){return(e%=360)<0&&(e+=360),e}function ce([e,t,r,n]){let i,s;const o=pe((.2225045*(e=he(e))+.7168786*(t=he(t))+.0606169*(r=he(r)))/1);e===t&&t===r?i=s=o:(i=pe((.4360747*e+.3850649*t+.1430804*r)/te),s=pe((.0139322*e+.0971045*t+.7141733*r)/re));const a=116*o-16;return[a<0?0:a,500*(i-o),200*(o-s),n]}function he(e){return e<=.04045?e/12.92:Math.pow((e+.055)/1.055,2.4)}function pe(e){return e>oe?Math.pow(e,1/3):e/se+ne}function fe([e,t,r,n]){let i=(e+16)/116,s=isNaN(t)?i:i+t/500,o=isNaN(r)?i:i-r/200;return i=1*ye(i),s=te*ye(s),o=re*ye(o),[de(3.1338561*s-1.6168667*i-.4906146*o),de(-.9787684*s+1.9161415*i+.033454*o),de(.0719453*s-.2289914*i+1.4052427*o),n]}function de(e){return(e=e<=.00304?12.92*e:1.055*Math.pow(e,1/2.4)-.055)<0?0:e>1?1:e}function ye(e){return e>ie?e*e*e:se*(e-ne)}const me=Object.hasOwn||function(e,t){return Object.prototype.hasOwnProperty.call(e,t)};function ge(e,t){return me(e,t)?e[t]:void 0}function xe(e){return parseInt(e.padEnd(2,e),16)/255}function ve(e,t){return be(t?e/100:e,0,1)}function be(e,t,r){return Math.min(Math.max(t,e),r)}function we(e){return!e.some(Number.isNaN)}const _e={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]};function Se(e,t,r){return e+r*(t-e)}function Ae(e,t,r){return e.map(((e,n)=>Se(e,t[n],r)))}class Ie{constructor(e,t,r,n=1,i=!0){this.r=e,this.g=t,this.b=r,this.a=n,i||(this.r*=n,this.g*=n,this.b*=n,n||this.overwriteGetter("rgb",[e,t,r,n]))}static parse(e){if(e instanceof Ie)return e;if("string"!=typeof e)return;const t=function(e){if("transparent"===(e=e.toLowerCase().trim()))return[0,0,0,0];const t=ge(_e,e);if(t){const[e,r,n]=t;return[e/255,r/255,n/255,1]}if(e.startsWith("#")&&/^#(?:[0-9a-f]{3,4}|[0-9a-f]{6}|[0-9a-f]{8})$/.test(e)){const t=e.length<6?1:2;let r=1;return[xe(e.slice(r,r+=t)),xe(e.slice(r,r+=t)),xe(e.slice(r,r+=t)),xe(e.slice(r,r+t)||"ff")]}if(e.startsWith("rgb")){const t=e.match(/^rgba?\(\s*([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(t){const[e,r,n,i,s,o,a,l,u,c,h,p]=t,f=[i||" ",a||" ",c].join("");if("  "===f||"  /"===f||",,"===f||",,,"===f){const e=[n,o,u].join(""),t="%%%"===e?100:""===e?255:0;if(t){const e=[be(+r/t,0,1),be(+s/t,0,1),be(+l/t,0,1),h?ve(+h,p):1];if(we(e))return e}}return}}const r=e.match(/^hsla?\(\s*([\de.+-]+)(?:deg)?(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(r){const[e,t,n,i,s,o,a,l,u]=r,c=[n||" ",s||" ",a].join("");if("  "===c||"  /"===c||",,"===c||",,,"===c){const e=[+t,be(+i,0,100),be(+o,0,100),l?ve(+l,u):1];if(we(e))return function([e,t,r,n]){function i(n){const i=(n+e/30)%12,s=t*Math.min(r,1-r);return r-s*Math.max(-1,Math.min(i-3,9-i,1))}return e=ue(e),t/=100,r/=100,[i(0),i(8),i(4),n]}(e)}}}(e);return t?new Ie(...t,!1):void 0}get rgb(){const{r:e,g:t,b:r,a:n}=this,i=n||1/0;return this.overwriteGetter("rgb",[e/i,t/i,r/i,n])}get hcl(){return this.overwriteGetter("hcl",function(e){const[t,r,n,i]=ce(e),s=Math.sqrt(r*r+n*n);return[Math.round(1e4*s)?ue(Math.atan2(n,r)*le):NaN,s,t,i]}(this.rgb))}get lab(){return this.overwriteGetter("lab",ce(this.rgb))}overwriteGetter(e,t){return Object.defineProperty(this,e,{value:t}),t}toString(){const[e,t,r,n]=this.rgb;return`rgba(${[e,t,r].map((e=>Math.round(255*e))).join(",")},${n})`}static interpolate(e,t,r,n="rgb"){switch(n){case"rgb":{const[n,i,s,o]=Ae(e.rgb,t.rgb,r);return new Ie(n,i,s,o,!1)}case"hcl":{const[n,i,s,o]=e.hcl,[a,l,u,c]=t.hcl;let h,p;if(isNaN(n)||isNaN(a))isNaN(n)?isNaN(a)?h=NaN:(h=a,1!==s&&0!==s||(p=l)):(h=n,1!==u&&0!==u||(p=i));else{let e=a-n;a>n&&e>180?e-=360:a<n&&n-a>180&&(e+=360),h=n+r*e}const[f,d,y,m]=function([e,t,r,n]){return e=isNaN(e)?0:e*ae,fe([r,Math.cos(e)*t,Math.sin(e)*t,n])}([h,null!=p?p:Se(i,l,r),Se(s,u,r),Se(o,c,r)]);return new Ie(f,d,y,m,!1)}case"lab":{const[n,i,s,o]=fe(Ae(e.lab,t.lab,r));return new Ie(n,i,s,o,!1)}}}}Ie.black=new Ie(0,0,0,1),Ie.white=new Ie(1,1,1,1),Ie.transparent=new Ie(0,0,0,0),Ie.red=new Ie(1,0,0,1);class Te{constructor(e,t,r){this.sensitivity=e?t?"variant":"case":t?"accent":"base",this.locale=r,this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"})}compare(e,t){return this.collator.compare(e,t)}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale}}const ke=["bottom","center","top"];class Ee{constructor(e,t,r,n,i,s){this.text=e,this.image=t,this.scale=r,this.fontStack=n,this.textColor=i,this.verticalAlign=s}}class Me{constructor(e){this.sections=e}static fromString(e){return new Me([new Ee(e,null,null,null,null,null)])}isEmpty(){return 0===this.sections.length||!this.sections.some((e=>0!==e.text.length||e.image&&0!==e.image.name.length))}static factory(e){return e instanceof Me?e:Me.fromString(e)}toString(){return 0===this.sections.length?"":this.sections.map((e=>e.text)).join("")}}class De{constructor(e){this.values=e.slice()}static parse(e){if(e instanceof De)return e;if("number"==typeof e)return new De([e,e,e,e]);if(Array.isArray(e)&&!(e.length<1||e.length>4)){for(const t of e)if("number"!=typeof t)return;switch(e.length){case 1:e=[e[0],e[0],e[0],e[0]];break;case 2:e=[e[0],e[1],e[0],e[1]];break;case 3:e=[e[0],e[1],e[2],e[1]]}return new De(e)}}toString(){return JSON.stringify(this.values)}static interpolate(e,t,r){return new De(Ae(e.values,t.values,r))}}class Pe{constructor(e){this.values=e.slice()}static parse(e){if(e instanceof Pe)return e;if("number"==typeof e)return new Pe([e]);if(Array.isArray(e)){for(const t of e)if("number"!=typeof t)return;return new Pe(e)}}toString(){return JSON.stringify(this.values)}static interpolate(e,t,r){return new Pe(Ae(e.values,t.values,r))}}class ze{constructor(e){this.values=e.slice()}static parse(e){if(e instanceof ze)return e;if("string"==typeof e){const t=Ie.parse(e);if(!t)return;return new ze([t])}if(!Array.isArray(e))return;const t=[];for(const r of e){if("string"!=typeof r)return;const e=Ie.parse(r);if(!e)return;t.push(e)}return new ze(t)}toString(){return JSON.stringify(this.values)}static interpolate(e,t,r,n="rgb"){const i=[];if(e.values.length!=t.values.length)throw new Error(`colorArray: Arrays have mismatched length (${e.values.length} vs. ${t.values.length}), cannot interpolate.`);for(let s=0;s<e.values.length;s++)i.push(Ie.interpolate(e.values[s],t.values[s],r,n));return new ze(i)}}class Fe extends Error{constructor(e){super(e),this.name="RuntimeError"}toJSON(){return this.message}}const Be=new Set(["center","left","right","top","bottom","top-left","top-right","bottom-left","bottom-right"]);class Ce{constructor(e){this.values=e.slice()}static parse(e){if(e instanceof Ce)return e;if(Array.isArray(e)&&!(e.length<1)&&e.length%2==0){for(let t=0;t<e.length;t+=2){const r=e[t],n=e[t+1];if("string"!=typeof r||!Be.has(r))return;if(!Array.isArray(n)||2!==n.length||"number"!=typeof n[0]||"number"!=typeof n[1])return}return new Ce(e)}}toString(){return JSON.stringify(this.values)}static interpolate(e,t,r){const n=e.values,i=t.values;if(n.length!==i.length)throw new Fe(`Cannot interpolate values of different length. from: ${e.toString()}, to: ${t.toString()}`);const s=[];for(let e=0;e<n.length;e+=2){if(n[e]!==i[e])throw new Fe(`Cannot interpolate values containing mismatched anchors. from[${e}]: ${n[e]}, to[${e}]: ${i[e]}`);s.push(n[e]);const[t,o]=n[e+1],[a,l]=i[e+1];s.push([Se(t,a,r),Se(o,l,r)])}return new Ce(s)}}class Ve{constructor(e){this.name=e.name,this.available=e.available}toString(){return this.name}static fromString(e){return e?new Ve({name:e,available:!1}):null}}class Le{constructor(e,t,r){this.from=e,this.to=t,this.transition=r}static interpolate(e,t,r){return new Le(e,t,r)}static parse(e){return e instanceof Le?e:Array.isArray(e)&&3===e.length&&"string"==typeof e[0]&&"string"==typeof e[1]&&"number"==typeof e[2]?new Le(e[0],e[1],e[2]):"object"==typeof e&&"string"==typeof e.from&&"string"==typeof e.to&&"number"==typeof e.transition?new Le(e.from,e.to,e.transition):"string"==typeof e?new Le(e,e,1):void 0}}function Oe(e,t,r,n){return"number"==typeof e&&e>=0&&e<=255&&"number"==typeof t&&t>=0&&t<=255&&"number"==typeof r&&r>=0&&r<=255?void 0===n||"number"==typeof n&&n>=0&&n<=1?null:`Invalid rgba value [${[e,t,r,n].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof n?[e,t,r,n]:[e,t,r]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`}function Re(e){if(null===e||"string"==typeof e||"boolean"==typeof e||"number"==typeof e||e instanceof Le||e instanceof Ie||e instanceof Te||e instanceof Me||e instanceof De||e instanceof Pe||e instanceof ze||e instanceof Ce||e instanceof Ve)return!0;if(Array.isArray(e)){for(const t of e)if(!Re(t))return!1;return!0}if("object"==typeof e){for(const t in e)if(!Re(e[t]))return!1;return!0}return!1}function Ne(e){if(null===e)return F;if("string"==typeof e)return C;if("boolean"==typeof e)return V;if("number"==typeof e)return B;if(e instanceof Ie)return L;if(e instanceof Le)return O;if(e instanceof Te)return $;if(e instanceof Me)return U;if(e instanceof De)return q;if(e instanceof Pe)return j;if(e instanceof ze)return G;if(e instanceof Ce)return Y;if(e instanceof Ve)return X;if(Array.isArray(e)){const t=e.length;let r;for(const t of e){const e=Ne(t);if(r){if(r===e)continue;r=N;break}r=e}return Z(r||N,t)}return R}function $e(e){const t=typeof e;return null===e?"":"string"===t||"number"===t||"boolean"===t?String(e):e instanceof Ie||e instanceof Le||e instanceof Me||e instanceof De||e instanceof Pe||e instanceof ze||e instanceof Ce||e instanceof Ve?e.toString():JSON.stringify(e)}class Ue{constructor(e,t){this.type=e,this.value=t}static parse(e,t){if(2!==e.length)return t.error(`'literal' expression requires exactly one argument, but found ${e.length-1} instead.`);if(!Re(e[1]))return t.error("invalid value");const r=e[1];let n=Ne(r);const i=t.expectedType;return"array"!==n.kind||0!==n.N||!i||"array"!==i.kind||"number"==typeof i.N&&0!==i.N||(n=i),new Ue(n,r)}evaluate(){return this.value}eachChild(){}outputDefined(){return!0}}const qe={string:C,number:B,boolean:V,object:R};class Ge{constructor(e,t){this.type=e,this.args=t}static parse(e,t){if(e.length<2)return t.error("Expected at least one argument.");let r,n=1;const i=e[0];if("array"===i){let i,s;if(e.length>2){const r=e[1];if("string"!=typeof r||!(r in qe)||"object"===r)return t.error('The item type argument of "array" must be one of string, number, boolean',1);i=qe[r],n++}else i=N;if(e.length>3){if(null!==e[2]&&("number"!=typeof e[2]||e[2]<0||e[2]!==Math.floor(e[2])))return t.error('The length argument to "array" must be a positive integer literal',2);s=e[2],n++}r=Z(i,s)}else{if(!qe[i])throw new Error(`Types doesn't contain name = ${i}`);r=qe[i]}const s=[];for(;n<e.length;n++){const r=t.parse(e[n],n,N);if(!r)return null;s.push(r)}return new Ge(r,s)}evaluate(e){for(let t=0;t<this.args.length;t++){const r=this.args[t].evaluate(e);if(!J(this.type,Ne(r)))return r;if(t===this.args.length-1)throw new Fe(`Expected value to be of type ${H(this.type)}, but found ${H(Ne(r))} instead.`)}throw new Error}eachChild(e){this.args.forEach(e)}outputDefined(){return this.args.every((e=>e.outputDefined()))}}const je={"to-boolean":V,"to-color":L,"to-number":B,"to-string":C};class Xe{constructor(e,t){this.type=e,this.args=t}static parse(e,t){if(e.length<2)return t.error("Expected at least one argument.");const r=e[0];if(!je[r])throw new Error(`Can't parse ${r} as it is not part of the known types`);if(("to-boolean"===r||"to-string"===r)&&2!==e.length)return t.error("Expected one argument.");const n=je[r],i=[];for(let r=1;r<e.length;r++){const n=t.parse(e[r],r,N);if(!n)return null;i.push(n)}return new Xe(n,i)}evaluate(e){switch(this.type.kind){case"boolean":return Boolean(this.args[0].evaluate(e));case"color":{let t,r;for(const n of this.args){if(t=n.evaluate(e),r=null,t instanceof Ie)return t;if("string"==typeof t){const r=e.parseColor(t);if(r)return r}else if(Array.isArray(t)&&(r=t.length<3||t.length>4?`Invalid rgba value ${JSON.stringify(t)}: expected an array containing either three or four numeric values.`:Oe(t[0],t[1],t[2],t[3]),!r))return new Ie(t[0]/255,t[1]/255,t[2]/255,t[3])}throw new Fe(r||`Could not parse color from value '${"string"==typeof t?t:JSON.stringify(t)}'`)}case"padding":{let t;for(const r of this.args){t=r.evaluate(e);const n=De.parse(t);if(n)return n}throw new Fe(`Could not parse padding from value '${"string"==typeof t?t:JSON.stringify(t)}'`)}case"numberArray":{let t;for(const r of this.args){t=r.evaluate(e);const n=Pe.parse(t);if(n)return n}throw new Fe(`Could not parse numberArray from value '${"string"==typeof t?t:JSON.stringify(t)}'`)}case"colorArray":{let t;for(const r of this.args){t=r.evaluate(e);const n=ze.parse(t);if(n)return n}throw new Fe(`Could not parse colorArray from value '${"string"==typeof t?t:JSON.stringify(t)}'`)}case"variableAnchorOffsetCollection":{let t;for(const r of this.args){t=r.evaluate(e);const n=Ce.parse(t);if(n)return n}throw new Fe(`Could not parse variableAnchorOffsetCollection from value '${"string"==typeof t?t:JSON.stringify(t)}'`)}case"number":{let t=null;for(const r of this.args){if(t=r.evaluate(e),null===t)return 0;const n=Number(t);if(!isNaN(n))return n}throw new Fe(`Could not convert ${JSON.stringify(t)} to number.`)}case"formatted":return Me.fromString($e(this.args[0].evaluate(e)));case"resolvedImage":return Ve.fromString($e(this.args[0].evaluate(e)));case"projectionDefinition":return this.args[0].evaluate(e);default:return $e(this.args[0].evaluate(e))}}eachChild(e){this.args.forEach(e)}outputDefined(){return this.args.every((e=>e.outputDefined()))}}const Ye=["Unknown","Point","LineString","Polygon"];class Ze{constructor(){this.globals=null,this.feature=null,this.featureState=null,this.formattedSection=null,this._parseColorCache=new Map,this.availableImages=null,this.canonical=null}id(){return this.feature&&"id"in this.feature?this.feature.id:null}geometryType(){return this.feature?"number"==typeof this.feature.type?Ye[this.feature.type]:this.feature.type:null}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null}canonicalID(){return this.canonical}properties(){return this.feature&&this.feature.properties||{}}parseColor(e){let t=this._parseColorCache.get(e);return t||(t=Ie.parse(e),this._parseColorCache.set(e,t)),t}}class He{constructor(e,t,r=[],n,i=new z,s=[]){this.registry=e,this.path=r,this.key=r.map((e=>`[${e}]`)).join(""),this.scope=i,this.errors=s,this.expectedType=n,this._isConstant=t}parse(e,t,r,n,i={}){return t?this.concat(t,r,n)._parse(e,i):this._parse(e,i)}_parse(e,t){function r(e,t,r){return"assert"===r?new Ge(t,[e]):"coerce"===r?new Xe(t,[e]):e}if(null!==e&&"string"!=typeof e&&"boolean"!=typeof e&&"number"!=typeof e||(e=["literal",e]),Array.isArray(e)){if(0===e.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const n=e[0];if("string"!=typeof n)return this.error(`Expression name must be a string, but found ${typeof n} instead. If you wanted a literal array, use ["literal", [...]].`,0),null;const i=this.registry[n];if(i){let n=i.parse(e,this);if(!n)return null;if(this.expectedType){const e=this.expectedType,i=n.type;if("string"!==e.kind&&"number"!==e.kind&&"boolean"!==e.kind&&"object"!==e.kind&&"array"!==e.kind||"value"!==i.kind){if("projectionDefinition"===e.kind&&["string","array"].includes(i.kind)||["color","formatted","resolvedImage"].includes(e.kind)&&["value","string"].includes(i.kind)||["padding","numberArray"].includes(e.kind)&&["value","number","array"].includes(i.kind)||"colorArray"===e.kind&&["value","string","array"].includes(i.kind)||"variableAnchorOffsetCollection"===e.kind&&["value","array"].includes(i.kind))n=r(n,e,t.typeAnnotation||"coerce");else if(this.checkSubtype(e,i))return null}else n=r(n,e,t.typeAnnotation||"assert")}if(!(n instanceof Ue)&&"resolvedImage"!==n.type.kind&&this._isConstant(n)){const e=new Ze;try{n=new Ue(n.type,n.evaluate(e))}catch(e){return this.error(e.message),null}}return n}return this.error(`Unknown expression "${n}". If you wanted a literal array, use ["literal", [...]].`,0)}return this.error(void 0===e?"'undefined' value invalid. Use null instead.":"object"==typeof e?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof e} instead.`)}concat(e,t,r){const n="number"==typeof e?this.path.concat(e):this.path,i=r?this.scope.concat(r):this.scope;return new He(this.registry,this._isConstant,n,t||null,i,this.errors)}error(e,...t){const r=`${this.key}${t.map((e=>`[${e}]`)).join("")}`;this.errors.push(new P(r,e))}checkSubtype(e,t){const r=J(e,t);return r&&this.error(r),r}}class We{constructor(e,t){this.type=t.type,this.bindings=[].concat(e),this.result=t}evaluate(e){return this.result.evaluate(e)}eachChild(e){for(const t of this.bindings)e(t[1]);e(this.result)}static parse(e,t){if(e.length<4)return t.error(`Expected at least 3 arguments, but found ${e.length-1} instead.`);const r=[];for(let n=1;n<e.length-1;n+=2){const i=e[n];if("string"!=typeof i)return t.error(`Expected string, but found ${typeof i} instead.`,n);if(/[^a-zA-Z0-9_]/.test(i))return t.error("Variable names must contain only alphanumeric characters or '_'.",n);const s=t.parse(e[n+1],n+1);if(!s)return null;r.push([i,s])}const n=t.parse(e[e.length-1],e.length-1,t.expectedType,r);return n?new We(r,n):null}outputDefined(){return this.result.outputDefined()}}class Je{constructor(e,t){this.type=t.type,this.name=e,this.boundExpression=t}static parse(e,t){if(2!==e.length||"string"!=typeof e[1])return t.error("'var' expression requires exactly one string literal argument.");const r=e[1];return t.scope.has(r)?new Je(r,t.scope.get(r)):t.error(`Unknown variable "${r}". Make sure "${r}" has been bound in an enclosing "let" expression before using it.`,1)}evaluate(e){return this.boundExpression.evaluate(e)}eachChild(){}outputDefined(){return!1}}class Ke{constructor(e,t,r){this.type=e,this.index=t,this.input=r}static parse(e,t){if(3!==e.length)return t.error(`Expected 2 arguments, but found ${e.length-1} instead.`);const r=t.parse(e[1],1,B),n=t.parse(e[2],2,Z(t.expectedType||N));return r&&n?new Ke(n.type.itemType,r,n):null}evaluate(e){const t=this.index.evaluate(e),r=this.input.evaluate(e);if(t<0)throw new Fe(`Array index out of bounds: ${t} < 0.`);if(t>=r.length)throw new Fe(`Array index out of bounds: ${t} > ${r.length-1}.`);if(t!==Math.floor(t))throw new Fe(`Array index must be an integer, but found ${t} instead.`);return r[t]}eachChild(e){e(this.index),e(this.input)}outputDefined(){return!1}}class Qe{constructor(e,t){this.type=V,this.needle=e,this.haystack=t}static parse(e,t){if(3!==e.length)return t.error(`Expected 2 arguments, but found ${e.length-1} instead.`);const r=t.parse(e[1],1,N),n=t.parse(e[2],2,N);return r&&n?K(r.type,[V,C,B,F,N])?new Qe(r,n):t.error(`Expected first argument to be of type boolean, string, number or null, but found ${H(r.type)} instead`):null}evaluate(e){const t=this.needle.evaluate(e),r=this.haystack.evaluate(e);if(!r)return!1;if(!Q(t,["boolean","string","number","null"]))throw new Fe(`Expected first argument to be of type boolean, string, number or null, but found ${H(Ne(t))} instead.`);if(!Q(r,["string","array"]))throw new Fe(`Expected second argument to be of type array or string, but found ${H(Ne(r))} instead.`);return r.indexOf(t)>=0}eachChild(e){e(this.needle),e(this.haystack)}outputDefined(){return!0}}class et{constructor(e,t,r){this.type=B,this.needle=e,this.haystack=t,this.fromIndex=r}static parse(e,t){if(e.length<=2||e.length>=5)return t.error(`Expected 2 or 3 arguments, but found ${e.length-1} instead.`);const r=t.parse(e[1],1,N),n=t.parse(e[2],2,N);if(!r||!n)return null;if(!K(r.type,[V,C,B,F,N]))return t.error(`Expected first argument to be of type boolean, string, number or null, but found ${H(r.type)} instead`);if(4===e.length){const i=t.parse(e[3],3,B);return i?new et(r,n,i):null}return new et(r,n)}evaluate(e){const t=this.needle.evaluate(e),r=this.haystack.evaluate(e);if(!Q(t,["boolean","string","number","null"]))throw new Fe(`Expected first argument to be of type boolean, string, number or null, but found ${H(Ne(t))} instead.`);let n;if(this.fromIndex&&(n=this.fromIndex.evaluate(e)),Q(r,["string"])){const e=r.indexOf(t,n);return-1===e?-1:[...r.slice(0,e)].length}if(Q(r,["array"]))return r.indexOf(t,n);throw new Fe(`Expected second argument to be of type array or string, but found ${H(Ne(r))} instead.`)}eachChild(e){e(this.needle),e(this.haystack),this.fromIndex&&e(this.fromIndex)}outputDefined(){return!1}}class tt{constructor(e,t,r,n,i,s){this.inputType=e,this.type=t,this.input=r,this.cases=n,this.outputs=i,this.otherwise=s}static parse(e,t){if(e.length<5)return t.error(`Expected at least 4 arguments, but found only ${e.length-1}.`);if(e.length%2!=1)return t.error("Expected an even number of arguments.");let r,n;t.expectedType&&"value"!==t.expectedType.kind&&(n=t.expectedType);const i={},s=[];for(let o=2;o<e.length-1;o+=2){let a=e[o];const l=e[o+1];Array.isArray(a)||(a=[a]);const u=t.concat(o);if(0===a.length)return u.error("Expected at least one branch label.");for(const e of a){if("number"!=typeof e&&"string"!=typeof e)return u.error("Branch labels must be numbers or strings.");if("number"==typeof e&&Math.abs(e)>Number.MAX_SAFE_INTEGER)return u.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof e&&Math.floor(e)!==e)return u.error("Numeric branch labels must be integer values.");if(r){if(u.checkSubtype(r,Ne(e)))return null}else r=Ne(e);if(void 0!==i[String(e)])return u.error("Branch labels must be unique.");i[String(e)]=s.length}const c=t.parse(l,o,n);if(!c)return null;n=n||c.type,s.push(c)}const o=t.parse(e[1],1,N);if(!o)return null;const a=t.parse(e[e.length-1],e.length-1,n);return a?"value"!==o.type.kind&&t.concat(1).checkSubtype(r,o.type)?null:new tt(r,n,o,i,s,a):null}evaluate(e){const t=this.input.evaluate(e);return(Ne(t)===this.inputType&&this.outputs[this.cases[t]]||this.otherwise).evaluate(e)}eachChild(e){e(this.input),this.outputs.forEach(e),e(this.otherwise)}outputDefined(){return this.outputs.every((e=>e.outputDefined()))&&this.otherwise.outputDefined()}}class rt{constructor(e,t,r){this.type=e,this.branches=t,this.otherwise=r}static parse(e,t){if(e.length<4)return t.error(`Expected at least 3 arguments, but found only ${e.length-1}.`);if(e.length%2!=0)return t.error("Expected an odd number of arguments.");let r;t.expectedType&&"value"!==t.expectedType.kind&&(r=t.expectedType);const n=[];for(let i=1;i<e.length-1;i+=2){const s=t.parse(e[i],i,V);if(!s)return null;const o=t.parse(e[i+1],i+1,r);if(!o)return null;n.push([s,o]),r=r||o.type}const i=t.parse(e[e.length-1],e.length-1,r);if(!i)return null;if(!r)throw new Error("Can't infer output type");return new rt(r,n,i)}evaluate(e){for(const[t,r]of this.branches)if(t.evaluate(e))return r.evaluate(e);return this.otherwise.evaluate(e)}eachChild(e){for(const[t,r]of this.branches)e(t),e(r);e(this.otherwise)}outputDefined(){return this.branches.every((([e,t])=>t.outputDefined()))&&this.otherwise.outputDefined()}}class nt{constructor(e,t,r,n){this.type=e,this.input=t,this.beginIndex=r,this.endIndex=n}static parse(e,t){if(e.length<=2||e.length>=5)return t.error(`Expected 2 or 3 arguments, but found ${e.length-1} instead.`);const r=t.parse(e[1],1,N),n=t.parse(e[2],2,B);if(!r||!n)return null;if(!K(r.type,[Z(N),C,N]))return t.error(`Expected first argument to be of type array or string, but found ${H(r.type)} instead`);if(4===e.length){const i=t.parse(e[3],3,B);return i?new nt(r.type,r,n,i):null}return new nt(r.type,r,n)}evaluate(e){const t=this.input.evaluate(e),r=this.beginIndex.evaluate(e);let n;if(this.endIndex&&(n=this.endIndex.evaluate(e)),Q(t,["string"]))return[...t].slice(r,n).join("");if(Q(t,["array"]))return t.slice(r,n);throw new Fe(`Expected first argument to be of type array or string, but found ${H(Ne(t))} instead.`)}eachChild(e){e(this.input),e(this.beginIndex),this.endIndex&&e(this.endIndex)}outputDefined(){return!1}}function it(e,t){const r=e.length-1;let n,i,s=0,o=r,a=0;for(;s<=o;)if(a=Math.floor((s+o)/2),n=e[a],i=e[a+1],n<=t){if(a===r||t<i)return a;s=a+1}else{if(!(n>t))throw new Fe("Input is not a number.");o=a-1}return 0}class st{constructor(e,t,r){this.type=e,this.input=t,this.labels=[],this.outputs=[];for(const[e,t]of r)this.labels.push(e),this.outputs.push(t)}static parse(e,t){if(e.length-1<4)return t.error(`Expected at least 4 arguments, but found only ${e.length-1}.`);if((e.length-1)%2!=0)return t.error("Expected an even number of arguments.");const r=t.parse(e[1],1,B);if(!r)return null;const n=[];let i=null;t.expectedType&&"value"!==t.expectedType.kind&&(i=t.expectedType);for(let r=1;r<e.length;r+=2){const s=1===r?-1/0:e[r],o=e[r+1],a=r,l=r+1;if("number"!=typeof s)return t.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',a);if(n.length&&n[n.length-1][0]>=s)return t.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',a);const u=t.parse(o,l,i);if(!u)return null;i=i||u.type,n.push([s,u])}return new st(i,r,n)}evaluate(e){const t=this.labels,r=this.outputs;if(1===t.length)return r[0].evaluate(e);const n=this.input.evaluate(e);if(n<=t[0])return r[0].evaluate(e);const i=t.length;return n>=t[i-1]?r[i-1].evaluate(e):r[it(t,n)].evaluate(e)}eachChild(e){e(this.input);for(const t of this.outputs)e(t)}outputDefined(){return this.outputs.every((e=>e.outputDefined()))}}function ot(e){return e&&e.__esModule&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e}var at,lt,ut=function(){if(lt)return at;function e(e,t,r,n){this.cx=3*e,this.bx=3*(r-e)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*t,this.by=3*(n-t)-this.cy,this.ay=1-this.cy-this.by,this.p1x=e,this.p1y=t,this.p2x=r,this.p2y=n}return lt=1,at=e,e.prototype={sampleCurveX:function(e){return((this.ax*e+this.bx)*e+this.cx)*e},sampleCurveY:function(e){return((this.ay*e+this.by)*e+this.cy)*e},sampleCurveDerivativeX:function(e){return(3*this.ax*e+2*this.bx)*e+this.cx},solveCurveX:function(e,t){if(void 0===t&&(t=1e-6),e<0)return 0;if(e>1)return 1;for(var r=e,n=0;n<8;n++){var i=this.sampleCurveX(r)-e;if(Math.abs(i)<t)return r;var s=this.sampleCurveDerivativeX(r);if(Math.abs(s)<1e-6)break;r-=i/s}var o=0,a=1;for(r=e,n=0;n<20&&(i=this.sampleCurveX(r),!(Math.abs(i-e)<t));n++)e>i?o=r:a=r,r=.5*(a-o)+o;return r},solve:function(e,t){return this.sampleCurveY(this.solveCurveX(e,t))}},at}(),ct=ot(ut);class ht{constructor(e,t,r,n,i){this.type=e,this.operator=t,this.interpolation=r,this.input=n,this.labels=[],this.outputs=[];for(const[e,t]of i)this.labels.push(e),this.outputs.push(t)}static interpolationFactor(e,t,r,n){let i=0;if("exponential"===e.name)i=pt(t,e.base,r,n);else if("linear"===e.name)i=pt(t,1,r,n);else if("cubic-bezier"===e.name){const s=e.controlPoints;i=new ct(s[0],s[1],s[2],s[3]).solve(pt(t,1,r,n))}return i}static parse(e,t){let[r,n,i,...s]=e;if(!Array.isArray(n)||0===n.length)return t.error("Expected an interpolation type expression.",1);if("linear"===n[0])n={name:"linear"};else if("exponential"===n[0]){const e=n[1];if("number"!=typeof e)return t.error("Exponential interpolation requires a numeric base.",1,1);n={name:"exponential",base:e}}else{if("cubic-bezier"!==n[0])return t.error(`Unknown interpolation type ${String(n[0])}`,1,0);{const e=n.slice(1);if(4!==e.length||e.some((e=>"number"!=typeof e||e<0||e>1)))return t.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);n={name:"cubic-bezier",controlPoints:e}}}if(e.length-1<4)return t.error(`Expected at least 4 arguments, but found only ${e.length-1}.`);if((e.length-1)%2!=0)return t.error("Expected an even number of arguments.");if(i=t.parse(i,2,B),!i)return null;const o=[];let a=null;"interpolate-hcl"!==r&&"interpolate-lab"!==r||t.expectedType==G?t.expectedType&&"value"!==t.expectedType.kind&&(a=t.expectedType):a=L;for(let e=0;e<s.length;e+=2){const r=s[e],n=s[e+1],i=e+3,l=e+4;if("number"!=typeof r)return t.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',i);if(o.length&&o[o.length-1][0]>=r)return t.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',i);const u=t.parse(n,l,a);if(!u)return null;a=a||u.type,o.push([r,u])}return ee(a,B)||ee(a,O)||ee(a,L)||ee(a,q)||ee(a,j)||ee(a,G)||ee(a,Y)||ee(a,Z(B))?new ht(a,r,n,i,o):t.error(`Type ${H(a)} is not interpolatable.`)}evaluate(e){const t=this.labels,r=this.outputs;if(1===t.length)return r[0].evaluate(e);const n=this.input.evaluate(e);if(n<=t[0])return r[0].evaluate(e);const i=t.length;if(n>=t[i-1])return r[i-1].evaluate(e);const s=it(t,n),o=ht.interpolationFactor(this.interpolation,n,t[s],t[s+1]),a=r[s].evaluate(e),l=r[s+1].evaluate(e);switch(this.operator){case"interpolate":switch(this.type.kind){case"number":return Se(a,l,o);case"color":return Ie.interpolate(a,l,o);case"padding":return De.interpolate(a,l,o);case"colorArray":return ze.interpolate(a,l,o);case"numberArray":return Pe.interpolate(a,l,o);case"variableAnchorOffsetCollection":return Ce.interpolate(a,l,o);case"array":return Ae(a,l,o);case"projectionDefinition":return Le.interpolate(a,l,o)}case"interpolate-hcl":switch(this.type.kind){case"color":return Ie.interpolate(a,l,o,"hcl");case"colorArray":return ze.interpolate(a,l,o,"hcl")}case"interpolate-lab":switch(this.type.kind){case"color":return Ie.interpolate(a,l,o,"lab");case"colorArray":return ze.interpolate(a,l,o,"lab")}}}eachChild(e){e(this.input);for(const t of this.outputs)e(t)}outputDefined(){return this.outputs.every((e=>e.outputDefined()))}}function pt(e,t,r,n){const i=n-r,s=e-r;return 0===i?0:1===t?s/i:(Math.pow(t,s)-1)/(Math.pow(t,i)-1)}const ft={color:Ie.interpolate,number:Se,padding:De.interpolate,numberArray:Pe.interpolate,colorArray:ze.interpolate,variableAnchorOffsetCollection:Ce.interpolate,array:Ae};class dt{constructor(e,t){this.type=e,this.args=t}static parse(e,t){if(e.length<2)return t.error("Expected at least one argument.");let r=null;const n=t.expectedType;n&&"value"!==n.kind&&(r=n);const i=[];for(const n of e.slice(1)){const e=t.parse(n,1+i.length,r,void 0,{typeAnnotation:"omit"});if(!e)return null;r=r||e.type,i.push(e)}if(!r)throw new Error("No output type");const s=n&&i.some((e=>J(n,e.type)));return new dt(s?N:r,i)}evaluate(e){let t,r=null,n=0;for(const i of this.args)if(n++,r=i.evaluate(e),r&&r instanceof Ve&&!r.available&&(t||(t=r.name),r=null,n===this.args.length&&(r=t)),null!==r)break;return r}eachChild(e){this.args.forEach(e)}outputDefined(){return this.args.every((e=>e.outputDefined()))}}function yt(e,t){return"=="===e||"!="===e?"boolean"===t.kind||"string"===t.kind||"number"===t.kind||"null"===t.kind||"value"===t.kind:"string"===t.kind||"number"===t.kind||"value"===t.kind}function mt(e,t,r,n){return 0===n.compare(t,r)}function gt(e,t,r){const n="=="!==e&&"!="!==e;return class i{constructor(e,t,r){this.type=V,this.lhs=e,this.rhs=t,this.collator=r,this.hasUntypedArgument="value"===e.type.kind||"value"===t.type.kind}static parse(e,t){if(3!==e.length&&4!==e.length)return t.error("Expected two or three arguments.");const r=e[0];let s=t.parse(e[1],1,N);if(!s)return null;if(!yt(r,s.type))return t.concat(1).error(`"${r}" comparisons are not supported for type '${H(s.type)}'.`);let o=t.parse(e[2],2,N);if(!o)return null;if(!yt(r,o.type))return t.concat(2).error(`"${r}" comparisons are not supported for type '${H(o.type)}'.`);if(s.type.kind!==o.type.kind&&"value"!==s.type.kind&&"value"!==o.type.kind)return t.error(`Cannot compare types '${H(s.type)}' and '${H(o.type)}'.`);n&&("value"===s.type.kind&&"value"!==o.type.kind?s=new Ge(o.type,[s]):"value"!==s.type.kind&&"value"===o.type.kind&&(o=new Ge(s.type,[o])));let a=null;if(4===e.length){if("string"!==s.type.kind&&"string"!==o.type.kind&&"value"!==s.type.kind&&"value"!==o.type.kind)return t.error("Cannot use collator to compare non-string types.");if(a=t.parse(e[3],3,$),!a)return null}return new i(s,o,a)}evaluate(i){const s=this.lhs.evaluate(i),o=this.rhs.evaluate(i);if(n&&this.hasUntypedArgument){const t=Ne(s),r=Ne(o);if(t.kind!==r.kind||"string"!==t.kind&&"number"!==t.kind)throw new Fe(`Expected arguments for "${e}" to be (string, string) or (number, number), but found (${t.kind}, ${r.kind}) instead.`)}if(this.collator&&!n&&this.hasUntypedArgument){const e=Ne(s),r=Ne(o);if("string"!==e.kind||"string"!==r.kind)return t(i,s,o)}return this.collator?r(i,s,o,this.collator.evaluate(i)):t(i,s,o)}eachChild(e){e(this.lhs),e(this.rhs),this.collator&&e(this.collator)}outputDefined(){return!0}}}const xt=gt("==",(function(e,t,r){return t===r}),mt),vt=gt("!=",(function(e,t,r){return t!==r}),(function(e,t,r,n){return!mt(0,t,r,n)})),bt=gt("<",(function(e,t,r){return t<r}),(function(e,t,r,n){return n.compare(t,r)<0})),wt=gt(">",(function(e,t,r){return t>r}),(function(e,t,r,n){return n.compare(t,r)>0})),_t=gt("<=",(function(e,t,r){return t<=r}),(function(e,t,r,n){return n.compare(t,r)<=0})),St=gt(">=",(function(e,t,r){return t>=r}),(function(e,t,r,n){return n.compare(t,r)>=0}));class At{constructor(e,t,r){this.type=$,this.locale=r,this.caseSensitive=e,this.diacriticSensitive=t}static parse(e,t){if(2!==e.length)return t.error("Expected one argument.");const r=e[1];if("object"!=typeof r||Array.isArray(r))return t.error("Collator options argument must be an object.");const n=t.parse(void 0!==r["case-sensitive"]&&r["case-sensitive"],1,V);if(!n)return null;const i=t.parse(void 0!==r["diacritic-sensitive"]&&r["diacritic-sensitive"],1,V);if(!i)return null;let s=null;return r.locale&&(s=t.parse(r.locale,1,C),!s)?null:new At(n,i,s)}evaluate(e){return new Te(this.caseSensitive.evaluate(e),this.diacriticSensitive.evaluate(e),this.locale?this.locale.evaluate(e):null)}eachChild(e){e(this.caseSensitive),e(this.diacriticSensitive),this.locale&&e(this.locale)}outputDefined(){return!1}}class It{constructor(e,t,r,n,i){this.type=C,this.number=e,this.locale=t,this.currency=r,this.minFractionDigits=n,this.maxFractionDigits=i}static parse(e,t){if(3!==e.length)return t.error("Expected two arguments.");const r=t.parse(e[1],1,B);if(!r)return null;const n=e[2];if("object"!=typeof n||Array.isArray(n))return t.error("NumberFormat options argument must be an object.");let i=null;if(n.locale&&(i=t.parse(n.locale,1,C),!i))return null;let s=null;if(n.currency&&(s=t.parse(n.currency,1,C),!s))return null;let o=null;if(n["min-fraction-digits"]&&(o=t.parse(n["min-fraction-digits"],1,B),!o))return null;let a=null;return n["max-fraction-digits"]&&(a=t.parse(n["max-fraction-digits"],1,B),!a)?null:new It(r,i,s,o,a)}evaluate(e){return new Intl.NumberFormat(this.locale?this.locale.evaluate(e):[],{style:this.currency?"currency":"decimal",currency:this.currency?this.currency.evaluate(e):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(e):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(e):void 0}).format(this.number.evaluate(e))}eachChild(e){e(this.number),this.locale&&e(this.locale),this.currency&&e(this.currency),this.minFractionDigits&&e(this.minFractionDigits),this.maxFractionDigits&&e(this.maxFractionDigits)}outputDefined(){return!1}}class Tt{constructor(e){this.type=U,this.sections=e}static parse(e,t){if(e.length<2)return t.error("Expected at least one argument.");const r=e[1];if(!Array.isArray(r)&&"object"==typeof r)return t.error("First argument must be an image or text section.");const n=[];let i=!1;for(let r=1;r<=e.length-1;++r){const s=e[r];if(i&&"object"==typeof s&&!Array.isArray(s)){i=!1;let e=null;if(s["font-scale"]&&(e=t.parse(s["font-scale"],1,B),!e))return null;let r=null;if(s["text-font"]&&(r=t.parse(s["text-font"],1,Z(C)),!r))return null;let o=null;if(s["text-color"]&&(o=t.parse(s["text-color"],1,L),!o))return null;let a=null;if(s["vertical-align"]){if("string"==typeof s["vertical-align"]&&!ke.includes(s["vertical-align"]))return t.error(`'vertical-align' must be one of: 'bottom', 'center', 'top' but found '${s["vertical-align"]}' instead.`);if(a=t.parse(s["vertical-align"],1,C),!a)return null}const l=n[n.length-1];l.scale=e,l.font=r,l.textColor=o,l.verticalAlign=a}else{const s=t.parse(e[r],1,N);if(!s)return null;const o=s.type.kind;if("string"!==o&&"value"!==o&&"null"!==o&&"resolvedImage"!==o)return t.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");i=!0,n.push({content:s,scale:null,font:null,textColor:null,verticalAlign:null})}}return new Tt(n)}evaluate(e){return new Me(this.sections.map((t=>{const r=t.content.evaluate(e);return Ne(r)===X?new Ee("",r,null,null,null,t.verticalAlign?t.verticalAlign.evaluate(e):null):new Ee($e(r),null,t.scale?t.scale.evaluate(e):null,t.font?t.font.evaluate(e).join(","):null,t.textColor?t.textColor.evaluate(e):null,t.verticalAlign?t.verticalAlign.evaluate(e):null)})))}eachChild(e){for(const t of this.sections)e(t.content),t.scale&&e(t.scale),t.font&&e(t.font),t.textColor&&e(t.textColor),t.verticalAlign&&e(t.verticalAlign)}outputDefined(){return!1}}class kt{constructor(e){this.type=X,this.input=e}static parse(e,t){if(2!==e.length)return t.error("Expected two arguments.");const r=t.parse(e[1],1,C);return r?new kt(r):t.error("No image name provided.")}evaluate(e){const t=this.input.evaluate(e),r=Ve.fromString(t);return r&&e.availableImages&&(r.available=e.availableImages.indexOf(t)>-1),r}eachChild(e){e(this.input)}outputDefined(){return!1}}class Et{constructor(e){this.type=B,this.input=e}static parse(e,t){if(2!==e.length)return t.error(`Expected 1 argument, but found ${e.length-1} instead.`);const r=t.parse(e[1],1);return r?"array"!==r.type.kind&&"string"!==r.type.kind&&"value"!==r.type.kind?t.error(`Expected argument of type string or array, but found ${H(r.type)} instead.`):new Et(r):null}evaluate(e){const t=this.input.evaluate(e);if("string"==typeof t)return[...t].length;if(Array.isArray(t))return t.length;throw new Fe(`Expected value to be of type string or array, but found ${H(Ne(t))} instead.`)}eachChild(e){e(this.input)}outputDefined(){return!1}}const Mt=8192;function Dt(e,t){const r=(180+e[0])/360,n=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+e[1]*Math.PI/360)))/360,i=Math.pow(2,t.z);return[Math.round(r*i*Mt),Math.round(n*i*Mt)]}function Pt(e,t){const r=Math.pow(2,t.z);return[(i=(e[0]/Mt+t.x)/r,360*i-180),(n=(e[1]/Mt+t.y)/r,360/Math.PI*Math.atan(Math.exp((180-360*n)*Math.PI/180))-90)];var n,i}function zt(e,t){e[0]=Math.min(e[0],t[0]),e[1]=Math.min(e[1],t[1]),e[2]=Math.max(e[2],t[0]),e[3]=Math.max(e[3],t[1])}function Ft(e,t){return!(e[0]<=t[0]||e[2]>=t[2]||e[1]<=t[1]||e[3]>=t[3])}function Bt(e,t,r){const n=e[0]-t[0],i=e[1]-t[1],s=e[0]-r[0],o=e[1]-r[1];return n*o-s*i==0&&n*s<=0&&i*o<=0}function Ct(e,t,r,n){return 0!=(i=[n[0]-r[0],n[1]-r[1]])[0]*(s=[t[0]-e[0],t[1]-e[1]])[1]-i[1]*s[0]&&!(!$t(e,t,r,n)||!$t(r,n,e,t));var i,s}function Vt(e,t,r){for(const n of r)for(let r=0;r<n.length-1;++r)if(Ct(e,t,n[r],n[r+1]))return!0;return!1}function Lt(e,t,r=!1){let n=!1;for(const a of t)for(let t=0;t<a.length-1;t++){if(Bt(e,a[t],a[t+1]))return r;(s=a[t])[1]>(i=e)[1]!=(o=a[t+1])[1]>i[1]&&i[0]<(o[0]-s[0])*(i[1]-s[1])/(o[1]-s[1])+s[0]&&(n=!n)}var i,s,o;return n}function Ot(e,t){for(const r of t)if(Lt(e,r))return!0;return!1}function Rt(e,t){for(const r of e)if(!Lt(r,t))return!1;for(let r=0;r<e.length-1;++r)if(Vt(e[r],e[r+1],t))return!1;return!0}function Nt(e,t){for(const r of t)if(Rt(e,r))return!0;return!1}function $t(e,t,r,n){const i=n[0]-r[0],s=n[1]-r[1],o=(e[0]-r[0])*s-i*(e[1]-r[1]),a=(t[0]-r[0])*s-i*(t[1]-r[1]);return o>0&&a<0||o<0&&a>0}function Ut(e,t,r){const n=[];for(let i=0;i<e.length;i++){const s=[];for(let n=0;n<e[i].length;n++){const o=Dt(e[i][n],r);zt(t,o),s.push(o)}n.push(s)}return n}function qt(e,t,r){const n=[];for(let i=0;i<e.length;i++){const s=Ut(e[i],t,r);n.push(s)}return n}function Gt(e,t,r,n){if(e[0]<r[0]||e[0]>r[2]){const t=.5*n;let i=e[0]-r[0]>t?-n:r[0]-e[0]>t?n:0;0===i&&(i=e[0]-r[2]>t?-n:r[2]-e[0]>t?n:0),e[0]+=i}zt(t,e)}function jt(e,t,r,n){const i=Math.pow(2,n.z)*Mt,s=[n.x*Mt,n.y*Mt],o=[];for(const n of e)for(const e of n){const n=[e.x+s[0],e.y+s[1]];Gt(n,t,r,i),o.push(n)}return o}function Xt(e,t,r,n){const i=Math.pow(2,n.z)*Mt,s=[n.x*Mt,n.y*Mt],o=[];for(const r of e){const e=[];for(const n of r){const r=[n.x+s[0],n.y+s[1]];zt(t,r),e.push(r)}o.push(e)}if(t[2]-t[0]<=i/2){(a=t)[0]=a[1]=1/0,a[2]=a[3]=-1/0;for(const e of o)for(const n of e)Gt(n,t,r,i)}var a;return o}class Yt{constructor(e,t){this.type=V,this.geojson=e,this.geometries=t}static parse(e,t){if(2!==e.length)return t.error(`'within' expression requires exactly one argument, but found ${e.length-1} instead.`);if(Re(e[1])){const t=e[1];if("FeatureCollection"===t.type){const e=[];for(const r of t.features){const{type:t,coordinates:n}=r.geometry;"Polygon"===t&&e.push(n),"MultiPolygon"===t&&e.push(...n)}if(e.length)return new Yt(t,{type:"MultiPolygon",coordinates:e})}else if("Feature"===t.type){const e=t.geometry.type;if("Polygon"===e||"MultiPolygon"===e)return new Yt(t,t.geometry)}else if("Polygon"===t.type||"MultiPolygon"===t.type)return new Yt(t,t)}return t.error("'within' expression requires valid geojson object that contains polygon geometry type.")}evaluate(e){if(null!=e.geometry()&&null!=e.canonicalID()){if("Point"===e.geometryType())return function(e,t){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=e.canonicalID();if("Polygon"===t.type){const s=Ut(t.coordinates,n,i),o=jt(e.geometry(),r,n,i);if(!Ft(r,n))return!1;for(const e of o)if(!Lt(e,s))return!1}if("MultiPolygon"===t.type){const s=qt(t.coordinates,n,i),o=jt(e.geometry(),r,n,i);if(!Ft(r,n))return!1;for(const e of o)if(!Ot(e,s))return!1}return!0}(e,this.geometries);if("LineString"===e.geometryType())return function(e,t){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=e.canonicalID();if("Polygon"===t.type){const s=Ut(t.coordinates,n,i),o=Xt(e.geometry(),r,n,i);if(!Ft(r,n))return!1;for(const e of o)if(!Rt(e,s))return!1}if("MultiPolygon"===t.type){const s=qt(t.coordinates,n,i),o=Xt(e.geometry(),r,n,i);if(!Ft(r,n))return!1;for(const e of o)if(!Nt(e,s))return!1}return!0}(e,this.geometries)}return!1}eachChild(){}outputDefined(){return!0}}let Zt=class{constructor(e=[],t=(e,t)=>e<t?-1:e>t?1:0){if(this.data=e,this.length=this.data.length,this.compare=t,this.length>0)for(let e=(this.length>>1)-1;e>=0;e--)this._down(e)}push(e){this.data.push(e),this._up(this.length++)}pop(){if(0===this.length)return;const e=this.data[0],t=this.data.pop();return--this.length>0&&(this.data[0]=t,this._down(0)),e}peek(){return this.data[0]}_up(e){const{data:t,compare:r}=this,n=t[e];for(;e>0;){const i=e-1>>1,s=t[i];if(r(n,s)>=0)break;t[e]=s,e=i}t[e]=n}_down(e){const{data:t,compare:r}=this,n=this.length>>1,i=t[e];for(;e<n;){let n=1+(e<<1);const s=n+1;if(s<this.length&&r(t[s],t[n])<0&&(n=s),r(t[n],i)>=0)break;t[e]=t[n],e=n}t[e]=i}};function Ht(e,t,r=0,n=e.length-1,i=Jt){for(;n>r;){if(n-r>600){const s=n-r+1,o=t-r+1,a=Math.log(s),l=.5*Math.exp(2*a/3),u=.5*Math.sqrt(a*l*(s-l)/s)*(o-s/2<0?-1:1);Ht(e,t,Math.max(r,Math.floor(t-o*l/s+u)),Math.min(n,Math.floor(t+(s-o)*l/s+u)),i)}const s=e[t];let o=r,a=n;for(Wt(e,r,t),i(e[n],s)>0&&Wt(e,r,n);o<a;){for(Wt(e,o,a),o++,a--;i(e[o],s)<0;)o++;for(;i(e[a],s)>0;)a--}0===i(e[r],s)?Wt(e,r,a):(a++,Wt(e,a,n)),a<=t&&(r=a+1),t<=a&&(n=a-1)}}function Wt(e,t,r){const n=e[t];e[t]=e[r],e[r]=n}function Jt(e,t){return e<t?-1:e>t?1:0}function Kt(e,t){if(e.length<=1)return[e];const r=[];let n,i;for(const t of e){const e=er(t);0!==e&&(t.area=Math.abs(e),void 0===i&&(i=e<0),i===e<0?(n&&r.push(n),n=[t]):n.push(t))}if(n&&r.push(n),t>1)for(let e=0;e<r.length;e++)r[e].length<=t||(Ht(r[e],t,1,r[e].length-1,Qt),r[e]=r[e].slice(0,t));return r}function Qt(e,t){return t.area-e.area}function er(e){let t=0;for(let r,n,i=0,s=e.length,o=s-1;i<s;o=i++)r=e[i],n=e[o],t+=(n.x-r.x)*(r.y+n.y);return t}const tr=1/298.257223563,rr=tr*(2-tr),nr=Math.PI/180;class ir{constructor(e){const t=6378.137*nr*1e3,r=Math.cos(e*nr),n=1/(1-rr*(1-r*r)),i=Math.sqrt(n);this.kx=t*i*r,this.ky=t*i*n*(1-rr)}distance(e,t){const r=this.wrap(e[0]-t[0])*this.kx,n=(e[1]-t[1])*this.ky;return Math.sqrt(r*r+n*n)}pointOnLine(e,t){let r,n,i,s,o=1/0;for(let a=0;a<e.length-1;a++){let l=e[a][0],u=e[a][1],c=this.wrap(e[a+1][0]-l)*this.kx,h=(e[a+1][1]-u)*this.ky,p=0;0===c&&0===h||(p=(this.wrap(t[0]-l)*this.kx*c+(t[1]-u)*this.ky*h)/(c*c+h*h),p>1?(l=e[a+1][0],u=e[a+1][1]):p>0&&(l+=c/this.kx*p,u+=h/this.ky*p)),c=this.wrap(t[0]-l)*this.kx,h=(t[1]-u)*this.ky;const f=c*c+h*h;f<o&&(o=f,r=l,n=u,i=a,s=p)}return{point:[r,n],index:i,t:Math.max(0,Math.min(1,s))}}wrap(e){for(;e<-180;)e+=360;for(;e>180;)e-=360;return e}}function sr(e,t){return t[0]-e[0]}function or(e){return e[1]-e[0]+1}function ar(e,t){return e[1]>=e[0]&&e[1]<t}function lr(e,t){if(e[0]>e[1])return[null,null];const r=or(e);if(t){if(2===r)return[e,null];const t=Math.floor(r/2);return[[e[0],e[0]+t],[e[0]+t,e[1]]]}if(1===r)return[e,null];const n=Math.floor(r/2)-1;return[[e[0],e[0]+n],[e[0]+n+1,e[1]]]}function ur(e,t){if(!ar(t,e.length))return[1/0,1/0,-1/0,-1/0];const r=[1/0,1/0,-1/0,-1/0];for(let n=t[0];n<=t[1];++n)zt(r,e[n]);return r}function cr(e){const t=[1/0,1/0,-1/0,-1/0];for(const r of e)for(const e of r)zt(t,e);return t}function hr(e){return e[0]!==-1/0&&e[1]!==-1/0&&e[2]!==1/0&&e[3]!==1/0}function pr(e,t,r){if(!hr(e)||!hr(t))return NaN;let n=0,i=0;return e[2]<t[0]&&(n=t[0]-e[2]),e[0]>t[2]&&(n=e[0]-t[2]),e[1]>t[3]&&(i=e[1]-t[3]),e[3]<t[1]&&(i=t[1]-e[3]),r.distance([0,0],[n,i])}function fr(e,t,r){const n=r.pointOnLine(t,e);return r.distance(e,n.point)}function dr(e,t,r,n,i){const s=Math.min(fr(e,[r,n],i),fr(t,[r,n],i)),o=Math.min(fr(r,[e,t],i),fr(n,[e,t],i));return Math.min(s,o)}function yr(e,t,r,n,i){if(!ar(t,e.length)||!ar(n,r.length))return 1/0;let s=1/0;for(let o=t[0];o<t[1];++o){const t=e[o],a=e[o+1];for(let e=n[0];e<n[1];++e){const n=r[e],o=r[e+1];if(Ct(t,a,n,o))return 0;s=Math.min(s,dr(t,a,n,o,i))}}return s}function mr(e,t,r,n,i){if(!ar(t,e.length)||!ar(n,r.length))return NaN;let s=1/0;for(let o=t[0];o<=t[1];++o)for(let t=n[0];t<=n[1];++t)if(s=Math.min(s,i.distance(e[o],r[t])),0===s)return s;return s}function gr(e,t,r){if(Lt(e,t,!0))return 0;let n=1/0;for(const i of t){const t=i[0],s=i[i.length-1];if(t!==s&&(n=Math.min(n,fr(e,[s,t],r)),0===n))return n;const o=r.pointOnLine(i,e);if(n=Math.min(n,r.distance(e,o.point)),0===n)return n}return n}function xr(e,t,r,n){if(!ar(t,e.length))return NaN;for(let n=t[0];n<=t[1];++n)if(Lt(e[n],r,!0))return 0;let i=1/0;for(let s=t[0];s<t[1];++s){const t=e[s],o=e[s+1];for(const e of r)for(let r=0,s=e.length,a=s-1;r<s;a=r++){const s=e[a],l=e[r];if(Ct(t,o,s,l))return 0;i=Math.min(i,dr(t,o,s,l,n))}}return i}function vr(e,t){for(const r of e)for(const e of r)if(Lt(e,t,!0))return!0;return!1}function br(e,t,r,n=1/0){const i=cr(e),s=cr(t);if(n!==1/0&&pr(i,s,r)>=n)return n;if(Ft(i,s)){if(vr(e,t))return 0}else if(vr(t,e))return 0;let o=1/0;for(const n of e)for(let e=0,i=n.length,s=i-1;e<i;s=e++){const i=n[s],a=n[e];for(const e of t)for(let t=0,n=e.length,s=n-1;t<n;s=t++){const n=e[s],l=e[t];if(Ct(i,a,n,l))return 0;o=Math.min(o,dr(i,a,n,l,r))}}return o}function wr(e,t,r,n,i,s){if(!s)return;const o=pr(ur(n,s),i,r);o<t&&e.push([o,s,[0,0]])}function _r(e,t,r,n,i,s,o){if(!s||!o)return;const a=pr(ur(n,s),ur(i,o),r);a<t&&e.push([a,s,o])}function Sr(e,t,r,n,i=1/0){let s=Math.min(n.distance(e[0],r[0][0]),i);if(0===s)return s;const o=new Zt([[0,[0,e.length-1],[0,0]]],sr),a=cr(r);for(;o.length>0;){const i=o.pop();if(i[0]>=s)continue;const l=i[1],u=t?50:100;if(or(l)<=u){if(!ar(l,e.length))return NaN;if(t){const t=xr(e,l,r,n);if(isNaN(t)||0===t)return t;s=Math.min(s,t)}else for(let t=l[0];t<=l[1];++t){const i=gr(e[t],r,n);if(s=Math.min(s,i),0===s)return 0}}else{const r=lr(l,t);wr(o,s,n,e,a,r[0]),wr(o,s,n,e,a,r[1])}}return s}function Ar(e,t,r,n,i,s=1/0){let o=Math.min(s,i.distance(e[0],r[0]));if(0===o)return o;const a=new Zt([[0,[0,e.length-1],[0,r.length-1]]],sr);for(;a.length>0;){const s=a.pop();if(s[0]>=o)continue;const l=s[1],u=s[2],c=t?50:100,h=n?50:100;if(or(l)<=c&&or(u)<=h){if(!ar(l,e.length)&&ar(u,r.length))return NaN;let s;if(t&&n)s=yr(e,l,r,u,i),o=Math.min(o,s);else if(t&&!n){const t=e.slice(l[0],l[1]+1);for(let e=u[0];e<=u[1];++e)if(s=fr(r[e],t,i),o=Math.min(o,s),0===o)return o}else if(!t&&n){const t=r.slice(u[0],u[1]+1);for(let r=l[0];r<=l[1];++r)if(s=fr(e[r],t,i),o=Math.min(o,s),0===o)return o}else s=mr(e,l,r,u,i),o=Math.min(o,s)}else{const s=lr(l,t),c=lr(u,n);_r(a,o,i,e,r,s[0],c[0]),_r(a,o,i,e,r,s[0],c[1]),_r(a,o,i,e,r,s[1],c[0]),_r(a,o,i,e,r,s[1],c[1])}}return o}function Ir(e){return"MultiPolygon"===e.type?e.coordinates.map((e=>({type:"Polygon",coordinates:e}))):"MultiLineString"===e.type?e.coordinates.map((e=>({type:"LineString",coordinates:e}))):"MultiPoint"===e.type?e.coordinates.map((e=>({type:"Point",coordinates:e}))):[e]}class Tr{constructor(e,t){this.type=B,this.geojson=e,this.geometries=t}static parse(e,t){if(2!==e.length)return t.error(`'distance' expression requires exactly one argument, but found ${e.length-1} instead.`);if(Re(e[1])){const t=e[1];if("FeatureCollection"===t.type)return new Tr(t,t.features.map((e=>Ir(e.geometry))).flat());if("Feature"===t.type)return new Tr(t,Ir(t.geometry));if("type"in t&&"coordinates"in t)return new Tr(t,Ir(t))}return t.error("'distance' expression requires valid geojson object that contains polygon geometry type.")}evaluate(e){if(null!=e.geometry()&&null!=e.canonicalID()){if("Point"===e.geometryType())return function(e,t){const r=e.geometry(),n=r.flat().map((t=>Pt([t.x,t.y],e.canonical)));if(0===r.length)return NaN;const i=new ir(n[0][1]);let s=1/0;for(const e of t){switch(e.type){case"Point":s=Math.min(s,Ar(n,!1,[e.coordinates],!1,i,s));break;case"LineString":s=Math.min(s,Ar(n,!1,e.coordinates,!0,i,s));break;case"Polygon":s=Math.min(s,Sr(n,!1,e.coordinates,i,s))}if(0===s)return s}return s}(e,this.geometries);if("LineString"===e.geometryType())return function(e,t){const r=e.geometry(),n=r.flat().map((t=>Pt([t.x,t.y],e.canonical)));if(0===r.length)return NaN;const i=new ir(n[0][1]);let s=1/0;for(const e of t){switch(e.type){case"Point":s=Math.min(s,Ar(n,!0,[e.coordinates],!1,i,s));break;case"LineString":s=Math.min(s,Ar(n,!0,e.coordinates,!0,i,s));break;case"Polygon":s=Math.min(s,Sr(n,!0,e.coordinates,i,s))}if(0===s)return s}return s}(e,this.geometries);if("Polygon"===e.geometryType())return function(e,t){const r=e.geometry();if(0===r.length||0===r[0].length)return NaN;const n=Kt(r,0).map((t=>t.map((t=>t.map((t=>Pt([t.x,t.y],e.canonical))))))),i=new ir(n[0][0][0][1]);let s=1/0;for(const e of t)for(const t of n){switch(e.type){case"Point":s=Math.min(s,Sr([e.coordinates],!1,t,i,s));break;case"LineString":s=Math.min(s,Sr(e.coordinates,!0,t,i,s));break;case"Polygon":s=Math.min(s,br(t,e.coordinates,i,s))}if(0===s)return s}return s}(e,this.geometries)}return NaN}eachChild(){}outputDefined(){return!0}}class kr{constructor(e){this.type=N,this.key=e}static parse(e,t){if(2!==e.length)return t.error(`Expected 1 argument, but found ${e.length-1} instead.`);const r=e[1];return null==r?t.error("Global state property must be defined."):"string"!=typeof r?t.error(`Global state property must be string, but found ${typeof e[1]} instead.`):new kr(r)}evaluate(e){var t;const r=null===(t=e.globals)||void 0===t?void 0:t.globalState;return r&&0!==Object.keys(r).length?ge(r,this.key):null}eachChild(){}outputDefined(){return!1}}const Er={"==":xt,"!=":vt,">":wt,"<":bt,">=":St,"<=":_t,array:Ge,at:Ke,boolean:Ge,case:rt,coalesce:dt,collator:At,format:Tt,image:kt,in:Qe,"index-of":et,interpolate:ht,"interpolate-hcl":ht,"interpolate-lab":ht,length:Et,let:We,literal:Ue,match:tt,number:Ge,"number-format":It,object:Ge,slice:nt,step:st,string:Ge,"to-boolean":Xe,"to-color":Xe,"to-number":Xe,"to-string":Xe,var:Je,within:Yt,distance:Tr,"global-state":kr};class Mr{constructor(e,t,r,n){this.name=e,this.type=t,this._evaluate=r,this.args=n}evaluate(e){return this._evaluate(e,this.args)}eachChild(e){this.args.forEach(e)}outputDefined(){return!1}static parse(e,t){const r=e[0],n=Mr.definitions[r];if(!n)return t.error(`Unknown expression "${r}". If you wanted a literal array, use ["literal", [...]].`,0);const i=Array.isArray(n)?n[0]:n.type,s=Array.isArray(n)?[[n[1],n[2]]]:n.overloads,o=s.filter((([t])=>!Array.isArray(t)||t.length===e.length-1));let a=null;for(const[n,s]of o){a=new He(t.registry,Br,t.path,null,t.scope);const o=[];let l=!1;for(let t=1;t<e.length;t++){const r=e[t],i=Array.isArray(n)?n[t-1]:n.type,s=a.parse(r,1+o.length,i);if(!s){l=!0;break}o.push(s)}if(!l)if(Array.isArray(n)&&n.length!==o.length)a.error(`Expected ${n.length} arguments, but found ${o.length} instead.`);else{for(let e=0;e<o.length;e++){const t=Array.isArray(n)?n[e]:n.type,r=o[e];a.concat(e+1).checkSubtype(t,r.type)}if(0===a.errors.length)return new Mr(r,i,s,o)}}if(1===o.length)t.errors.push(...a.errors);else{const r=(o.length?o:s).map((([e])=>{return t=e,Array.isArray(t)?`(${t.map(H).join(", ")})`:`(${H(t.type)}...)`;var t})).join(" | "),n=[];for(let r=1;r<e.length;r++){const i=t.parse(e[r],1+n.length);if(!i)return null;n.push(H(i.type))}t.error(`Expected arguments of type ${r}, but found (${n.join(", ")}) instead.`)}return null}static register(e,t){Mr.definitions=t;for(const r in t)e[r]=Mr}}function Dr(e,[t,r,n,i]){t=t.evaluate(e),r=r.evaluate(e),n=n.evaluate(e);const s=i?i.evaluate(e):1,o=Oe(t,r,n,s);if(o)throw new Fe(o);return new Ie(t/255,r/255,n/255,s,!1)}function Pr(e,t){return e in t}function zr(e,t){const r=t[e];return void 0===r?null:r}function Fr(e){return{type:e}}function Br(e){if(e instanceof Je)return Br(e.boundExpression);if(e instanceof Mr&&"error"===e.name)return!1;if(e instanceof At)return!1;if(e instanceof Yt)return!1;if(e instanceof Tr)return!1;if(e instanceof kr)return!1;const t=e instanceof Xe||e instanceof Ge;let r=!0;return e.eachChild((e=>{r=t?r&&Br(e):r&&e instanceof Ue})),!!r&&Cr(e)&&Lr(e,["zoom","heatmap-density","elevation","line-progress","accumulated","is-supported-script"])}function Cr(e){if(e instanceof Mr){if("get"===e.name&&1===e.args.length)return!1;if("feature-state"===e.name)return!1;if("has"===e.name&&1===e.args.length)return!1;if("properties"===e.name||"geometry-type"===e.name||"id"===e.name)return!1;if(/^filter-/.test(e.name))return!1}if(e instanceof Yt)return!1;if(e instanceof Tr)return!1;let t=!0;return e.eachChild((e=>{t&&!Cr(e)&&(t=!1)})),t}function Vr(e){if(e instanceof Mr&&"feature-state"===e.name)return!1;let t=!0;return e.eachChild((e=>{t&&!Vr(e)&&(t=!1)})),t}function Lr(e,t){if(e instanceof Mr&&t.indexOf(e.name)>=0)return!1;let r=!0;return e.eachChild((e=>{r&&!Lr(e,t)&&(r=!1)})),r}function Or(e){return{result:"success",value:e}}function Rr(e){return{result:"error",value:e}}function Nr(e){return"data-driven"===e["property-type"]||"cross-faded-data-driven"===e["property-type"]}function $r(e){return!!e.expression&&e.expression.parameters.indexOf("zoom")>-1}function Ur(e){return!!e.expression&&e.expression.interpolated}function qr(e){return e instanceof Number?"number":e instanceof String?"string":e instanceof Boolean?"boolean":Array.isArray(e)?"array":null===e?"null":typeof e}function Gr(e){return"object"==typeof e&&null!==e&&!Array.isArray(e)&&Ne(e)===R}function jr(e){return e}function Xr(e,t){const r=e.stops&&"object"==typeof e.stops[0][0],n=r||!(r||void 0!==e.property),i=e.type||(Ur(t)?"exponential":"interval"),s=function(e){switch(e.type){case"color":return Ie.parse;case"padding":return De.parse;case"numberArray":return Pe.parse;case"colorArray":return ze.parse;default:return null}}(t);if(s&&((e=D({},e)).stops&&(e.stops=e.stops.map((e=>[e[0],s(e[1])]))),e.default=s(e.default?e.default:t.default)),e.colorSpace&&"rgb"!==(o=e.colorSpace)&&"hcl"!==o&&"lab"!==o)throw new Error(`Unknown color space: "${e.colorSpace}"`);var o;const a=function(e){switch(e){case"exponential":return Wr;case"interval":return Hr;case"categorical":return Zr;case"identity":return Jr;default:throw new Error(`Unknown function type "${e}"`)}}(i);let l,u;if("categorical"===i){l=Object.create(null);for(const t of e.stops)l[t[0]]=t[1];u=typeof e.stops[0][0]}if(r){const r={},n=[];for(let t=0;t<e.stops.length;t++){const i=e.stops[t],s=i[0].zoom;void 0===r[s]&&(r[s]={zoom:s,type:e.type,property:e.property,default:e.default,stops:[]},n.push(s)),r[s].stops.push([i[0].value,i[1]])}const i=[];for(const e of n)i.push([r[e].zoom,Xr(r[e],t)]);const s={name:"linear"};return{kind:"composite",interpolationType:s,interpolationFactor:ht.interpolationFactor.bind(void 0,s),zoomStops:i.map((e=>e[0])),evaluate:({zoom:r},n)=>Wr({stops:i,base:e.base},t,r).evaluate(r,n)}}if(n){const r="exponential"===i?{name:"exponential",base:void 0!==e.base?e.base:1}:null;return{kind:"camera",interpolationType:r,interpolationFactor:ht.interpolationFactor.bind(void 0,r),zoomStops:e.stops.map((e=>e[0])),evaluate:({zoom:r})=>a(e,t,r,l,u)}}return{kind:"source",evaluate(r,n){const i=n&&n.properties?n.properties[e.property]:void 0;return void 0===i?Yr(e.default,t.default):a(e,t,i,l,u)}}}function Yr(e,t,r){return void 0!==e?e:void 0!==t?t:void 0!==r?r:void 0}function Zr(e,t,r,n,i){return Yr(typeof r===i?n[r]:void 0,e.default,t.default)}function Hr(e,t,r){if("number"!==qr(r))return Yr(e.default,t.default);const n=e.stops.length;if(1===n)return e.stops[0][1];if(r<=e.stops[0][0])return e.stops[0][1];if(r>=e.stops[n-1][0])return e.stops[n-1][1];const i=it(e.stops.map((e=>e[0])),r);return e.stops[i][1]}function Wr(e,t,r){const n=void 0!==e.base?e.base:1;if("number"!==qr(r))return Yr(e.default,t.default);const i=e.stops.length;if(1===i)return e.stops[0][1];if(r<=e.stops[0][0])return e.stops[0][1];if(r>=e.stops[i-1][0])return e.stops[i-1][1];const s=it(e.stops.map((e=>e[0])),r),o=function(e,t,r,n){const i=n-r,s=e-r;return 0===i?0:1===t?s/i:(Math.pow(t,s)-1)/(Math.pow(t,i)-1)}(r,n,e.stops[s][0],e.stops[s+1][0]),a=e.stops[s][1],l=e.stops[s+1][1],u=ft[t.type]||jr;return"function"==typeof a.evaluate?{evaluate(...t){const r=a.evaluate.apply(void 0,t),n=l.evaluate.apply(void 0,t);if(void 0!==r&&void 0!==n)return u(r,n,o,e.colorSpace)}}:u(a,l,o,e.colorSpace)}function Jr(e,t,r){switch(t.type){case"color":r=Ie.parse(r);break;case"formatted":r=Me.fromString(r.toString());break;case"resolvedImage":r=Ve.fromString(r.toString());break;case"padding":r=De.parse(r);break;case"colorArray":r=ze.parse(r);break;case"numberArray":r=Pe.parse(r);break;default:qr(r)===t.type||"enum"===t.type&&t.values[r]||(r=void 0)}return Yr(r,e.default,t.default)}Mr.register(Er,{error:[{kind:"error"},[C],(e,[t])=>{throw new Fe(t.evaluate(e))}],typeof:[C,[N],(e,[t])=>H(Ne(t.evaluate(e)))],"to-rgba":[Z(B,4),[L],(e,[t])=>{const[r,n,i,s]=t.evaluate(e).rgb;return[255*r,255*n,255*i,s]}],rgb:[L,[B,B,B],Dr],rgba:[L,[B,B,B,B],Dr],has:{type:V,overloads:[[[C],(e,[t])=>Pr(t.evaluate(e),e.properties())],[[C,R],(e,[t,r])=>Pr(t.evaluate(e),r.evaluate(e))]]},get:{type:N,overloads:[[[C],(e,[t])=>zr(t.evaluate(e),e.properties())],[[C,R],(e,[t,r])=>zr(t.evaluate(e),r.evaluate(e))]]},"feature-state":[N,[C],(e,[t])=>zr(t.evaluate(e),e.featureState||{})],properties:[R,[],e=>e.properties()],"geometry-type":[C,[],e=>e.geometryType()],id:[N,[],e=>e.id()],zoom:[B,[],e=>e.globals.zoom],"heatmap-density":[B,[],e=>e.globals.heatmapDensity||0],elevation:[B,[],e=>e.globals.elevation||0],"line-progress":[B,[],e=>e.globals.lineProgress||0],accumulated:[N,[],e=>void 0===e.globals.accumulated?null:e.globals.accumulated],"+":[B,Fr(B),(e,t)=>{let r=0;for(const n of t)r+=n.evaluate(e);return r}],"*":[B,Fr(B),(e,t)=>{let r=1;for(const n of t)r*=n.evaluate(e);return r}],"-":{type:B,overloads:[[[B,B],(e,[t,r])=>t.evaluate(e)-r.evaluate(e)],[[B],(e,[t])=>-t.evaluate(e)]]},"/":[B,[B,B],(e,[t,r])=>t.evaluate(e)/r.evaluate(e)],"%":[B,[B,B],(e,[t,r])=>t.evaluate(e)%r.evaluate(e)],ln2:[B,[],()=>Math.LN2],pi:[B,[],()=>Math.PI],e:[B,[],()=>Math.E],"^":[B,[B,B],(e,[t,r])=>Math.pow(t.evaluate(e),r.evaluate(e))],sqrt:[B,[B],(e,[t])=>Math.sqrt(t.evaluate(e))],log10:[B,[B],(e,[t])=>Math.log(t.evaluate(e))/Math.LN10],ln:[B,[B],(e,[t])=>Math.log(t.evaluate(e))],log2:[B,[B],(e,[t])=>Math.log(t.evaluate(e))/Math.LN2],sin:[B,[B],(e,[t])=>Math.sin(t.evaluate(e))],cos:[B,[B],(e,[t])=>Math.cos(t.evaluate(e))],tan:[B,[B],(e,[t])=>Math.tan(t.evaluate(e))],asin:[B,[B],(e,[t])=>Math.asin(t.evaluate(e))],acos:[B,[B],(e,[t])=>Math.acos(t.evaluate(e))],atan:[B,[B],(e,[t])=>Math.atan(t.evaluate(e))],min:[B,Fr(B),(e,t)=>Math.min(...t.map((t=>t.evaluate(e))))],max:[B,Fr(B),(e,t)=>Math.max(...t.map((t=>t.evaluate(e))))],abs:[B,[B],(e,[t])=>Math.abs(t.evaluate(e))],round:[B,[B],(e,[t])=>{const r=t.evaluate(e);return r<0?-Math.round(-r):Math.round(r)}],floor:[B,[B],(e,[t])=>Math.floor(t.evaluate(e))],ceil:[B,[B],(e,[t])=>Math.ceil(t.evaluate(e))],"filter-==":[V,[C,N],(e,[t,r])=>e.properties()[t.value]===r.value],"filter-id-==":[V,[N],(e,[t])=>e.id()===t.value],"filter-type-==":[V,[C],(e,[t])=>e.geometryType()===t.value],"filter-<":[V,[C,N],(e,[t,r])=>{const n=e.properties()[t.value],i=r.value;return typeof n==typeof i&&n<i}],"filter-id-<":[V,[N],(e,[t])=>{const r=e.id(),n=t.value;return typeof r==typeof n&&r<n}],"filter->":[V,[C,N],(e,[t,r])=>{const n=e.properties()[t.value],i=r.value;return typeof n==typeof i&&n>i}],"filter-id->":[V,[N],(e,[t])=>{const r=e.id(),n=t.value;return typeof r==typeof n&&r>n}],"filter-<=":[V,[C,N],(e,[t,r])=>{const n=e.properties()[t.value],i=r.value;return typeof n==typeof i&&n<=i}],"filter-id-<=":[V,[N],(e,[t])=>{const r=e.id(),n=t.value;return typeof r==typeof n&&r<=n}],"filter->=":[V,[C,N],(e,[t,r])=>{const n=e.properties()[t.value],i=r.value;return typeof n==typeof i&&n>=i}],"filter-id->=":[V,[N],(e,[t])=>{const r=e.id(),n=t.value;return typeof r==typeof n&&r>=n}],"filter-has":[V,[N],(e,[t])=>t.value in e.properties()],"filter-has-id":[V,[],e=>null!==e.id()&&void 0!==e.id()],"filter-type-in":[V,[Z(C)],(e,[t])=>t.value.indexOf(e.geometryType())>=0],"filter-id-in":[V,[Z(N)],(e,[t])=>t.value.indexOf(e.id())>=0],"filter-in-small":[V,[C,Z(N)],(e,[t,r])=>r.value.indexOf(e.properties()[t.value])>=0],"filter-in-large":[V,[C,Z(N)],(e,[t,r])=>function(e,t,r,n){for(;r<=n;){const i=r+n>>1;if(t[i]===e)return!0;t[i]>e?n=i-1:r=i+1}return!1}(e.properties()[t.value],r.value,0,r.value.length-1)],all:{type:V,overloads:[[[V,V],(e,[t,r])=>t.evaluate(e)&&r.evaluate(e)],[Fr(V),(e,t)=>{for(const r of t)if(!r.evaluate(e))return!1;return!0}]]},any:{type:V,overloads:[[[V,V],(e,[t,r])=>t.evaluate(e)||r.evaluate(e)],[Fr(V),(e,t)=>{for(const r of t)if(r.evaluate(e))return!0;return!1}]]},"!":[V,[V],(e,[t])=>!t.evaluate(e)],"is-supported-script":[V,[C],(e,[t])=>{const r=e.globals&&e.globals.isSupportedScript;return!r||r(t.evaluate(e))}],upcase:[C,[C],(e,[t])=>t.evaluate(e).toUpperCase()],downcase:[C,[C],(e,[t])=>t.evaluate(e).toLowerCase()],concat:[C,Fr(N),(e,t)=>t.map((t=>$e(t.evaluate(e)))).join("")],"resolved-locale":[C,[$],(e,[t])=>t.evaluate(e).resolvedLocale()]});class Kr{constructor(e,t,r){this.expression=e,this._warningHistory={},this._evaluator=new Ze,this._defaultValue=t?function(e){if("color"===e.type&&Gr(e.default))return new Ie(0,0,0,0);switch(e.type){case"color":return Ie.parse(e.default)||null;case"padding":return De.parse(e.default)||null;case"numberArray":return Pe.parse(e.default)||null;case"colorArray":return ze.parse(e.default)||null;case"variableAnchorOffsetCollection":return Ce.parse(e.default)||null;case"projectionDefinition":return Le.parse(e.default)||null;default:return void 0===e.default?null:e.default}}(t):null,this._enumValues=t&&"enum"===t.type?t.values:null,this._globalState=r}evaluateWithoutErrorHandling(e,t,r,n,i,s){return this._globalState&&(e=ln(e,this._globalState)),this._evaluator.globals=e,this._evaluator.feature=t,this._evaluator.featureState=r,this._evaluator.canonical=n,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s,this.expression.evaluate(this._evaluator)}evaluate(e,t,r,n,i,s){this._globalState&&(e=ln(e,this._globalState)),this._evaluator.globals=e,this._evaluator.feature=t||null,this._evaluator.featureState=r||null,this._evaluator.canonical=n,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s||null;try{const e=this.expression.evaluate(this._evaluator);if(null==e||"number"==typeof e&&e!=e)return this._defaultValue;if(this._enumValues&&!(e in this._enumValues))throw new Fe(`Expected value to be one of ${Object.keys(this._enumValues).map((e=>JSON.stringify(e))).join(", ")}, but found ${JSON.stringify(e)} instead.`);return e}catch(e){return this._warningHistory[e.message]||(this._warningHistory[e.message]=!0,"undefined"!=typeof console&&console.warn(e.message)),this._defaultValue}}}function Qr(e){return Array.isArray(e)&&e.length>0&&"string"==typeof e[0]&&e[0]in Er}function en(e,t,r){const n=new He(Er,Br,[],t?function(e){const t={color:L,string:C,number:B,enum:C,boolean:V,formatted:U,padding:q,numberArray:j,colorArray:G,projectionDefinition:O,resolvedImage:X,variableAnchorOffsetCollection:Y};return"array"===e.type?Z(t[e.value]||N,e.length):t[e.type]}(t):void 0),i=n.parse(e,void 0,void 0,void 0,t&&"string"===t.type?{typeAnnotation:"coerce"}:void 0);return i?Or(new Kr(i,t,r)):Rr(n.errors)}class tn{constructor(e,t,r){this.kind=e,this._styleExpression=t,this.isStateDependent="constant"!==e&&!Vr(t.expression),this.globalStateRefs=an(t.expression),this._globalState=r}evaluateWithoutErrorHandling(e,t,r,n,i,s){return this._globalState&&(e=ln(e,this._globalState)),this._styleExpression.evaluateWithoutErrorHandling(e,t,r,n,i,s)}evaluate(e,t,r,n,i,s){return this._globalState&&(e=ln(e,this._globalState)),this._styleExpression.evaluate(e,t,r,n,i,s)}}class rn{constructor(e,t,r,n,i){this.kind=e,this.zoomStops=r,this._styleExpression=t,this.isStateDependent="camera"!==e&&!Vr(t.expression),this.globalStateRefs=an(t.expression),this.interpolationType=n,this._globalState=i}evaluateWithoutErrorHandling(e,t,r,n,i,s){return this._globalState&&(e=ln(e,this._globalState)),this._styleExpression.evaluateWithoutErrorHandling(e,t,r,n,i,s)}evaluate(e,t,r,n,i,s){return this._globalState&&(e=ln(e,this._globalState)),this._styleExpression.evaluate(e,t,r,n,i,s)}interpolationFactor(e,t,r){return this.interpolationType?ht.interpolationFactor(this.interpolationType,e,t,r):0}}function nn(e,t,r){const n=en(e,t,r);if("error"===n.result)return n;const i=n.value.expression,s=Cr(i);if(!s&&!Nr(t))return Rr([new P("","data expressions not supported")]);const o=Lr(i,["zoom"]);if(!o&&!$r(t))return Rr([new P("","zoom expressions not supported")]);const a=on(i);return a||o?a instanceof P?Rr([a]):a instanceof ht&&!Ur(t)?Rr([new P("",'"interpolate" expressions cannot be used with this property')]):Or(a?new rn(s?"camera":"composite",n.value,a.labels,a instanceof ht?a.interpolation:void 0,r):new tn(s?"constant":"source",n.value,r)):Rr([new P("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.')])}class sn{constructor(e,t){this._parameters=e,this._specification=t,D(this,Xr(this._parameters,this._specification))}static deserialize(e){return new sn(e._parameters,e._specification)}static serialize(e){return{_parameters:e._parameters,_specification:e._specification}}}function on(e){let t=null;if(e instanceof We)t=on(e.result);else if(e instanceof dt){for(const r of e.args)if(t=on(r),t)break}else(e instanceof st||e instanceof ht)&&e.input instanceof Mr&&"zoom"===e.input.name&&(t=e);return t instanceof P||e.eachChild((e=>{const r=on(e);r instanceof P?t=r:!t&&r?t=new P("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.'):t&&r&&t!==r&&(t=new P("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'))})),t}function an(e,t=new Set){return e instanceof kr&&t.add(e.key),e.eachChild((e=>{an(e,t)})),t}function ln(e,t){const{zoom:r,heatmapDensity:n,elevation:i,lineProgress:s,isSupportedScript:o,accumulated:a}=null!=e?e:{};return{zoom:r,heatmapDensity:n,elevation:i,lineProgress:s,isSupportedScript:o,accumulated:a,globalState:t}}function un(e){if(!0===e||!1===e)return!0;if(!Array.isArray(e)||0===e.length)return!1;switch(e[0]){case"has":return e.length>=2&&"$id"!==e[1]&&"$type"!==e[1];case"in":return e.length>=3&&("string"!=typeof e[1]||Array.isArray(e[2]));case"!in":case"!has":case"none":return!1;case"==":case"!=":case">":case">=":case"<":case"<=":return 3!==e.length||Array.isArray(e[1])||Array.isArray(e[2]);case"any":case"all":for(const t of e.slice(1))if(!un(t)&&"boolean"!=typeof t)return!1;return!0;default:return!0}}const cn={type:"boolean",default:!1,transition:!1,"property-type":"data-driven",expression:{interpolated:!1,parameters:["zoom","feature"]}};function hn(e,t){if(null==e)return{filter:()=>!0,needGeometry:!1,getGlobalStateRefs:()=>new Set};un(e)||(e=dn(e));const r=en(e,cn,t);if("error"===r.result)throw new Error(r.value.map((e=>`${e.key}: ${e.message}`)).join(", "));return{filter:(e,t,n)=>r.value.evaluate(e,t,{},n),needGeometry:fn(e),getGlobalStateRefs:()=>an(r.value.expression)}}function pn(e,t){return e<t?-1:e>t?1:0}function fn(e){if(!Array.isArray(e))return!1;if("within"===e[0]||"distance"===e[0])return!0;for(let t=1;t<e.length;t++)if(fn(e[t]))return!0;return!1}function dn(e){if(!e)return!0;const t=e[0];return e.length<=1?"any"!==t:"=="===t?yn(e[1],e[2],"=="):"!="===t?xn(yn(e[1],e[2],"==")):"<"===t||">"===t||"<="===t||">="===t?yn(e[1],e[2],t):"any"===t?(r=e.slice(1),["any"].concat(r.map(dn))):"all"===t?["all"].concat(e.slice(1).map(dn)):"none"===t?["all"].concat(e.slice(1).map(dn).map(xn)):"in"===t?mn(e[1],e.slice(2)):"!in"===t?xn(mn(e[1],e.slice(2))):"has"===t?gn(e[1]):"!has"!==t||xn(gn(e[1]));var r}function yn(e,t,r){switch(e){case"$type":return[`filter-type-${r}`,t];case"$id":return[`filter-id-${r}`,t];default:return[`filter-${r}`,e,t]}}function mn(e,t){if(0===t.length)return!1;switch(e){case"$type":return["filter-type-in",["literal",t]];case"$id":return["filter-id-in",["literal",t]];default:return t.length>200&&!t.some((e=>typeof e!=typeof t[0]))?["filter-in-large",e,["literal",t.sort(pn)]]:["filter-in-small",e,["literal",t]]}}function gn(e){switch(e){case"$type":return!0;case"$id":return["filter-has-id"];default:return["filter-has",e]}}function xn(e){return["!",e]}function vn(e){const t=typeof e;if("number"===t||"boolean"===t||"string"===t||null==e)return JSON.stringify(e);if(Array.isArray(e)){let t="[";for(const r of e)t+=`${vn(r)},`;return`${t}]`}const r=Object.keys(e).sort();let n="{";for(let t=0;t<r.length;t++)n+=`${JSON.stringify(r[t])}:${vn(e[r[t]])},`;return`${n}}`}function bn(e){let t="";for(const r of E)t+=`/${vn(e[r])}`;return t}function wn(e){const t=e.value;return t?[new M(e.key,t,"constants have been deprecated as of v8")]:[]}function _n(e){return e instanceof Number||e instanceof String||e instanceof Boolean?e.valueOf():e}function Sn(e){if(Array.isArray(e))return e.map(Sn);if(e instanceof Object&&!(e instanceof Number||e instanceof String||e instanceof Boolean)){const t={};for(const r in e)t[r]=Sn(e[r]);return t}return _n(e)}function An(e){const t=e.key,r=e.value,n=e.valueSpec||{},i=e.objectElementValidators||{},s=e.style,o=e.styleSpec,a=e.validateSpec;let l=[];const u=qr(r);if("object"!==u)return[new M(t,r,`object expected, ${u} found`)];for(const e in r){const u=e.split(".")[0],c=ge(n,u)||n["*"];let h;if(ge(i,u))h=i[u];else if(ge(n,u)){if(void 0===r[e])continue;h=a}else if(i["*"])h=i["*"];else{if(!n["*"]){l.push(new M(t,r[e],`unknown property "${e}"`));continue}h=a}l=l.concat(h({key:(t?`${t}.`:t)+e,value:r[e],valueSpec:c,style:s,styleSpec:o,object:r,objectKey:e,validateSpec:a},r))}for(const e in n)i[e]||n[e].required&&void 0===n[e].default&&void 0===r[e]&&l.push(new M(t,r,`missing required property "${e}"`));return l}function In(e){const t=e.value,r=e.valueSpec,n=e.style,i=e.styleSpec,s=e.key,o=e.arrayElementValidator||e.validateSpec;if("array"!==qr(t))return[new M(s,t,`array expected, ${qr(t)} found`)];if(r.length&&t.length!==r.length)return[new M(s,t,`array length ${r.length} expected, length ${t.length} found`)];let a={type:r.value,values:r.values};i.$version<7&&(a.function=r.function),"object"===qr(r.value)&&(a=r.value);let l=[];for(let r=0;r<t.length;r++)l=l.concat(o({array:t,arrayIndex:r,value:t[r],valueSpec:a,validateSpec:e.validateSpec,style:n,styleSpec:i,key:`${s}[${r}]`}));return l}function Tn(e){const t=e.key,r=e.value,n=e.valueSpec;let i=qr(r);return"number"===i&&r!=r&&(i="NaN"),"number"!==i?[new M(t,r,`number expected, ${i} found`)]:"minimum"in n&&r<n.minimum?[new M(t,r,`${r} is less than the minimum value ${n.minimum}`)]:"maximum"in n&&r>n.maximum?[new M(t,r,`${r} is greater than the maximum value ${n.maximum}`)]:[]}function kn(e){const t=e.valueSpec,r=_n(e.value.type);let n,i,s,o={};const a="categorical"!==r&&void 0===e.value.property,l=!a,u="array"===qr(e.value.stops)&&"array"===qr(e.value.stops[0])&&"object"===qr(e.value.stops[0][0]),c=An({key:e.key,value:e.value,valueSpec:e.styleSpec.function,validateSpec:e.validateSpec,style:e.style,styleSpec:e.styleSpec,objectElementValidators:{stops:function(e){if("identity"===r)return[new M(e.key,e.value,'identity function may not have a "stops" property')];let t=[];const n=e.value;return t=t.concat(In({key:e.key,value:n,valueSpec:e.valueSpec,validateSpec:e.validateSpec,style:e.style,styleSpec:e.styleSpec,arrayElementValidator:h})),"array"===qr(n)&&0===n.length&&t.push(new M(e.key,n,"array must have at least one stop")),t},default:function(e){return e.validateSpec({key:e.key,value:e.value,valueSpec:t,validateSpec:e.validateSpec,style:e.style,styleSpec:e.styleSpec})}}});return"identity"===r&&a&&c.push(new M(e.key,e.value,'missing required property "property"')),"identity"===r||e.value.stops||c.push(new M(e.key,e.value,'missing required property "stops"')),"exponential"===r&&e.valueSpec.expression&&!Ur(e.valueSpec)&&c.push(new M(e.key,e.value,"exponential functions not supported")),e.styleSpec.$version>=8&&(l&&!Nr(e.valueSpec)?c.push(new M(e.key,e.value,"property functions not supported")):a&&!$r(e.valueSpec)&&c.push(new M(e.key,e.value,"zoom functions not supported"))),"categorical"!==r&&!u||void 0!==e.value.property||c.push(new M(e.key,e.value,'"property" property is required')),c;function h(e){let r=[];const n=e.value,a=e.key;if("array"!==qr(n))return[new M(a,n,`array expected, ${qr(n)} found`)];if(2!==n.length)return[new M(a,n,`array length 2 expected, length ${n.length} found`)];if(u){if("object"!==qr(n[0]))return[new M(a,n,`object expected, ${qr(n[0])} found`)];if(void 0===n[0].zoom)return[new M(a,n,"object stop key must have zoom")];if(void 0===n[0].value)return[new M(a,n,"object stop key must have value")];if(s&&s>_n(n[0].zoom))return[new M(a,n[0].zoom,"stop zoom values must appear in ascending order")];_n(n[0].zoom)!==s&&(s=_n(n[0].zoom),i=void 0,o={}),r=r.concat(An({key:`${a}[0]`,value:n[0],valueSpec:{zoom:{}},validateSpec:e.validateSpec,style:e.style,styleSpec:e.styleSpec,objectElementValidators:{zoom:Tn,value:p}}))}else r=r.concat(p({key:`${a}[0]`,value:n[0],validateSpec:e.validateSpec,style:e.style,styleSpec:e.styleSpec},n));return Qr(Sn(n[1]))?r.concat([new M(`${a}[1]`,n[1],"expressions are not allowed in function stops.")]):r.concat(e.validateSpec({key:`${a}[1]`,value:n[1],valueSpec:t,validateSpec:e.validateSpec,style:e.style,styleSpec:e.styleSpec}))}function p(e,s){const a=qr(e.value),l=_n(e.value),u=null!==e.value?e.value:s;if(n){if(a!==n)return[new M(e.key,u,`${a} stop domain type must match previous stop domain type ${n}`)]}else n=a;if("number"!==a&&"string"!==a&&"boolean"!==a)return[new M(e.key,u,"stop domain value must be a number, string, or boolean")];if("number"!==a&&"categorical"!==r){let n=`number expected, ${a} found`;return Nr(t)&&void 0===r&&(n+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'),[new M(e.key,u,n)]}return"categorical"!==r||"number"!==a||isFinite(l)&&Math.floor(l)===l?"categorical"!==r&&"number"===a&&void 0!==i&&l<i?[new M(e.key,u,"stop domain values must appear in ascending order")]:(i=l,"categorical"===r&&l in o?[new M(e.key,u,"stop domain values must be unique")]:(o[l]=!0,[])):[new M(e.key,u,`integer expected, found ${l}`)]}}function En(e){const t=("property"===e.expressionContext?nn:en)(Sn(e.value),e.valueSpec);if("error"===t.result)return t.value.map((t=>new M(`${e.key}${t.key}`,e.value,t.message)));const r=t.value.expression||t.value._styleExpression.expression;if("property"===e.expressionContext&&"text-font"===e.propertyKey&&!r.outputDefined())return[new M(e.key,e.value,`Invalid data expression for "${e.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===e.expressionContext&&"layout"===e.propertyType&&!Vr(r))return[new M(e.key,e.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===e.expressionContext&&!Vr(r))return[new M(e.key,e.value,'"feature-state" data expressions are not supported with filters.')];if(e.expressionContext&&0===e.expressionContext.indexOf("cluster")){if(!Lr(r,["zoom","feature-state"]))return[new M(e.key,e.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===e.expressionContext&&!Cr(r))return[new M(e.key,e.value,"Feature data expressions are not supported with initial expression part of cluster properties.")]}return[]}function Mn(e){const t=e.key,r=e.value,n=qr(r);return"string"!==n?[new M(t,r,`color expected, ${n} found`)]:Ie.parse(String(r))?[]:[new M(t,r,`color expected, "${r}" found`)]}function Dn(e){const t=e.key,r=e.value,n=e.valueSpec,i=[];return Array.isArray(n.values)?-1===n.values.indexOf(_n(r))&&i.push(new M(t,r,`expected one of [${n.values.join(", ")}], ${JSON.stringify(r)} found`)):-1===Object.keys(n.values).indexOf(_n(r))&&i.push(new M(t,r,`expected one of [${Object.keys(n.values).join(", ")}], ${JSON.stringify(r)} found`)),i}function Pn(e){return un(Sn(e.value))?En(D({},e,{expressionContext:"filter",valueSpec:{value:"boolean"}})):zn(e)}function zn(e){const t=e.value,r=e.key;if("array"!==qr(t))return[new M(r,t,`array expected, ${qr(t)} found`)];const n=e.styleSpec;let i,s=[];if(t.length<1)return[new M(r,t,"filter array must have at least 1 element")];switch(s=s.concat(Dn({key:`${r}[0]`,value:t[0],valueSpec:n.filter_operator,style:e.style,styleSpec:e.styleSpec})),_n(t[0])){case"<":case"<=":case">":case">=":t.length>=2&&"$type"===_n(t[1])&&s.push(new M(r,t,`"$type" cannot be use with operator "${t[0]}"`));case"==":case"!=":3!==t.length&&s.push(new M(r,t,`filter array for operator "${t[0]}" must have 3 elements`));case"in":case"!in":t.length>=2&&(i=qr(t[1]),"string"!==i&&s.push(new M(`${r}[1]`,t[1],`string expected, ${i} found`)));for(let o=2;o<t.length;o++)i=qr(t[o]),"$type"===_n(t[1])?s=s.concat(Dn({key:`${r}[${o}]`,value:t[o],valueSpec:n.geometry_type,style:e.style,styleSpec:e.styleSpec})):"string"!==i&&"number"!==i&&"boolean"!==i&&s.push(new M(`${r}[${o}]`,t[o],`string, number, or boolean expected, ${i} found`));break;case"any":case"all":case"none":for(let n=1;n<t.length;n++)s=s.concat(zn({key:`${r}[${n}]`,value:t[n],style:e.style,styleSpec:e.styleSpec}));break;case"has":case"!has":i=qr(t[1]),2!==t.length?s.push(new M(r,t,`filter array for "${t[0]}" operator must have 2 elements`)):"string"!==i&&s.push(new M(`${r}[1]`,t[1],`string expected, ${i} found`))}return s}function Fn(e,t){const r=e.key,n=e.validateSpec,i=e.style,s=e.styleSpec,o=e.value,a=e.objectKey,l=s[`${t}_${e.layerType}`];if(!l)return[];const u=a.match(/^(.*)-transition$/);if("paint"===t&&u&&l[u[1]]&&l[u[1]].transition)return n({key:r,value:o,valueSpec:s.transition,style:i,styleSpec:s});const c=e.valueSpec||l[a];if(!c)return[new M(r,o,`unknown property "${a}"`)];let h;if("string"===qr(o)&&Nr(c)&&!c.tokens&&(h=/^{([^}]+)}$/.exec(o)))return[new M(r,o,`"${a}" does not support interpolation syntax\nUse an identity property function instead: \`{ "type": "identity", "property": ${JSON.stringify(h[1])} }\`.`)];const p=[];return"symbol"===e.layerType&&"text-font"===a&&Gr(Sn(o))&&"identity"===_n(o.type)&&p.push(new M(r,o,'"text-font" does not support identity functions')),p.concat(n({key:e.key,value:o,valueSpec:c,style:i,styleSpec:s,expressionContext:"property",propertyType:t,propertyKey:a}))}function Bn(e){return Fn(e,"paint")}function Cn(e){return Fn(e,"layout")}function Vn(e){let t=[];const r=e.value,n=e.key,i=e.style,s=e.styleSpec;if("object"!==qr(r))return[new M(n,r,`object expected, ${qr(r)} found`)];r.type||r.ref||t.push(new M(n,r,'either "type" or "ref" is required'));let o=_n(r.type);const a=_n(r.ref);if(r.id){const s=_n(r.id);for(let o=0;o<e.arrayIndex;o++){const e=i.layers[o];_n(e.id)===s&&t.push(new M(n,r.id,`duplicate layer id "${r.id}", previously used at line ${e.id.__line__}`))}}if("ref"in r){let e;["type","source","source-layer","filter","layout"].forEach((e=>{e in r&&t.push(new M(n,r[e],`"${e}" is prohibited for ref layers`))})),i.layers.forEach((t=>{_n(t.id)===a&&(e=t)})),e?e.ref?t.push(new M(n,r.ref,"ref cannot reference another ref layer")):o=_n(e.type):t.push(new M(n,r.ref,`ref layer "${a}" not found`))}else if("background"!==o)if(r.source){const e=i.sources&&i.sources[r.source],s=e&&_n(e.type);e?"vector"===s&&"raster"===o?t.push(new M(n,r.source,`layer "${r.id}" requires a raster source`)):"raster-dem"!==s&&"hillshade"===o||"raster-dem"!==s&&"color-relief"===o?t.push(new M(n,r.source,`layer "${r.id}" requires a raster-dem source`)):"raster"===s&&"raster"!==o?t.push(new M(n,r.source,`layer "${r.id}" requires a vector source`)):"vector"!==s||r["source-layer"]?"raster-dem"===s&&"hillshade"!==o&&"color-relief"!==o?t.push(new M(n,r.source,"raster-dem source can only be used with layer type 'hillshade' or 'color-relief'.")):"line"!==o||!r.paint||!r.paint["line-gradient"]||"geojson"===s&&e.lineMetrics||t.push(new M(n,r,`layer "${r.id}" specifies a line-gradient, which requires a GeoJSON source with \`lineMetrics\` enabled.`)):t.push(new M(n,r,`layer "${r.id}" must specify a "source-layer"`)):t.push(new M(n,r.source,`source "${r.source}" not found`))}else t.push(new M(n,r,'missing required property "source"'));return t=t.concat(An({key:n,value:r,valueSpec:s.layer,style:e.style,styleSpec:e.styleSpec,validateSpec:e.validateSpec,objectElementValidators:{"*":()=>[],type:()=>e.validateSpec({key:`${n}.type`,value:r.type,valueSpec:s.layer.type,style:e.style,styleSpec:e.styleSpec,validateSpec:e.validateSpec,object:r,objectKey:"type"}),filter:Pn,layout:e=>An({layer:r,key:e.key,value:e.value,style:e.style,styleSpec:e.styleSpec,validateSpec:e.validateSpec,objectElementValidators:{"*":e=>Cn(D({layerType:o},e))}}),paint:e=>An({layer:r,key:e.key,value:e.value,style:e.style,styleSpec:e.styleSpec,validateSpec:e.validateSpec,objectElementValidators:{"*":e=>Bn(D({layerType:o},e))}})}})),t}function Ln(e){const t=e.value,r=e.key,n=qr(t);return"string"!==n?[new M(r,t,`string expected, ${n} found`)]:[]}const On={promoteId:function({key:e,value:t}){if("string"===qr(t))return Ln({key:e,value:t});{const r=[];for(const n in t)r.push(...Ln({key:`${e}.${n}`,value:t[n]}));return r}}};function Rn(e){const t=e.value,r=e.key,n=e.styleSpec,i=e.style,s=e.validateSpec;if(!t.type)return[new M(r,t,'"type" is required')];const o=_n(t.type);let a;switch(o){case"vector":case"raster":return a=An({key:r,value:t,valueSpec:n[`source_${o.replace("-","_")}`],style:e.style,styleSpec:n,objectElementValidators:On,validateSpec:s}),a;case"raster-dem":return a=function(e){var t;const r=null!==(t=e.sourceName)&&void 0!==t?t:"",n=e.value,i=e.styleSpec,s=i.source_raster_dem,o=e.style;let a=[];const l=qr(n);if(void 0===n)return a;if("object"!==l)return a.push(new M("source_raster_dem",n,`object expected, ${l} found`)),a;const u="custom"===_n(n.encoding),c=["redFactor","greenFactor","blueFactor","baseShift"],h=e.value.encoding?`"${e.value.encoding}"`:"Default";for(const t in n)!u&&c.includes(t)?a.push(new M(t,n[t],`In "${r}": "${t}" is only valid when "encoding" is set to "custom". ${h} encoding found`)):s[t]?a=a.concat(e.validateSpec({key:t,value:n[t],valueSpec:s[t],validateSpec:e.validateSpec,style:o,styleSpec:i})):a.push(new M(t,n[t],`unknown property "${t}"`));return a}({sourceName:r,value:t,style:e.style,styleSpec:n,validateSpec:s}),a;case"geojson":if(a=An({key:r,value:t,valueSpec:n.source_geojson,style:i,styleSpec:n,validateSpec:s,objectElementValidators:On}),t.cluster)for(const e in t.clusterProperties){const[n,i]=t.clusterProperties[e],s="string"==typeof n?[n,["accumulated"],["get",e]]:n;a.push(...En({key:`${r}.${e}.map`,value:i,expressionContext:"cluster-map"})),a.push(...En({key:`${r}.${e}.reduce`,value:s,expressionContext:"cluster-reduce"}))}return a;case"video":return An({key:r,value:t,valueSpec:n.source_video,style:i,validateSpec:s,styleSpec:n});case"image":return An({key:r,value:t,valueSpec:n.source_image,style:i,validateSpec:s,styleSpec:n});case"canvas":return[new M(r,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return Dn({key:`${r}.type`,value:t.type,valueSpec:{values:["vector","raster","raster-dem","geojson","video","image"]}})}}function Nn(e){const t=e.value,r=e.styleSpec,n=r.light,i=e.style;let s=[];const o=qr(t);if(void 0===t)return s;if("object"!==o)return s=s.concat([new M("light",t,`object expected, ${o} found`)]),s;for(const o in t){const a=o.match(/^(.*)-transition$/);s=s.concat(a&&n[a[1]]&&n[a[1]].transition?e.validateSpec({key:o,value:t[o],valueSpec:r.transition,validateSpec:e.validateSpec,style:i,styleSpec:r}):n[o]?e.validateSpec({key:o,value:t[o],valueSpec:n[o],validateSpec:e.validateSpec,style:i,styleSpec:r}):[new M(o,t[o],`unknown property "${o}"`)])}return s}function $n(e){const t=e.value,r=e.styleSpec,n=r.sky,i=e.style,s=qr(t);if(void 0===t)return[];if("object"!==s)return[new M("sky",t,`object expected, ${s} found`)];let o=[];for(const s in t)o=o.concat(n[s]?e.validateSpec({key:s,value:t[s],valueSpec:n[s],style:i,styleSpec:r}):[new M(s,t[s],`unknown property "${s}"`)]);return o}function Un(e){const t=e.value,r=e.styleSpec,n=r.terrain,i=e.style;let s=[];const o=qr(t);if(void 0===t)return s;if("object"!==o)return s=s.concat([new M("terrain",t,`object expected, ${o} found`)]),s;for(const o in t)s=s.concat(n[o]?e.validateSpec({key:o,value:t[o],valueSpec:n[o],validateSpec:e.validateSpec,style:i,styleSpec:r}):[new M(o,t[o],`unknown property "${o}"`)]);return s}function qn(e){let t=[];const r=e.value,n=e.key;if(Array.isArray(r)){const i=[],s=[];for(const o in r)r[o].id&&i.includes(r[o].id)&&t.push(new M(n,r,`all the sprites' ids must be unique, but ${r[o].id} is duplicated`)),i.push(r[o].id),r[o].url&&s.includes(r[o].url)&&t.push(new M(n,r,`all the sprites' URLs must be unique, but ${r[o].url} is duplicated`)),s.push(r[o].url),t=t.concat(An({key:`${n}[${o}]`,value:r[o],valueSpec:{id:{type:"string",required:!0},url:{type:"string",required:!0}},validateSpec:e.validateSpec}));return t}return Ln({key:n,value:r})}function Gn(e){return Boolean(e)&&e.constructor===Object}function jn(e){return Gn(e.value)?[]:[new M(e.key,e.value,`object expected, ${qr(e.value)} found`)]}const Xn={"*":()=>[],array:In,boolean:function(e){const t=e.value,r=e.key,n=qr(t);return"boolean"!==n?[new M(r,t,`boolean expected, ${n} found`)]:[]},number:Tn,color:Mn,constants:wn,enum:Dn,filter:Pn,function:kn,layer:Vn,object:An,source:Rn,light:Nn,sky:$n,terrain:Un,projection:function(e){const t=e.value,r=e.styleSpec,n=r.projection,i=e.style,s=qr(t);if(void 0===t)return[];if("object"!==s)return[new M("projection",t,`object expected, ${s} found`)];let o=[];for(const s in t)o=o.concat(n[s]?e.validateSpec({key:s,value:t[s],valueSpec:n[s],style:i,styleSpec:r}):[new M(s,t[s],`unknown property "${s}"`)]);return o},projectionDefinition:function(e){const t=e.key;let r=e.value;r=r instanceof String?r.valueOf():r;const n=qr(r);return"array"!==n||function(e){return Array.isArray(e)&&3===e.length&&"string"==typeof e[0]&&"string"==typeof e[1]&&"number"==typeof e[2]}(r)||function(e){return!!["interpolate","step","literal"].includes(e[0])}(r)?["array","string"].includes(n)?[]:[new M(t,r,`projection expected, invalid type "${n}" found`)]:[new M(t,r,`projection expected, invalid array ${JSON.stringify(r)} found`)]},string:Ln,formatted:function(e){return 0===Ln(e).length?[]:En(e)},resolvedImage:function(e){return 0===Ln(e).length?[]:En(e)},padding:function(e){const t=e.key,r=e.value;if("array"===qr(r)){if(r.length<1||r.length>4)return[new M(t,r,`padding requires 1 to 4 values; ${r.length} values found`)];const n={type:"number"};let i=[];for(let s=0;s<r.length;s++)i=i.concat(e.validateSpec({key:`${t}[${s}]`,value:r[s],validateSpec:e.validateSpec,valueSpec:n}));return i}return Tn({key:t,value:r,valueSpec:{}})},numberArray:function(e){const t=e.key,r=e.value;if("array"===qr(r)){const n={type:"number"};if(r.length<1)return[new M(t,r,"array length at least 1 expected, length 0 found")];let i=[];for(let s=0;s<r.length;s++)i=i.concat(e.validateSpec({key:`${t}[${s}]`,value:r[s],validateSpec:e.validateSpec,valueSpec:n}));return i}return Tn({key:t,value:r,valueSpec:{}})},colorArray:function(e){const t=e.key,r=e.value;if("array"===qr(r)){if(r.length<1)return[new M(t,r,"array length at least 1 expected, length 0 found")];let e=[];for(let n=0;n<r.length;n++)e=e.concat(Mn({key:`${t}[${n}]`,value:r[n]}));return e}return Mn({key:t,value:r})},variableAnchorOffsetCollection:function(e){const t=e.key,r=e.value,n=qr(r),i=e.styleSpec;if("array"!==n||r.length<1||r.length%2!=0)return[new M(t,r,"variableAnchorOffsetCollection requires a non-empty array of even length")];let s=[];for(let n=0;n<r.length;n+=2)s=s.concat(Dn({key:`${t}[${n}]`,value:r[n],valueSpec:i.layout_symbol["text-anchor"]})),s=s.concat(In({key:`${t}[${n+1}]`,value:r[n+1],valueSpec:{length:2,value:"number"},validateSpec:e.validateSpec,style:e.style,styleSpec:i}));return s},sprite:qn,state:jn,fontFaces:function(e){const t=e.key,r=e.value,n=e.validateSpec,i=e.styleSpec,s=e.style;if(!Gn(r))return[new M(t,r,`object expected, ${qr(r)} found`)];const o=[];for(const e in r){const a=r[e],l=qr(a);if("string"===l)o.push(...Ln({key:`${t}.${e}`,value:a}));else if("array"===l){const r={url:{type:"string",required:!0},"unicode-range":{type:"array",value:"string"}};for(const[l,u]of a.entries())o.push(...An({key:`${t}.${e}[${l}]`,value:u,valueSpec:r,styleSpec:i,style:s,validateSpec:n}))}else o.push(new M(`${t}.${e}`,a,`string or array expected, ${l} found`))}return o}};function Yn(e){const t=e.value,r=e.valueSpec,n=e.styleSpec;return e.validateSpec=Yn,r.expression&&Gr(_n(t))?kn(e):r.expression&&Qr(Sn(t))?En(e):r.type&&Xn[r.type]?Xn[r.type](e):An(D({},e,{valueSpec:r.type?n[r.type]:r}))}function Zn(e){const t=e.value,r=e.key,n=Ln(e);return n.length||(-1===t.indexOf("{fontstack}")&&n.push(new M(r,t,'"glyphs" url must include a "{fontstack}" token')),-1===t.indexOf("{range}")&&n.push(new M(r,t,'"glyphs" url must include a "{range}" token'))),n}function Hn(e,t=k){let r=[];return r=r.concat(Yn({key:"",value:e,valueSpec:t.$root,styleSpec:t,style:e,validateSpec:Yn,objectElementValidators:{glyphs:Zn,"*":()=>[]}})),e.constants&&(r=r.concat(wn({key:"constants",value:e.constants}))),Jn(r)}function Wn(e){return function(t){return e(Object.assign({},t,{validateSpec:Yn}))}}function Jn(e){return[].concat(e).sort(((e,t)=>e.line-t.line))}function Kn(e){return function(...t){return Jn(e.apply(this,t))}}Hn.source=Kn(Wn(Rn)),Hn.sprite=Kn(Wn(qn)),Hn.glyphs=Kn(Wn(Zn)),Hn.light=Kn(Wn(Nn)),Hn.sky=Kn(Wn($n)),Hn.terrain=Kn(Wn(Un)),Hn.state=Kn(Wn(jn)),Hn.layer=Kn(Wn(Vn)),Hn.filter=Kn(Wn(Pn)),Hn.paintProperty=Kn(Wn(Bn)),Hn.layoutProperty=Kn(Wn(Cn));const Qn={type:"enum","property-type":"data-constant",expression:{interpolated:!1,parameters:["global-state"]},values:{visible:{},none:{}},transition:!1,default:"visible"};class ei{constructor(e,t){this._globalState=t,this.setValue(e)}evaluate(){var e;return null!==(e=this._literalValue)&&void 0!==e?e:this._compiledValue.evaluate({})}setValue(e){if(null==e||"visible"===e||"none"===e)return this._literalValue="none"===e?"none":"visible",this._compiledValue=void 0,void(this._globalStateRefs=new Set);const t=en(e,Qn,this._globalState);if("error"===t.result)throw this._literalValue="visible",this._compiledValue=void 0,new Error(t.value.map((e=>`${e.key}: ${e.message}`)).join(", "));this._literalValue=void 0,this._compiledValue=t.value,this._globalStateRefs=an(t.value.expression)}getGlobalStateRefs(){return this._globalStateRefs}}const ti="AbortError";class ri extends Error{constructor(e=ti){super(e instanceof Error?e.message:e),this.name=ti,e instanceof Error&&e.stack&&(this.stack=e.stack)}}function ni(e){return e.name===ti}const ii={REGISTERED_PROTOCOLS:{}};function si(e,t){ii.REGISTERED_PROTOCOLS[e]=t}function oi(e){delete ii.REGISTERED_PROTOCOLS[e]}const ai="global-dispatcher";class li extends Error{constructor(e,t,r,n){super(`AJAXError: ${t} (${e}): ${r}`),this.status=e,this.statusText=t,this.url=r,this.body=n}}const ui=()=>b(self)?self.worker&&self.worker.referrer:("blob:"===window.location.protocol?window.parent:window).location.href,ci=function(t,r){if(/:\/\//.test(t.url)&&!/^https?:|^file:/.test(t.url)){const e=ii.REGISTERED_PROTOCOLS[(n=t.url).substring(0,n.indexOf("://"))];if(e)return e(t,r);if(b(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:t,targetMapId:ai},r)}var n;if(!(e=>/^file:/.test(e)||/^file:/.test(ui())&&!/^\w+:/.test(e))(t.url)){if(fetch&&Request&&AbortController&&Object.prototype.hasOwnProperty.call(Request.prototype,"signal"))return function(t,r){return e(this,void 0,void 0,(function*(){const e=new Request(t.url,{method:t.method||"GET",body:t.body,credentials:t.credentials,headers:t.headers,cache:t.cache,referrer:ui(),signal:r.signal});let n,i;"json"!==t.type||e.headers.has("Accept")||e.headers.set("Accept","application/json");try{n=yield fetch(e)}catch(e){if(ni(e))throw e;throw new li(0,e.message,t.url,new Blob)}if(!n.ok){const e=yield n.blob();throw new li(n.status,n.statusText,t.url,e)}i="arrayBuffer"===t.type||"image"===t.type?n.arrayBuffer():"json"===t.type?n.json():n.text();const s=yield i;return r.signal.throwIfAborted(),{data:s,cacheControl:n.headers.get("Cache-Control"),expires:n.headers.get("Expires")}}))}(t,r);if(b(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:t,mustQueue:!0,targetMapId:ai},r)}return function(e,t){return new Promise(((r,n)=>{var i;const s=new XMLHttpRequest;s.open(e.method||"GET",e.url,!0),"arrayBuffer"!==e.type&&"image"!==e.type||(s.responseType="arraybuffer");for(const t in e.headers)s.setRequestHeader(t,e.headers[t]);"json"===e.type&&(s.responseType="text",(null===(i=e.headers)||void 0===i?void 0:i.Accept)||s.setRequestHeader("Accept","application/json")),s.withCredentials="include"===e.credentials,s.onerror=()=>{n(new Error(s.statusText))},s.onload=()=>{if(!t.signal.aborted)if((s.status>=200&&s.status<300||0===s.status)&&null!==s.response){let t=s.response;if("json"===e.type)try{t=JSON.parse(s.response)}catch(e){return void n(e)}r({data:t,cacheControl:s.getResponseHeader("Cache-Control"),expires:s.getResponseHeader("Expires")})}else{const t=new Blob([s.response],{type:s.getResponseHeader("Content-Type")});n(new li(s.status,s.statusText,e.url,t))}},t.signal.addEventListener("abort",(()=>{s.abort(),n(new ri(t.signal.reason))})),s.send(e.body)}))}(t,r)},hi={};function pi(e,t,r={}){if(hi[e])throw new Error(`${e} is already registered.`);Object.defineProperty(t,"_classRegistryKey",{value:e,writeable:!1}),hi[e]={klass:t,omit:r.omit||[],shallow:r.shallow||[]}}pi("Object",Object),pi("Set",Set),pi("TransferableGridIndex",T),pi("Color",Ie),pi("Error",Error),pi("AJAXError",li),pi("ResolvedImage",Ve),pi("StylePropertyFunction",sn),pi("StyleExpression",Kr,{omit:["_evaluator"]}),pi("ZoomDependentExpression",rn),pi("ZoomConstantExpression",tn),pi("CompoundExpression",Mr,{omit:["_evaluate"]});for(const e in Er)Er[e]._classRegistryKey||pi(`Expression_${e}`,Er[e]);function fi(e){return e&&"undefined"!=typeof ArrayBuffer&&(e instanceof ArrayBuffer||e.constructor&&"ArrayBuffer"===e.constructor.name)}function di(e){return e.$name||e.constructor._classRegistryKey}function yi(e){return!function(e){if(null===e||"object"!=typeof e)return!1;const t=di(e);return!(!t||"Object"===t)}(e)&&(null==e||"boolean"==typeof e||"number"==typeof e||"string"==typeof e||e instanceof Boolean||e instanceof Number||e instanceof String||e instanceof Date||e instanceof RegExp||e instanceof Blob||e instanceof Error||fi(e)||w(e)||ArrayBuffer.isView(e)||e instanceof ImageData)}function mi(e,t){if(yi(e))return(fi(e)||w(e))&&t&&t.push(e),ArrayBuffer.isView(e)&&t&&t.push(e.buffer),e instanceof ImageData&&t&&t.push(e.data.buffer),e;if(Array.isArray(e)){const r=[];for(const n of e)r.push(mi(n,t));return r}if("object"!=typeof e)throw new Error("can't serialize object of type "+typeof e);const r=di(e);if(!r)throw new Error(`can't serialize object of unregistered class ${e.constructor.name}`);if(!hi[r])throw new Error(`${r} is not registered.`);const{klass:n}=hi[r],i=n.serialize?n.serialize(e,t):{};if(n.serialize){if(t&&i===t[t.length-1])throw new Error("statically serialized object won't survive transfer of $name property")}else{for(const n in e){if(!e.hasOwnProperty(n))continue;if(hi[r].omit.indexOf(n)>=0)continue;const s=e[n];i[n]=hi[r].shallow.indexOf(n)>=0?s:mi(s,t)}e instanceof Error&&(i.message=e.message)}if(i.$name)throw new Error("$name property is reserved for worker serialization logic.");return"Object"!==r&&(i.$name=r),i}function gi(e){if(yi(e))return e;if(Array.isArray(e))return e.map(gi);if("object"!=typeof e)throw new Error("can't deserialize object of type "+typeof e);const t=di(e)||"Object";if(!hi[t])throw new Error(`can't deserialize unregistered class ${t}`);const{klass:r}=hi[t];if(!r)throw new Error(`can't deserialize unregistered class ${t}`);if(r.deserialize)return r.deserialize(e);const n=Object.create(r.prototype);for(const r of Object.keys(e)){if("$name"===r)continue;const i=e[r];n[r]=hi[t].shallow.indexOf(r)>=0?i:gi(i)}return n}class xi{constructor(e){this._methodToThrottle=e,this._triggered=!1,"undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel,this._channel.port2.onmessage=()=>{this._triggered=!1,this._methodToThrottle()})}trigger(){this._triggered||(this._triggered=!0,this._channel?this._channel.port1.postMessage(!0):setTimeout((()=>{this._triggered=!1,this._methodToThrottle()}),0))}remove(){delete this._channel,this._methodToThrottle=()=>{}}}const vi={once:!0};class bi{constructor(e,t){this.target=e,this.mapId=t,this.resolveRejects={},this.tasks={},this.taskQueue=[],this.abortControllers={},this.messageHandlers={},this.invoker=new xi((()=>this.process())),this.subscription=A(this.target,"message",(e=>this.receive(e)),!1),this.globalScope=b(self)?e:window}registerMessageHandler(e,t){this.messageHandlers[e]=t}unregisterMessageHandler(e){delete this.messageHandlers[e]}sendAsync(e,t){return new Promise(((r,n)=>{const i=Math.round(1e18*Math.random()).toString(36).substring(0,10),s=t?A(t.signal,"abort",(()=>{null==s||s.unsubscribe(),delete this.resolveRejects[i];const t={id:i,type:"<cancel>",origin:location.origin,targetMapId:e.targetMapId,sourceMapId:this.mapId};this.target.postMessage(t)}),vi):null;this.resolveRejects[i]={resolve:e=>{null==s||s.unsubscribe(),r(e)},reject:e=>{null==s||s.unsubscribe(),n(e)}};const o=[],a=Object.assign(Object.assign({},e),{id:i,sourceMapId:this.mapId,origin:location.origin,data:mi(e.data,o)});this.target.postMessage(a,{transfer:o})}))}receive(e){const t=e.data,r=t.id;if(!("file://"!==t.origin&&"file://"!==location.origin&&"resource://android"!==t.origin&&"resource://android"!==location.origin&&t.origin!==location.origin||t.targetMapId&&this.mapId!==t.targetMapId)){if("<cancel>"===t.type){delete this.tasks[r];const e=this.abortControllers[r];return delete this.abortControllers[r],void(e&&e.abort())}if(b(self)||t.mustQueue)return this.tasks[r]=t,this.taskQueue.push(r),void this.invoker.trigger();this.processTask(r,t)}}process(){if(0===this.taskQueue.length)return;const e=this.taskQueue.shift(),t=this.tasks[e];delete this.tasks[e],this.taskQueue.length>0&&this.invoker.trigger(),t&&this.processTask(e,t)}processTask(t,r){return e(this,void 0,void 0,(function*(){if("<response>"===r.type){const e=this.resolveRejects[t];if(delete this.resolveRejects[t],!e)return;return void(r.error?e.reject(gi(r.error)):e.resolve(gi(r.data)))}if(!this.messageHandlers[r.type])return void this.completeTask(t,new Error(`Could not find a registered handler for ${r.type}, map ID: ${this.mapId}, available handlers: ${Object.keys(this.messageHandlers).join(", ")}`));const e=gi(r.data),n=new AbortController;this.abortControllers[t]=n;try{const i=yield this.messageHandlers[r.type](r.sourceMapId,e,n);this.completeTask(t,null,i)}catch(e){this.completeTask(t,e)}}))}completeTask(e,t,r){const n=[];delete this.abortControllers[e];const i={id:e,type:"<response>",sourceMapId:this.mapId,origin:location.origin,error:t?mi(t):null,data:mi(r,n)};this.target.postMessage(i,{transfer:n})}remove(){this.invoker.remove(),this.subscription.unsubscribe()}}function wi(e,t,r){r[e]&&-1!==r[e].indexOf(t)||(r[e]=r[e]||[],r[e].push(t))}function _i(e,t,r){if(r&&r[e]){const n=r[e].indexOf(t);-1!==n&&r[e].splice(n,1)}}class Si{constructor(e,t={}){d(this,t),this.type=e}}class Ai extends Si{constructor(e,t={}){super("error",d({error:e},t))}}class Ii{on(e,t){return this._listeners=this._listeners||{},wi(e,t,this._listeners),{unsubscribe:()=>{this.off(e,t)}}}off(e,t){return _i(e,t,this._listeners),_i(e,t,this._oneTimeListeners),this}once(e,t){return t?(this._oneTimeListeners=this._oneTimeListeners||{},wi(e,t,this._oneTimeListeners),this):new Promise((t=>this.once(e,t)))}fire(e,t){"string"==typeof e&&(e=new Si(e,t||{}));const r=e.type;if(this.listens(r)){e.target=this;const t=this._listeners&&this._listeners[r]?this._listeners[r].slice():[];for(const r of t)r.call(this,e);const n=this._oneTimeListeners&&this._oneTimeListeners[r]?this._oneTimeListeners[r].slice():[];for(const t of n)_i(r,t,this._oneTimeListeners),t.call(this,e);const i=this._eventedParent;i&&(d(e,"function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData),i.fire(e))}else e instanceof Ai&&console.error(e.error);return this}listens(e){return this._listeners&&this._listeners[e]&&this._listeners[e].length>0||this._oneTimeListeners&&this._oneTimeListeners[e]&&this._oneTimeListeners[e].length>0||this._eventedParent&&this._eventedParent.listens(e)}setEventedParent(e,t){return this._eventedParent=e,this._eventedParentData=t,this}}const Ti=Hn,ki=Ti.paintProperty,Ei=Ti.layoutProperty;class Mi{constructor(){this.first=!0}update(e,t){const r=Math.floor(e);return this.first?(this.first=!1,this.lastIntegerZoom=r,this.lastIntegerZoomTime=0,this.lastZoom=e,this.lastFloorZoom=r,!0):(this.lastFloorZoom>r?(this.lastIntegerZoom=r+1,this.lastIntegerZoomTime=t):this.lastFloorZoom<r&&(this.lastIntegerZoom=r,this.lastIntegerZoomTime=t),e!==this.lastZoom&&(this.lastZoom=e,this.lastFloorZoom=r,!0))}}function Di(e){return/[\u02EA\u02EB\u2E80-\u2FDF\u2FF0-\u303F\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FD-\u30FF\u3105-\u312F\u31A0-\u4DBF\u4E00-\uA48C\uA490-\uA4C6\uF900-\uFA6D\uFA70-\uFAD9\uFE10-\uFE1F\uFE30-\uFE4F\uFF00-\uFFEF]|\uD81B[\uDFE0-\uDFFF]|[\uD81C-\uD822\uD840-\uD868\uD86A-\uD86D\uD86F-\uD872\uD874-\uD879\uD880-\uD883\uD885-\uD88C][\uDC00-\uDFFF]|\uD823[\uDC00-\uDCD5\uDCFF-\uDD1E\uDD80-\uDDF2]|\uD82B[\uDFF0-\uDFFF]|\uD82C[\uDC00-\uDEFB]|\uD83C[\uDE00-\uDEFF]|\uD869[\uDC00-\uDEDF\uDF00-\uDFFF]|\uD86E[\uDC00-\uDC1D\uDC20-\uDFFF]|\uD873[\uDC00-\uDEAD\uDEB0-\uDFFF]|\uD87A[\uDC00-\uDFE0\uDFF0-\uDFFF]|\uD87B[\uDC00-\uDE5D]|\uD87E[\uDC00-\uDE1D]|\uD884[\uDC00-\uDF4A\uDF50-\uDFFF]|\uD88D[\uDC00-\uDC79]/gim.test(String.fromCodePoint(e))}function Pi(e){return/[\u02EA\u02EB\u1100-\u11FF\u1400-\u167F\u18B0-\u18F5\u2E80-\u2E99\u2E9B-\u2EF3\u2F00-\u2FD5\u2FF0-\u3007\u3012\u3013\u3020-\u302F\u3031-\u303F\u3041-\u3096\u309D-\u30FB\u30FD-\u30FF\u3105-\u312F\u3131-\u318E\u3190-\uA48C\uA490-\uA4C6\uA960-\uA97C\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFE10-\uFE1F\uFE30-\uFE48\uFE50-\uFE57\uFE5F-\uFE62\uFE67-\uFE6F\uFF00-\uFF07\uFF0A-\uFF0C\uFF0E-\uFF19\uFF1F-\uFF3A\uFF3C\uFF3E\uFF40-\uFF5A\uFFE0-\uFFE2\uFFE4-\uFFE7]|\uD802[\uDD80-\uDD9F]|\uD805[\uDD80-\uDDFF]|\uD806[\uDE00-\uDEBF]|\uD811[\uDC00-\uDE7F]|\uD81B[\uDFE0-\uDFE4\uDFF0-\uDFF6]|[\uD81C-\uD822\uD83D\uD840-\uD868\uD86A-\uD86D\uD86F-\uD872\uD874-\uD879\uD880-\uD883\uD885-\uD88C][\uDC00-\uDFFF]|\uD823[\uDC00-\uDCD5\uDCFF-\uDD1E\uDD80-\uDDF2]|\uD82B[\uDFF0-\uDFF3\uDFF5-\uDFFB\uDFFD\uDFFE]|\uD82C[\uDC00-\uDD22\uDD30-\uDEFB]|\uD833[\uDEC0-\uDFCF]|\uD834[\uDC00-\uDDFF\uDEE0-\uDF7F]|\uD836[\uDC00-\uDEAF]|\uD83C[\uDC00-\uDE00\uDF00-\uDFFF]|\uD83E[\uDD00-\uDEFF]|\uD869[\uDC00-\uDEDF\uDF00-\uDFFF]|\uD86E[\uDC00-\uDC1D\uDC20-\uDFFF]|\uD873[\uDC00-\uDEAD\uDEB0-\uDFFF]|\uD87A[\uDC00-\uDFE0\uDFF0-\uDFFF]|\uD87B[\uDC00-\uDE5D]|\uD87E[\uDC00-\uDE1D]|\uD884[\uDC00-\uDF4A\uDF50-\uDFFF]|\uD88D[\uDC00-\uDC79]/gim.test(String.fromCodePoint(e))}function zi(e){return/\s/u.test(String.fromCodePoint(e))}function Fi(e){for(const t of e)if(Pi(t.codePointAt(0)))return!0;return!1}function Bi(e){for(const t of e)if(!Li(t.codePointAt(0)))return!1;return!0}function Ci(e){const t=e.map((e=>{try{return new RegExp(`\\p{sc=${e}}`,"u").source}catch(e){return null}})).filter((e=>e));return new RegExp(t.join("|"),"u")}const Vi=Ci(["Arab","Dupl","Mong","Ougr","Syrc"]);function Li(e){return!Vi.test(String.fromCodePoint(e))}function Oi(e){return!(Pi(e)||(t=e,/[\xA7\xA9\xAE\xB1\xBC-\xBE\xD7\xF7\u2016\u2020\u2021\u2030\u2031\u203B\u203C\u2042\u2047-\u2049\u2051\u2100-\u218F\u221E\u2234\u2235\u2300-\u2307\u230C-\u231F\u2324-\u2328\u232B\u237D-\u239A\u23BE-\u23CD\u23CF\u23D1-\u23DB\u23E2-\u2422\u2424-\u24FF\u25A0-\u2619\u2620-\u2767\u2776-\u2793\u2B12-\u2B2F\u2B50-\u2B59\u2BB8-\u2BEB\u3000-\u303F\u30A0-\u30FF\uE000-\uF8FF\uFE30-\uFE6F\uFF00-\uFFEF\uFFFC\uFFFD]|[\uDB80-\uDBFF][\uDC00-\uDFFF]/gim.test(String.fromCodePoint(t))));var t}const Ri=Ci(["Adlm","Arab","Armi","Avst","Chrs","Cprt","Egyp","Elym","Gara","Hatr","Hebr","Hung","Khar","Lydi","Mand","Mani","Mend","Merc","Mero","Narb","Nbat","Nkoo","Orkh","Palm","Phli","Phlp","Phnx","Prti","Rohg","Samr","Sarb","Sogo","Syrc","Thaa","Todr","Yezi"]);function Ni(e){return Ri.test(String.fromCodePoint(e))}function $i(e,t){return!(!t&&Ni(e)||/[\u0900-\u0DFF\u0F00-\u109F\u1780-\u17FF]/gim.test(String.fromCodePoint(e)))}function Ui(e){for(const t of e)if(Ni(t.codePointAt(0)))return!0;return!1}const qi=new class{constructor(){this.TIMEOUT=5e3,this.applyArabicShaping=null,this.processBidirectionalText=null,this.processStyledBidirectionalText=null,this.pluginStatus="unavailable",this.pluginURL=null,this.loadScriptResolve=()=>{}}setState(e){this.pluginStatus=e.pluginStatus,this.pluginURL=e.pluginURL}getState(){return{pluginStatus:this.pluginStatus,pluginURL:this.pluginURL}}setMethods(e){if(qi.isParsed())throw new Error("RTL text plugin already registered.");this.applyArabicShaping=e.applyArabicShaping,this.processBidirectionalText=e.processBidirectionalText,this.processStyledBidirectionalText=e.processStyledBidirectionalText,this.loadScriptResolve()}isParsed(){return null!=this.applyArabicShaping&&null!=this.processBidirectionalText&&null!=this.processStyledBidirectionalText}getRTLTextPluginStatus(){return this.pluginStatus}syncState(t,r){return e(this,void 0,void 0,(function*(){if(this.isParsed())return this.getState();if("loading"!==t.pluginStatus)return this.setState(t),t;const e=t.pluginURL,n=new Promise((e=>{this.loadScriptResolve=e}));r(e);const i=new Promise((e=>setTimeout((()=>e()),this.TIMEOUT)));if(yield Promise.race([n,i]),this.isParsed()){const t={pluginStatus:"loaded",pluginURL:e};return this.setState(t),t}throw this.setState({pluginStatus:"error",pluginURL:""}),new Error(`RTL Text Plugin failed to import scripts from ${e}`)}))}};class Gi{constructor(e,t){this.isSupportedScript=ji,this.zoom=e,t?(this.now=t.now||0,this.fadeDuration=t.fadeDuration||0,this.zoomHistory=t.zoomHistory||new Mi,this.transition=t.transition||{}):(this.now=0,this.fadeDuration=0,this.zoomHistory=new Mi,this.transition={})}crossFadingFactor(){return 0===this.fadeDuration?1:Math.min((this.now-this.zoomHistory.lastIntegerZoomTime)/this.fadeDuration,1)}getCrossfadeParameters(){const e=this.zoom,t=e-Math.floor(e),r=this.crossFadingFactor();return e>this.zoomHistory.lastIntegerZoom?{fromScale:2,toScale:1,t:t+(1-t)*r}:{fromScale:.5,toScale:1,t:1-(1-r)*t}}}function ji(e){return function(e,t){for(const r of e)if(!$i(r.codePointAt(0),t))return!1;return!0}(e,"loaded"===qi.getRTLTextPluginStatus())}const Xi="-transition";class Yi{constructor(e,t,r){this.property=e,this.value=t,this.expression=function(e,t,r){if(Gr(e))return new sn(e,t);if(Qr(e)){const n=nn(e,t,r);if("error"===n.result)throw new Error(n.value.map((e=>`${e.key}: ${e.message}`)).join(", "));return n.value}{let r=e;return"color"===t.type&&"string"==typeof e?r=Ie.parse(e):"padding"!==t.type||"number"!=typeof e&&!Array.isArray(e)?"numberArray"!==t.type||"number"!=typeof e&&!Array.isArray(e)?"colorArray"!==t.type||"string"!=typeof e&&!Array.isArray(e)?"variableAnchorOffsetCollection"===t.type&&Array.isArray(e)?r=Ce.parse(e):"projectionDefinition"===t.type&&"string"==typeof e&&(r=Le.parse(e)):r=ze.parse(e):r=Pe.parse(e):r=De.parse(e),{globalStateRefs:new Set,_globalState:null,kind:"constant",evaluate:()=>r}}}(void 0===t?e.specification.default:t,e.specification,r)}isDataDriven(){return"source"===this.expression.kind||"composite"===this.expression.kind}getGlobalStateRefs(){return this.expression.globalStateRefs||new Set}possiblyEvaluate(e,t,r){return this.property.possiblyEvaluate(this,e,t,r)}}class Zi{constructor(e,t){this.property=e,this.value=new Yi(e,void 0,t)}transitioned(e,t){return new Wi(this.property,this.value,t,d({},e.transition,this.transition),e.now)}untransitioned(){return new Wi(this.property,this.value,null,{},0)}}class Hi{constructor(e,t){this._properties=e,this._values=Object.create(e.defaultTransitionablePropertyValues),this._globalState=t}getValue(e){return m(this._values[e].value.value)}setValue(e,t){Object.prototype.hasOwnProperty.call(this._values,e)||(this._values[e]=new Zi(this._values[e].property,this._globalState)),this._values[e].value=new Yi(this._values[e].property,null===t?void 0:m(t),this._globalState)}getTransition(e){return m(this._values[e].transition)}setTransition(e,t){Object.prototype.hasOwnProperty.call(this._values,e)||(this._values[e]=new Zi(this._values[e].property,this._globalState)),this._values[e].transition=m(t)||void 0}serialize(){const e={};for(const t of Object.keys(this._values)){const r=this.getValue(t);void 0!==r&&(e[t]=r);const n=this.getTransition(t);void 0!==n&&(e[`${t}${Xi}`]=n)}return e}transitioned(e,t){const r=new Ji(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].transitioned(e,t._values[n]);return r}untransitioned(){const e=new Ji(this._properties);for(const t of Object.keys(this._values))e._values[t]=this._values[t].untransitioned();return e}}class Wi{constructor(e,t,r,n,i){this.property=e,this.value=t,this.begin=i+n.delay||0,this.end=this.begin+n.duration||0,e.specification.transition&&(n.delay||n.duration)&&(this.prior=r)}possiblyEvaluate(e,t,r){const n=e.now||0,i=this.value.possiblyEvaluate(e,t,r),s=this.prior;if(s){if(n>this.end)return this.prior=null,i;if(this.value.isDataDriven())return this.prior=null,i;if(n<this.begin)return s.possiblyEvaluate(e,t,r);{const o=(n-this.begin)/(this.end-this.begin);return this.property.interpolate(s.possiblyEvaluate(e,t,r),i,function(e){if(e<=0)return 0;if(e>=1)return 1;const t=e*e,r=t*e;return 4*(e<.5?r:3*(e-t)+r-.75)}(o))}}return i}}class Ji{constructor(e){this._properties=e,this._values=Object.create(e.defaultTransitioningPropertyValues)}possiblyEvaluate(e,t,r){const n=new es(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(e,t,r);return n}hasTransition(){for(const e of Object.keys(this._values))if(this._values[e].prior)return!0;return!1}}class Ki{constructor(e,t){this._properties=e,this._values=Object.create(e.defaultPropertyValues),this._globalState=t}hasValue(e){return void 0!==this._values[e].value}getValue(e){return m(this._values[e].value)}setValue(e,t){this._values[e]=new Yi(this._values[e].property,null===t?void 0:m(t),this._globalState)}serialize(){const e={};for(const t of Object.keys(this._values)){const r=this.getValue(t);void 0!==r&&(e[t]=r)}return e}possiblyEvaluate(e,t,r){const n=new es(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(e,t,r);return n}}class Qi{constructor(e,t,r){this.property=e,this.value=t,this.parameters=r}isConstant(){return"constant"===this.value.kind}constantOr(e){return"constant"===this.value.kind?this.value.value:e}evaluate(e,t,r,n){return this.property.evaluate(this.value,this.parameters,e,t,r,n)}}class es{constructor(e){this._properties=e,this._values=Object.create(e.defaultPossiblyEvaluatedValues)}get(e){return this._values[e]}}class ts{constructor(e){this.specification=e}possiblyEvaluate(e,t){if(e.isDataDriven())throw new Error("Value should not be data driven");return e.expression.evaluate(t)}interpolate(e,t,r){const n=ft[this.specification.type];return n?n(e,t,r):e}}class rs{constructor(e,t){this.specification=e,this.overrides=t}possiblyEvaluate(e,t,r,n){return new Qi(this,"constant"===e.expression.kind||"camera"===e.expression.kind?{kind:"constant",value:e.expression.evaluate(t,null,{},r,n)}:e.expression,t)}interpolate(e,t,r){if("constant"!==e.value.kind||"constant"!==t.value.kind)return e;if(void 0===e.value.value||void 0===t.value.value)return new Qi(this,{kind:"constant",value:void 0},e.parameters);const n=ft[this.specification.type];if(n){const i=n(e.value.value,t.value.value,r);return new Qi(this,{kind:"constant",value:i},e.parameters)}return e}evaluate(e,t,r,n,i,s){return"constant"===e.kind?e.value:e.evaluate(t,r,n,i,s)}}class ns extends rs{possiblyEvaluate(e,t,r,n){if(void 0===e.value)return new Qi(this,{kind:"constant",value:void 0},t);if("constant"===e.expression.kind){const i=e.expression.evaluate(t,null,{},r,n),s="resolvedImage"===e.property.specification.type&&"string"!=typeof i?i.name:i,o=this._calculate(s,s,s,t);return new Qi(this,{kind:"constant",value:o},t)}if("camera"===e.expression.kind){const r=this._calculate(e.expression.evaluate({zoom:t.zoom-1}),e.expression.evaluate({zoom:t.zoom}),e.expression.evaluate({zoom:t.zoom+1}),t);return new Qi(this,{kind:"constant",value:r},t)}return new Qi(this,e.expression,t)}evaluate(e,t,r,n,i,s){if("source"===e.kind){const o=e.evaluate(t,r,n,i,s);return this._calculate(o,o,o,t)}return"composite"===e.kind?this._calculate(e.evaluate({zoom:Math.floor(t.zoom)-1},r,n),e.evaluate({zoom:Math.floor(t.zoom)},r,n),e.evaluate({zoom:Math.floor(t.zoom)+1},r,n),t):e.value}_calculate(e,t,r,n){return n.zoom>n.zoomHistory.lastIntegerZoom?{from:e,to:t}:{from:r,to:t}}interpolate(e){return e}}class is{constructor(e){this.specification=e}possiblyEvaluate(e,t,r,n){if(void 0!==e.value){if("constant"===e.expression.kind){const i=e.expression.evaluate(t,null,{},r,n);return this._calculate(i,i,i,t)}return this._calculate(e.expression.evaluate(new Gi(Math.floor(t.zoom-1),t)),e.expression.evaluate(new Gi(Math.floor(t.zoom),t)),e.expression.evaluate(new Gi(Math.floor(t.zoom+1),t)),t)}}_calculate(e,t,r,n){return n.zoom>n.zoomHistory.lastIntegerZoom?{from:e,to:t}:{from:r,to:t}}interpolate(e){return e}}class ss{constructor(e){this.specification=e}possiblyEvaluate(e,t,r,n){return!!e.expression.evaluate(t,null,{},r,n)}interpolate(){return!1}}class os{constructor(e){this.properties=e,this.defaultPropertyValues={},this.defaultTransitionablePropertyValues={},this.defaultTransitioningPropertyValues={},this.defaultPossiblyEvaluatedValues={},this.overridableProperties=[];for(const t in e){const r=e[t];r.specification.overridable&&this.overridableProperties.push(t);const n=this.defaultPropertyValues[t]=new Yi(r,void 0,void 0),i=this.defaultTransitionablePropertyValues[t]=new Zi(r,void 0);this.defaultTransitioningPropertyValues[t]=i.untransitioned(),this.defaultPossiblyEvaluatedValues[t]=n.possiblyEvaluate({})}}}pi("DataDrivenProperty",rs),pi("DataConstantProperty",ts),pi("CrossFadedDataDrivenProperty",ns),pi("CrossFadedProperty",is),pi("ColorRampProperty",ss);class as extends Ii{constructor(e,t,r){if(super(),this.id=e.id,this.type=e.type,this._globalState=r,this._featureFilter={filter:()=>!0,needGeometry:!1,getGlobalStateRefs:()=>new Set},this._visibilityExpression=function(e,t){return new ei(e,t)}(this.visibility,r),"custom"!==e.type&&(this.metadata=e.metadata,this.minzoom=e.minzoom,this.maxzoom=e.maxzoom,"background"!==e.type&&(this.source=e.source,this.sourceLayer=e["source-layer"],this.filter=e.filter,this._featureFilter=hn(e.filter,r)),t.layout&&(this._unevaluatedLayout=new Ki(t.layout,r)),t.paint)){this._transitionablePaint=new Hi(t.paint,r);for(const t in e.paint)this.setPaintProperty(t,e.paint[t],{validate:!1});for(const t in e.layout)this.setLayoutProperty(t,e.layout[t],{validate:!1});this._transitioningPaint=this._transitionablePaint.untransitioned(),this.paint=new es(t.paint)}}setFilter(e){this.filter=e,this._featureFilter=hn(e,this._globalState)}getCrossfadeParameters(){return this._crossfadeParameters}getLayoutProperty(e){return"visibility"===e?this.visibility:this._unevaluatedLayout.getValue(e)}getLayoutAffectingGlobalStateRefs(){const e=new Set;for(const t of this._visibilityExpression.getGlobalStateRefs())e.add(t);if(this._unevaluatedLayout)for(const t in this._unevaluatedLayout._values){const r=this._unevaluatedLayout._values[t];for(const t of r.getGlobalStateRefs())e.add(t)}for(const t of this._featureFilter.getGlobalStateRefs())e.add(t);return e}getPaintAffectingGlobalStateRefs(){var e;const t=new globalThis.Map;if(this._transitionablePaint)for(const r in this._transitionablePaint._values){const n=this._transitionablePaint._values[r].value;for(const i of n.getGlobalStateRefs()){const s=null!==(e=t.get(i))&&void 0!==e?e:[];s.push({name:r,value:n.value}),t.set(i,s)}}return t}getVisibilityAffectingGlobalStateRefs(){return this._visibilityExpression.getGlobalStateRefs()}setLayoutProperty(e,t,r={}){if(null==t||!this._validate(Ei,`layers.${this.id}.layout.${e}`,e,t,r))return"visibility"===e?(this.visibility=t,this._visibilityExpression.setValue(t),void this.recalculateVisibility()):void this._unevaluatedLayout.setValue(e,t)}getPaintProperty(e){return e.endsWith(Xi)?this._transitionablePaint.getTransition(e.slice(0,-11)):this._transitionablePaint.getValue(e)}setPaintProperty(e,t,r={}){if(null!=t&&this._validate(ki,`layers.${this.id}.paint.${e}`,e,t,r))return!1;if(e.endsWith(Xi))return this._transitionablePaint.setTransition(e.slice(0,-11),t||void 0),!1;{const r=this._transitionablePaint._values[e],n="cross-faded-data-driven"===r.property.specification["property-type"],i=r.value.isDataDriven(),s=r.value;this._transitionablePaint.setValue(e,t),this._handleSpecialPaintPropertyUpdate(e);const o=this._transitionablePaint._values[e].value;return o.isDataDriven()||i||n||this._handleOverridablePaintPropertyUpdate(e,s,o)}}_handleSpecialPaintPropertyUpdate(e){}_handleOverridablePaintPropertyUpdate(e,t,r){return!1}isHidden(e=this.minzoom,t=!1){return!!(this.minzoom&&e<(t?Math.floor(this.minzoom):this.minzoom))||!!(this.maxzoom&&e>=this.maxzoom)||"none"===this._evaluatedVisibility}updateTransitions(e){this._transitioningPaint=this._transitionablePaint.transitioned(e,this._transitioningPaint)}hasTransition(){return this._transitioningPaint.hasTransition()}recalculateVisibility(){this._evaluatedVisibility=this._visibilityExpression.evaluate()}recalculate(e,t){e.getCrossfadeParameters&&(this._crossfadeParameters=e.getCrossfadeParameters()),this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(e,void 0,t)),this.paint=this._transitioningPaint.possiblyEvaluate(e,void 0,t)}serialize(){const e={id:this.id,type:this.type,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()};return this.visibility&&(e.layout=e.layout||{},e.layout.visibility=this.visibility),function(e,t){const r={};for(const n in e)t.call(this,e[n],n,e)&&(r[n]=e[n]);return r}(e,((e,t)=>!(void 0===e||"layout"===t&&!Object.keys(e).length||"paint"===t&&!Object.keys(e).length)))}_validate(e,t,r,n,i={}){return(!i||!1!==i.validate)&&function(e,t){let r=!1;if(t&&t.length)for(const n of t)e.fire(new Ai(new Error(n.message))),r=!0;return r}(this,e.call(Ti,{key:t,layerType:this.type,objectKey:r,value:n,styleSpec:k,style:{glyphs:!0,sprite:!0}}))}is3D(){return!1}isTileClipped(){return!1}hasOffscreenPass(){return!1}resize(){}isStateDependent(){for(const e in this.paint._values){const t=this.paint.get(e);if(t instanceof Qi&&Nr(t.property.specification)&&("source"===t.value.kind||"composite"===t.value.kind)&&t.value.isStateDependent)return!0}return!1}}const ls={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class us{constructor(e,t){this._structArray=e,this._pos1=t*this.size,this._pos2=this._pos1/2,this._pos4=this._pos1/4,this._pos8=this._pos1/8}}class cs{constructor(){this.isTransferred=!1,this.capacity=-1,this.resize(0)}static serialize(e,t){return e._trim(),t&&(e.isTransferred=!0,t.push(e.arrayBuffer)),{length:e.length,arrayBuffer:e.arrayBuffer}}static deserialize(e){const t=Object.create(this.prototype);return t.arrayBuffer=e.arrayBuffer,t.length=e.length,t.capacity=e.arrayBuffer.byteLength/t.bytesPerElement,t._refreshViews(),t}_trim(){this.length!==this.capacity&&(this.capacity=this.length,this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement),this._refreshViews())}clear(){this.length=0}resize(e){this.reserve(e),this.length=e}reserve(e){if(e>this.capacity){this.capacity=Math.max(e,Math.floor(5*this.capacity),128),this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const t=this.uint8;this._refreshViews(),t&&this.uint8.set(t)}}_refreshViews(){throw new Error("_refreshViews() must be implemented by each concrete StructArray layout")}}function hs(e,t=1){let r=0,n=0;return{members:e.map((e=>{const i=ls[e.type].BYTES_PER_ELEMENT,s=r=ps(r,Math.max(t,i)),o=e.components||1;return n=Math.max(n,i),r+=i*o,{name:e.name,type:e.type,components:o,offset:s}})),size:ps(r,Math.max(n,t)),alignment:t}}function ps(e,t){return Math.ceil(e/t)*t}class fs extends cs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(e,t){const r=this.length;return this.resize(r+1),this.emplace(r,e,t)}emplace(e,t,r){const n=2*e;return this.int16[n+0]=t,this.int16[n+1]=r,e}}fs.prototype.bytesPerElement=4,pi("StructArrayLayout2i4",fs);class ds extends cs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(e,t,r){const n=this.length;return this.resize(n+1),this.emplace(n,e,t,r)}emplace(e,t,r,n){const i=3*e;return this.int16[i+0]=t,this.int16[i+1]=r,this.int16[i+2]=n,e}}ds.prototype.bytesPerElement=6,pi("StructArrayLayout3i6",ds);class ys extends cs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(e,t,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,e,t,r,n)}emplace(e,t,r,n,i){const s=4*e;return this.int16[s+0]=t,this.int16[s+1]=r,this.int16[s+2]=n,this.int16[s+3]=i,e}}ys.prototype.bytesPerElement=8,pi("StructArrayLayout4i8",ys);class ms extends cs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(e,t,r,n,i,s){const o=this.length;return this.resize(o+1),this.emplace(o,e,t,r,n,i,s)}emplace(e,t,r,n,i,s,o){const a=6*e;return this.int16[a+0]=t,this.int16[a+1]=r,this.int16[a+2]=n,this.int16[a+3]=i,this.int16[a+4]=s,this.int16[a+5]=o,e}}ms.prototype.bytesPerElement=12,pi("StructArrayLayout2i4i12",ms);class gs extends cs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(e,t,r,n,i,s){const o=this.length;return this.resize(o+1),this.emplace(o,e,t,r,n,i,s)}emplace(e,t,r,n,i,s,o){const a=4*e,l=8*e;return this.int16[a+0]=t,this.int16[a+1]=r,this.uint8[l+4]=n,this.uint8[l+5]=i,this.uint8[l+6]=s,this.uint8[l+7]=o,e}}gs.prototype.bytesPerElement=8,pi("StructArrayLayout2i4ub8",gs);class xs extends cs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t){const r=this.length;return this.resize(r+1),this.emplace(r,e,t)}emplace(e,t,r){const n=2*e;return this.float32[n+0]=t,this.float32[n+1]=r,e}}xs.prototype.bytesPerElement=8,pi("StructArrayLayout2f8",xs);class vs extends cs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(e,t,r,n,i,s,o,a,l,u){const c=this.length;return this.resize(c+1),this.emplace(c,e,t,r,n,i,s,o,a,l,u)}emplace(e,t,r,n,i,s,o,a,l,u,c){const h=10*e;return this.uint16[h+0]=t,this.uint16[h+1]=r,this.uint16[h+2]=n,this.uint16[h+3]=i,this.uint16[h+4]=s,this.uint16[h+5]=o,this.uint16[h+6]=a,this.uint16[h+7]=l,this.uint16[h+8]=u,this.uint16[h+9]=c,e}}vs.prototype.bytesPerElement=20,pi("StructArrayLayout10ui20",vs);class bs extends cs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(e,t,r,n,i,s,o,a){const l=this.length;return this.resize(l+1),this.emplace(l,e,t,r,n,i,s,o,a)}emplace(e,t,r,n,i,s,o,a,l){const u=8*e;return this.uint16[u+0]=t,this.uint16[u+1]=r,this.uint16[u+2]=n,this.uint16[u+3]=i,this.uint16[u+4]=s,this.uint16[u+5]=o,this.uint16[u+6]=a,this.uint16[u+7]=l,e}}bs.prototype.bytesPerElement=16,pi("StructArrayLayout8ui16",bs);class ws extends cs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(e,t,r,n,i,s,o,a,l,u,c,h){const p=this.length;return this.resize(p+1),this.emplace(p,e,t,r,n,i,s,o,a,l,u,c,h)}emplace(e,t,r,n,i,s,o,a,l,u,c,h,p){const f=12*e;return this.int16[f+0]=t,this.int16[f+1]=r,this.int16[f+2]=n,this.int16[f+3]=i,this.uint16[f+4]=s,this.uint16[f+5]=o,this.uint16[f+6]=a,this.uint16[f+7]=l,this.int16[f+8]=u,this.int16[f+9]=c,this.int16[f+10]=h,this.int16[f+11]=p,e}}ws.prototype.bytesPerElement=24,pi("StructArrayLayout4i4ui4i24",ws);class _s extends cs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t,r){const n=this.length;return this.resize(n+1),this.emplace(n,e,t,r)}emplace(e,t,r,n){const i=3*e;return this.float32[i+0]=t,this.float32[i+1]=r,this.float32[i+2]=n,e}}_s.prototype.bytesPerElement=12,pi("StructArrayLayout3f12",_s);class Ss extends cs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer)}emplaceBack(e){const t=this.length;return this.resize(t+1),this.emplace(t,e)}emplace(e,t){return this.uint32[1*e+0]=t,e}}Ss.prototype.bytesPerElement=4,pi("StructArrayLayout1ul4",Ss);class As extends cs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(e,t,r,n,i,s,o,a,l){const u=this.length;return this.resize(u+1),this.emplace(u,e,t,r,n,i,s,o,a,l)}emplace(e,t,r,n,i,s,o,a,l,u){const c=10*e,h=5*e;return this.int16[c+0]=t,this.int16[c+1]=r,this.int16[c+2]=n,this.int16[c+3]=i,this.int16[c+4]=s,this.int16[c+5]=o,this.uint32[h+3]=a,this.uint16[c+8]=l,this.uint16[c+9]=u,e}}As.prototype.bytesPerElement=20,pi("StructArrayLayout6i1ul2ui20",As);class Is extends cs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(e,t,r,n,i,s){const o=this.length;return this.resize(o+1),this.emplace(o,e,t,r,n,i,s)}emplace(e,t,r,n,i,s,o){const a=6*e;return this.int16[a+0]=t,this.int16[a+1]=r,this.int16[a+2]=n,this.int16[a+3]=i,this.int16[a+4]=s,this.int16[a+5]=o,e}}Is.prototype.bytesPerElement=12,pi("StructArrayLayout2i2i2i12",Is);class Ts extends cs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(e,t,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,e,t,r,n,i)}emplace(e,t,r,n,i,s){const o=4*e,a=8*e;return this.float32[o+0]=t,this.float32[o+1]=r,this.float32[o+2]=n,this.int16[a+6]=i,this.int16[a+7]=s,e}}Ts.prototype.bytesPerElement=16,pi("StructArrayLayout2f1f2i16",Ts);class ks extends cs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(e,t,r,n,i,s){const o=this.length;return this.resize(o+1),this.emplace(o,e,t,r,n,i,s)}emplace(e,t,r,n,i,s,o){const a=16*e,l=4*e,u=8*e;return this.uint8[a+0]=t,this.uint8[a+1]=r,this.float32[l+1]=n,this.float32[l+2]=i,this.int16[u+6]=s,this.int16[u+7]=o,e}}ks.prototype.bytesPerElement=16,pi("StructArrayLayout2ub2f2i16",ks);class Es extends cs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(e,t,r){const n=this.length;return this.resize(n+1),this.emplace(n,e,t,r)}emplace(e,t,r,n){const i=3*e;return this.uint16[i+0]=t,this.uint16[i+1]=r,this.uint16[i+2]=n,e}}Es.prototype.bytesPerElement=6,pi("StructArrayLayout3ui6",Es);class Ms extends cs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t,r,n,i,s,o,a,l,u,c,h,p,f,d,y,m){const g=this.length;return this.resize(g+1),this.emplace(g,e,t,r,n,i,s,o,a,l,u,c,h,p,f,d,y,m)}emplace(e,t,r,n,i,s,o,a,l,u,c,h,p,f,d,y,m,g){const x=24*e,v=12*e,b=48*e;return this.int16[x+0]=t,this.int16[x+1]=r,this.uint16[x+2]=n,this.uint16[x+3]=i,this.uint32[v+2]=s,this.uint32[v+3]=o,this.uint32[v+4]=a,this.uint16[x+10]=l,this.uint16[x+11]=u,this.uint16[x+12]=c,this.float32[v+7]=h,this.float32[v+8]=p,this.uint8[b+36]=f,this.uint8[b+37]=d,this.uint8[b+38]=y,this.uint32[v+10]=m,this.int16[x+22]=g,e}}Ms.prototype.bytesPerElement=48,pi("StructArrayLayout2i2ui3ul3ui2f3ub1ul1i48",Ms);class Ds extends cs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t,r,n,i,s,o,a,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,A,I,T,k){const E=this.length;return this.resize(E+1),this.emplace(E,e,t,r,n,i,s,o,a,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,A,I,T,k)}emplace(e,t,r,n,i,s,o,a,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,A,I,T,k,E){const M=32*e,D=16*e;return this.int16[M+0]=t,this.int16[M+1]=r,this.int16[M+2]=n,this.int16[M+3]=i,this.int16[M+4]=s,this.int16[M+5]=o,this.int16[M+6]=a,this.int16[M+7]=l,this.uint16[M+8]=u,this.uint16[M+9]=c,this.uint16[M+10]=h,this.uint16[M+11]=p,this.uint16[M+12]=f,this.uint16[M+13]=d,this.uint16[M+14]=y,this.uint16[M+15]=m,this.uint16[M+16]=g,this.uint16[M+17]=x,this.uint16[M+18]=v,this.uint16[M+19]=b,this.uint16[M+20]=w,this.uint16[M+21]=_,this.uint16[M+22]=S,this.uint32[D+12]=A,this.float32[D+13]=I,this.float32[D+14]=T,this.uint16[M+30]=k,this.uint16[M+31]=E,e}}Ds.prototype.bytesPerElement=64,pi("StructArrayLayout8i15ui1ul2f2ui64",Ds);class Ps extends cs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e){const t=this.length;return this.resize(t+1),this.emplace(t,e)}emplace(e,t){return this.float32[1*e+0]=t,e}}Ps.prototype.bytesPerElement=4,pi("StructArrayLayout1f4",Ps);class zs extends cs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t,r){const n=this.length;return this.resize(n+1),this.emplace(n,e,t,r)}emplace(e,t,r,n){const i=3*e;return this.uint16[6*e+0]=t,this.float32[i+1]=r,this.float32[i+2]=n,e}}zs.prototype.bytesPerElement=12,pi("StructArrayLayout1ui2f12",zs);class Fs extends cs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(e,t,r){const n=this.length;return this.resize(n+1),this.emplace(n,e,t,r)}emplace(e,t,r,n){const i=4*e;return this.uint32[2*e+0]=t,this.uint16[i+2]=r,this.uint16[i+3]=n,e}}Fs.prototype.bytesPerElement=8,pi("StructArrayLayout1ul2ui8",Fs);class Bs extends cs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(e,t){const r=this.length;return this.resize(r+1),this.emplace(r,e,t)}emplace(e,t,r){const n=2*e;return this.uint16[n+0]=t,this.uint16[n+1]=r,e}}Bs.prototype.bytesPerElement=4,pi("StructArrayLayout2ui4",Bs);class Cs extends cs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(e){const t=this.length;return this.resize(t+1),this.emplace(t,e)}emplace(e,t){return this.uint16[1*e+0]=t,e}}Cs.prototype.bytesPerElement=2,pi("StructArrayLayout1ui2",Cs);class Vs extends cs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,e,t,r,n)}emplace(e,t,r,n,i){const s=4*e;return this.float32[s+0]=t,this.float32[s+1]=r,this.float32[s+2]=n,this.float32[s+3]=i,e}}Vs.prototype.bytesPerElement=16,pi("StructArrayLayout4f16",Vs);class Ls extends us{get anchorPointX(){return this._structArray.int16[this._pos2+0]}get anchorPointY(){return this._structArray.int16[this._pos2+1]}get x1(){return this._structArray.int16[this._pos2+2]}get y1(){return this._structArray.int16[this._pos2+3]}get x2(){return this._structArray.int16[this._pos2+4]}get y2(){return this._structArray.int16[this._pos2+5]}get featureIndex(){return this._structArray.uint32[this._pos4+3]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+8]}get bucketIndex(){return this._structArray.uint16[this._pos2+9]}get anchorPoint(){return new t(this.anchorPointX,this.anchorPointY)}}Ls.prototype.size=20;class Os extends As{get(e){return new Ls(this,e)}}pi("CollisionBoxArray",Os);class Rs extends us{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get glyphStartIndex(){return this._structArray.uint16[this._pos2+2]}get numGlyphs(){return this._structArray.uint16[this._pos2+3]}get vertexStartIndex(){return this._structArray.uint32[this._pos4+2]}get lineStartIndex(){return this._structArray.uint32[this._pos4+3]}get lineLength(){return this._structArray.uint32[this._pos4+4]}get segment(){return this._structArray.uint16[this._pos2+10]}get lowerSize(){return this._structArray.uint16[this._pos2+11]}get upperSize(){return this._structArray.uint16[this._pos2+12]}get lineOffsetX(){return this._structArray.float32[this._pos4+7]}get lineOffsetY(){return this._structArray.float32[this._pos4+8]}get writingMode(){return this._structArray.uint8[this._pos1+36]}get placedOrientation(){return this._structArray.uint8[this._pos1+37]}set placedOrientation(e){this._structArray.uint8[this._pos1+37]=e}get hidden(){return this._structArray.uint8[this._pos1+38]}set hidden(e){this._structArray.uint8[this._pos1+38]=e}get crossTileID(){return this._structArray.uint32[this._pos4+10]}set crossTileID(e){this._structArray.uint32[this._pos4+10]=e}get associatedIconIndex(){return this._structArray.int16[this._pos2+22]}}Rs.prototype.size=48;class Ns extends Ms{get(e){return new Rs(this,e)}}pi("PlacedSymbolArray",Ns);class $s extends us{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+2]}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+3]}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+4]}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+5]}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+6]}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+7]}get key(){return this._structArray.uint16[this._pos2+8]}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+9]}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+10]}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+11]}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+12]}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+13]}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+14]}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+15]}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+16]}get featureIndex(){return this._structArray.uint16[this._pos2+17]}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+18]}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+19]}get numIconVertices(){return this._structArray.uint16[this._pos2+20]}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+21]}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+22]}get crossTileID(){return this._structArray.uint32[this._pos4+12]}set crossTileID(e){this._structArray.uint32[this._pos4+12]=e}get textBoxScale(){return this._structArray.float32[this._pos4+13]}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+14]}get textAnchorOffsetStartIndex(){return this._structArray.uint16[this._pos2+30]}get textAnchorOffsetEndIndex(){return this._structArray.uint16[this._pos2+31]}}$s.prototype.size=64;class Us extends Ds{get(e){return new $s(this,e)}}pi("SymbolInstanceArray",Us);class qs extends Ps{getoffsetX(e){return this.float32[1*e+0]}}pi("GlyphOffsetArray",qs);class Gs extends ds{getx(e){return this.int16[3*e+0]}gety(e){return this.int16[3*e+1]}gettileUnitDistanceFromAnchor(e){return this.int16[3*e+2]}}pi("SymbolLineVertexArray",Gs);class js extends us{get textAnchor(){return this._structArray.uint16[this._pos2+0]}get textOffset0(){return this._structArray.float32[this._pos4+1]}get textOffset1(){return this._structArray.float32[this._pos4+2]}}js.prototype.size=12;class Xs extends zs{get(e){return new js(this,e)}}pi("TextAnchorOffsetArray",Xs);class Ys extends us{get featureIndex(){return this._structArray.uint32[this._pos4+0]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2]}get bucketIndex(){return this._structArray.uint16[this._pos2+3]}}Ys.prototype.size=8;class Zs extends Fs{get(e){return new Ys(this,e)}}pi("FeatureIndexArray",Zs);class Hs extends fs{}class Ws extends fs{}class Js extends fs{}class Ks extends ms{}class Qs extends gs{}class eo extends xs{}class to extends vs{}class ro extends bs{}class no extends ws{}class io extends _s{}class so extends Ss{}class oo extends Is{}class ao extends ks{}class lo extends Es{}class uo extends Bs{}const co=hs([{name:"a_pos",components:2,type:"Int16"}],4),{members:ho}=co;class po{constructor(e=[]){this._forceNewSegmentOnNextPrepare=!1,this.segments=e}prepareSegment(e,t,r,n){const i=this.segments[this.segments.length-1];return e>po.MAX_VERTEX_ARRAY_LENGTH&&x(`Max vertices per segment is ${po.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${e}. Consider using the \`fillLargeMeshArrays\` function if you require meshes with more than ${po.MAX_VERTEX_ARRAY_LENGTH} vertices.`),this._forceNewSegmentOnNextPrepare||!i||i.vertexLength+e>po.MAX_VERTEX_ARRAY_LENGTH||i.sortKey!==n?this.createNewSegment(t,r,n):i}createNewSegment(e,t,r){const n={vertexOffset:e.length,primitiveOffset:t.length,vertexLength:0,primitiveLength:0,vaos:{}};return void 0!==r&&(n.sortKey=r),this._forceNewSegmentOnNextPrepare=!1,this.segments.push(n),n}getOrCreateLatestSegment(e,t,r){return this.prepareSegment(0,e,t,r)}forceNewSegmentOnNextPrepare(){this._forceNewSegmentOnNextPrepare=!0}get(){return this.segments}destroy(){for(const e of this.segments)for(const t in e.vaos)e.vaos[t].destroy()}static simpleSegment(e,t,r,n){return new po([{vertexOffset:e,primitiveOffset:t,vertexLength:r,primitiveLength:n,vaos:{},sortKey:0}])}}function fo(e,t){return 256*(e=f(Math.floor(e),0,255))+f(Math.floor(t),0,255)}po.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1,pi("SegmentVector",po);const yo=hs([{name:"a_pattern_from",components:4,type:"Uint16"},{name:"a_pattern_to",components:4,type:"Uint16"},{name:"a_pixel_ratio_from",components:1,type:"Uint16"},{name:"a_pixel_ratio_to",components:1,type:"Uint16"}]),mo=hs([{name:"a_dasharray_from",components:4,type:"Uint16"},{name:"a_dasharray_to",components:4,type:"Uint16"}]);var go,xo,vo,bo={exports:{}},wo={exports:{}},_o={exports:{}},So=function(){if(vo)return bo.exports;vo=1;var e=(go||(go=1,wo.exports=function(e,t){var r,n,i,s,o,a,l,u;for(n=e.length-(r=3&e.length),i=t,o=3432918353,a=461845907,u=0;u<n;)l=255&e.charCodeAt(u)|(255&e.charCodeAt(++u))<<8|(255&e.charCodeAt(++u))<<16|(255&e.charCodeAt(++u))<<24,++u,i=27492+(65535&(s=5*(65535&(i=(i^=l=(65535&(l=(l=(65535&l)*o+(((l>>>16)*o&65535)<<16)&4294967295)<<15|l>>>17))*a+(((l>>>16)*a&65535)<<16)&4294967295)<<13|i>>>19))+((5*(i>>>16)&65535)<<16)&4294967295))+((58964+(s>>>16)&65535)<<16);switch(l=0,r){case 3:l^=(255&e.charCodeAt(u+2))<<16;case 2:l^=(255&e.charCodeAt(u+1))<<8;case 1:i^=l=(65535&(l=(l=(65535&(l^=255&e.charCodeAt(u)))*o+(((l>>>16)*o&65535)<<16)&4294967295)<<15|l>>>17))*a+(((l>>>16)*a&65535)<<16)&4294967295}return i^=e.length,i=2246822507*(65535&(i^=i>>>16))+((2246822507*(i>>>16)&65535)<<16)&4294967295,i=3266489909*(65535&(i^=i>>>13))+((3266489909*(i>>>16)&65535)<<16)&4294967295,(i^=i>>>16)>>>0}),wo.exports),t=(xo||(xo=1,_o.exports=function(e,t){for(var r,n=e.length,i=t^n,s=0;n>=4;)r=1540483477*(65535&(r=255&e.charCodeAt(s)|(255&e.charCodeAt(++s))<<8|(255&e.charCodeAt(++s))<<16|(255&e.charCodeAt(++s))<<24))+((1540483477*(r>>>16)&65535)<<16),i=1540483477*(65535&i)+((1540483477*(i>>>16)&65535)<<16)^(r=1540483477*(65535&(r^=r>>>24))+((1540483477*(r>>>16)&65535)<<16)),n-=4,++s;switch(n){case 3:i^=(255&e.charCodeAt(s+2))<<16;case 2:i^=(255&e.charCodeAt(s+1))<<8;case 1:i=1540483477*(65535&(i^=255&e.charCodeAt(s)))+((1540483477*(i>>>16)&65535)<<16)}return i=1540483477*(65535&(i^=i>>>13))+((1540483477*(i>>>16)&65535)<<16),(i^=i>>>15)>>>0}),_o.exports);return bo.exports=e,bo.exports.murmur3=e,bo.exports.murmur2=t,bo.exports}(),Ao=r(So);class Io{constructor(){this.ids=[],this.positions=[],this.indexed=!1}add(e,t,r,n){this.ids.push(To(e)),this.positions.push(t,r,n)}getPositions(e){if(!this.indexed)throw new Error("Trying to get index, but feature positions are not indexed");const t=To(e);let r=0,n=this.ids.length-1;for(;r<n;){const e=r+n>>1;this.ids[e]>=t?n=e:r=e+1}const i=[];for(;this.ids[r]===t;)i.push({index:this.positions[3*r],start:this.positions[3*r+1],end:this.positions[3*r+2]}),r++;return i}static serialize(e,t){const r=new Float64Array(e.ids),n=new Uint32Array(e.positions);return ko(r,n,0,r.length-1),t&&t.push(r.buffer,n.buffer),{ids:r,positions:n}}static deserialize(e){const t=new Io;return t.ids=e.ids,t.positions=e.positions,t.indexed=!0,t}}function To(e){const t=+e;return!isNaN(t)&&t<=Number.MAX_SAFE_INTEGER?t:Ao(String(e))}function ko(e,t,r,n){for(;r<n;){const i=e[r+n>>1];let s=r-1,o=n+1;for(;;){do{s++}while(e[s]<i);do{o--}while(e[o]>i);if(s>=o)break;Eo(e,s,o),Eo(t,3*s,3*o),Eo(t,3*s+1,3*o+1),Eo(t,3*s+2,3*o+2)}o-r<n-o?(ko(e,t,r,o),r=o+1):(ko(e,t,o+1,n),n=o)}}function Eo(e,t,r){const n=e[t];e[t]=e[r],e[r]=n}pi("FeaturePositionMap",Io);class Mo{constructor(e,t){this.gl=e.gl,this.location=t}}class Do extends Mo{constructor(e,t){super(e,t),this.current=0}set(e){this.current!==e&&(this.current=e,this.gl.uniform1f(this.location,e))}}class Po extends Mo{constructor(e,t){super(e,t),this.current=[0,0,0,0]}set(e){e[0]===this.current[0]&&e[1]===this.current[1]&&e[2]===this.current[2]&&e[3]===this.current[3]||(this.current=e,this.gl.uniform4f(this.location,e[0],e[1],e[2],e[3]))}}class zo extends Mo{constructor(e,t){super(e,t),this.current=Ie.transparent}set(e){e.r===this.current.r&&e.g===this.current.g&&e.b===this.current.b&&e.a===this.current.a||(this.current=e,this.gl.uniform4f(this.location,e.r,e.g,e.b,e.a))}}function Fo(e){return[fo(255*e.r,255*e.g),fo(255*e.b,255*e.a)]}class Bo{constructor(e,t,r){this.value=e,this.uniformNames=t.map((e=>`u_${e}`)),this.type=r}setUniform(e,t,r){e.set(r.constantOr(this.value))}getBinding(e,t,r){return"color"===this.type?new zo(e,t):new Do(e,t)}}class Co{constructor(e,t){this.uniformNames=t.map((e=>`u_${e}`)),this.patternFrom=null,this.patternTo=null,this.pixelRatioFrom=1,this.pixelRatioTo=1}setConstantPatternPositions(e,t){this.pixelRatioFrom=t.pixelRatio,this.pixelRatioTo=e.pixelRatio,this.patternFrom=t.tlbr,this.patternTo=e.tlbr}setConstantDashPositions(e,t){this.dashTo=[0,e.y,e.height,e.width],this.dashFrom=[0,t.y,t.height,t.width]}setUniform(e,t,r,n){let i=null;"u_pattern_to"===n?i=this.patternTo:"u_pattern_from"===n?i=this.patternFrom:"u_dasharray_to"===n?i=this.dashTo:"u_dasharray_from"===n?i=this.dashFrom:"u_pixel_ratio_to"===n?i=this.pixelRatioTo:"u_pixel_ratio_from"===n&&(i=this.pixelRatioFrom),null!==i&&e.set(i)}getBinding(e,t,r){return"u_pattern"===r.substr(0,9)||"u_dasharray_"===r.substr(0,12)?new Po(e,t):new Do(e,t)}}class Vo{constructor(e,t,r,n){this.expression=e,this.type=r,this.maxValue=0,this.paintVertexAttributes=t.map((e=>({name:`a_${e}`,type:"Float32",components:"color"===r?2:1,offset:0}))),this.paintVertexArray=new n}populatePaintArray(e,t,r){const n=this.paintVertexArray.length,i=this.expression.evaluate(new Gi(0,r),t,{},r.canonical,[],r.formattedSection);this.paintVertexArray.resize(e),this._setPaintValue(n,e,i)}updatePaintArray(e,t,r,n,i){const s=this.expression.evaluate(new Gi(0,i),r,n);this._setPaintValue(e,t,s)}_setPaintValue(e,t,r){if("color"===this.type){const n=Fo(r);for(let r=e;r<t;r++)this.paintVertexArray.emplace(r,n[0],n[1])}else{for(let n=e;n<t;n++)this.paintVertexArray.emplace(n,r);this.maxValue=Math.max(this.maxValue,Math.abs(r))}}upload(e){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=e.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent))}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy()}}class Lo{constructor(e,t,r,n,i,s){this.expression=e,this.uniformNames=t.map((e=>`u_${e}_t`)),this.type=r,this.useIntegerZoom=n,this.zoom=i,this.maxValue=0,this.paintVertexAttributes=t.map((e=>({name:`a_${e}`,type:"Float32",components:"color"===r?4:2,offset:0}))),this.paintVertexArray=new s}populatePaintArray(e,t,r){const n=this.expression.evaluate(new Gi(this.zoom,r),t,{},r.canonical,[],r.formattedSection),i=this.expression.evaluate(new Gi(this.zoom+1,r),t,{},r.canonical,[],r.formattedSection),s=this.paintVertexArray.length;this.paintVertexArray.resize(e),this._setPaintValue(s,e,n,i)}updatePaintArray(e,t,r,n,i){const s=this.expression.evaluate(new Gi(this.zoom,i),r,n),o=this.expression.evaluate(new Gi(this.zoom+1,i),r,n);this._setPaintValue(e,t,s,o)}_setPaintValue(e,t,r,n){if("color"===this.type){const i=Fo(r),s=Fo(n);for(let r=e;r<t;r++)this.paintVertexArray.emplace(r,i[0],i[1],s[0],s[1])}else{for(let i=e;i<t;i++)this.paintVertexArray.emplace(i,r,n);this.maxValue=Math.max(this.maxValue,Math.abs(r),Math.abs(n))}}upload(e){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=e.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent))}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy()}setUniform(e,t){const r=this.useIntegerZoom?Math.floor(t.zoom):t.zoom,n=f(this.expression.interpolationFactor(r,this.zoom,this.zoom+1),0,1);e.set(n)}getBinding(e,t,r){return new Do(e,t)}}class Oo{constructor(e,t,r,n,i,s){this.expression=e,this.type=t,this.useIntegerZoom=r,this.zoom=n,this.layerId=s,this.zoomInPaintVertexArray=new i,this.zoomOutPaintVertexArray=new i}populatePaintArray(e,t,r){const n=this.zoomInPaintVertexArray.length;this.zoomInPaintVertexArray.resize(e),this.zoomOutPaintVertexArray.resize(e),this._setPaintValues(n,e,this.getPositionIds(t),r)}updatePaintArray(e,t,r,n,i){this._setPaintValues(e,t,this.getPositionIds(r),i)}_setPaintValues(e,t,r,n){const i=this.getPositions(n);if(!i||!r)return;const s=i[r.min],o=i[r.mid],a=i[r.max];if(s&&o&&a)for(let r=e;r<t;r++)this.emplace(this.zoomInPaintVertexArray,r,o,s),this.emplace(this.zoomOutPaintVertexArray,r,o,a)}upload(e){if(this.zoomInPaintVertexArray&&this.zoomInPaintVertexArray.arrayBuffer&&this.zoomOutPaintVertexArray&&this.zoomOutPaintVertexArray.arrayBuffer){const t=this.getVertexAttributes();this.zoomInPaintVertexBuffer=e.createVertexBuffer(this.zoomInPaintVertexArray,t,this.expression.isStateDependent),this.zoomOutPaintVertexBuffer=e.createVertexBuffer(this.zoomOutPaintVertexArray,t,this.expression.isStateDependent)}}destroy(){this.zoomOutPaintVertexBuffer&&this.zoomOutPaintVertexBuffer.destroy(),this.zoomInPaintVertexBuffer&&this.zoomInPaintVertexBuffer.destroy()}}class Ro extends Oo{getPositions(e){return e.imagePositions}getPositionIds(e){return e.patterns&&e.patterns[this.layerId]}getVertexAttributes(){return yo.members}emplace(e,t,r,n){e.emplace(t,r.tlbr[0],r.tlbr[1],r.tlbr[2],r.tlbr[3],n.tlbr[0],n.tlbr[1],n.tlbr[2],n.tlbr[3],r.pixelRatio,n.pixelRatio)}}class No extends Oo{getPositions(e){return e.dashPositions}getPositionIds(e){return e.dashes&&e.dashes[this.layerId]}getVertexAttributes(){return mo.members}emplace(e,t,r,n){e.emplace(t,0,r.y,r.height,r.width,0,n.y,n.height,n.width)}}class $o{constructor(e,t,r){this.binders={},this._buffers=[];const n=[];for(const i in e.paint._values){if(!r(i))continue;const s=e.paint.get(i);if(!(s instanceof Qi&&Nr(s.property.specification)))continue;const o=qo(i,e.type),a=s.value,l=s.property.specification.type,u=s.property.useIntegerZoom,c=s.property.specification["property-type"],h="cross-faded"===c||"cross-faded-data-driven"===c;if("constant"===a.kind)this.binders[i]=h?new Co(a.value,o):new Bo(a.value,o,l),n.push(`/u_${i}`);else if("source"===a.kind||h){const r=Go(i,l,"source");this.binders[i]=h?"line-dasharray"===i?new No(a,l,u,t,r,e.id):new Ro(a,l,u,t,r,e.id):new Vo(a,o,l,r),n.push(`/a_${i}`)}else{const e=Go(i,l,"composite");this.binders[i]=new Lo(a,o,l,u,t,e),n.push(`/z_${i}`)}}this.cacheKey=n.sort().join("")}getMaxValue(e){const t=this.binders[e];return t instanceof Vo||t instanceof Lo?t.maxValue:0}populatePaintArrays(e,t,r){for(const n in this.binders){const i=this.binders[n];(i instanceof Vo||i instanceof Lo||i instanceof Oo)&&i.populatePaintArray(e,t,r)}}setConstantPatternPositions(e,t){for(const r in this.binders){const n=this.binders[r];n instanceof Co&&n.setConstantPatternPositions(e,t)}}setConstantDashPositions(e,t){for(const r in this.binders){const n=this.binders[r];n instanceof Co&&n.setConstantDashPositions(e,t)}}updatePaintArrays(e,t,r,n,i){let s=!1;for(const o in e){const a=t.getPositions(o);for(const t of a){const a=r.feature(t.index);for(const r in this.binders){const l=this.binders[r];if((l instanceof Vo||l instanceof Lo||l instanceof Oo)&&!0===l.expression.isStateDependent){const u=n.paint.get(r);l.expression=u.value,l.updatePaintArray(t.start,t.end,a,e[o],i),s=!0}}}}return s}defines(){const e=[];for(const t in this.binders){const r=this.binders[t];(r instanceof Bo||r instanceof Co)&&e.push(...r.uniformNames.map((e=>`#define HAS_UNIFORM_${e}`)))}return e}getBinderAttributes(){const e=[];for(const t in this.binders){const r=this.binders[t];if(r instanceof Vo||r instanceof Lo)for(let t=0;t<r.paintVertexAttributes.length;t++)e.push(r.paintVertexAttributes[t].name);else if(r instanceof Oo){const t=r.getVertexAttributes();for(const r of t)e.push(r.name)}}return e}getBinderUniforms(){const e=[];for(const t in this.binders){const r=this.binders[t];if(r instanceof Bo||r instanceof Co||r instanceof Lo)for(const t of r.uniformNames)e.push(t)}return e}getPaintVertexBuffers(){return this._buffers}getUniforms(e,t){const r=[];for(const n in this.binders){const i=this.binders[n];if(i instanceof Bo||i instanceof Co||i instanceof Lo)for(const s of i.uniformNames)if(t[s]){const o=i.getBinding(e,t[s],s);r.push({name:s,property:n,binding:o})}}return r}setUniforms(e,t,r,n){for(const{name:e,property:i,binding:s}of t)this.binders[i].setUniform(s,n,r.get(i),e)}updatePaintBuffers(e){this._buffers=[];for(const t in this.binders){const r=this.binders[t];if(e&&r instanceof Oo){const t=2===e.fromScale?r.zoomInPaintVertexBuffer:r.zoomOutPaintVertexBuffer;t&&this._buffers.push(t)}else(r instanceof Vo||r instanceof Lo)&&r.paintVertexBuffer&&this._buffers.push(r.paintVertexBuffer)}}upload(e){for(const t in this.binders){const r=this.binders[t];(r instanceof Vo||r instanceof Lo||r instanceof Oo)&&r.upload(e)}this.updatePaintBuffers()}destroy(){for(const e in this.binders){const t=this.binders[e];(t instanceof Vo||t instanceof Lo||t instanceof Oo)&&t.destroy()}}}class Uo{constructor(e,t,r=()=>!0){this.programConfigurations={};for(const n of e)this.programConfigurations[n.id]=new $o(n,t,r);this.needsUpload=!1,this._featureMap=new Io,this._bufferOffset=0}populatePaintArrays(e,t,r,n){for(const r in this.programConfigurations)this.programConfigurations[r].populatePaintArrays(e,t,n);void 0!==t.id&&this._featureMap.add(t.id,r,this._bufferOffset,e),this._bufferOffset=e,this.needsUpload=!0}updatePaintArrays(e,t,r,n){for(const i of r)this.needsUpload=this.programConfigurations[i.id].updatePaintArrays(e,this._featureMap,t,i,n)||this.needsUpload}get(e){return this.programConfigurations[e]}upload(e){if(this.needsUpload){for(const t in this.programConfigurations)this.programConfigurations[t].upload(e);this.needsUpload=!1}}destroy(){for(const e in this.programConfigurations)this.programConfigurations[e].destroy()}}function qo(e,t){return{"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"line-gap-width":["gapwidth"],"line-dasharray":["dasharray_to","dasharray_from"],"line-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-extrusion-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"]}[e]||[e.replace(`${t}-`,"").replace(/-/g,"_")]}function Go(e,t,r){const n={color:{source:xs,composite:Vs},number:{source:Ps,composite:xs}},i=function(e){return{"line-pattern":{source:to,composite:to},"fill-pattern":{source:to,composite:to},"fill-extrusion-pattern":{source:to,composite:to},"line-dasharray":{source:ro,composite:ro}}[e]}(e);return i&&i[r]||n[t][r]}pi("ConstantBinder",Bo),pi("CrossFadedConstantBinder",Co),pi("SourceExpressionBinder",Vo),pi("CrossFadedPatternBinder",Ro),pi("CrossFadedDasharrayBinder",No),pi("CompositeExpressionBinder",Lo),pi("ProgramConfiguration",$o,{omit:["_buffers"]}),pi("ProgramConfigurationSet",Uo);const jo=Math.pow(2,14)-1,Xo=-jo-1;function Yo(e){const t=p/e.extent,r=e.loadGeometry();for(let e=0;e<r.length;e++){const n=r[e];for(let e=0;e<n.length;e++){const r=n[e],i=Math.round(r.x*t),s=Math.round(r.y*t);r.x=f(i,Xo,jo),r.y=f(s,Xo,jo),(i<r.x||i>r.x+1||s<r.y||s>r.y+1)&&x("Geometry exceeds allowed extent, reduce your vector tile buffer size")}}return r}function Zo(e,t){return{type:e.type,id:e.id,properties:e.properties,geometry:t?Yo(e):[]}}const Ho=-32768;function Wo(e,t,r,n,i){e.emplaceBack(Ho+8*t+n,Ho+8*r+i)}class Jo{constructor(e){this.zoom=e.zoom,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((e=>e.id)),this.index=e.index,this.hasDependencies=!1,this.layoutVertexArray=new Ws,this.indexArray=new lo,this.segments=new po,this.programConfigurations=new Uo(e.layers,e.zoom),this.stateDependentLayerIds=this.layers.filter((e=>e.isStateDependent())).map((e=>e.id))}populate(e,t,r){const n=this.layers[0],i=[];let s=null,o=!1,a="heatmap"===n.type;if("circle"===n.type){const e=n;s=e.layout.get("circle-sort-key"),o=!s.isConstant(),a=a||"map"===e.paint.get("circle-pitch-alignment")}const l=a?t.subdivisionGranularity.circle:1;for(const{feature:t,id:n,index:a,sourceLayerIndex:l}of e){const e=this.layers[0]._featureFilter.needGeometry,u=Zo(t,e);if(!this.layers[0]._featureFilter.filter(new Gi(this.zoom),u,r))continue;const c=o?s.evaluate(u,{},r):void 0,h={id:n,properties:t.properties,type:t.type,sourceLayerIndex:l,index:a,geometry:e?u.geometry:Yo(t),patterns:{},sortKey:c};i.push(h)}o&&i.sort(((e,t)=>e.sortKey-t.sortKey));for(const n of i){const{geometry:i,index:s,sourceLayerIndex:o}=n,a=e[s].feature;this.addFeature(n,i,s,r,l),t.featureIndex.insert(a,i,s,o,this.index)}}update(e,t,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(e,t,this.stateDependentLayers,{imagePositions:r})}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(e){this.uploaded||(this.layoutVertexBuffer=e.createVertexBuffer(this.layoutVertexArray,ho),this.indexBuffer=e.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(e),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy())}addFeature(e,t,r,n,i=1){let s;switch(i){case 1:s=[0,7];break;case 3:s=[0,2,5,7];break;case 5:s=[0,1,3,4,6,7];break;case 7:s=[0,1,2,3,4,5,6,7];break;default:throw new Error(`Invalid circle bucket granularity: ${i}; valid values are 1, 3, 5, 7.`)}const o=s.length;for(const r of t)for(const t of r){const r=t.x,n=t.y;if(r<0||r>=p||n<0||n>=p)continue;const i=this.segments.prepareSegment(o*o,this.layoutVertexArray,this.indexArray,e.sortKey),a=i.vertexLength;for(let e=0;e<o;e++)for(let t=0;t<o;t++)Wo(this.layoutVertexArray,r,n,s[t],s[e]);for(let e=0;e<o-1;e++)for(let t=0;t<o-1;t++){const r=a+e*o+t,n=a+(e+1)*o+t;this.indexArray.emplaceBack(r,n+1,r+1),this.indexArray.emplaceBack(r,n,n+1)}i.vertexLength+=o*o,i.primitiveLength+=(o-1)*(o-1)*2}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,e,r,{imagePositions:{},canonical:n})}}function Ko(e,t){for(let r=0;r<e.length;r++)if(aa(t,e[r]))return!0;for(let r=0;r<t.length;r++)if(aa(e,t[r]))return!0;return!!ra(e,t)}function Qo(e,t,r){return!!aa(e,t)||!!ia(t,e,r)}function ea(e,t){if(1===e.length)return oa(t,e[0]);for(let r=0;r<t.length;r++){const n=t[r];for(let t=0;t<n.length;t++)if(aa(e,n[t]))return!0}for(let r=0;r<e.length;r++)if(oa(t,e[r]))return!0;for(let r=0;r<t.length;r++)if(ra(e,t[r]))return!0;return!1}function ta(e,t,r){if(e.length>1){if(ra(e,t))return!0;for(let n=0;n<t.length;n++)if(ia(t[n],e,r))return!0}for(let n=0;n<e.length;n++)if(ia(e[n],t,r))return!0;return!1}function ra(e,t){if(0===e.length||0===t.length)return!1;for(let r=0;r<e.length-1;r++){const n=e[r],i=e[r+1];for(let e=0;e<t.length-1;e++)if(na(n,i,t[e],t[e+1]))return!0}return!1}function na(e,t,r,n){return v(e,r,n)!==v(t,r,n)&&v(e,t,r)!==v(e,t,n)}function ia(e,t,r){const n=r*r;if(1===t.length)return e.distSqr(t[0])<n;for(let r=1;r<t.length;r++)if(sa(e,t[r-1],t[r])<n)return!0;return!1}function sa(e,t,r){const n=t.distSqr(r);if(0===n)return e.distSqr(t);const i=((e.x-t.x)*(r.x-t.x)+(e.y-t.y)*(r.y-t.y))/n;return e.distSqr(i<0?t:i>1?r:r.sub(t)._mult(i)._add(t))}function oa(e,t){let r,n,i,s=!1;for(let o=0;o<e.length;o++){r=e[o];for(let e=0,o=r.length-1;e<r.length;o=e++)n=r[e],i=r[o],n.y>t.y!=i.y>t.y&&t.x<(i.x-n.x)*(t.y-n.y)/(i.y-n.y)+n.x&&(s=!s)}return s}function aa(e,t){let r=!1;for(let n=0,i=e.length-1;n<e.length;i=n++){const s=e[n],o=e[i];s.y>t.y!=o.y>t.y&&t.x<(o.x-s.x)*(t.y-s.y)/(o.y-s.y)+s.x&&(r=!r)}return r}function la(e,t,r){const n=r[0],i=r[2];if(e.x<n.x&&t.x<n.x||e.x>i.x&&t.x>i.x||e.y<n.y&&t.y<n.y||e.y>i.y&&t.y>i.y)return!1;const s=v(e,t,r[0]);return s!==v(e,t,r[1])||s!==v(e,t,r[2])||s!==v(e,t,r[3])}function ua(e,t,r){const n=t.paint.get(e).value;return"constant"===n.kind?n.value:r.programConfigurations.get(t.id).getMaxValue(e)}function ca(e){return Math.sqrt(e[0]*e[0]+e[1]*e[1])}function ha(e,r,n,i,s){if(!r[0]&&!r[1])return e;const o=t.convert(r)._mult(s);"viewport"===n&&o._rotate(-i);const a=[];for(let t=0;t<e.length;t++)a.push(e[t].sub(o));return a}function pa(e){const t=[];for(let r=0;r<e.length;r++){const n=e[r],i=t.at(-1);(0===r||i&&!n.equals(i))&&t.push(n)}return t}function fa({queryGeometry:e,size:t},r){return Qo(e,r,t)}function da({queryGeometry:e,size:t,transform:r,unwrappedTileID:n,getElevation:i},s){return Qo(e,s,t*(r.projectTileCoordinates(s.x,s.y,n,i).signedDistanceFromCamera/r.cameraToCenterDistance))}function ya({queryGeometry:e,size:t,transform:r,unwrappedTileID:n,getElevation:i},s){const o=r.projectTileCoordinates(s.x,s.y,n,i).signedDistanceFromCamera,a=t*(r.cameraToCenterDistance/o);return Qo(e,xa(s,r,n,i),a)}function ma({queryGeometry:e,size:t,transform:r,unwrappedTileID:n,getElevation:i},s){return Qo(e,xa(s,r,n,i),t)}function ga({queryGeometry:e,size:t,transform:r,unwrappedTileID:n,getElevation:i,pitchAlignment:s="map",pitchScale:o="map"},a){const l="map"===s?"map"===o?fa:da:"map"===o?ya:ma,u={queryGeometry:e,size:t,transform:r,unwrappedTileID:n,getElevation:i};for(const e of a)for(const t of e)if(l(u,t))return!0;return!1}function xa(e,r,n,i){const s=r.projectTileCoordinates(e.x,e.y,n,i).point;return new t((.5*s.x+.5)*r.width,(.5*-s.y+.5)*r.height)}let va,ba;pi("CircleBucket",Jo,{omit:["layers"]});var wa={get paint(){return ba=ba||new os({"circle-radius":new rs(k.paint_circle["circle-radius"]),"circle-color":new rs(k.paint_circle["circle-color"]),"circle-blur":new rs(k.paint_circle["circle-blur"]),"circle-opacity":new rs(k.paint_circle["circle-opacity"]),"circle-translate":new ts(k.paint_circle["circle-translate"]),"circle-translate-anchor":new ts(k.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new ts(k.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new ts(k.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new rs(k.paint_circle["circle-stroke-width"]),"circle-stroke-color":new rs(k.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new rs(k.paint_circle["circle-stroke-opacity"])})},get layout(){return va=va||new os({"circle-sort-key":new rs(k.layout_circle["circle-sort-key"])})}};class _a extends as{constructor(e,t){super(e,wa,t)}createBucket(e){return new Jo(e)}queryRadius(e){const t=e;return ua("circle-radius",this,t)+ua("circle-stroke-width",this,t)+ca(this.paint.get("circle-translate"))}queryIntersectsFeature({queryGeometry:e,feature:t,featureState:r,geometry:n,transform:i,pixelsToTileUnits:s,unwrappedTileID:o,getElevation:a}){const l=ha(e,this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),-i.bearingInRadians,s),u=this.paint.get("circle-radius").evaluate(t,r)+this.paint.get("circle-stroke-width").evaluate(t,r),c=this.paint.get("circle-pitch-scale"),h=this.paint.get("circle-pitch-alignment");let p,f;return"map"===h?(p=l,f=u*s):(p=function(e,t,r,n){return e.map((e=>xa(e,t,r,n)))}(l,i,o,a),f=u),ga({queryGeometry:p,size:f,transform:i,unwrappedTileID:o,getElevation:a,pitchAlignment:h,pitchScale:c},n)}}class Sa extends Jo{}let Aa;pi("HeatmapBucket",Sa,{omit:["layers"]});var Ia={get paint(){return Aa=Aa||new os({"heatmap-radius":new rs(k.paint_heatmap["heatmap-radius"]),"heatmap-weight":new rs(k.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new ts(k.paint_heatmap["heatmap-intensity"]),"heatmap-color":new ss(k.paint_heatmap["heatmap-color"]),"heatmap-opacity":new ts(k.paint_heatmap["heatmap-opacity"])})}};function Ta(e,{width:t,height:r},n,i){if(i){if(i instanceof Uint8ClampedArray)i=new Uint8Array(i.buffer);else if(i.length!==t*r*n)throw new RangeError(`mismatched image size. expected: ${i.length} but got: ${t*r*n}`)}else i=new Uint8Array(t*r*n);return e.width=t,e.height=r,e.data=i,e}function ka(e,{width:t,height:r},n){if(t===e.width&&r===e.height)return;const i=Ta({},{width:t,height:r},n);Ea(e,i,{x:0,y:0},{x:0,y:0},{width:Math.min(e.width,t),height:Math.min(e.height,r)},n),e.width=t,e.height=r,e.data=i.data}function Ea(e,t,r,n,i,s){if(0===i.width||0===i.height)return t;if(i.width>e.width||i.height>e.height||r.x>e.width-i.width||r.y>e.height-i.height)throw new RangeError("out of range source coordinates for image copy");if(i.width>t.width||i.height>t.height||n.x>t.width-i.width||n.y>t.height-i.height)throw new RangeError("out of range destination coordinates for image copy");const o=e.data,a=t.data;if(o===a)throw new Error("srcData equals dstData, so image is already copied");for(let l=0;l<i.height;l++){const u=((r.y+l)*e.width+r.x)*s,c=((n.y+l)*t.width+n.x)*s;for(let e=0;e<i.width*s;e++)a[c+e]=o[u+e]}return t}class Ma{constructor(e,t){Ta(this,e,1,t)}resize(e){ka(this,e,1)}clone(){return new Ma({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(e,t,r,n,i){Ea(e,t,r,n,i,1)}}class Da{constructor(e,t){Ta(this,e,4,t)}resize(e){ka(this,e,4)}replace(e,t){t?this.data.set(e):this.data=e instanceof Uint8ClampedArray?new Uint8Array(e.buffer):e}clone(){return new Da({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(e,t,r,n,i){Ea(e,t,r,n,i,4)}setPixel(e,t,r){const n=4*(e*this.width+t);this.data[n+0]=Math.round(255*r.r/r.a),this.data[n+1]=Math.round(255*r.g/r.a),this.data[n+2]=Math.round(255*r.b/r.a),this.data[n+3]=Math.round(255*r.a)}}pi("AlphaImage",Ma),pi("RGBAImage",Da);const Pa="big-fb";class za extends as{createBucket(e){return new Sa(e)}constructor(e,t){super(e,Ia,t),this.heatmapFbos=new Map,this._updateColorRamp()}_handleSpecialPaintPropertyUpdate(e){"heatmap-color"===e&&this._updateColorRamp()}_updateColorRamp(){this.colorRamp=function(e){const t={},r=e.resolution||256,n=e.clips?e.clips.length:1,i=e.image||new Da({width:r,height:n});if(Math.log(r)/Math.LN2%1!=0)throw new Error(`width is not a power of 2 - ${r}`);const s=(n,s,o)=>{t[e.evaluationKey]=o;const a=e.expression.evaluate(t);i.setPixel(n/4/r,s/4,a)};if(e.clips)for(let t=0,i=0;t<n;++t,i+=4*r)for(let n=0,o=0;n<r;n++,o+=4){const a=n/(r-1),{start:l,end:u}=e.clips[t];s(i,o,l*(1-a)+u*a)}else for(let e=0,t=0;e<r;e++,t+=4)s(0,t,e/(r-1));return i}({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}),this.colorRampTexture=null}resize(){this.heatmapFbos.has(Pa)&&this.heatmapFbos.delete(Pa)}queryRadius(e){return ua("heatmap-radius",this,e)}queryIntersectsFeature({queryGeometry:e,feature:t,featureState:r,geometry:n,transform:i,pixelsToTileUnits:s,unwrappedTileID:o,getElevation:a}){return ga({queryGeometry:e,size:this.paint.get("heatmap-radius").evaluate(t,r)*s,transform:i,unwrappedTileID:o,getElevation:a},n)}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&!this.isHidden()}}let Fa;var Ba={get paint(){return Fa=Fa||new os({"hillshade-illumination-direction":new ts(k.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-altitude":new ts(k.paint_hillshade["hillshade-illumination-altitude"]),"hillshade-illumination-anchor":new ts(k.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new ts(k.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new ts(k.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new ts(k.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new ts(k.paint_hillshade["hillshade-accent-color"]),"hillshade-method":new ts(k.paint_hillshade["hillshade-method"])})}};class Ca extends as{constructor(e,t){super(e,Ba,t),this.recalculate({zoom:0,zoomHistory:{}},void 0)}getIlluminationProperties(){let e=this.paint.get("hillshade-illumination-direction").values,t=this.paint.get("hillshade-illumination-altitude").values,r=this.paint.get("hillshade-highlight-color").values,n=this.paint.get("hillshade-shadow-color").values;const i=Math.max(e.length,t.length,r.length,n.length);e=e.concat(Array(i-e.length).fill(e.at(-1))),t=t.concat(Array(i-t.length).fill(t.at(-1))),r=r.concat(Array(i-r.length).fill(r.at(-1))),n=n.concat(Array(i-n.length).fill(n.at(-1)));const s=t.map(I);return{directionRadians:e.map(I),altitudeRadians:s,shadowColor:n,highlightColor:r}}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&!this.isHidden()}}let Va;var La={get paint(){return Va=Va||new os({"color-relief-opacity":new ts(k["paint_color-relief"]["color-relief-opacity"]),"color-relief-color":new ss(k["paint_color-relief"]["color-relief-color"])})}};class Oa{constructor(e,t,r,n){this.context=e,this.format=r,this.texture=e.gl.createTexture(),this.update(t,n)}update(e,t,r){const{width:n,height:i}=e,s=!(this.size&&this.size[0]===n&&this.size[1]===i||r),{context:o}=this,{gl:a}=o;if(this.useMipmap=Boolean(t&&t.useMipmap),a.bindTexture(a.TEXTURE_2D,this.texture),o.pixelStoreUnpackFlipY.set(!1),o.pixelStoreUnpack.set(1),o.pixelStoreUnpackPremultiplyAlpha.set(this.format===a.RGBA&&(!t||!1!==t.premultiply)),s)this.size=[n,i],e instanceof HTMLImageElement||e instanceof HTMLCanvasElement||e instanceof HTMLVideoElement||e instanceof ImageData||w(e)?a.texImage2D(a.TEXTURE_2D,0,this.format,this.format,a.UNSIGNED_BYTE,e):a.texImage2D(a.TEXTURE_2D,0,this.format,n,i,0,this.format,a.UNSIGNED_BYTE,e.data);else{const{x:t,y:s}=r||{x:0,y:0};e instanceof HTMLImageElement||e instanceof HTMLCanvasElement||e instanceof HTMLVideoElement||e instanceof ImageData||w(e)?a.texSubImage2D(a.TEXTURE_2D,0,t,s,a.RGBA,a.UNSIGNED_BYTE,e):a.texSubImage2D(a.TEXTURE_2D,0,t,s,n,i,a.RGBA,a.UNSIGNED_BYTE,e.data)}this.useMipmap&&this.isSizePowerOfTwo()&&a.generateMipmap(a.TEXTURE_2D),o.pixelStoreUnpackFlipY.setDefault(),o.pixelStoreUnpack.setDefault(),o.pixelStoreUnpackPremultiplyAlpha.setDefault()}bind(e,t,r){const{context:n}=this,{gl:i}=n;i.bindTexture(i.TEXTURE_2D,this.texture),r!==i.LINEAR_MIPMAP_NEAREST||this.isSizePowerOfTwo()||(r=i.LINEAR),e!==this.filter&&(i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MAG_FILTER,e),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MIN_FILTER,r||e),this.filter=e),t!==this.wrap&&(i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_S,t),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_T,t),this.wrap=t)}isSizePowerOfTwo(){return this.size[0]===this.size[1]&&Math.log(this.size[0])/Math.LN2%1==0}destroy(){const{gl:e}=this.context;e.deleteTexture(this.texture),this.texture=null}}class Ra{constructor(e,t,r,n=1,i=1,s=1,o=0){if(this.uid=e,t.height!==t.width)throw new RangeError("DEM tiles must be square");if(r&&!["mapbox","terrarium","custom"].includes(r))return void x(`"${r}" is not a valid encoding type. Valid types include "mapbox", "terrarium" and "custom".`);this.stride=t.height;const a=this.dim=t.height-2;switch(this.data=new Uint32Array(t.data.buffer),r){case"terrarium":this.redFactor=256,this.greenFactor=1,this.blueFactor=1/256,this.baseShift=32768;break;case"custom":this.redFactor=n,this.greenFactor=i,this.blueFactor=s,this.baseShift=o;break;default:this.redFactor=6553.6,this.greenFactor=25.6,this.blueFactor=.1,this.baseShift=1e4}for(let e=0;e<a;e++)this.data[this._idx(-1,e)]=this.data[this._idx(0,e)],this.data[this._idx(a,e)]=this.data[this._idx(a-1,e)],this.data[this._idx(e,-1)]=this.data[this._idx(e,0)],this.data[this._idx(e,a)]=this.data[this._idx(e,a-1)];this.data[this._idx(-1,-1)]=this.data[this._idx(0,0)],this.data[this._idx(a,-1)]=this.data[this._idx(a-1,0)],this.data[this._idx(-1,a)]=this.data[this._idx(0,a-1)],this.data[this._idx(a,a)]=this.data[this._idx(a-1,a-1)],this.min=Number.MAX_SAFE_INTEGER,this.max=Number.MIN_SAFE_INTEGER;for(let e=0;e<a;e++)for(let t=0;t<a;t++){const r=this.get(e,t);r>this.max&&(this.max=r),r<this.min&&(this.min=r)}}get(e,t){const r=new Uint8Array(this.data.buffer),n=4*this._idx(e,t);return this.unpack(r[n],r[n+1],r[n+2])}getUnpackVector(){return[this.redFactor,this.greenFactor,this.blueFactor,this.baseShift]}_idx(e,t){if(e<-1||e>=this.dim+1||t<-1||t>=this.dim+1)throw new RangeError(`Out of range source coordinates for DEM data. x: ${e}, y: ${t}, dim: ${this.dim}`);return(t+1)*this.stride+(e+1)}unpack(e,t,r){return e*this.redFactor+t*this.greenFactor+r*this.blueFactor-this.baseShift}pack(e){return Na(e,this.getUnpackVector())}getPixels(){return new Da({width:this.stride,height:this.stride},new Uint8Array(this.data.buffer))}backfillBorder(e,t,r){if(this.dim!==e.dim)throw new Error("dem dimension mismatch");let n=t*this.dim,i=t*this.dim+this.dim,s=r*this.dim,o=r*this.dim+this.dim;switch(t){case-1:n=i-1;break;case 1:i=n+1}switch(r){case-1:s=o-1;break;case 1:o=s+1}const a=-t*this.dim,l=-r*this.dim;for(let t=s;t<o;t++)for(let r=n;r<i;r++)this.data[this._idx(r,t)]=e.data[this._idx(r+a,t+l)]}}function Na(e,t){const r=t[0],n=t[1],i=t[2],s=t[3],o=Math.min(r,n,i),a=Math.round((e+s)/o);return{r:Math.floor(a*o/r)%256,g:Math.floor(a*o/n)%256,b:Math.floor(a*o/i)%256}}pi("DEMData",Ra);class $a extends as{constructor(e,t){super(e,La,t)}_createColorRamp(e){const t={elevationStops:[],colorStops:[]},r=this._transitionablePaint._values["color-relief-color"].value.expression;if(r instanceof tn&&r._styleExpression.expression instanceof ht){this.colorRampExpression=r;const e=r._styleExpression.expression;t.elevationStops=e.labels,t.colorStops=[];for(const r of t.elevationStops)t.colorStops.push(e.evaluate({globals:{elevation:r}}))}if(t.elevationStops.length<1&&(t.elevationStops=[0],t.colorStops=[Ie.transparent]),t.elevationStops.length<2&&(t.elevationStops.push(t.elevationStops[0]+1),t.colorStops.push(t.colorStops[0])),t.elevationStops.length<=e)return t;const n={elevationStops:[],colorStops:[]},i=(t.elevationStops.length-1)/(e-1);for(let e=0;e<t.elevationStops.length-.5;e+=i)n.elevationStops.push(t.elevationStops[Math.round(e)]),n.colorStops.push(t.colorStops[Math.round(e)]);return x(`Too many colors in specification of ${this.id} color-relief layer, may not render properly. Max possible colors: ${e}, provided: ${t.elevationStops.length}`),n}_colorRampChanged(){return this.colorRampExpression!=this._transitionablePaint._values["color-relief-color"].value.expression}getColorRampTextures(e,t,r){if(this.colorRampTextures&&!this._colorRampChanged())return this.colorRampTextures;const n=this._createColorRamp(t),i=new Da({width:n.colorStops.length,height:1}),s=new Da({width:n.colorStops.length,height:1});for(let e=0;e<n.elevationStops.length;e++){const t=Na(n.elevationStops[e],r);s.setPixel(0,e,new Ie(t.r/255,t.g/255,t.b/255,1)),i.setPixel(0,e,n.colorStops[e])}return this.colorRampTextures={elevationTexture:new Oa(e,s,e.gl.RGBA),colorTexture:new Oa(e,i,e.gl.RGBA)},this.colorRampTextures}hasOffscreenPass(){return!this.isHidden()&&!!this.colorRampTextures}}const Ua=hs([{name:"a_pos",components:2,type:"Int16"}],4),{members:qa}=Ua;function Ga(e,t,r){const n=r.patternDependencies;let i=!1;for(const r of t){const t=r.paint.get(`${e}-pattern`);t.isConstant()||(i=!0);const s=t.constantOr(null);s&&(i=!0,n[s.to]=!0,n[s.from]=!0)}return i}function ja(e,t,r,n,i){const{zoom:s}=n,o=i.patternDependencies;for(const n of t){const t=n.paint.get(`${e}-pattern`).value;if("constant"!==t.kind){let e=t.evaluate({zoom:s-1},r,{},i.availableImages),a=t.evaluate({zoom:s},r,{},i.availableImages),l=t.evaluate({zoom:s+1},r,{},i.availableImages);e=e&&e.name?e.name:e,a=a&&a.name?a.name:a,l=l&&l.name?l.name:l,o[e]=!0,o[a]=!0,o[l]=!0,r.patterns[n.id]={min:e,mid:a,max:l}}}return r}function Xa(e,t,r,n,i){let s;if(i===function(e,t,r,n){let i=0;for(let s=t,o=r-n;s<r;s+=n)i+=(e[o]-e[s])*(e[s+1]+e[o+1]),o=s;return i}(e,t,r,n)>0)for(let i=t;i<r;i+=n)s=dl(i/n|0,e[i],e[i+1],s);else for(let i=r-n;i>=t;i-=n)s=dl(i/n|0,e[i],e[i+1],s);return s&&ll(s,s.next)&&(yl(s),s=s.next),s}function Ya(e,t){if(!e)return e;t||(t=e);let r,n=e;do{if(r=!1,n.steiner||!ll(n,n.next)&&0!==al(n.prev,n,n.next))n=n.next;else{if(yl(n),n=t=n.prev,n===n.next)break;r=!0}}while(r||n!==t);return t}function Za(e,t,r,n,i,s,o){if(!e)return;!o&&s&&function(e,t,r,n){let i=e;do{0===i.z&&(i.z=rl(i.x,i.y,t,r,n)),i.prevZ=i.prev,i.nextZ=i.next,i=i.next}while(i!==e);i.prevZ.nextZ=null,i.prevZ=null,function(e){let t,r=1;do{let n,i=e;e=null;let s=null;for(t=0;i;){t++;let o=i,a=0;for(let e=0;e<r&&(a++,o=o.nextZ,o);e++);let l=r;for(;a>0||l>0&&o;)0!==a&&(0===l||!o||i.z<=o.z)?(n=i,i=i.nextZ,a--):(n=o,o=o.nextZ,l--),s?s.nextZ=n:e=n,n.prevZ=s,s=n;i=o}s.nextZ=null,r*=2}while(t>1)}(i)}(e,n,i,s);let a=e;for(;e.prev!==e.next;){const l=e.prev,u=e.next;if(s?Wa(e,n,i,s):Ha(e))t.push(l.i,e.i,u.i),yl(e),e=u.next,a=u.next;else if((e=u)===a){o?1===o?Za(e=Ja(Ya(e),t),t,r,n,i,s,2):2===o&&Ka(e,t,r,n,i,s):Za(Ya(e),t,r,n,i,s,1);break}}}function Ha(e){const t=e.prev,r=e,n=e.next;if(al(t,r,n)>=0)return!1;const i=t.x,s=r.x,o=n.x,a=t.y,l=r.y,u=n.y,c=Math.min(i,s,o),h=Math.min(a,l,u),p=Math.max(i,s,o),f=Math.max(a,l,u);let d=n.next;for(;d!==t;){if(d.x>=c&&d.x<=p&&d.y>=h&&d.y<=f&&sl(i,a,s,l,o,u,d.x,d.y)&&al(d.prev,d,d.next)>=0)return!1;d=d.next}return!0}function Wa(e,t,r,n){const i=e.prev,s=e,o=e.next;if(al(i,s,o)>=0)return!1;const a=i.x,l=s.x,u=o.x,c=i.y,h=s.y,p=o.y,f=Math.min(a,l,u),d=Math.min(c,h,p),y=Math.max(a,l,u),m=Math.max(c,h,p),g=rl(f,d,t,r,n),x=rl(y,m,t,r,n);let v=e.prevZ,b=e.nextZ;for(;v&&v.z>=g&&b&&b.z<=x;){if(v.x>=f&&v.x<=y&&v.y>=d&&v.y<=m&&v!==i&&v!==o&&sl(a,c,l,h,u,p,v.x,v.y)&&al(v.prev,v,v.next)>=0)return!1;if(v=v.prevZ,b.x>=f&&b.x<=y&&b.y>=d&&b.y<=m&&b!==i&&b!==o&&sl(a,c,l,h,u,p,b.x,b.y)&&al(b.prev,b,b.next)>=0)return!1;b=b.nextZ}for(;v&&v.z>=g;){if(v.x>=f&&v.x<=y&&v.y>=d&&v.y<=m&&v!==i&&v!==o&&sl(a,c,l,h,u,p,v.x,v.y)&&al(v.prev,v,v.next)>=0)return!1;v=v.prevZ}for(;b&&b.z<=x;){if(b.x>=f&&b.x<=y&&b.y>=d&&b.y<=m&&b!==i&&b!==o&&sl(a,c,l,h,u,p,b.x,b.y)&&al(b.prev,b,b.next)>=0)return!1;b=b.nextZ}return!0}function Ja(e,t){let r=e;do{const n=r.prev,i=r.next.next;!ll(n,i)&&ul(n,r,r.next,i)&&pl(n,i)&&pl(i,n)&&(t.push(n.i,r.i,i.i),yl(r),yl(r.next),r=e=i),r=r.next}while(r!==e);return Ya(r)}function Ka(e,t,r,n,i,s){let o=e;do{let e=o.next.next;for(;e!==o.prev;){if(o.i!==e.i&&ol(o,e)){let a=fl(o,e);return o=Ya(o,o.next),a=Ya(a,a.next),Za(o,t,r,n,i,s,0),void Za(a,t,r,n,i,s,0)}e=e.next}o=o.next}while(o!==e)}function Qa(e,t){let r=e.x-t.x;return 0===r&&(r=e.y-t.y,0===r)&&(r=(e.next.y-e.y)/(e.next.x-e.x)-(t.next.y-t.y)/(t.next.x-t.x)),r}function el(e,t){const r=function(e,t){let r=t;const n=e.x,i=e.y;let s,o=-1/0;if(ll(e,r))return r;do{if(ll(e,r.next))return r.next;if(i<=r.y&&i>=r.next.y&&r.next.y!==r.y){const e=r.x+(i-r.y)*(r.next.x-r.x)/(r.next.y-r.y);if(e<=n&&e>o&&(o=e,s=r.x<r.next.x?r:r.next,e===n))return s}r=r.next}while(r!==t);if(!s)return null;const a=s,l=s.x,u=s.y;let c=1/0;r=s;do{if(n>=r.x&&r.x>=l&&n!==r.x&&il(i<u?n:o,i,l,u,i<u?o:n,i,r.x,r.y)){const t=Math.abs(i-r.y)/(n-r.x);pl(r,e)&&(t<c||t===c&&(r.x>s.x||r.x===s.x&&tl(s,r)))&&(s=r,c=t)}r=r.next}while(r!==a);return s}(e,t);if(!r)return t;const n=fl(r,e);return Ya(n,n.next),Ya(r,r.next)}function tl(e,t){return al(e.prev,e,t.prev)<0&&al(t.next,e,e.next)<0}function rl(e,t,r,n,i){return(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-r)*i|0)|e<<8))|e<<4))|e<<2))|e<<1))|(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-n)*i|0)|t<<8))|t<<4))|t<<2))|t<<1))<<1}function nl(e){let t=e,r=e;do{(t.x<r.x||t.x===r.x&&t.y<r.y)&&(r=t),t=t.next}while(t!==e);return r}function il(e,t,r,n,i,s,o,a){return(i-o)*(t-a)>=(e-o)*(s-a)&&(e-o)*(n-a)>=(r-o)*(t-a)&&(r-o)*(s-a)>=(i-o)*(n-a)}function sl(e,t,r,n,i,s,o,a){return!(e===o&&t===a)&&il(e,t,r,n,i,s,o,a)}function ol(e,t){return e.next.i!==t.i&&e.prev.i!==t.i&&!function(e,t){let r=e;do{if(r.i!==e.i&&r.next.i!==e.i&&r.i!==t.i&&r.next.i!==t.i&&ul(r,r.next,e,t))return!0;r=r.next}while(r!==e);return!1}(e,t)&&(pl(e,t)&&pl(t,e)&&function(e,t){let r=e,n=!1;const i=(e.x+t.x)/2,s=(e.y+t.y)/2;do{r.y>s!=r.next.y>s&&r.next.y!==r.y&&i<(r.next.x-r.x)*(s-r.y)/(r.next.y-r.y)+r.x&&(n=!n),r=r.next}while(r!==e);return n}(e,t)&&(al(e.prev,e,t.prev)||al(e,t.prev,t))||ll(e,t)&&al(e.prev,e,e.next)>0&&al(t.prev,t,t.next)>0)}function al(e,t,r){return(t.y-e.y)*(r.x-t.x)-(t.x-e.x)*(r.y-t.y)}function ll(e,t){return e.x===t.x&&e.y===t.y}function ul(e,t,r,n){const i=hl(al(e,t,r)),s=hl(al(e,t,n)),o=hl(al(r,n,e)),a=hl(al(r,n,t));return i!==s&&o!==a||!(0!==i||!cl(e,r,t))||!(0!==s||!cl(e,n,t))||!(0!==o||!cl(r,e,n))||!(0!==a||!cl(r,t,n))}function cl(e,t,r){return t.x<=Math.max(e.x,r.x)&&t.x>=Math.min(e.x,r.x)&&t.y<=Math.max(e.y,r.y)&&t.y>=Math.min(e.y,r.y)}function hl(e){return e>0?1:e<0?-1:0}function pl(e,t){return al(e.prev,e,e.next)<0?al(e,t,e.next)>=0&&al(e,e.prev,t)>=0:al(e,t,e.prev)<0||al(e,e.next,t)<0}function fl(e,t){const r=ml(e.i,e.x,e.y),n=ml(t.i,t.x,t.y),i=e.next,s=t.prev;return e.next=t,t.prev=e,r.next=i,i.prev=r,n.next=r,r.prev=n,s.next=n,n.prev=s,n}function dl(e,t,r,n){const i=ml(e,t,r);return n?(i.next=n.next,i.prev=n,n.next.prev=i,n.next=i):(i.prev=i,i.next=i),i}function yl(e){e.next.prev=e.prev,e.prev.next=e.next,e.prevZ&&(e.prevZ.nextZ=e.nextZ),e.nextZ&&(e.nextZ.prevZ=e.prevZ)}function ml(e,t,r){return{i:e,x:t,y:r,prev:null,next:null,z:0,prevZ:null,nextZ:null,steiner:!1}}class gl{constructor(e,t){if(t>e)throw new Error("Min granularity must not be greater than base granularity.");this._baseZoomGranularity=e,this._minGranularity=t}getGranularityForZoomLevel(e){return Math.max(Math.floor(this._baseZoomGranularity/(1<<e)),this._minGranularity,1)}}class xl{constructor(e){this.fill=e.fill,this.line=e.line,this.tile=e.tile,this.stencil=e.stencil,this.circle=e.circle}}xl.noSubdivision=new xl({fill:new gl(0,0),line:new gl(0,0),tile:new gl(0,0),stencil:new gl(0,0),circle:1}),pi("SubdivisionGranularityExpression",gl),pi("SubdivisionGranularitySetting",xl);const vl=-32768,bl=32767;class wl{constructor(e,t){this._vertexBuffer=[],this._vertexDictionary=new Map,this._used=!1,this._granularity=e,this._granularityCellSize=p/e,this._canonical=t}_getKey(e,t){return(e+=32768)<<16|t+32768}_vertexToIndex(e,t){if(e<-32768||t<-32768||e>32767||t>32767)throw new Error("Vertex coordinates are out of signed 16 bit integer range.");const r=0|Math.round(e),n=0|Math.round(t),i=this._getKey(r,n);if(this._vertexDictionary.has(i))return this._vertexDictionary.get(i);const s=this._vertexBuffer.length/2;return this._vertexDictionary.set(i,s),this._vertexBuffer.push(r,n),s}_subdivideTrianglesScanline(e){if(this._granularity<2)return function(e,t){const r=[];for(let n=0;n<t.length;n+=3){const i=t[n],s=t[n+1],o=t[n+2],a=e[2*i],l=e[2*i+1];(e[2*s]-a)*(e[2*o+1]-l)-(e[2*s+1]-l)*(e[2*o]-a)>0?(r.push(i),r.push(o),r.push(s)):(r.push(i),r.push(s),r.push(o))}return r}(this._vertexBuffer,e);const t=[],r=e.length;for(let n=0;n<r;n+=3){const r=[e[n+0],e[n+1],e[n+2]],i=[this._vertexBuffer[2*e[n+0]+0],this._vertexBuffer[2*e[n+0]+1],this._vertexBuffer[2*e[n+1]+0],this._vertexBuffer[2*e[n+1]+1],this._vertexBuffer[2*e[n+2]+0],this._vertexBuffer[2*e[n+2]+1]];let s=1/0,o=1/0,a=-1/0,l=-1/0;for(let e=0;e<3;e++){const t=i[2*e],r=i[2*e+1];s=Math.min(s,t),a=Math.max(a,t),o=Math.min(o,r),l=Math.max(l,r)}if(s===a||o===l)continue;const u=Math.floor(s/this._granularityCellSize),c=Math.ceil(a/this._granularityCellSize),h=Math.floor(o/this._granularityCellSize),p=Math.ceil(l/this._granularityCellSize);if(u!==c||h!==p)for(let e=h;e<p;e++){const n=this._scanlineGenerateVertexRingForCellRow(e,i,r);Al(this._vertexBuffer,n,t)}else t.push(...r)}return t}_scanlineGenerateVertexRingForCellRow(e,t,r){const n=e*this._granularityCellSize,i=n+this._granularityCellSize,s=[];for(let e=0;e<3;e++){const o=t[2*e],a=t[2*e+1],l=t[2*(e+1)%6],u=t[(2*(e+1)+1)%6],c=t[2*(e+2)%6],h=t[(2*(e+2)+1)%6],p=l-o,f=u-a,d=0===p,y=0===f,m=(n-a)/f,g=(i-a)/f,x=Math.min(m,g),v=Math.max(m,g);if(!y&&(x>=1||v<=0)||y&&(a<n||a>i)){u>=n&&u<=i&&s.push(r[(e+1)%3]);continue}!y&&x>0&&s.push(this._vertexToIndex(o+p*x,a+f*x));const b=o+p*Math.max(x,0),w=o+p*Math.min(v,1);d||this._generateIntraEdgeVertices(s,o,a,l,u,b,w),!y&&v<1&&s.push(this._vertexToIndex(o+p*v,a+f*v)),(y||u>=n&&u<=i)&&s.push(r[(e+1)%3]),!y&&(u<=n||u>=i)&&this._generateInterEdgeVertices(s,o,a,l,u,c,h,w,n,i)}return s}_generateIntraEdgeVertices(e,t,r,n,i,s,o){const a=n-t,l=i-r,u=0===l,c=u?Math.min(t,n):Math.min(s,o),h=u?Math.max(t,n):Math.max(s,o),p=Math.floor(c/this._granularityCellSize)+1,f=Math.ceil(h/this._granularityCellSize)-1;if(u?t<n:s<o)for(let n=p;n<=f;n++){const i=n*this._granularityCellSize;e.push(this._vertexToIndex(i,r+l*(i-t)/a))}else for(let n=f;n>=p;n--){const i=n*this._granularityCellSize;e.push(this._vertexToIndex(i,r+l*(i-t)/a))}}_generateInterEdgeVertices(e,t,r,n,i,s,o,a,l,u){const c=i-r,h=s-n,p=o-i,f=(l-i)/p,d=(u-i)/p,y=Math.min(f,d),m=Math.max(f,d),g=n+h*y;let x=Math.floor(Math.min(g,a)/this._granularityCellSize)+1,v=Math.ceil(Math.max(g,a)/this._granularityCellSize)-1,b=a<g;const w=0===p;if(w&&(o===l||o===u))return;if(w||y>=1||m<=0){const e=r-o,n=s+(t-s)*Math.min((l-o)/e,(u-o)/e);x=Math.floor(Math.min(n,a)/this._granularityCellSize)+1,v=Math.ceil(Math.max(n,a)/this._granularityCellSize)-1,b=a<n}const _=c>0?u:l;if(b)for(let t=x;t<=v;t++)e.push(this._vertexToIndex(t*this._granularityCellSize,_));else for(let t=v;t>=x;t--)e.push(this._vertexToIndex(t*this._granularityCellSize,_))}_generateOutline(e){const t=[];for(const r of e){const e=Sl(r,this._granularity,!0),n=this._pointArrayToIndices(e),i=[];for(let e=1;e<n.length;e++)i.push(n[e-1]),i.push(n[e]);t.push(i)}return t}_handlePoles(e){let t=!1,r=!1;this._canonical&&(0===this._canonical.y&&(t=!0),this._canonical.y===(1<<this._canonical.z)-1&&(r=!0)),(t||r)&&this._fillPoles(e,t,r)}_ensureNoPoleVertices(){const e=this._vertexBuffer;for(let t=0;t<e.length;t+=2){const r=e[t+1];r===vl&&(e[t+1]=-32767),r===bl&&(e[t+1]=32766)}}_generatePoleQuad(e,t,r,n,i,s){n>i!=(s===vl)?(e.push(t),e.push(r),e.push(this._vertexToIndex(n,s)),e.push(r),e.push(this._vertexToIndex(i,s)),e.push(this._vertexToIndex(n,s))):(e.push(r),e.push(t),e.push(this._vertexToIndex(n,s)),e.push(this._vertexToIndex(i,s)),e.push(r),e.push(this._vertexToIndex(n,s)))}_fillPoles(e,t,r){const n=this._vertexBuffer,i=p,s=e.length;for(let o=2;o<s;o+=3){const s=e[o-2],a=e[o-1],l=e[o],u=n[2*s],c=n[2*s+1],h=n[2*a],p=n[2*a+1],f=n[2*l],d=n[2*l+1];t&&(0===c&&0===p&&this._generatePoleQuad(e,s,a,u,h,vl),0===p&&0===d&&this._generatePoleQuad(e,a,l,h,f,vl),0===d&&0===c&&this._generatePoleQuad(e,l,s,f,u,vl)),r&&(c===i&&p===i&&this._generatePoleQuad(e,s,a,u,h,bl),p===i&&d===i&&this._generatePoleQuad(e,a,l,h,f,bl),d===i&&c===i&&this._generatePoleQuad(e,l,s,f,u,bl))}}_initializeVertices(e){for(let t=0;t<e.length;t+=2)this._vertexToIndex(e[t],e[t+1])}subdividePolygonInternal(e,t){if(this._used)throw new Error("Subdivision: multiple use not allowed.");this._used=!0;const{flattened:r,holeIndices:n}=function(e){const t=[],r=[];for(const n of e)if(0!==n.length){n!==e[0]&&t.push(r.length/2);for(let e=0;e<n.length;e++)r.push(n[e].x),r.push(n[e].y)}return{flattened:r,holeIndices:t}}(e);let i;this._initializeVertices(r);try{const e=function(e,t,r=2){const n=t&&t.length,i=n?t[0]*r:e.length;let s=Xa(e,0,i,r,!0);const o=[];if(!s||s.next===s.prev)return o;let a,l,u;if(n&&(s=function(e,t,r,n){const i=[];for(let r=0,s=t.length;r<s;r++){const o=Xa(e,t[r]*n,r<s-1?t[r+1]*n:e.length,n,!1);o===o.next&&(o.steiner=!0),i.push(nl(o))}i.sort(Qa);for(let e=0;e<i.length;e++)r=el(i[e],r);return r}(e,t,s,r)),e.length>80*r){a=e[0],l=e[1];let t=a,n=l;for(let s=r;s<i;s+=r){const r=e[s],i=e[s+1];r<a&&(a=r),i<l&&(l=i),r>t&&(t=r),i>n&&(n=i)}u=Math.max(t-a,n-l),u=0!==u?32767/u:0}return Za(s,o,r,a,l,u,0),o}(r,n),t=this._convertIndices(r,e);i=this._subdivideTrianglesScanline(t)}catch(e){console.error(e)}let s=[];return t&&(s=this._generateOutline(e)),this._ensureNoPoleVertices(),this._handlePoles(i),{verticesFlattened:this._vertexBuffer,indicesTriangles:i,indicesLineList:s}}_convertIndices(e,t){const r=[];for(let n=0;n<t.length;n++)r.push(this._vertexToIndex(e[2*t[n]],e[2*t[n]+1]));return r}_pointArrayToIndices(e){const t=[];for(let r=0;r<e.length;r++){const n=e[r];t.push(this._vertexToIndex(n.x,n.y))}return t}}function _l(e,t,r,n=!0){return new wl(r,t).subdividePolygonInternal(e,n)}function Sl(e,r,n=!1){if(!e||e.length<1)return[];if(e.length<2)return[];const i=e[0],s=e[e.length-1],o=n&&(i.x!==s.x||i.y!==s.y);if(r<2)return o?[...e,e[0]]:[...e];const a=Math.floor(p/r),l=[];l.push(new t(e[0].x,e[0].y));const u=e.length,c=o?u:u-1;for(let r=0;r<c;r++){const n=e[r],i=r<u-1?e[r+1]:e[0],s=n.x,o=n.y,c=i.x,h=i.y,p=s!==c,f=o!==h;if(!p&&!f)continue;const d=c-s,y=h-o,m=Math.abs(d),g=Math.abs(y);let x=s,v=o;for(;;){const e=d>0?(Math.floor(x/a)+1)*a:(Math.ceil(x/a)-1)*a,r=y>0?(Math.floor(v/a)+1)*a:(Math.ceil(v/a)-1)*a,n=Math.abs(x-e),i=Math.abs(v-r),s=Math.abs(x-c),o=Math.abs(v-h),u=p?n/m:Number.POSITIVE_INFINITY,b=f?i/g:Number.POSITIVE_INFINITY;if((s<=n||!p)&&(o<=i||!f))break;if(u<b&&p||!f){x=e,v+=y*u;const r=new t(x,Math.round(v));l[l.length-1].x===r.x&&l[l.length-1].y===r.y||l.push(r)}else{x+=d*b,v=r;const e=new t(Math.round(x),v);l[l.length-1].x===e.x&&l[l.length-1].y===e.y||l.push(e)}}const b=new t(c,h);l[l.length-1].x===b.x&&l[l.length-1].y===b.y||l.push(b)}return l}function Al(e,t,r){if(0===t.length)throw new Error("Subdivision vertex ring is empty.");let n=0,i=e[2*t[0]];for(let r=1;r<t.length;r++){const s=e[2*t[r]];s<i&&(i=s,n=r)}const s=t.length;let o=n,a=(o+1)%s;for(;;){const n=o-1>=0?o-1:s-1,i=(a+1)%s,l=e[2*t[n]],u=e[2*t[i]],c=e[2*t[o]],h=e[2*t[o]+1],p=e[2*t[a]+1];let f=!1;if(l<u)f=!0;else if(l>u)f=!1;else{const r=p-h,s=-(e[2*t[a]]-c),o=h<p?1:-1;((l-c)*r+(e[2*t[n]+1]-h)*s)*o>((u-c)*r+(e[2*t[i]+1]-h)*s)*o&&(f=!0)}if(f){const e=t[n],i=t[o],l=t[a];e!==i&&e!==l&&i!==l&&r.push(l,i,e),o--,o<0&&(o=s-1)}else{const e=t[i],n=t[o],l=t[a];e!==n&&e!==l&&n!==l&&r.push(l,n,e),a++,a>=s&&(a=0)}if(n===i)break}}function Il(e,t,r,n,i,s,o,a,l){const u=i.length/2,c=o&&a&&l;if(u<po.MAX_VERTEX_ARRAY_LENGTH){const h=t.prepareSegment(u,r,n),p=h.vertexLength;for(let e=0;e<s.length;e+=3)n.emplaceBack(p+s[e],p+s[e+1],p+s[e+2]);let f,d;h.vertexLength+=u,h.primitiveLength+=s.length/3,c&&(d=o.prepareSegment(u,r,a),f=d.vertexLength,d.vertexLength+=u);for(let t=0;t<i.length;t+=2)e(i[t],i[t+1]);if(c)for(let e=0;e<l.length;e++){const t=l[e];for(let e=1;e<t.length;e+=2)a.emplaceBack(f+t[e-1],f+t[e]);d.primitiveLength+=t.length/2}}else!function(e,t,r,n,i,s){const o=[];for(let e=0;e<n.length/2;e++)o.push(-1);const a={count:0};let l=0,u=e.getOrCreateLatestSegment(t,r),c=u.vertexLength;for(let h=2;h<i.length;h+=3){const p=i[h-2],f=i[h-1],d=i[h];let y=o[p]<l,m=o[f]<l,g=o[d]<l;u.vertexLength+((y?1:0)+(m?1:0)+(g?1:0))>po.MAX_VERTEX_ARRAY_LENGTH&&(u=e.createNewSegment(t,r),l=a.count,y=!0,m=!0,g=!0,c=0);const x=Tl(o,n,s,a,p,y,u),v=Tl(o,n,s,a,f,m,u),b=Tl(o,n,s,a,d,g,u);r.emplaceBack(c+x-l,c+v-l,c+b-l),u.primitiveLength++}}(t,r,n,i,s,e),c&&function(e,t,r,n,i,s){const o=[];for(let e=0;e<n.length/2;e++)o.push(-1);const a={count:0};let l=0,u=e.getOrCreateLatestSegment(t,r),c=u.vertexLength;for(let h=0;h<i.length;h++){const p=i[h];for(let f=1;f<i[h].length;f+=2){const i=p[f-1],h=p[f];let d=o[i]<l,y=o[h]<l;u.vertexLength+((d?1:0)+(y?1:0))>po.MAX_VERTEX_ARRAY_LENGTH&&(u=e.createNewSegment(t,r),l=a.count,d=!0,y=!0,c=0);const m=Tl(o,n,s,a,i,d,u),g=Tl(o,n,s,a,h,y,u);r.emplaceBack(c+m-l,c+g-l),u.primitiveLength++}}}(o,r,a,i,l,e),t.forceNewSegmentOnNextPrepare(),null==o||o.forceNewSegmentOnNextPrepare()}function Tl(e,t,r,n,i,s,o){if(s){const s=n.count;return r(t[2*i],t[2*i+1]),e[i]=n.count,n.count++,o.vertexLength++,s}return e[i]}class kl{constructor(e){this.zoom=e.zoom,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((e=>e.id)),this.index=e.index,this.hasDependencies=!1,this.patternFeatures=[],this.layoutVertexArray=new Js,this.indexArray=new lo,this.indexArray2=new uo,this.programConfigurations=new Uo(e.layers,e.zoom),this.segments=new po,this.segments2=new po,this.stateDependentLayerIds=this.layers.filter((e=>e.isStateDependent())).map((e=>e.id))}populate(e,t,r){this.hasDependencies=Ga("fill",this.layers,t);const n=this.layers[0].layout.get("fill-sort-key"),i=!n.isConstant(),s=[];for(const{feature:o,id:a,index:l,sourceLayerIndex:u}of e){const e=this.layers[0]._featureFilter.needGeometry,c=Zo(o,e);if(!this.layers[0]._featureFilter.filter(new Gi(this.zoom),c,r))continue;const h=i?n.evaluate(c,{},r,t.availableImages):void 0,p={id:a,properties:o.properties,type:o.type,sourceLayerIndex:u,index:l,geometry:e?c.geometry:Yo(o),patterns:{},sortKey:h};s.push(p)}i&&s.sort(((e,t)=>e.sortKey-t.sortKey));for(const n of s){const{geometry:i,index:s,sourceLayerIndex:o}=n;if(this.hasDependencies){const e=ja("fill",this.layers,n,{zoom:this.zoom},t);this.patternFeatures.push(e)}else this.addFeature(n,i,s,r,{},t.subdivisionGranularity);t.featureIndex.insert(e[s].feature,i,s,o,this.index)}}update(e,t,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(e,t,this.stateDependentLayers,{imagePositions:r})}addFeatures(e,t,r){for(const n of this.patternFeatures)this.addFeature(n,n.geometry,n.index,t,r,e.subdivisionGranularity)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(e){this.uploaded||(this.layoutVertexBuffer=e.createVertexBuffer(this.layoutVertexArray,qa),this.indexBuffer=e.createIndexBuffer(this.indexArray),this.indexBuffer2=e.createIndexBuffer(this.indexArray2)),this.programConfigurations.upload(e),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.indexBuffer2.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.segments2.destroy())}addFeature(e,t,r,n,i,s){for(const e of Kt(t,500)){const t=_l(e,n,s.fill.getGranularityForZoomLevel(n.z)),r=this.layoutVertexArray;Il(((e,t)=>{r.emplaceBack(e,t)}),this.segments,this.layoutVertexArray,this.indexArray,t.verticesFlattened,t.indicesTriangles,this.segments2,this.indexArray2,t.indicesLineList)}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,e,r,{imagePositions:i,canonical:n})}}let El,Ml;pi("FillBucket",kl,{omit:["layers","patternFeatures"]});var Dl={get paint(){return Ml=Ml||new os({"fill-antialias":new ts(k.paint_fill["fill-antialias"]),"fill-opacity":new rs(k.paint_fill["fill-opacity"]),"fill-color":new rs(k.paint_fill["fill-color"]),"fill-outline-color":new rs(k.paint_fill["fill-outline-color"]),"fill-translate":new ts(k.paint_fill["fill-translate"]),"fill-translate-anchor":new ts(k.paint_fill["fill-translate-anchor"]),"fill-pattern":new ns(k.paint_fill["fill-pattern"])})},get layout(){return El=El||new os({"fill-sort-key":new rs(k.layout_fill["fill-sort-key"])})}};class Pl extends as{constructor(e,t){super(e,Dl,t)}recalculate(e,t){super.recalculate(e,t);const r=this.paint._values["fill-outline-color"];"constant"===r.value.kind&&void 0===r.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"])}createBucket(e){return new kl(e)}queryRadius(){return ca(this.paint.get("fill-translate"))}queryIntersectsFeature({queryGeometry:e,geometry:t,transform:r,pixelsToTileUnits:n}){return ea(ha(e,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),-r.bearingInRadians,n),t)}isTileClipped(){return!0}}const zl=hs([{name:"a_pos",components:2,type:"Int16"},{name:"a_normal_ed",components:4,type:"Int16"}],4),Fl=hs([{name:"a_centroid",components:2,type:"Int16"}],4),{members:Bl}=zl;class Cl{constructor(e,t,r,n,i){this.properties={},this.extent=r,this.type=0,this.id=void 0,this._pbf=e,this._geometry=-1,this._keys=n,this._values=i,e.readFields(Vl,this,t)}loadGeometry(){const e=this._pbf;e.pos=this._geometry;const r=e.readVarint()+e.pos,n=[];let i,s=1,o=0,a=0,l=0;for(;e.pos<r;){if(o<=0){const t=e.readVarint();s=7&t,o=t>>3}if(o--,1===s||2===s)a+=e.readSVarint(),l+=e.readSVarint(),1===s&&(i&&n.push(i),i=[]),i&&i.push(new t(a,l));else{if(7!==s)throw new Error(`unknown command ${s}`);i&&i.push(i[0].clone())}}return i&&n.push(i),n}bbox(){const e=this._pbf;e.pos=this._geometry;const t=e.readVarint()+e.pos;let r=1,n=0,i=0,s=0,o=1/0,a=-1/0,l=1/0,u=-1/0;for(;e.pos<t;){if(n<=0){const t=e.readVarint();r=7&t,n=t>>3}if(n--,1===r||2===r)i+=e.readSVarint(),s+=e.readSVarint(),i<o&&(o=i),i>a&&(a=i),s<l&&(l=s),s>u&&(u=s);else if(7!==r)throw new Error(`unknown command ${r}`)}return[o,l,a,u]}toGeoJSON(e,t,r){const n=this.extent*Math.pow(2,r),i=this.extent*e,s=this.extent*t,o=this.loadGeometry();function a(e){return[360*(e.x+i)/n-180,360/Math.PI*Math.atan(Math.exp((1-2*(e.y+s)/n)*Math.PI))-90]}function l(e){return e.map(a)}let u;if(1===this.type){const e=[];for(const t of o)e.push(t[0]);const t=l(e);u=1===e.length?{type:"Point",coordinates:t[0]}:{type:"MultiPoint",coordinates:t}}else if(2===this.type){const e=o.map(l);u=1===e.length?{type:"LineString",coordinates:e[0]}:{type:"MultiLineString",coordinates:e}}else{if(3!==this.type)throw new Error("unknown feature type");{const e=Ll(o),t=[];for(const r of e)t.push(r.map(l));u=1===t.length?{type:"Polygon",coordinates:t[0]}:{type:"MultiPolygon",coordinates:t}}}const c={type:"Feature",geometry:u,properties:this.properties};return null!=this.id&&(c.id=this.id),c}}function Vl(e,t,r){1===e?t.id=r.readVarint():2===e?function(e,t){const r=e.readVarint()+e.pos;for(;e.pos<r;){const r=t._keys[e.readVarint()],n=t._values[e.readVarint()];t.properties[r]=n}}(r,t):3===e?t.type=r.readVarint():4===e&&(t._geometry=r.pos)}function Ll(e){const t=e.length;if(t<=1)return[e];const r=[];let n,i;for(let s=0;s<t;s++){const t=Ol(e[s]);0!==t&&(void 0===i&&(i=t<0),i===t<0?(n&&r.push(n),n=[e[s]]):n&&n.push(e[s]))}return n&&r.push(n),r}function Ol(e){let t=0;for(let r,n,i=0,s=e.length,o=s-1;i<s;o=i++)r=e[i],n=e[o],t+=(n.x-r.x)*(r.y+n.y);return t}Cl.types=["Unknown","Point","LineString","Polygon"];class Rl{constructor(e,t){this.version=1,this.name="",this.extent=4096,this.length=0,this._pbf=e,this._keys=[],this._values=[],this._features=[],e.readFields(Nl,this,t),this.length=this._features.length}feature(e){if(e<0||e>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[e];const t=this._pbf.readVarint()+this._pbf.pos;return new Cl(this._pbf,t,this.extent,this._keys,this._values)}}function Nl(e,t,r){15===e?t.version=r.readVarint():1===e?t.name=r.readString():5===e?t.extent=r.readVarint():2===e?t._features.push(r.pos):3===e?t._keys.push(r.readString()):4===e&&t._values.push(function(e){let t=null;const r=e.readVarint()+e.pos;for(;e.pos<r;){const r=e.readVarint()>>3;t=1===r?e.readString():2===r?e.readFloat():3===r?e.readDouble():4===r?e.readVarint64():5===r?e.readVarint():6===r?e.readSVarint():7===r?e.readBoolean():null}if(null==t)throw new Error("unknown feature value");return t}(r))}class $l{constructor(e,t){this.layers=e.readFields(Ul,{},t)}}function Ul(e,t,r){if(3===e){const e=new Rl(r,r.readVarint()+r.pos);e.length&&(t[e.name]=e)}}const ql=Math.pow(2,13);function Gl(e,t,r,n,i,s,o,a){e.emplaceBack(t,r,2*Math.floor(n*ql)+o,i*ql*2,s*ql*2,Math.round(a))}class jl{constructor(e){this.zoom=e.zoom,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((e=>e.id)),this.index=e.index,this.hasDependencies=!1,this.layoutVertexArray=new Ks,this.centroidVertexArray=new Hs,this.indexArray=new lo,this.programConfigurations=new Uo(e.layers,e.zoom),this.segments=new po,this.stateDependentLayerIds=this.layers.filter((e=>e.isStateDependent())).map((e=>e.id))}populate(e,t,r){this.features=[],this.hasDependencies=Ga("fill-extrusion",this.layers,t);for(const{feature:n,id:i,index:s,sourceLayerIndex:o}of e){const e=this.layers[0]._featureFilter.needGeometry,a=Zo(n,e);if(!this.layers[0]._featureFilter.filter(new Gi(this.zoom),a,r))continue;const l={id:i,sourceLayerIndex:o,index:s,geometry:e?a.geometry:Yo(n),properties:n.properties,type:n.type,patterns:{}};this.hasDependencies?this.features.push(ja("fill-extrusion",this.layers,l,{zoom:this.zoom},t)):this.addFeature(l,l.geometry,s,r,{},t.subdivisionGranularity),t.featureIndex.insert(n,l.geometry,s,o,this.index,!0)}}addFeatures(e,t,r){for(const n of this.features){const{geometry:i}=n;this.addFeature(n,i,n.index,t,r,e.subdivisionGranularity)}}update(e,t,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(e,t,this.stateDependentLayers,{imagePositions:r})}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.centroidVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(e){this.uploaded||(this.layoutVertexBuffer=e.createVertexBuffer(this.layoutVertexArray,Bl),this.centroidVertexBuffer=e.createVertexBuffer(this.centroidVertexArray,Fl.members,!0),this.indexBuffer=e.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(e),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.centroidVertexBuffer.destroy())}addFeature(e,t,r,n,i,s){for(const r of Kt(t,500)){const t={x:0,y:0,sampleCount:0},i=this.layoutVertexArray.length;this.processPolygon(t,n,e,r,s);const o=this.layoutVertexArray.length-i,a=Math.floor(t.x/t.sampleCount),l=Math.floor(t.y/t.sampleCount);for(let e=0;e<o;e++)this.centroidVertexArray.emplaceBack(a,l)}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,e,r,{imagePositions:i,canonical:n})}processPolygon(e,t,r,n,i){if(n.length<1)return;if(Zl(n[0]))return;for(const t of n)0!==t.length&&Xl(e,t);const s={segment:this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray)},o=i.fill.getGranularityForZoomLevel(t.z),a="Polygon"===Cl.types[r.type];for(const e of n){if(0===e.length)continue;if(Zl(e))continue;const t=Sl(e,o,a);this._generateSideFaces(t,s)}if(!a)return;const l=_l(n,t,o,!1),u=this.layoutVertexArray;Il(((e,t)=>{Gl(u,e,t,0,0,1,1,0)}),this.segments,this.layoutVertexArray,this.indexArray,l.verticesFlattened,l.indicesTriangles)}_generateSideFaces(e,t){let r=0;for(let n=1;n<e.length;n++){const i=e[n],s=e[n-1];if(Yl(i,s))continue;t.segment.vertexLength+4>po.MAX_VERTEX_ARRAY_LENGTH&&(t.segment=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray));const o=i.sub(s)._perp()._unit(),a=s.dist(i);r+a>32768&&(r=0),Gl(this.layoutVertexArray,i.x,i.y,o.x,o.y,0,0,r),Gl(this.layoutVertexArray,i.x,i.y,o.x,o.y,0,1,r),r+=a,Gl(this.layoutVertexArray,s.x,s.y,o.x,o.y,0,0,r),Gl(this.layoutVertexArray,s.x,s.y,o.x,o.y,0,1,r);const l=t.segment.vertexLength;this.indexArray.emplaceBack(l,l+2,l+1),this.indexArray.emplaceBack(l+1,l+2,l+3),t.segment.vertexLength+=4,t.segment.primitiveLength+=2}}}function Xl(e,t){for(let r=0;r<t.length;r++){const n=t[r];r===t.length-1&&t[0].x===n.x&&t[0].y===n.y||(e.x+=n.x,e.y+=n.y,e.sampleCount++)}}function Yl(e,t){return e.x===t.x&&(e.x<0||e.x>p)||e.y===t.y&&(e.y<0||e.y>p)}function Zl(e){return e.every((e=>e.x<0))||e.every((e=>e.x>p))||e.every((e=>e.y<0))||e.every((e=>e.y>p))}let Hl;pi("FillExtrusionBucket",jl,{omit:["layers","features"]});var Wl={get paint(){return Hl=Hl||new os({"fill-extrusion-opacity":new ts(k["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new rs(k["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new ts(k["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new ts(k["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new ns(k["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-height":new rs(k["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new rs(k["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-vertical-gradient":new ts(k["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"])})}};class Jl extends as{constructor(e,t){super(e,Wl,t)}createBucket(e){return new jl(e)}queryRadius(){return ca(this.paint.get("fill-extrusion-translate"))}is3D(){return!0}queryIntersectsFeature({queryGeometry:e,feature:r,featureState:n,geometry:i,transform:s,pixelsToTileUnits:o,pixelPosMatrix:a}){const l=ha(e,this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),-s.bearingInRadians,o),u=this.paint.get("fill-extrusion-height").evaluate(r,n),c=this.paint.get("fill-extrusion-base").evaluate(r,n),p=function(e,r){const n=[];for(const i of e){const e=[i.x,i.y,0,1];h(e,e,r),n.push(new t(e[0]/e[3],e[1]/e[3]))}return n}(l,a),f=function(e,r,n,i){const s=[],o=[],a=i[8]*r,l=i[9]*r,u=i[10]*r,c=i[11]*r,h=i[8]*n,p=i[9]*n,f=i[10]*n,d=i[11]*n;for(const r of e){const e=[],n=[];for(const s of r){const r=s.x,o=s.y,y=i[0]*r+i[4]*o+i[12],m=i[1]*r+i[5]*o+i[13],g=i[2]*r+i[6]*o+i[14],x=i[3]*r+i[7]*o+i[15],v=g+u,b=x+c,w=y+h,_=m+p,S=g+f,A=x+d,I=new t((y+a)/b,(m+l)/b);I.z=v/b,e.push(I);const T=new t(w/A,_/A);T.z=S/A,n.push(T)}s.push(e),o.push(n)}return[s,o]}(i,c,u,a);return function(e,t,r){let n=1/0;ea(r,t)&&(n=Ql(r,t[0]));for(let i=0;i<t.length;i++){const s=t[i],o=e[i];for(let e=0;e<s.length-1;e++){const t=s[e],i=[t,s[e+1],o[e+1],o[e],t];Ko(r,i)&&(n=Math.min(n,Ql(r,i)))}}return n!==1/0&&n}(f[0],f[1],p)}}function Kl(e,t){return e.x*t.x+e.y*t.y}function Ql(e,t){if(1===e.length){let r=0;const n=t[r++];let i;for(;!i||n.equals(i);)if(i=t[r++],!i)return 1/0;for(;r<t.length;r++){const s=t[r],o=e[0],a=i.sub(n),l=s.sub(n),u=o.sub(n),c=Kl(a,a),h=Kl(a,l),p=Kl(l,l),f=Kl(u,a),d=Kl(u,l),y=c*p-h*h,m=(p*f-h*d)/y,g=(c*d-h*f)/y,x=n.z*(1-m-g)+i.z*m+s.z*g;if(isFinite(x))return x}return 1/0}{let e=1/0;for(const r of t)e=Math.min(e,r.z);return e}}const eu=hs([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"}],4),{members:tu}=eu,ru=hs([{name:"a_uv_x",components:1,type:"Float32"},{name:"a_split_index",components:1,type:"Float32"}]),{members:nu}=ru,iu=Math.cos(Math.PI/180*37.5),su=Math.pow(2,14)/.5;class ou{constructor(e){this.zoom=e.zoom,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((e=>e.id)),this.index=e.index,this.hasDependencies=!1,this.patternFeatures=[],this.lineClipsArray=[],this.gradients={},this.layers.forEach((e=>{this.gradients[e.id]={}})),this.layoutVertexArray=new Qs,this.layoutVertexArray2=new eo,this.indexArray=new lo,this.programConfigurations=new Uo(e.layers,e.zoom),this.segments=new po,this.maxLineLength=0,this.stateDependentLayerIds=this.layers.filter((e=>e.isStateDependent())).map((e=>e.id))}populate(e,t,r){this.hasDependencies=Ga("line",this.layers,t)||this.hasLineDasharray(this.layers);const n=this.layers[0].layout.get("line-sort-key"),i=!n.isConstant(),s=[];for(const{feature:t,id:o,index:a,sourceLayerIndex:l}of e){const e=this.layers[0]._featureFilter.needGeometry,u=Zo(t,e);if(!this.layers[0]._featureFilter.filter(new Gi(this.zoom),u,r))continue;const c=i?n.evaluate(u,{},r):void 0,h={id:o,properties:t.properties,type:t.type,sourceLayerIndex:l,index:a,geometry:e?u.geometry:Yo(t),patterns:{},dashes:{},sortKey:c};s.push(h)}i&&s.sort(((e,t)=>e.sortKey-t.sortKey));for(const n of s){const{geometry:i,index:s,sourceLayerIndex:o}=n;this.hasDependencies?(Ga("line",this.layers,t)?ja("line",this.layers,n,{zoom:this.zoom},t):this.hasLineDasharray(this.layers)&&this.addLineDashDependencies(this.layers,n,this.zoom,t),this.patternFeatures.push(n)):this.addFeature(n,i,s,r,{},{},t.subdivisionGranularity),t.featureIndex.insert(e[s].feature,i,s,o,this.index)}}update(e,t,r,n){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(e,t,this.stateDependentLayers,{imagePositions:r,dashPositions:n})}addFeatures(e,t,r,n){for(const i of this.patternFeatures)this.addFeature(i,i.geometry,i.index,t,r,n,e.subdivisionGranularity)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(e){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=e.createVertexBuffer(this.layoutVertexArray2,nu)),this.layoutVertexBuffer=e.createVertexBuffer(this.layoutVertexArray,tu),this.indexBuffer=e.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(e),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy())}lineFeatureClips(e){if(e.properties&&Object.prototype.hasOwnProperty.call(e.properties,"mapbox_clip_start")&&Object.prototype.hasOwnProperty.call(e.properties,"mapbox_clip_end"))return{start:+e.properties.mapbox_clip_start,end:+e.properties.mapbox_clip_end}}addFeature(e,t,r,n,i,s,o){const a=this.layers[0].layout,l=a.get("line-join").evaluate(e,{}),u=a.get("line-cap"),c=a.get("line-miter-limit"),h=a.get("line-round-limit");this.lineClips=this.lineFeatureClips(e);for(const r of t)this.addLine(r,e,l,u,c,h,n,o);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,e,r,{imagePositions:i,dashPositions:s,canonical:n})}addLine(e,t,r,n,i,s,o,a){if(this.distance=0,this.scaledDistance=0,this.totalDistance=0,e=Sl(e,o?a.line.getGranularityForZoomLevel(o.z):1),this.lineClips){this.lineClipsArray.push(this.lineClips);for(let t=0;t<e.length-1;t++)this.totalDistance+=e[t].dist(e[t+1]);this.updateScaledDistance(),this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance)}const l="Polygon"===Cl.types[t.type];let u=e.length;for(;u>=2&&e[u-1].equals(e[u-2]);)u--;let c=0;for(;c<u-1&&e[c].equals(e[c+1]);)c++;if(u<(l?3:2))return;"bevel"===r&&(i=1.05);const h=this.overscaling<=16?122880/(512*this.overscaling):0,p=this.segments.prepareSegment(10*u,this.layoutVertexArray,this.indexArray);let f,d,y,m,g;this.e1=this.e2=-1,l&&(f=e[u-2],g=e[c].sub(f)._unit()._perp());for(let t=c;t<u;t++){if(y=t===u-1?l?e[c+1]:void 0:e[t+1],y&&e[t].equals(y))continue;g&&(m=g),f&&(d=f),f=e[t],g=y?y.sub(f)._unit()._perp():m,m=m||g;let o=m.add(g);0===o.x&&0===o.y||o._unit();const a=m.x*g.x+m.y*g.y,x=o.x*g.x+o.y*g.y,v=0!==x?1/x:1/0,b=2*Math.sqrt(2-2*x),w=x<iu&&d&&y,_=m.x*g.y-m.y*g.x>0;if(w&&t>c){const e=f.dist(d);if(e>2*h){const t=f.sub(f.sub(d)._mult(h/e)._round());this.updateDistance(d,t),this.addCurrentVertex(t,m,0,0,p),d=t}}const S=d&&y;let A=S?r:l?"butt":n;if(S&&"round"===A&&(v<s?A="miter":v<=2&&(A="fakeround")),"miter"===A&&v>i&&(A="bevel"),"bevel"===A&&(v>2&&(A="flipbevel"),v<i&&(A="miter")),d&&this.updateDistance(d,f),"miter"===A)o._mult(v),this.addCurrentVertex(f,o,0,0,p);else if("flipbevel"===A){if(v>100)o=g.mult(-1);else{const e=v*m.add(g).mag()/m.sub(g).mag();o._perp()._mult(e*(_?-1:1))}this.addCurrentVertex(f,o,0,0,p),this.addCurrentVertex(f,o.mult(-1),0,0,p)}else if("bevel"===A||"fakeround"===A){const e=-Math.sqrt(v*v-1),t=_?e:0,r=_?0:e;if(d&&this.addCurrentVertex(f,m,t,r,p),"fakeround"===A){const e=Math.round(180*b/Math.PI/20);for(let t=1;t<e;t++){let r=t/e;if(.5!==r){const e=r-.5;r+=r*e*(r-1)*((1.0904+a*(a*(3.55645-1.43519*a)-3.2452))*e*e+(.848013+a*(.215638*a-1.06021)))}const n=g.sub(m)._mult(r)._add(m)._unit()._mult(_?-1:1);this.addHalfVertex(f,n.x,n.y,!1,_,0,p)}}y&&this.addCurrentVertex(f,g,-t,-r,p)}else if("butt"===A)this.addCurrentVertex(f,o,0,0,p);else if("square"===A){const e=d?1:-1;this.addCurrentVertex(f,o,e,e,p)}else"round"===A&&(d&&(this.addCurrentVertex(f,m,0,0,p),this.addCurrentVertex(f,m,1,1,p,!0)),y&&(this.addCurrentVertex(f,g,-1,-1,p,!0),this.addCurrentVertex(f,g,0,0,p)));if(w&&t<u-1){const e=f.dist(y);if(e>2*h){const t=f.add(y.sub(f)._mult(h/e)._round());this.updateDistance(f,t),this.addCurrentVertex(t,g,0,0,p),f=t}}}}addCurrentVertex(e,t,r,n,i,s=!1){const o=t.y*n-t.x,a=-t.y-t.x*n;this.addHalfVertex(e,t.x+t.y*r,t.y-t.x*r,s,!1,r,i),this.addHalfVertex(e,o,a,s,!0,-n,i),this.distance>su/2&&0===this.totalDistance&&(this.distance=0,this.updateScaledDistance(),this.addCurrentVertex(e,t,r,n,i,s))}addHalfVertex({x:e,y:t},r,n,i,s,o,a){const l=.5*(this.lineClips?this.scaledDistance*(su-1):this.scaledDistance);this.layoutVertexArray.emplaceBack((e<<1)+(i?1:0),(t<<1)+(s?1:0),Math.round(63*r)+128,Math.round(63*n)+128,1+(0===o?0:o<0?-1:1)|(63&l)<<2,l>>6),this.lineClips&&this.layoutVertexArray2.emplaceBack((this.scaledDistance-this.lineClips.start)/(this.lineClips.end-this.lineClips.start),this.lineClipsArray.length);const u=a.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,u,this.e2),a.primitiveLength++),s?this.e2=u:this.e1=u}updateScaledDistance(){this.scaledDistance=this.lineClips?this.lineClips.start+(this.lineClips.end-this.lineClips.start)*this.distance/this.totalDistance:this.distance}updateDistance(e,t){this.distance+=e.dist(t),this.updateScaledDistance()}hasLineDasharray(e){for(const t of e){const e=t.paint.get("line-dasharray");if(e&&!e.isConstant())return!0}return!1}addLineDashDependencies(e,t,r,n){for(const i of e){const e=i.paint.get("line-dasharray");if(!e||"constant"===e.value.kind)continue;const s="round"===i.layout.get("line-cap"),o={dasharray:e.value.evaluate({zoom:r-1},t,{}),round:s},a={dasharray:e.value.evaluate({zoom:r},t,{}),round:s},l={dasharray:e.value.evaluate({zoom:r+1},t,{}),round:s},u=`${o.dasharray.join(",")},${o.round}`,c=`${a.dasharray.join(",")},${a.round}`,h=`${l.dasharray.join(",")},${l.round}`;n.dashDependencies[u]=o,n.dashDependencies[c]=a,n.dashDependencies[h]=l,t.dashes[i.id]={min:u,mid:c,max:h}}}}let au,lu;pi("LineBucket",ou,{omit:["layers","patternFeatures"]});var uu={get paint(){return lu=lu||new os({"line-opacity":new rs(k.paint_line["line-opacity"]),"line-color":new rs(k.paint_line["line-color"]),"line-translate":new ts(k.paint_line["line-translate"]),"line-translate-anchor":new ts(k.paint_line["line-translate-anchor"]),"line-width":new rs(k.paint_line["line-width"]),"line-gap-width":new rs(k.paint_line["line-gap-width"]),"line-offset":new rs(k.paint_line["line-offset"]),"line-blur":new rs(k.paint_line["line-blur"]),"line-dasharray":new ns(k.paint_line["line-dasharray"]),"line-pattern":new ns(k.paint_line["line-pattern"]),"line-gradient":new ss(k.paint_line["line-gradient"])})},get layout(){return au=au||new os({"line-cap":new ts(k.layout_line["line-cap"]),"line-join":new rs(k.layout_line["line-join"]),"line-miter-limit":new ts(k.layout_line["line-miter-limit"]),"line-round-limit":new ts(k.layout_line["line-round-limit"]),"line-sort-key":new rs(k.layout_line["line-sort-key"])})}};class cu extends rs{possiblyEvaluate(e,t){return t=new Gi(Math.floor(t.zoom),{now:t.now,fadeDuration:t.fadeDuration,zoomHistory:t.zoomHistory,transition:t.transition}),super.possiblyEvaluate(e,t)}evaluate(e,t,r,n){return t=d({},t,{zoom:Math.floor(t.zoom)}),super.evaluate(e,t,r,n)}}let hu;class pu extends as{constructor(e,t){super(e,uu,t),this.gradientVersion=0,hu||(hu=new cu(uu.paint.properties["line-width"].specification),hu.useIntegerZoom=!0)}_handleSpecialPaintPropertyUpdate(e){if("line-gradient"===e){const e=this.gradientExpression();this.stepInterpolant=!!function(e){return void 0!==e._styleExpression}(e)&&e._styleExpression.expression instanceof st,this.gradientVersion=(this.gradientVersion+1)%Number.MAX_SAFE_INTEGER}}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression}recalculate(e,t){super.recalculate(e,t),this.paint._values["line-floorwidth"]=hu.possiblyEvaluate(this._transitioningPaint._values["line-width"].value,e)}createBucket(e){return new ou(e)}queryRadius(e){const t=e,r=fu(ua("line-width",this,t),ua("line-gap-width",this,t)),n=ua("line-offset",this,t);return r/2+Math.abs(n)+ca(this.paint.get("line-translate"))}queryIntersectsFeature({queryGeometry:e,feature:r,featureState:n,geometry:i,transform:s,pixelsToTileUnits:o}){const a=ha(e,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),-s.bearingInRadians,o),l=o/2*fu(this.paint.get("line-width").evaluate(r,n),this.paint.get("line-gap-width").evaluate(r,n)),u=this.paint.get("line-offset").evaluate(r,n);return u&&(i=function(e,r){const n=[];for(let i=0;i<e.length;i++){const s=pa(e[i]),o=[];for(let e=0;e<s.length;e++){const n=s[e],i=s[e-1],a=s[e+1],l=0===e?new t(0,0):n.sub(i)._unit()._perp(),u=e===s.length-1?new t(0,0):a.sub(n)._unit()._perp(),c=l._add(u)._unit(),h=c.x*u.x+c.y*u.y;0!==h&&c._mult(1/h),o.push(c._mult(r)._add(n))}n.push(o)}return n}(i,u*o)),function(e,t,r){for(let n=0;n<t.length;n++){const i=t[n];if(e.length>=3)for(let t=0;t<i.length;t++)if(aa(e,i[t]))return!0;if(ta(e,i,r))return!0}return!1}(a,i,l)}isTileClipped(){return!0}}function fu(e,t){return t>0?t+2*e:e}const du=hs([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_data",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"}],4),yu=hs([{name:"a_projected_pos",components:3,type:"Float32"}],4);hs([{name:"a_fade_opacity",components:1,type:"Uint32"}],4);const mu=hs([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"},{name:"a_box_real",components:2,type:"Int16"}]);hs([{type:"Int16",name:"anchorPointX"},{type:"Int16",name:"anchorPointY"},{type:"Int16",name:"x1"},{type:"Int16",name:"y1"},{type:"Int16",name:"x2"},{type:"Int16",name:"y2"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]);const gu=hs([{name:"a_pos",components:2,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4);function xu(e,t,r){return e.sections.forEach((e=>{e.text=function(e,t,r){const n=t.layout.get("text-transform").evaluate(r,{});return"uppercase"===n?e=e.toLocaleUpperCase():"lowercase"===n&&(e=e.toLocaleLowerCase()),qi.applyArabicShaping&&(e=qi.applyArabicShaping(e)),e}(e.text,t,r)})),e}hs([{name:"a_pos",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4),hs([{name:"triangle",components:3,type:"Uint16"}]),hs([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"}]),hs([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",name:"textBoxScale"},{type:"Float32",name:"collisionCircleDiameter"},{type:"Uint16",name:"textAnchorOffsetStartIndex"},{type:"Uint16",name:"textAnchorOffsetEndIndex"}]),hs([{type:"Float32",name:"offsetX"}]),hs([{type:"Int16",name:"x"},{type:"Int16",name:"y"},{type:"Int16",name:"tileUnitDistanceFromAnchor"}]),hs([{type:"Uint16",name:"textAnchor"},{type:"Float32",components:2,name:"textOffset"}]);var vu=24;const bu={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","⋯":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂"},wu={10:!0,32:!0,38:!0,41:!0,43:!0,45:!0,47:!0,173:!0,183:!0,8203:!0,8208:!0,8211:!0,8231:!0},_u={40:!0};function Su(e,t,r,n,i,s){if("fontStack"in t){const n=r[t.fontStack],s=n&&n[e];return s?s.metrics.advance*t.scale+i:0}{const e=n[t.imageName];return e?e.displaySize[0]*t.scale*vu/s+i:0}}function Au(e,t,r,n){const i=Math.pow(e-t,2);return n?e<t?i/2:2*i:i+Math.abs(r)*r}function Iu(e,t,r){let n=0;return 10===e&&(n-=1e4),r&&(n+=150),40!==e&&65288!==e||(n+=50),41!==t&&65289!==t||(n+=50),n}function Tu(e,t,r,n,i,s){let o=null,a=Au(t,r,i,s);for(const e of n){const n=Au(t-e.x,r,i,s)+e.badness;n<=a&&(o=e,a=n)}return{index:e,x:t,priorBreak:o,badness:a}}function ku(e){return e?ku(e.priorBreak).concat(e.index):[]}class Eu{constructor(e="",t=[],r=[]){this.text=e,this.sections=t,this.sectionIndex=r,this.imageSectionID=null}static fromFeature(e,t){const r=new Eu;for(let n=0;n<e.sections.length;n++){const i=e.sections[n];i.image?r.addImageSection(i):r.addTextSection(i,t)}return r}length(){return[...this.text].length}getSection(e){return this.sections[this.sectionIndex[e]]}getSectionIndex(e){return this.sectionIndex[e]}verticalizePunctuation(){this.text=function(e){let t="",r={premature:!0,value:void 0};const n=e[Symbol.iterator]();let i=n.next();const s=e[Symbol.iterator]();s.next();let o=s.next();for(;!i.done;)t+=!o.done&&Oi(o.value.codePointAt(0))&&!bu[o.value]||!r.premature&&Oi(r.value.codePointAt(0))&&!bu[r.value]||!bu[i.value]?i.value:bu[i.value],r={value:i.value,premature:!1},i=n.next(),o=s.next();return t}(this.text)}hasZeroWidthSpaces(){return this.text.includes("​")}trim(){const e=this.text.match(/^\s*/),t=e?e[0].length:0,r=this.text.match(/\S\s*$/),n=r?r[0].length-1:0;this.text=this.text.substring(t,this.text.length-n),this.sectionIndex=this.sectionIndex.slice(t,this.sectionIndex.length-n)}substring(e,t){const r=[...this.text].slice(e,t).join(""),n=this.sectionIndex.slice(e,t);return new Eu(r,this.sections,n)}toCodeUnitIndex(e){return[...this.text].slice(0,e).join("").length}toString(){return this.text}getMaxScale(){return this.sectionIndex.reduce(((e,t)=>Math.max(e,this.sections[t].scale)),0)}getMaxImageSize(e){let t=0,r=0;for(let n=0;n<this.length();n++){const i=this.getSection(n);if("imageName"in i){const n=e[i.imageName];if(!n)continue;const s=n.displaySize;t=Math.max(t,s[0]),r=Math.max(r,s[1])}}return{maxImageWidth:t,maxImageHeight:r}}addTextSection(e,t){this.text+=e.text,this.sections.push({scale:e.scale||1,verticalAlign:e.verticalAlign||"bottom",fontStack:e.fontStack||t});const r=this.sections.length-1;this.sectionIndex.push(...[...e.text].map((()=>r)))}addImageSection(e){const t=e.image?e.image.name:"";if(0===t.length)return void x("Can't add FormattedSection with an empty image.");const r=this.getNextImageSectionCharCode();r?(this.text+=String.fromCharCode(r),this.sections.push({scale:1,verticalAlign:e.verticalAlign||"bottom",imageName:t}),this.sectionIndex.push(this.sections.length-1)):x("Reached maximum number of images 6401")}getNextImageSectionCharCode(){return this.imageSectionID?this.imageSectionID>=63743?null:++this.imageSectionID:(this.imageSectionID=57344,this.imageSectionID)}determineLineBreaks(e,t,r,n,i){const s=[],o=this.determineAverageLineWidth(e,t,r,n,i),a=this.hasZeroWidthSpaces();let l=0,u=0;const c=this.text[Symbol.iterator]();let h=c.next();const p=this.text[Symbol.iterator]();p.next();let f=p.next();const d=this.text[Symbol.iterator]();d.next(),d.next();let y=d.next();for(;!h.done;){const t=this.getSection(u),m=h.value.codePointAt(0);if(zi(m)||(l+=Su(m,t,r,n,e,i)),!f.done){const e=Di(m),r=f.value.codePointAt(0);(wu[m]||e||"imageName"in t||!y.done&&_u[r])&&s.push(Tu(u+1,l,o,s,Iu(m,r,e&&a),!1))}u++,h=c.next(),f=p.next(),y=d.next()}return ku(Tu(this.length(),l,o,s,0,!0))}determineAverageLineWidth(e,t,r,n,i){let s=0,o=0;for(const t of this.text){const a=this.getSection(o);s+=Su(t.codePointAt(0),a,r,n,e,i),o++}return s/Math.max(1,Math.ceil(s/t))}}const Mu=4294967296,Du=1/Mu,Pu="undefined"==typeof TextDecoder?null:new TextDecoder("utf-8");class zu{constructor(e=new Uint8Array(16)){this.buf=ArrayBuffer.isView(e)?e:new Uint8Array(e),this.dataView=new DataView(this.buf.buffer),this.pos=0,this.type=0,this.length=this.buf.length}readFields(e,t,r=this.length){for(;this.pos<r;){const r=this.readVarint(),n=r>>3,i=this.pos;this.type=7&r,e(n,t,this),this.pos===i&&this.skip(r)}return t}readMessage(e,t){return this.readFields(e,t,this.readVarint()+this.pos)}readFixed32(){const e=this.dataView.getUint32(this.pos,!0);return this.pos+=4,e}readSFixed32(){const e=this.dataView.getInt32(this.pos,!0);return this.pos+=4,e}readFixed64(){const e=this.dataView.getUint32(this.pos,!0)+this.dataView.getUint32(this.pos+4,!0)*Mu;return this.pos+=8,e}readSFixed64(){const e=this.dataView.getUint32(this.pos,!0)+this.dataView.getInt32(this.pos+4,!0)*Mu;return this.pos+=8,e}readFloat(){const e=this.dataView.getFloat32(this.pos,!0);return this.pos+=4,e}readDouble(){const e=this.dataView.getFloat64(this.pos,!0);return this.pos+=8,e}readVarint(e){const t=this.buf;let r,n;return n=t[this.pos++],r=127&n,n<128?r:(n=t[this.pos++],r|=(127&n)<<7,n<128?r:(n=t[this.pos++],r|=(127&n)<<14,n<128?r:(n=t[this.pos++],r|=(127&n)<<21,n<128?r:(n=t[this.pos],r|=(15&n)<<28,function(e,t,r){const n=r.buf;let i,s;if(s=n[r.pos++],i=(112&s)>>4,s<128)return Fu(e,i,t);if(s=n[r.pos++],i|=(127&s)<<3,s<128)return Fu(e,i,t);if(s=n[r.pos++],i|=(127&s)<<10,s<128)return Fu(e,i,t);if(s=n[r.pos++],i|=(127&s)<<17,s<128)return Fu(e,i,t);if(s=n[r.pos++],i|=(127&s)<<24,s<128)return Fu(e,i,t);if(s=n[r.pos++],i|=(1&s)<<31,s<128)return Fu(e,i,t);throw new Error("Expected varint not more than 10 bytes")}(r,e,this)))))}readVarint64(){return this.readVarint(!0)}readSVarint(){const e=this.readVarint();return e%2==1?(e+1)/-2:e/2}readBoolean(){return Boolean(this.readVarint())}readString(){const e=this.readVarint()+this.pos,t=this.pos;return this.pos=e,e-t>=12&&Pu?Pu.decode(this.buf.subarray(t,e)):function(e,t,r){let n="",i=t;for(;i<r;){const t=e[i];let s,o,a,l=null,u=t>239?4:t>223?3:t>191?2:1;if(i+u>r)break;1===u?t<128&&(l=t):2===u?(s=e[i+1],128==(192&s)&&(l=(31&t)<<6|63&s,l<=127&&(l=null))):3===u?(s=e[i+1],o=e[i+2],128==(192&s)&&128==(192&o)&&(l=(15&t)<<12|(63&s)<<6|63&o,(l<=2047||l>=55296&&l<=57343)&&(l=null))):4===u&&(s=e[i+1],o=e[i+2],a=e[i+3],128==(192&s)&&128==(192&o)&&128==(192&a)&&(l=(15&t)<<18|(63&s)<<12|(63&o)<<6|63&a,(l<=65535||l>=1114112)&&(l=null))),null===l?(l=65533,u=1):l>65535&&(l-=65536,n+=String.fromCharCode(l>>>10&1023|55296),l=56320|1023&l),n+=String.fromCharCode(l),i+=u}return n}(this.buf,t,e)}readBytes(){const e=this.readVarint()+this.pos,t=this.buf.subarray(this.pos,e);return this.pos=e,t}readPackedVarint(e=[],t){const r=this.readPackedEnd();for(;this.pos<r;)e.push(this.readVarint(t));return e}readPackedSVarint(e=[]){const t=this.readPackedEnd();for(;this.pos<t;)e.push(this.readSVarint());return e}readPackedBoolean(e=[]){const t=this.readPackedEnd();for(;this.pos<t;)e.push(this.readBoolean());return e}readPackedFloat(e=[]){const t=this.readPackedEnd();for(;this.pos<t;)e.push(this.readFloat());return e}readPackedDouble(e=[]){const t=this.readPackedEnd();for(;this.pos<t;)e.push(this.readDouble());return e}readPackedFixed32(e=[]){const t=this.readPackedEnd();for(;this.pos<t;)e.push(this.readFixed32());return e}readPackedSFixed32(e=[]){const t=this.readPackedEnd();for(;this.pos<t;)e.push(this.readSFixed32());return e}readPackedFixed64(e=[]){const t=this.readPackedEnd();for(;this.pos<t;)e.push(this.readFixed64());return e}readPackedSFixed64(e=[]){const t=this.readPackedEnd();for(;this.pos<t;)e.push(this.readSFixed64());return e}readPackedEnd(){return 2===this.type?this.readVarint()+this.pos:this.pos+1}skip(e){const t=7&e;if(0===t)for(;this.buf[this.pos++]>127;);else if(2===t)this.pos=this.readVarint()+this.pos;else if(5===t)this.pos+=4;else{if(1!==t)throw new Error(`Unimplemented type: ${t}`);this.pos+=8}}writeTag(e,t){this.writeVarint(e<<3|t)}realloc(e){let t=this.length||16;for(;t<this.pos+e;)t*=2;if(t!==this.length){const e=new Uint8Array(t);e.set(this.buf),this.buf=e,this.dataView=new DataView(e.buffer),this.length=t}}finish(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)}writeFixed32(e){this.realloc(4),this.dataView.setInt32(this.pos,e,!0),this.pos+=4}writeSFixed32(e){this.realloc(4),this.dataView.setInt32(this.pos,e,!0),this.pos+=4}writeFixed64(e){this.realloc(8),this.dataView.setInt32(this.pos,-1&e,!0),this.dataView.setInt32(this.pos+4,Math.floor(e*Du),!0),this.pos+=8}writeSFixed64(e){this.realloc(8),this.dataView.setInt32(this.pos,-1&e,!0),this.dataView.setInt32(this.pos+4,Math.floor(e*Du),!0),this.pos+=8}writeVarint(e){(e=+e||0)>268435455||e<0?function(e,t){let r,n;if(e>=0?(r=e%4294967296|0,n=e/4294967296|0):(r=~(-e%4294967296),n=~(-e/4294967296),4294967295^r?r=r+1|0:(r=0,n=n+1|0)),e>=0x10000000000000000||e<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");t.realloc(10),function(e,t,r){r.buf[r.pos++]=127&e|128,e>>>=7,r.buf[r.pos++]=127&e|128,e>>>=7,r.buf[r.pos++]=127&e|128,e>>>=7,r.buf[r.pos++]=127&e|128,r.buf[r.pos]=127&(e>>>=7)}(r,0,t),function(e,t){const r=(7&e)<<4;t.buf[t.pos++]|=r|((e>>>=3)?128:0),e&&(t.buf[t.pos++]=127&e|((e>>>=7)?128:0),e&&(t.buf[t.pos++]=127&e|((e>>>=7)?128:0),e&&(t.buf[t.pos++]=127&e|((e>>>=7)?128:0),e&&(t.buf[t.pos++]=127&e|((e>>>=7)?128:0),e&&(t.buf[t.pos++]=127&e)))))}(n,t)}(e,this):(this.realloc(4),this.buf[this.pos++]=127&e|(e>127?128:0),e<=127||(this.buf[this.pos++]=127&(e>>>=7)|(e>127?128:0),e<=127||(this.buf[this.pos++]=127&(e>>>=7)|(e>127?128:0),e<=127||(this.buf[this.pos++]=e>>>7&127))))}writeSVarint(e){this.writeVarint(e<0?2*-e-1:2*e)}writeBoolean(e){this.writeVarint(+e)}writeString(e){e=String(e),this.realloc(4*e.length),this.pos++;const t=this.pos;this.pos=function(e,t,r){for(let n,i,s=0;s<t.length;s++){if(n=t.charCodeAt(s),n>55295&&n<57344){if(!i){n>56319||s+1===t.length?(e[r++]=239,e[r++]=191,e[r++]=189):i=n;continue}if(n<56320){e[r++]=239,e[r++]=191,e[r++]=189,i=n;continue}n=i-55296<<10|n-56320|65536,i=null}else i&&(e[r++]=239,e[r++]=191,e[r++]=189,i=null);n<128?e[r++]=n:(n<2048?e[r++]=n>>6|192:(n<65536?e[r++]=n>>12|224:(e[r++]=n>>18|240,e[r++]=n>>12&63|128),e[r++]=n>>6&63|128),e[r++]=63&n|128)}return r}(this.buf,e,this.pos);const r=this.pos-t;r>=128&&Bu(t,r,this),this.pos=t-1,this.writeVarint(r),this.pos+=r}writeFloat(e){this.realloc(4),this.dataView.setFloat32(this.pos,e,!0),this.pos+=4}writeDouble(e){this.realloc(8),this.dataView.setFloat64(this.pos,e,!0),this.pos+=8}writeBytes(e){const t=e.length;this.writeVarint(t),this.realloc(t);for(let r=0;r<t;r++)this.buf[this.pos++]=e[r]}writeRawMessage(e,t){this.pos++;const r=this.pos;e(t,this);const n=this.pos-r;n>=128&&Bu(r,n,this),this.pos=r-1,this.writeVarint(n),this.pos+=n}writeMessage(e,t,r){this.writeTag(e,2),this.writeRawMessage(t,r)}writePackedVarint(e,t){t.length&&this.writeMessage(e,Cu,t)}writePackedSVarint(e,t){t.length&&this.writeMessage(e,Vu,t)}writePackedBoolean(e,t){t.length&&this.writeMessage(e,Ru,t)}writePackedFloat(e,t){t.length&&this.writeMessage(e,Lu,t)}writePackedDouble(e,t){t.length&&this.writeMessage(e,Ou,t)}writePackedFixed32(e,t){t.length&&this.writeMessage(e,Nu,t)}writePackedSFixed32(e,t){t.length&&this.writeMessage(e,$u,t)}writePackedFixed64(e,t){t.length&&this.writeMessage(e,Uu,t)}writePackedSFixed64(e,t){t.length&&this.writeMessage(e,qu,t)}writeBytesField(e,t){this.writeTag(e,2),this.writeBytes(t)}writeFixed32Field(e,t){this.writeTag(e,5),this.writeFixed32(t)}writeSFixed32Field(e,t){this.writeTag(e,5),this.writeSFixed32(t)}writeFixed64Field(e,t){this.writeTag(e,1),this.writeFixed64(t)}writeSFixed64Field(e,t){this.writeTag(e,1),this.writeSFixed64(t)}writeVarintField(e,t){this.writeTag(e,0),this.writeVarint(t)}writeSVarintField(e,t){this.writeTag(e,0),this.writeSVarint(t)}writeStringField(e,t){this.writeTag(e,2),this.writeString(t)}writeFloatField(e,t){this.writeTag(e,5),this.writeFloat(t)}writeDoubleField(e,t){this.writeTag(e,1),this.writeDouble(t)}writeBooleanField(e,t){this.writeVarintField(e,+t)}}function Fu(e,t,r){return r?4294967296*t+(e>>>0):4294967296*(t>>>0)+(e>>>0)}function Bu(e,t,r){const n=t<=16383?1:t<=2097151?2:t<=268435455?3:Math.floor(Math.log(t)/(7*Math.LN2));r.realloc(n);for(let t=r.pos-1;t>=e;t--)r.buf[t+n]=r.buf[t]}function Cu(e,t){for(let r=0;r<e.length;r++)t.writeVarint(e[r])}function Vu(e,t){for(let r=0;r<e.length;r++)t.writeSVarint(e[r])}function Lu(e,t){for(let r=0;r<e.length;r++)t.writeFloat(e[r])}function Ou(e,t){for(let r=0;r<e.length;r++)t.writeDouble(e[r])}function Ru(e,t){for(let r=0;r<e.length;r++)t.writeBoolean(e[r])}function Nu(e,t){for(let r=0;r<e.length;r++)t.writeFixed32(e[r])}function $u(e,t){for(let r=0;r<e.length;r++)t.writeSFixed32(e[r])}function Uu(e,t){for(let r=0;r<e.length;r++)t.writeFixed64(e[r])}function qu(e,t){for(let r=0;r<e.length;r++)t.writeSFixed64(e[r])}function Gu(e){let t=0,r=0;for(const n of e)t+=n.w*n.h,r=Math.max(r,n.w);e.sort(((e,t)=>t.h-e.h));const n=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(t/.95)),r),h:1/0}];let i=0,s=0;for(const t of e)for(let e=n.length-1;e>=0;e--){const r=n[e];if(!(t.w>r.w||t.h>r.h)){if(t.x=r.x,t.y=r.y,s=Math.max(s,t.y+t.h),i=Math.max(i,t.x+t.w),t.w===r.w&&t.h===r.h){const t=n.pop();t&&e<n.length&&(n[e]=t)}else t.h===r.h?(r.x+=t.w,r.w-=t.w):t.w===r.w?(r.y+=t.h,r.h-=t.h):(n.push({x:r.x+t.w,y:r.y,w:r.w-t.w,h:t.h}),r.y+=t.h,r.h-=t.h);break}}return{w:i,h:s,fill:t/(i*s)||0}}class ju{constructor(e,{pixelRatio:t,version:r,stretchX:n,stretchY:i,content:s,textFitWidth:o,textFitHeight:a}){this.paddedRect=e,this.pixelRatio=t,this.stretchX=n,this.stretchY=i,this.content=s,this.version=r,this.textFitWidth=o,this.textFitHeight=a}get tl(){return[this.paddedRect.x+1,this.paddedRect.y+1]}get br(){return[this.paddedRect.x+this.paddedRect.w-1,this.paddedRect.y+this.paddedRect.h-1]}get tlbr(){return this.tl.concat(this.br)}get displaySize(){return[(this.paddedRect.w-2)/this.pixelRatio,(this.paddedRect.h-2)/this.pixelRatio]}}class Xu{constructor(e,t){const r={},n={};this.haveRenderCallbacks=[];const i=[];this.addImages(e,r,i),this.addImages(t,n,i);const{w:s,h:o}=Gu(i),a=new Da({width:s||1,height:o||1});for(const t in e){const n=e[t],i=r[t].paddedRect;Da.copy(n.data,a,{x:0,y:0},{x:i.x+1,y:i.y+1},n.data)}for(const e in t){const r=t[e],i=n[e].paddedRect,s=i.x+1,o=i.y+1,l=r.data.width,u=r.data.height;Da.copy(r.data,a,{x:0,y:0},{x:s,y:o},r.data),Da.copy(r.data,a,{x:0,y:u-1},{x:s,y:o-1},{width:l,height:1}),Da.copy(r.data,a,{x:0,y:0},{x:s,y:o+u},{width:l,height:1}),Da.copy(r.data,a,{x:l-1,y:0},{x:s-1,y:o},{width:1,height:u}),Da.copy(r.data,a,{x:0,y:0},{x:s+l,y:o},{width:1,height:u})}this.image=a,this.iconPositions=r,this.patternPositions=n}addImages(e,t,r){for(const n in e){const i=e[n],s={x:0,y:0,w:i.data.width+2,h:i.data.height+2};r.push(s),t[n]=new ju(s,i),i.hasRenderCallback&&this.haveRenderCallbacks.push(n)}}patchUpdatedImages(e,t){e.dispatchRenderCallbacks(this.haveRenderCallbacks);for(const r in e.updatedImages)this.patchUpdatedImage(this.iconPositions[r],e.getImage(r),t),this.patchUpdatedImage(this.patternPositions[r],e.getImage(r),t)}patchUpdatedImage(e,t,r){if(!e||!t)return;if(e.version===t.version)return;e.version=t.version;const[n,i]=e.tl;r.update(t.data,void 0,{x:n,y:i})}}var Yu;function Zu(e,t,r,n,i,s,o,a,l,u,c,h,p,f,d){const y=Eu.fromFeature(e,i);let m;h===Yu.vertical&&y.verticalizePunctuation();let g=y.determineLineBreaks(u,s,t,n,f);const{processBidirectionalText:x,processStyledBidirectionalText:v}=qi;if(x&&1===y.sections.length){m=[],g=g.map((e=>y.toCodeUnitIndex(e)));const e=x(y.toString(),g);for(const t of e){const e=[...t].map((()=>0));m.push(new Eu(t,y.sections,e))}}else if(v){m=[],g=g.map((e=>y.toCodeUnitIndex(e)));let e=0;const t=[];for(const r of y.text)t.push(...Array(r.length).fill(y.sectionIndex[e])),e++;const r=v(y.text,t,g);for(const e of r){const t=[];let r="";for(const n of e[0])t.push(e[1][r.length]),r+=n;m.push(new Eu(e[0],y.sections,t))}}else m=function(e,t){const r=[];let n=0;for(const i of t)r.push(e.substring(n,i)),n=i;return n<e.length()&&r.push(e.substring(n,e.length())),r}(y,g);const b=[],w={positionedLines:b,text:y.toString(),top:c[1],bottom:c[1],left:c[0],right:c[0],writingMode:h,iconsInText:!1,verticalizable:!1};return function(e,t,r,n,i,s,o,a,l,u,c,h){let p=0,f=0,d=0,y=0;const m="right"===a?1:"left"===a?0:.5,g=vu/h;let x=0;for(const o of i){o.trim();const i=o.getMaxScale(),a={positionedGlyphs:[],lineOffset:0};e.positionedLines[x]=a;const h=a.positionedGlyphs;let v=0;if(!o.length()){f+=s,++x;continue}const b=Wu(n,o,g);let w=0;for(const s of o.text){const a=o.getSection(w),d=s.codePointAt(0),y=Ku(l,c,d),m={glyph:d,imageName:null,x:p,y:f+-17,vertical:y,scale:1,fontStack:"",sectionIndex:o.getSectionIndex(w),metrics:null,rect:null};let x;if("fontStack"in a){if(x=Qu(a,d,y,b,t,r),!x)continue;m.fontStack=a.fontStack}else{if(e.iconsInText=!0,a.scale*=g,x=ec(a,y,i,b,n),!x)continue;v=Math.max(v,x.imageOffset),m.imageName=a.imageName}const{rect:_,metrics:S,baselineOffset:A}=x;m.y+=A,m.scale=a.scale,m.metrics=S,m.rect=_,h.push(m),y?(e.verticalizable=!0,p+=("imageName"in a?S.advance:vu)*a.scale+u):p+=S.advance*a.scale+u,w++}0!==h.length&&(d=Math.max(p-u,d),tc(h,0,h.length-1,m)),p=0,a.lineOffset=Math.max(v,(i-1)*vu);const _=s*i+v;f+=_,y=Math.max(_,y),++x}const{horizontalAlign:v,verticalAlign:b}=Hu(o);(function(e,t,r,n,i,s,o,a,l){const u=(t-r)*i;let c=0;c=s!==o?-a*n- -17:-n*l*o+.5*o;for(const t of e)for(const e of t.positionedGlyphs)e.x+=u,e.y+=c})(e.positionedLines,m,v,b,d,y,s,f,i.length),e.top+=-b*f,e.bottom=e.top+f,e.left+=-v*d,e.right=e.left+d}(w,t,r,n,m,o,a,l,h,u,p,d),!function(e){for(const t of e)if(0!==t.positionedGlyphs.length)return!1;return!0}(b)&&w}function Hu(e){let t=.5,r=.5;switch(e){case"right":case"top-right":case"bottom-right":t=1;break;case"left":case"top-left":case"bottom-left":t=0}switch(e){case"bottom":case"bottom-right":case"bottom-left":r=1;break;case"top":case"top-right":case"top-left":r=0}return{horizontalAlign:t,verticalAlign:r}}function Wu(e,t,r){const n=t.getMaxScale()*vu,{maxImageWidth:i,maxImageHeight:s}=t.getMaxImageSize(e),o=Math.max(n,s*r);return{verticalLineContentWidth:Math.max(n,i*r),horizontalLineContentHeight:o}}function Ju(e){switch(e){case"top":return 0;case"center":return.5;default:return 1}}function Ku(e,t,r){return!(e===Yu.horizontal||!t&&!Pi(r)||t&&(zi(r)||(n=r,/\p{sc=Arab}/u.test(String.fromCodePoint(n)))));var n}function Qu(e,t,r,n,i,s){const o=s[e.fontStack],a=function(e,t,r,n){if(e&&e.rect)return e;const i=t[r.fontStack],s=i&&i[n];return s?{rect:null,metrics:s.metrics}:null}(o&&o[t],i,e,t);if(null===a)return null;let l;if(r)l=n.verticalLineContentWidth-e.scale*vu;else{const t=Ju(e.verticalAlign);l=(n.horizontalLineContentHeight-e.scale*vu)*t}return{rect:a.rect,metrics:a.metrics,baselineOffset:l}}function ec(e,t,r,n,i){const s=i[e.imageName];if(!s)return null;const o=s.paddedRect,a=s.displaySize,l={width:a[0],height:a[1],left:1,top:-3,advance:t?a[1]:a[0]};let u;if(t)u=n.verticalLineContentWidth-a[1]*e.scale;else{const t=Ju(e.verticalAlign);u=(n.horizontalLineContentHeight-a[1]*e.scale)*t}return{rect:o,metrics:l,baselineOffset:u,imageOffset:(t?a[0]:a[1])*e.scale-vu*r}}function tc(e,t,r,n){if(0===n)return;const i=e[r],s=(e[r].x+i.metrics.advance*i.scale)*n;for(let n=t;n<=r;n++)e[n].x-=s}function rc(e,t,r){const{horizontalAlign:n,verticalAlign:i}=Hu(r),s=t[0]-e.displaySize[0]*n,o=t[1]-e.displaySize[1]*i;return{image:e,top:o,bottom:o+e.displaySize[1],left:s,right:s+e.displaySize[0]}}function nc(e){var t,r;let n=e.left,i=e.top,s=e.right-n,o=e.bottom-i;const a=null!==(t=e.image.textFitWidth)&&void 0!==t?t:"stretchOrShrink",l=null!==(r=e.image.textFitHeight)&&void 0!==r?r:"stretchOrShrink",u=(e.image.content[2]-e.image.content[0])/(e.image.content[3]-e.image.content[1]);if("proportional"===l){if("stretchOnly"===a&&s/o<u||"proportional"===a){const e=Math.ceil(o*u);n*=e/s,s=e}}else if("proportional"===a&&"stretchOnly"===l&&0!==u&&s/o>u){const e=Math.ceil(s/u);i*=e/o,o=e}return{x1:n,y1:i,x2:n+s,y2:i+o}}function ic(e,t,r,n,i,s){const o=e.image;let a;if(o.content){const e=o.content,t=o.pixelRatio||1;a=[e[0]/t,e[1]/t,o.displaySize[0]-e[2]/t,o.displaySize[1]-e[3]/t]}const l=t.left*s,u=t.right*s;let c,h,p,f;"width"===r||"both"===r?(f=i[0]+l-n[3],h=i[0]+u+n[1]):(f=i[0]+(l+u-o.displaySize[0])/2,h=f+o.displaySize[0]);const d=t.top*s,y=t.bottom*s;return"height"===r||"both"===r?(c=i[1]+d-n[0],p=i[1]+y+n[2]):(c=i[1]+(d+y-o.displaySize[1])/2,p=c+o.displaySize[1]),{image:o,top:c,right:h,bottom:p,left:f,collisionPadding:a}}pi("ImagePosition",ju),pi("ImageAtlas",Xu),function(e){e[e.none=0]="none",e[e.horizontal=1]="horizontal",e[e.vertical=2]="vertical",e[e.horizontalOnly=3]="horizontalOnly"}(Yu||(Yu={}));const sc=128,oc=32640;function ac(e,t){const{expression:r}=t;if("constant"===r.kind)return{kind:"constant",layoutSize:r.evaluate(new Gi(e+1))};if("source"===r.kind)return{kind:"source"};{const{zoomStops:t,interpolationType:n}=r;let i=0;for(;i<t.length&&t[i]<=e;)i++;i=Math.max(0,i-1);let s=i;for(;s<t.length&&t[s]<e+1;)s++;s=Math.min(t.length-1,s);const o=t[i],a=t[s];return"composite"===r.kind?{kind:"composite",minZoom:o,maxZoom:a,interpolationType:n}:{kind:"camera",minZoom:o,maxZoom:a,minSize:r.evaluate(new Gi(o)),maxSize:r.evaluate(new Gi(a)),interpolationType:n}}}function lc(e,t,r){let n="never";const i=e.get(t);return i?n=i:e.get(r)&&(n="always"),n}const uc=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function cc(e,t,r,n,i,s,o,a,l,u,c,h,p){const f=a?Math.min(oc,Math.round(a[0])):0,d=a?Math.min(oc,Math.round(a[1])):0;e.emplaceBack(t,r,Math.round(32*n),Math.round(32*i),s,o,(f<<1)+(l?1:0),d,16*u,16*c,256*h,256*p)}function hc(e,t,r){e.emplaceBack(t.x,t.y,r),e.emplaceBack(t.x,t.y,r),e.emplaceBack(t.x,t.y,r),e.emplaceBack(t.x,t.y,r)}function pc(e){for(const t of e.sections)if(Ui(t.text))return!0;return!1}class fc{constructor(e){this.layoutVertexArray=new no,this.indexArray=new lo,this.programConfigurations=e,this.segments=new po,this.dynamicLayoutVertexArray=new io,this.opacityVertexArray=new so,this.hasVisibleVertices=!1,this.placedSymbolArray=new Ns}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length}upload(e,t,r,n){this.isEmpty()||(r&&(this.layoutVertexBuffer=e.createVertexBuffer(this.layoutVertexArray,du.members),this.indexBuffer=e.createIndexBuffer(this.indexArray,t),this.dynamicLayoutVertexBuffer=e.createVertexBuffer(this.dynamicLayoutVertexArray,yu.members,!0),this.opacityVertexBuffer=e.createVertexBuffer(this.opacityVertexArray,uc,!0),this.opacityVertexBuffer.itemSize=1),(r||n)&&this.programConfigurations.upload(e))}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.dynamicLayoutVertexBuffer.destroy(),this.opacityVertexBuffer.destroy())}}pi("SymbolBuffers",fc);class dc{constructor(e,t,r){this.layoutVertexArray=new e,this.layoutAttributes=t,this.indexArray=new r,this.segments=new po,this.collisionVertexArray=new ao}upload(e){this.layoutVertexBuffer=e.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes),this.indexBuffer=e.createIndexBuffer(this.indexArray),this.collisionVertexBuffer=e.createVertexBuffer(this.collisionVertexArray,mu.members,!0)}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.collisionVertexBuffer.destroy())}}pi("CollisionBuffers",dc);class yc{constructor(e){this.collisionBoxArray=e.collisionBoxArray,this.zoom=e.zoom,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((e=>e.id)),this.index=e.index,this.pixelRatio=e.pixelRatio,this.sourceLayerIndex=e.sourceLayerIndex,this.hasDependencies=!1,this.hasRTLText=!1,this.sortKeyRanges=[],this.collisionCircleArray=[];const t=this.layers[0]._unevaluatedLayout._values;this.textSizeData=ac(this.zoom,t["text-size"]),this.iconSizeData=ac(this.zoom,t["icon-size"]);const r=this.layers[0].layout,n=r.get("symbol-sort-key"),i=r.get("symbol-z-order");this.canOverlap="never"!==lc(r,"text-overlap","text-allow-overlap")||"never"!==lc(r,"icon-overlap","icon-allow-overlap")||r.get("text-ignore-placement")||r.get("icon-ignore-placement"),this.sortFeaturesByKey="viewport-y"!==i&&!n.isConstant(),this.sortFeaturesByY=("viewport-y"===i||"auto"===i&&!this.sortFeaturesByKey)&&this.canOverlap,"point"===r.get("symbol-placement")&&(this.writingModes=r.get("text-writing-mode").map((e=>Yu[e]))),this.stateDependentLayerIds=this.layers.filter((e=>e.isStateDependent())).map((e=>e.id)),this.sourceID=e.sourceID}createArrays(){this.text=new fc(new Uo(this.layers,this.zoom,(e=>/^text/.test(e)))),this.icon=new fc(new Uo(this.layers,this.zoom,(e=>/^icon/.test(e)))),this.glyphOffsetArray=new qs,this.lineVertexArray=new Gs,this.symbolInstances=new Us,this.textAnchorOffsets=new Xs}calculateGlyphDependencies(e,t,r,n,i){for(const s of e)if(t[s.codePointAt(0)]=!0,(r||n)&&i){const e=bu[s];e&&(t[e.codePointAt(0)]=!0)}}populate(e,t,r){const n=this.layers[0],i=n.layout,s=i.get("text-font"),o=i.get("text-field"),a=i.get("icon-image"),l=("constant"!==o.value.kind||o.value.value instanceof Me&&!o.value.value.isEmpty()||o.value.value.toString().length>0)&&("constant"!==s.value.kind||s.value.value.length>0),u="constant"!==a.value.kind||!!a.value.value||Object.keys(a.parameters).length>0,c=i.get("symbol-sort-key");if(this.features=[],!l&&!u)return;const h=t.iconDependencies,p=t.glyphDependencies,f=t.availableImages,d=new Gi(this.zoom);for(const{feature:t,id:o,index:a,sourceLayerIndex:y}of e){const e=n._featureFilter.needGeometry,m=Zo(t,e);if(!n._featureFilter.filter(d,m,r))continue;let g,x;if(e||(m.geometry=Yo(t)),l){const e=n.getValueAndResolveTokens("text-field",m,r,f),t=Me.factory(e),i=this.hasRTLText=this.hasRTLText||pc(t);(!i||"unavailable"===qi.getRTLTextPluginStatus()||i&&qi.isParsed())&&(g=xu(t,n,m))}if(u){const e=n.getValueAndResolveTokens("icon-image",m,r,f);x=e instanceof Ve?e:Ve.fromString(e)}if(!g&&!x)continue;const v=this.sortFeaturesByKey?c.evaluate(m,{},r):void 0;if(this.features.push({id:o,text:g,icon:x,index:a,sourceLayerIndex:y,geometry:m.geometry,properties:t.properties,type:Cl.types[t.type],sortKey:v}),x&&(h[x.name]=!0),g){const e=s.evaluate(m,{},r).join(","),t="viewport"!==i.get("text-rotation-alignment")&&"point"!==i.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf(Yu.vertical)>=0;for(const r of g.sections)if(r.image)h[r.image.name]=!0;else{const n=Fi(g.toString()),i=r.fontStack||e,s=p[i]=p[i]||{};this.calculateGlyphDependencies(r.text,s,t,this.allowVerticalPlacement,n)}}}"line"===i.get("symbol-placement")&&(this.features=function(e){const t={},r={},n=[];let i=0;function s(t){n.push(e[t]),i++}function o(e,t,i){const s=r[e];return delete r[e],r[t]=s,n[s].geometry[0].pop(),n[s].geometry[0]=n[s].geometry[0].concat(i[0]),s}function a(e,r,i){const s=t[r];return delete t[r],t[e]=s,n[s].geometry[0].shift(),n[s].geometry[0]=i[0].concat(n[s].geometry[0]),s}function l(e,t,r){const n=r?t[0][t[0].length-1]:t[0][0];return`${e}:${n.x}:${n.y}`}for(let u=0;u<e.length;u++){const c=e[u],h=c.geometry,p=c.text?c.text.toString():null;if(!p){s(u);continue}const f=l(p,h),d=l(p,h,!0);if(f in r&&d in t&&r[f]!==t[d]){const e=a(f,d,h),i=o(f,d,n[e].geometry);delete t[f],delete r[d],r[l(p,n[i].geometry,!0)]=i,n[e].geometry=null}else f in r?o(f,d,h):d in t?a(f,d,h):(s(u),t[f]=i-1,r[d]=i-1)}return n.filter((e=>e.geometry))}(this.features)),this.sortFeaturesByKey&&this.features.sort(((e,t)=>e.sortKey-t.sortKey))}update(e,t,r){this.stateDependentLayers.length&&(this.text.programConfigurations.updatePaintArrays(e,t,this.layers,{imagePositions:r}),this.icon.programConfigurations.updatePaintArrays(e,t,this.layers,{imagePositions:r}))}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText}uploadPending(){return!this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload}upload(e){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(e),this.iconCollisionBox.upload(e)),this.text.upload(e,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload),this.icon.upload(e,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload),this.uploaded=!0}destroyDebugData(){this.textCollisionBox.destroy(),this.iconCollisionBox.destroy()}destroy(){this.text.destroy(),this.icon.destroy(),this.hasDebugData()&&this.destroyDebugData()}addToLineVertexArray(e,t){const r=this.lineVertexArray.length;if(void 0!==e.segment){let r=e.dist(t[e.segment+1]),n=e.dist(t[e.segment]);const i={};for(let n=e.segment+1;n<t.length;n++)i[n]={x:t[n].x,y:t[n].y,tileUnitDistanceFromAnchor:r},n<t.length-1&&(r+=t[n+1].dist(t[n]));for(let r=e.segment||0;r>=0;r--)i[r]={x:t[r].x,y:t[r].y,tileUnitDistanceFromAnchor:n},r>0&&(n+=t[r-1].dist(t[r]));for(let e=0;e<t.length;e++){const t=i[e];this.lineVertexArray.emplaceBack(t.x,t.y,t.tileUnitDistanceFromAnchor)}}return{lineStartIndex:r,lineLength:this.lineVertexArray.length-r}}addSymbols(e,t,r,n,i,s,o,a,l,u,c,h){const p=e.indexArray,f=e.layoutVertexArray,d=e.segments.prepareSegment(4*t.length,f,p,this.canOverlap?s.sortKey:void 0),y=this.glyphOffsetArray.length,m=d.vertexLength,g=this.allowVerticalPlacement&&o===Yu.vertical?Math.PI/2:0,x=s.text&&s.text.sections;for(let n=0;n<t.length;n++){const{tl:i,tr:o,bl:l,br:u,tex:c,pixelOffsetTL:y,pixelOffsetBR:m,minFontScaleX:v,minFontScaleY:b,glyphOffset:w,isSDF:_,sectionIndex:S}=t[n],A=d.vertexLength,I=w[1];cc(f,a.x,a.y,i.x,I+i.y,c.x,c.y,r,_,y.x,y.y,v,b),cc(f,a.x,a.y,o.x,I+o.y,c.x+c.w,c.y,r,_,m.x,y.y,v,b),cc(f,a.x,a.y,l.x,I+l.y,c.x,c.y+c.h,r,_,y.x,m.y,v,b),cc(f,a.x,a.y,u.x,I+u.y,c.x+c.w,c.y+c.h,r,_,m.x,m.y,v,b),hc(e.dynamicLayoutVertexArray,a,g),p.emplaceBack(A,A+2,A+1),p.emplaceBack(A+1,A+2,A+3),d.vertexLength+=4,d.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(w[0]),n!==t.length-1&&S===t[n+1].sectionIndex||e.programConfigurations.populatePaintArrays(f.length,s,s.index,{imagePositions:{},canonical:h,formattedSection:x&&x[S]})}e.placedSymbolArray.emplaceBack(a.x,a.y,y,this.glyphOffsetArray.length-y,m,l,u,a.segment,r?r[0]:0,r?r[1]:0,n[0],n[1],o,0,!1,0,c)}_addCollisionDebugVertex(e,t,r,n,i,s){return t.emplaceBack(0,0),e.emplaceBack(r.x,r.y,n,i,Math.round(s.x),Math.round(s.y))}addCollisionDebugVertices(e,r,n,i,s,o,a){const l=s.segments.prepareSegment(4,s.layoutVertexArray,s.indexArray),u=l.vertexLength,c=s.layoutVertexArray,h=s.collisionVertexArray,p=a.anchorX,f=a.anchorY;this._addCollisionDebugVertex(c,h,o,p,f,new t(e,r)),this._addCollisionDebugVertex(c,h,o,p,f,new t(n,r)),this._addCollisionDebugVertex(c,h,o,p,f,new t(n,i)),this._addCollisionDebugVertex(c,h,o,p,f,new t(e,i)),l.vertexLength+=4;const d=s.indexArray;d.emplaceBack(u,u+1),d.emplaceBack(u+1,u+2),d.emplaceBack(u+2,u+3),d.emplaceBack(u+3,u),l.primitiveLength+=4}addDebugCollisionBoxes(e,t,r,n){for(let i=e;i<t;i++){const e=this.collisionBoxArray.get(i);this.addCollisionDebugVertices(e.x1,e.y1,e.x2,e.y2,n?this.textCollisionBox:this.iconCollisionBox,e.anchorPoint,r)}}generateCollisionDebugBuffers(){this.hasDebugData()&&this.destroyDebugData(),this.textCollisionBox=new dc(oo,gu.members,uo),this.iconCollisionBox=new dc(oo,gu.members,uo);for(let e=0;e<this.symbolInstances.length;e++){const t=this.symbolInstances.get(e);this.addDebugCollisionBoxes(t.textBoxStartIndex,t.textBoxEndIndex,t,!0),this.addDebugCollisionBoxes(t.verticalTextBoxStartIndex,t.verticalTextBoxEndIndex,t,!0),this.addDebugCollisionBoxes(t.iconBoxStartIndex,t.iconBoxEndIndex,t,!1),this.addDebugCollisionBoxes(t.verticalIconBoxStartIndex,t.verticalIconBoxEndIndex,t,!1)}}_deserializeCollisionBoxesForSymbol(e,t,r,n,i,s,o,a,l){const u={};for(let n=t;n<r;n++){const t=e.get(n);u.textBox={x1:t.x1,y1:t.y1,x2:t.x2,y2:t.y2,anchorPointX:t.anchorPointX,anchorPointY:t.anchorPointY},u.textFeatureIndex=t.featureIndex;break}for(let t=n;t<i;t++){const r=e.get(t);u.verticalTextBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.verticalTextFeatureIndex=r.featureIndex;break}for(let t=s;t<o;t++){const r=e.get(t);u.iconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.iconFeatureIndex=r.featureIndex;break}for(let t=a;t<l;t++){const r=e.get(t);u.verticalIconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.verticalIconFeatureIndex=r.featureIndex;break}return u}deserializeCollisionBoxes(e){this.collisionArrays=[];for(let t=0;t<this.symbolInstances.length;t++){const r=this.symbolInstances.get(t);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(e,r.textBoxStartIndex,r.textBoxEndIndex,r.verticalTextBoxStartIndex,r.verticalTextBoxEndIndex,r.iconBoxStartIndex,r.iconBoxEndIndex,r.verticalIconBoxStartIndex,r.verticalIconBoxEndIndex))}}hasTextData(){return this.text.segments.get().length>0}hasIconData(){return this.icon.segments.get().length>0}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0}addIndicesForPlacedSymbol(e,t){const r=e.placedSymbolArray.get(t),n=r.vertexStartIndex+4*r.numGlyphs;for(let t=r.vertexStartIndex;t<n;t+=4)e.indexArray.emplaceBack(t,t+2,t+1),e.indexArray.emplaceBack(t+1,t+2,t+3)}getSortedSymbolIndexes(e){if(this.sortedAngle===e&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const t=Math.sin(e),r=Math.cos(e),n=[],i=[],s=[];for(let e=0;e<this.symbolInstances.length;++e){s.push(e);const o=this.symbolInstances.get(e);n.push(0|Math.round(t*o.anchorX+r*o.anchorY)),i.push(o.featureIndex)}return s.sort(((e,t)=>n[e]-n[t]||i[t]-i[e])),s}addToSortKeyRanges(e,t){const r=this.sortKeyRanges[this.sortKeyRanges.length-1];r&&r.sortKey===t?r.symbolInstanceEnd=e+1:this.sortKeyRanges.push({sortKey:t,symbolInstanceStart:e,symbolInstanceEnd:e+1})}sortFeatures(e){if(this.sortFeaturesByY&&this.sortedAngle!==e&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(e),this.sortedAngle=e,this.text.indexArray.clear(),this.icon.indexArray.clear(),this.featureSortOrder=[];for(const e of this.symbolInstanceIndexes){const t=this.symbolInstances.get(e);this.featureSortOrder.push(t.featureIndex),[t.rightJustifiedTextSymbolIndex,t.centerJustifiedTextSymbolIndex,t.leftJustifiedTextSymbolIndex].forEach(((e,t,r)=>{e>=0&&r.indexOf(e)===t&&this.addIndicesForPlacedSymbol(this.text,e)})),t.verticalPlacedTextSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.text,t.verticalPlacedTextSymbolIndex),t.placedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,t.placedIconSymbolIndex),t.verticalPlacedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,t.verticalPlacedIconSymbolIndex)}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray),this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray)}}}let mc,gc;pi("SymbolBucket",yc,{omit:["layers","collisionBoxArray","features","compareText"]}),yc.MAX_GLYPHS=65535,yc.addDynamicAttributes=hc;var xc={get paint(){return gc=gc||new os({"icon-opacity":new rs(k.paint_symbol["icon-opacity"]),"icon-color":new rs(k.paint_symbol["icon-color"]),"icon-halo-color":new rs(k.paint_symbol["icon-halo-color"]),"icon-halo-width":new rs(k.paint_symbol["icon-halo-width"]),"icon-halo-blur":new rs(k.paint_symbol["icon-halo-blur"]),"icon-translate":new ts(k.paint_symbol["icon-translate"]),"icon-translate-anchor":new ts(k.paint_symbol["icon-translate-anchor"]),"text-opacity":new rs(k.paint_symbol["text-opacity"]),"text-color":new rs(k.paint_symbol["text-color"],{runtimeType:L,getOverride:e=>e.textColor,hasOverride:e=>!!e.textColor}),"text-halo-color":new rs(k.paint_symbol["text-halo-color"]),"text-halo-width":new rs(k.paint_symbol["text-halo-width"]),"text-halo-blur":new rs(k.paint_symbol["text-halo-blur"]),"text-translate":new ts(k.paint_symbol["text-translate"]),"text-translate-anchor":new ts(k.paint_symbol["text-translate-anchor"])})},get layout(){return mc=mc||new os({"symbol-placement":new ts(k.layout_symbol["symbol-placement"]),"symbol-spacing":new ts(k.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new ts(k.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new rs(k.layout_symbol["symbol-sort-key"]),"symbol-z-order":new ts(k.layout_symbol["symbol-z-order"]),"icon-allow-overlap":new ts(k.layout_symbol["icon-allow-overlap"]),"icon-overlap":new ts(k.layout_symbol["icon-overlap"]),"icon-ignore-placement":new ts(k.layout_symbol["icon-ignore-placement"]),"icon-optional":new ts(k.layout_symbol["icon-optional"]),"icon-rotation-alignment":new ts(k.layout_symbol["icon-rotation-alignment"]),"icon-size":new rs(k.layout_symbol["icon-size"]),"icon-text-fit":new ts(k.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new ts(k.layout_symbol["icon-text-fit-padding"]),"icon-image":new rs(k.layout_symbol["icon-image"]),"icon-rotate":new rs(k.layout_symbol["icon-rotate"]),"icon-padding":new rs(k.layout_symbol["icon-padding"]),"icon-keep-upright":new ts(k.layout_symbol["icon-keep-upright"]),"icon-offset":new rs(k.layout_symbol["icon-offset"]),"icon-anchor":new rs(k.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new ts(k.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new ts(k.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new ts(k.layout_symbol["text-rotation-alignment"]),"text-field":new rs(k.layout_symbol["text-field"]),"text-font":new rs(k.layout_symbol["text-font"]),"text-size":new rs(k.layout_symbol["text-size"]),"text-max-width":new rs(k.layout_symbol["text-max-width"]),"text-line-height":new ts(k.layout_symbol["text-line-height"]),"text-letter-spacing":new rs(k.layout_symbol["text-letter-spacing"]),"text-justify":new rs(k.layout_symbol["text-justify"]),"text-radial-offset":new rs(k.layout_symbol["text-radial-offset"]),"text-variable-anchor":new ts(k.layout_symbol["text-variable-anchor"]),"text-variable-anchor-offset":new rs(k.layout_symbol["text-variable-anchor-offset"]),"text-anchor":new rs(k.layout_symbol["text-anchor"]),"text-max-angle":new ts(k.layout_symbol["text-max-angle"]),"text-writing-mode":new ts(k.layout_symbol["text-writing-mode"]),"text-rotate":new rs(k.layout_symbol["text-rotate"]),"text-padding":new ts(k.layout_symbol["text-padding"]),"text-keep-upright":new ts(k.layout_symbol["text-keep-upright"]),"text-transform":new rs(k.layout_symbol["text-transform"]),"text-offset":new rs(k.layout_symbol["text-offset"]),"text-allow-overlap":new ts(k.layout_symbol["text-allow-overlap"]),"text-overlap":new ts(k.layout_symbol["text-overlap"]),"text-ignore-placement":new ts(k.layout_symbol["text-ignore-placement"]),"text-optional":new ts(k.layout_symbol["text-optional"])})}};class vc{constructor(e){if(void 0===e.property.overrides)throw new Error("overrides must be provided to instantiate FormatSectionOverride class");this.type=e.property.overrides?e.property.overrides.runtimeType:F,this.defaultValue=e}evaluate(e){if(e.formattedSection){const t=this.defaultValue.property.overrides;if(t&&t.hasOverride(e.formattedSection))return t.getOverride(e.formattedSection)}return e.feature&&e.featureState?this.defaultValue.evaluate(e.feature,e.featureState):this.defaultValue.property.specification.default}eachChild(e){this.defaultValue.isConstant()||e(this.defaultValue.value._styleExpression.expression)}outputDefined(){return!1}serialize(){return null}}pi("FormatSectionOverride",vc,{omit:["defaultValue"]});class bc extends as{constructor(e,t){super(e,xc,t)}recalculate(e,t){if(super.recalculate(e,t),"auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]="map"===this.layout.get("text-rotation-alignment")?"map":"viewport"),"auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment")),"point"===this.layout.get("symbol-placement")){const e=this.layout.get("text-writing-mode");if(e){const t=[];for(const r of e)t.indexOf(r)<0&&t.push(r);this.layout._values["text-writing-mode"]=t}else this.layout._values["text-writing-mode"]=["horizontal"]}this._setPaintOverrides()}getValueAndResolveTokens(e,t,r,n){const i=this.layout.get(e).evaluate(t,{},r,n),s=this._unevaluatedLayout._values[e];return s.isDataDriven()||Qr(s.value)||!i?i:function(e,t){return t.replace(/{([^{}]+)}/g,((t,r)=>e&&r in e?String(e[r]):""))}(t.properties,i)}createBucket(e){return new yc(e)}queryRadius(){return 0}queryIntersectsFeature(){throw new Error("Should take a different path in FeatureIndex")}_setPaintOverrides(){for(const e of xc.paint.overridableProperties){if(!bc.hasPaintOverride(this.layout,e))continue;const t=this.paint.get(e),r=new vc(t),n=new Kr(r,t.property.specification);let i=null;i="constant"===t.value.kind||"source"===t.value.kind?new tn("source",n):new rn("composite",n,t.value.zoomStops),this.paint._values[e]=new Qi(t.property,i,t.parameters)}}_handleOverridablePaintPropertyUpdate(e,t,r){return!(!this.layout||t.isDataDriven()||r.isDataDriven())&&bc.hasPaintOverride(this.layout,e)}static hasPaintOverride(e,t){const r=e.get("text-field"),n=xc.paint.properties[t];let i=!1;const s=e=>{for(const t of e)if(n.overrides&&n.overrides.hasOverride(t))return void(i=!0)};if("constant"===r.value.kind&&r.value.value instanceof Me)s(r.value.value.sections);else if("source"===r.value.kind||"composite"===r.value.kind){const e=t=>{i||(t instanceof Ue&&Ne(t.value)===U?s(t.value.sections):t instanceof Tt?s(t.sections):t.eachChild(e))},t=r.value;t._styleExpression&&e(t._styleExpression.expression)}return i}}let wc;var _c={get paint(){return wc=wc||new os({"background-color":new ts(k.paint_background["background-color"]),"background-pattern":new is(k.paint_background["background-pattern"]),"background-opacity":new ts(k.paint_background["background-opacity"])})}};class Sc extends as{constructor(e,t){super(e,_c,t)}}let Ac;var Ic,Tc,kc,Ec,Mc,Dc,Pc,zc,Fc,Bc,Cc={get paint(){return Ac=Ac||new os({"raster-opacity":new ts(k.paint_raster["raster-opacity"]),"raster-hue-rotate":new ts(k.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new ts(k.paint_raster["raster-brightness-min"]),"raster-brightness-max":new ts(k.paint_raster["raster-brightness-max"]),"raster-saturation":new ts(k.paint_raster["raster-saturation"]),"raster-contrast":new ts(k.paint_raster["raster-contrast"]),"raster-resampling":new ts(k.paint_raster["raster-resampling"]),"raster-fade-duration":new ts(k.paint_raster["raster-fade-duration"])})}};class Vc extends as{constructor(e,t){super(e,Cc,t)}}class Lc extends as{constructor(e,t){super(e,{},t),this.onAdd=e=>{this.implementation.onAdd&&this.implementation.onAdd(e,e.painter.context.gl)},this.onRemove=e=>{this.implementation.onRemove&&this.implementation.onRemove(e,e.painter.context.gl)},this.implementation=e}is3D(){return"3d"===this.implementation.renderingMode}hasOffscreenPass(){return void 0!==this.implementation.prerender}recalculate(){}updateTransitions(){}hasTransition(){return!1}serialize(){throw new Error("Custom layers cannot be serialized")}}function Oc(e,t){if("custom"===e.type)return new Lc(e,t);switch(e.type){case"background":return new Sc(e,t);case"circle":return new _a(e,t);case"color-relief":return new $a(e,t);case"fill":return new Pl(e,t);case"fill-extrusion":return new Jl(e,t);case"heatmap":return new za(e,t);case"hillshade":return new Ca(e,t);case"line":return new pu(e,t);case"raster":return new Vc(e,t);case"symbol":return new bc(e,t)}}class Rc{constructor(e){this._stringToNumber={},this._numberToString=[];for(let t=0;t<e.length;t++){const r=e[t];this._stringToNumber[r]=t,this._numberToString[t]=r}}encode(e){return this._stringToNumber[e]}decode(e){if(e>=this._numberToString.length)throw new Error(`Out of bounds. Index requested n=${e} can't be >= this._numberToString.length ${this._numberToString.length}`);return this._numberToString[e]}}class Nc{constructor(e,t,r,n,i){this.type="Feature",this._vectorTileFeature=e,this._x=r,this._y=n,this._z=t,this.properties=e.properties,this.id=i}projectPoint(e,t,r,n){return[360*(e.x+t)/n-180,360/Math.PI*Math.atan(Math.exp((1-2*(e.y+r)/n)*Math.PI))-90]}projectLine(e,t,r,n){return e.map((e=>this.projectPoint(e,t,r,n)))}get geometry(){if(this._geometry)return this._geometry;const e=this._vectorTileFeature,t=e.extent*Math.pow(2,this._z),r=e.extent*this._x,n=e.extent*this._y,i=e.loadGeometry();switch(e.type){case 1:{const e=[];for(const t of i)e.push(t[0]);const s=this.projectLine(e,r,n,t);this._geometry=1===e.length?{type:"Point",coordinates:s[0]}:{type:"MultiPoint",coordinates:s};break}case 2:{const e=i.map((e=>this.projectLine(e,r,n,t)));this._geometry=1===e.length?{type:"LineString",coordinates:e[0]}:{type:"MultiLineString",coordinates:e};break}case 3:{const e=Ll(i),s=[];for(const i of e)s.push(i.map((e=>this.projectLine(e,r,n,t))));this._geometry=1===s.length?{type:"Polygon",coordinates:s[0]}:{type:"MultiPolygon",coordinates:s};break}default:throw new Error(`unknown feature type: ${e.type}`)}return this._geometry}set geometry(e){this._geometry=e}toJSON(){const e={geometry:this.geometry};for(const t in this)"_geometry"!==t&&"_vectorTileFeature"!==t&&"_x"!==t&&"_y"!==t&&"_z"!==t&&(e[t]=this[t]);return e}}class $c{_name;dataBuffer;nullabilityBuffer;_size;constructor(e,t,r){this._name=e,this.dataBuffer=t,"number"==typeof r?this._size=r:(this.nullabilityBuffer=r,this._size=r.size())}getValue(e){return this.nullabilityBuffer&&!this.nullabilityBuffer.get(e)?null:this.getValueFromBuffer(e)}has(e){return this.nullabilityBuffer&&this.nullabilityBuffer.get(e)||!this.nullabilityBuffer}get name(){return this._name}get size(){return this._size}}class Uc extends $c{}class qc extends Uc{getValueFromBuffer(e){return this.dataBuffer[e]}}class Gc extends Uc{getValueFromBuffer(e){return this.dataBuffer[e]}}class jc extends $c{delta;constructor(e,t,r,n){super(e,t,n),this.delta=r}}class Xc extends jc{constructor(e,t,r,n){super(e,Int32Array.of(t),r,n)}getValueFromBuffer(e){return this.dataBuffer[0]+e*this.delta}}class Yc extends $c{constructor(e,t,r){super(e,Int32Array.of(t),r)}getValueFromBuffer(e){return this.dataBuffer[0]}}class Zc{_name;_geometryVector;_idVector;_propertyVectors;_extent;propertyVectorsMap;constructor(e,t,r,n,i=4096){this._name=e,this._geometryVector=t,this._idVector=r,this._propertyVectors=n,this._extent=i}get name(){return this._name}get idVector(){return this._idVector}get geometryVector(){return this._geometryVector}get propertyVectors(){return this._propertyVectors}getPropertyVector(e){return this.propertyVectorsMap||(this.propertyVectorsMap=new Map(this._propertyVectors.map((e=>[e.name,e])))),this.propertyVectorsMap.get(e)}*[Symbol.iterator](){const e=this.geometryVector[Symbol.iterator]();let t=0;for(;t<this.numFeatures;){let r;this.idVector&&(r=this.containsMaxSaveIntegerValues(this.idVector)?Number(this.idVector.getValue(t)):this.idVector.getValue(t));const n=e?.next().value,i={};for(const e of this.propertyVectors){if(!e)continue;const r=e.name,n=e.getValue(t);null!==n&&(i[r]=n)}t++,yield{id:r,geometry:n,properties:i}}}get numFeatures(){return this.geometryVector.numGeometries}get extent(){return this._extent}getFeatures(){const e=[],t=this.geometryVector.getGeometries();for(let r=0;r<this.numFeatures;r++){let n;this.idVector&&(n=this.containsMaxSaveIntegerValues(this.idVector)?Number(this.idVector.getValue(r)):this.idVector.getValue(r));const i={coordinates:t[r],type:this.geometryVector.geometryType(r)},s={};for(const e of this.propertyVectors){if(!e)continue;const t=e.name,n=e.getValue(r);null!==n&&(s[t]=n)}e.push({id:n,geometry:i,properties:s})}return e}containsMaxSaveIntegerValues(e){return e instanceof qc||e instanceof Yc&&e instanceof Xc||e instanceof Gc}}class Hc{value;constructor(e){this.value=e}get(){return this.value}set(e){this.value=e}increment(){return this.value++}add(e){this.value+=e}}function Wc(e,t,r){const n=new Int32Array(r);let i=0,s=t.get();for(let t=0;t<n.length;t++){let t=e[s++],r=127&t;t<128||(t=e[s++],r|=(127&t)<<7,t<128||(t=e[s++],r|=(127&t)<<14,t<128||(t=e[s++],r|=(127&t)<<21,t<128||(t=e[s++],r|=(15&t)<<28)))),n[i++]=r}return t.set(s),n}function Jc(e,t,r){const n=new BigInt64Array(r);for(let r=0;r<n.length;r++)n[r]=rh(e,t);return n}function Kc(e,t){let r,n;return n=e[t.get()],t.increment(),r=127&n,n<128?r:(n=e[t.get()],t.increment(),r|=(127&n)<<7,n<128?r:(n=e[t.get()],t.increment(),r|=(127&n)<<14,n<128?r:(n=e[t.get()],t.increment(),r|=(127&n)<<21,n<128?r:(n=e[t.get()],r|=(15&n)<<28,function(e,t,r){let n,i;if(i=t[r.get()],r.increment(),n=(112&i)>>4,i<128)return 4294967296*n+(e>>>0);if(i=t[r.get()],r.increment(),n|=(127&i)<<3,i<128)return 4294967296*n+(e>>>0);if(i=t[r.get()],r.increment(),n|=(127&i)<<10,i<128)return 4294967296*n+(e>>>0);if(i=t[r.get()],r.increment(),n|=(127&i)<<17,i<128)return 4294967296*n+(e>>>0);if(i=t[r.get()],r.increment(),n|=(127&i)<<24,i<128)return 4294967296*n+(e>>>0);if(i=t[r.get()],r.increment(),n|=(1&i)<<31,i<128)return 4294967296*n+(e>>>0);throw new Error("Expected varint not more than 10 bytes")}(r,e,t)))))}function Qc(e,t,r,n){throw new Error("FastPFor is not implemented yet.")}function eh(e){return e>>>1^-(1&e)}function th(e){return e>>1n^-(1n&e)}function rh(e,t){let r=0n,n=0,i=t.get();for(;i<e.length;){const t=e[i++];if(r|=BigInt(127&t)<<BigInt(n),!(128&t))break;if(n+=7,n>=64)throw new Error("Varint too long")}return t.set(i),r}function nh(e,t,r){const n=new Int32Array(r);let i=0;for(let r=0;r<t;r++){const s=e[r];n.fill(e[r+t],i,i+s),i+=s}return n}function ih(e,t,r){const n=new BigInt64Array(r);let i=0;for(let r=0;r<t;r++){const s=Number(e[r]);n.fill(e[r+t],i,i+s),i+=s}return n}function sh(e,t,r){const n=new Float64Array(r);let i=0;for(let r=0;r<t;r++){const s=e[r];n.fill(e[r+t],i,i+s),i+=s}return n}function oh(e){const t=e.length/4*4;let r=1;if(t>=4)for(let n=e[0];r<t-4;r+=4)n=e[r]+=n,n=e[r+1]+=n,n=e[r+2]+=n,n=e[r+3]+=n;for(;r!=e.length;)e[r]+=e[r-1],++r}function ah(e){e[0]=e[0]>>>1^-(1&e[0]),e[1]=e[1]>>>1^-(1&e[1]);const t=e.length/4*4;let r=2;if(t>=4)for(;r<t-4;r+=4){const t=e[r],n=e[r+1],i=e[r+2],s=e[r+3];e[r]=(t>>>1^-(1&t))+e[r-2],e[r+1]=(n>>>1^-(1&n))+e[r-1],e[r+2]=(i>>>1^-(1&i))+e[r],e[r+3]=(s>>>1^-(1&s))+e[r+1]}for(;r!=e.length;r+=2)e[r]=(e[r]>>>1^-(1&e[r]))+e[r-2],e[r+1]=(e[r+1]>>>1^-(1&e[r+1]))+e[r-1]}!function(e){e.NONE="NONE",e.DELTA="DELTA",e.COMPONENTWISE_DELTA="COMPONENTWISE_DELTA",e.RLE="RLE",e.MORTON="MORTON",e.PDE="PDE"}(Ic||(Ic={})),function(e){e.NONE="NONE",e.FAST_PFOR="FAST_PFOR",e.VARINT="VARINT",e.ALP="ALP"}(Tc||(Tc={})),function(e){e.PRESENT="PRESENT",e.DATA="DATA",e.OFFSET="OFFSET",e.LENGTH="LENGTH"}(kc||(kc={}));class lh{_dictionaryType;_offsetType;_lengthType;constructor(e,t,r){this._dictionaryType=e,this._offsetType=t,this._lengthType=r}get dictionaryType(){return this._dictionaryType}get offsetType(){return this._offsetType}get lengthType(){return this._lengthType}}function uh(e,t){const r=function(e,t){const r=e[t.get()],n=Object.values(kc)[r>>4];let i=null;switch(n){case kc.DATA:i=new lh(Object.values(Ec)[15&r]);break;case kc.OFFSET:i=new lh(null,Object.values(Mc)[15&r]);break;case kc.LENGTH:i=new lh(null,null,Object.values(Dc)[15&r])}t.increment();const s=e[t.get()],o=Object.values(Ic)[s>>5],a=Object.values(Ic)[s>>2&7],l=Object.values(Tc)[3&s];t.increment();const u=Wc(e,t,2),c=u[0];return{physicalStreamType:n,logicalStreamType:i,logicalLevelTechnique1:o,logicalLevelTechnique2:a,physicalLevelTechnique:l,numValues:c,byteLength:u[1],decompressedCount:c}}(e,t);return r.logicalLevelTechnique1===Ic.MORTON?function(e,t,r){const n=Wc(t,r,2);return{physicalStreamType:e.physicalStreamType,logicalStreamType:e.logicalStreamType,logicalLevelTechnique1:e.logicalLevelTechnique1,logicalLevelTechnique2:e.logicalLevelTechnique2,physicalLevelTechnique:e.physicalLevelTechnique,numValues:e.numValues,byteLength:e.byteLength,decompressedCount:e.decompressedCount,numBits:n[0],coordinateShift:n[1]}}(r,e,t):Ic.RLE!==r.logicalLevelTechnique1&&Ic.RLE!==r.logicalLevelTechnique2||Tc.NONE===r.physicalLevelTechnique?r:function(e,t,r){const n=Wc(t,r,2);return{physicalStreamType:e.physicalStreamType,logicalStreamType:e.logicalStreamType,logicalLevelTechnique1:e.logicalLevelTechnique1,logicalLevelTechnique2:e.logicalLevelTechnique2,physicalLevelTechnique:e.physicalLevelTechnique,numValues:e.numValues,byteLength:e.byteLength,decompressedCount:n[1],runs:n[0],numRleValues:n[1]}}(r,e,t)}!function(e){e.NONE="NONE",e.SINGLE="SINGLE",e.SHARED="SHARED",e.VERTEX="VERTEX",e.MORTON="MORTON",e.FSST="FSST"}(Ec||(Ec={})),function(e){e.VERTEX="VERTEX",e.INDEX="INDEX",e.STRING="STRING",e.KEY="KEY"}(Mc||(Mc={})),function(e){e.VAR_BINARY="VAR_BINARY",e.GEOMETRIES="GEOMETRIES",e.PARTS="PARTS",e.RINGS="RINGS",e.TRIANGLES="TRIANGLES",e.SYMBOL="SYMBOL",e.DICTIONARY="DICTIONARY"}(Dc||(Dc={})),function(e){e[e.FLAT=0]="FLAT",e[e.CONST=1]="CONST",e[e.SEQUENCE=2]="SEQUENCE",e[e.DICTIONARY=3]="DICTIONARY",e[e.FSST_DICTIONARY=4]="FSST_DICTIONARY"}(Pc||(Pc={}));class ch{values;_size;constructor(e,t){this.values=e,this._size=t}get(e){const t=Math.floor(e/8);return 1==(this.values[t]>>e%8&1)}set(e,t){const r=Math.floor(e/8);this.values[r]=this.values[r]|(t?1:0)<<e%8}getInt(e){const t=Math.floor(e/8);return this.values[t]>>e%8&1}size(){return this._size}getBuffer(){return this.values}}function hh(e,t,r,n,i){return function(e,t,r){switch(t.logicalLevelTechnique1){case Ic.DELTA:return t.logicalLevelTechnique2===Ic.RLE?function(e,t,r){const n=new Int32Array(r);let i=0,s=0;for(let r=0;r<t;r++){const o=e[r],a=eh(e[r+t]);for(let e=0;e<o;e++)s+=a,n[i++]=s}return n}(e,t.runs,t.numRleValues):(function(e){e[0]=e[0]>>>1^-(1&e[0]);const t=e.length/4*4;let r=1;if(t>=4)for(;r<t-4;r+=4){const t=e[r],n=e[r+1],i=e[r+2],s=e[r+3];e[r]=(t>>>1^-(1&t))+e[r-1],e[r+1]=(n>>>1^-(1&n))+e[r],e[r+2]=(i>>>1^-(1&i))+e[r+1],e[r+3]=(s>>>1^-(1&s))+e[r+2]}for(;r!=e.length;++r)e[r]=(e[r]>>>1^-(1&e[r]))+e[r-1]}(e),e);case Ic.RLE:return function(e,t,r){return r?function(e,t,r){const n=new Int32Array(r);let i=0;for(let r=0;r<t;r++){const s=e[r];let o=e[r+t];o=o>>>1^-(1&o),n.fill(o,i,i+s),i+=s}return n}(e,t.runs,t.numRleValues):nh(e,t.runs,t.numRleValues)}(e,t,r);case Ic.MORTON:return oh(e),e;case Ic.COMPONENTWISE_DELTA:return ah(e),e;case Ic.NONE:return r&&function(e){for(let t=0;t<e.length;t++){const r=e[t];e[t]=r>>>1^-(1&r)}}(e),e;default:throw new Error(`The specified Logical level technique is not supported: ${t.logicalLevelTechnique1}`)}}(fh(e,t,r),r,n)}function ph(e,t,r){return function(e,t){if(t.logicalLevelTechnique1===Ic.DELTA&&t.logicalLevelTechnique2===Ic.NONE){const t=function(e){const t=new Int32Array(e.length+1);t[0]=0,t[1]=eh(e[0]);let r=t[1],n=2;for(;n!=t.length;++n){const i=e[n-1];r+=i>>>1^-(1&i),t[n]=t[n-1]+r}return t}(e);return t}if(t.logicalLevelTechnique1===Ic.RLE&&t.logicalLevelTechnique2===Ic.NONE){const r=function(e,t,r){const n=new Int32Array(r+1);n[0]=0;let i=1,s=n[0];for(let r=0;r<t;r++){const o=e[r],a=e[r+t];for(let e=i;e<i+o;e++)n[e]=a+s,s=n[e];i+=o}return n}(e,t.runs,t.numRleValues);return r}if(t.logicalLevelTechnique1===Ic.NONE&&t.logicalLevelTechnique2===Ic.NONE){!function(e){let t=0;for(let r=0;r<e.length;r++)e[r]+=t,t=e[r]}(e);const r=new Int32Array(t.numValues+1);return r[0]=0,r.set(e,1),r}if(t.logicalLevelTechnique1===Ic.DELTA&&t.logicalLevelTechnique2===Ic.RLE){const r=function(e,t,r){const n=new Int32Array(r+1);n[0]=0;let i=1,s=n[0];for(let r=0;r<t;r++){const o=e[r];let a=e[r+t];a=a>>>1^-(1&a);for(let e=i;e<i+o;e++)n[e]=a+s,s=n[e];i+=o}return n}(e,t.runs,t.numRleValues);return oh(r),r}throw new Error("Only delta encoding is supported for transforming length to offset streams yet.")}(fh(e,t,r),r)}function fh(e,t,r){const n=r.physicalLevelTechnique;if(n===Tc.FAST_PFOR)return Qc();if(n===Tc.VARINT)return Wc(e,t,r.numValues);if(n===Tc.NONE){const n=t.get();t.add(r.byteLength);const i=e.subarray(n,t.get());return new Int32Array(i)}throw new Error("Specified physicalLevelTechnique is not supported (yet).")}function dh(e,t,r,n){const i=fh(e,t,r);if(1===i.length){const e=i[0];return n?eh(e):e}return n?function(e){return eh(e[1])}(i):function(e){return e[1]}(i)}function yh(e,t,r){return function(e){if(2==e.length){const t=eh(e[1]);return[t,t]}return[eh(e[2]),eh(e[3])]}(fh(e,t,r))}function mh(e,t,r){return function(e){if(2==e.length){const t=th(e[1]);return[t,t]}return[th(e[2]),th(e[3])]}(Jc(e,t,r.numValues))}function gh(e,t,r,n){return function(e,t,r){switch(t.logicalLevelTechnique1){case Ic.DELTA:return t.logicalLevelTechnique2===Ic.RLE?function(e,t,r){const n=new BigInt64Array(r);let i=0,s=0n;for(let r=0;r<t;r++){const o=Number(e[r]),a=th(e[r+t]);for(let e=0;e<o;e++)s+=a,n[i++]=s}return n}(e,t.runs,t.numRleValues):(function(e){e[0]=e[0]>>1n^-(1n&e[0]);const t=e.length/4*4;let r=1;if(t>=4)for(;r<t-4;r+=4){const t=e[r],n=e[r+1],i=e[r+2],s=e[r+3];e[r]=(t>>1n^-(1n&t))+e[r-1],e[r+1]=(n>>1n^-(1n&n))+e[r],e[r+2]=(i>>1n^-(1n&i))+e[r+1],e[r+3]=(s>>1n^-(1n&s))+e[r+2]}for(;r!=e.length;++r)e[r]=(e[r]>>1n^-(1n&e[r]))+e[r-1]}(e),e);case Ic.RLE:return function(e,t,r){return r?function(e,t,r){const n=new BigInt64Array(r);let i=0;for(let r=0;r<t;r++){const s=Number(e[r]);let o=e[r+t];o=o>>1n^-(1n&o),n.fill(o,i,i+s),i+=s}return n}(e,t.runs,t.numRleValues):ih(e,t.runs,t.numRleValues)}(e,t,r);case Ic.NONE:return r&&function(e){for(let t=0;t<e.length;t++){const r=e[t];e[t]=r>>1n^-(1n&r)}}(e),e;default:throw new Error(`The specified Logical level technique is not supported: ${t.logicalLevelTechnique1}`)}}(Jc(e,t,r.numValues),r,n)}function xh(e,t,r,n){const i=Jc(e,t,r.numValues);if(1===i.length){const e=i[0];return n?th(e):e}return n?function(e){return th(e[1])}(i):function(e){return e[1]}(i)}function vh(e,t,r,n,i){return function(e,t,r,n){switch(t.logicalLevelTechnique1){case Ic.DELTA:return t.logicalLevelTechnique2===Ic.RLE&&(e=nh(e,t.runs,t.numRleValues)),function(e,t){const r=new Int32Array(e.size());let n=0;e.get(0)?(r[0]=e.get(0)?t[0]>>>1^-(1&t[0]):0,n=1):r[0]=0;let i=1;for(;i!=r.length;++i)r[i]=e.get(i)?r[i-1]+(t[n]>>>1^-(1&t[n++])):r[i-1];return r}(n,e);case Ic.RLE:return function(e,t,r,n){const i=t;return r?function(e,t,r){const n=new Int32Array(e.size());let i=0;for(let s=0;s<r;s++){const o=t[s];let a=t[s+r];a=a>>>1^-(1&a);for(let t=i;t<i+o;t++)e.get(t)?n[t]=a:(n[t]=0,i++);i+=o}return n}(n,e,i.runs):function(e,t,r){const n=new Int32Array(e.size());let i=0;for(let s=0;s<r;s++){const o=t[s],a=t[s+r];for(let t=i;t<i+o;t++)e.get(t)?n[t]=a:(n[t]=0,i++);i+=o}return n}(n,e,i.runs)}(e,t,r,n);case Ic.MORTON:return oh(e),e;case Ic.COMPONENTWISE_DELTA:return ah(e),e;case Ic.NONE:return e=r?function(e,t){const r=new Int32Array(e.size());let n=0,i=0;for(;i!=r.length;++i)if(e.get(i)){const e=t[n++];r[i]=e>>>1^-(1&e)}else r[i]=0;return r}(n,e):function(e,t){const r=new Int32Array(e.size());let n=0,i=0;for(;i!=r.length;++i)r[i]=e.get(i)?t[n++]:0;return r}(n,e),e;default:throw new Error("The specified Logical level technique is not supported")}}(r.physicalLevelTechnique===Tc.FAST_PFOR?Qc():Wc(e,t,r.numValues),r,n,i)}function bh(e,t,r,n){const i=e.logicalLevelTechnique1;if(i===Ic.RLE)return 1===e.runs?Pc.CONST:Pc.FLAT;const s=t instanceof ch?t.size():t;if(i===Ic.DELTA&&e.logicalLevelTechnique2===Ic.RLE){const t=e.runs,i=2;if(e.numRleValues!==s)return Pc.FLAT;if(1===t)return Pc.SEQUENCE;if(2===t){const t=n.get();let s;if(e.physicalLevelTechnique===Tc.VARINT)s=Wc(r,n,4);else{const e=n.get();s=new Int32Array(r.buffer,r.byteOffset+e,4)}if(n.set(t),s[2]===i&&s[3]===i)return Pc.SEQUENCE}}return 1===e.numValues?Pc.CONST:Pc.FLAT}class wh extends Uc{getValueFromBuffer(e){return this.dataBuffer[e]}}class _h extends jc{constructor(e,t,r,n){super(e,BigInt64Array.of(t),r,n)}getValueFromBuffer(e){return this.dataBuffer[0]+BigInt(e)*this.delta}}class Sh{_geometryOffsets;_partOffsets;_ringOffsets;constructor(e,t,r){this._geometryOffsets=e,this._partOffsets=t,this._ringOffsets=r}get geometryOffsets(){return this._geometryOffsets}get partOffsets(){return this._partOffsets}get ringOffsets(){return this._ringOffsets}}function Ah(e,t,r){return{x:Ih(e,t)-r,y:Ih(e>>1,t)-r}}function Ih(e,t){let r=0;for(let n=0;n<t;n++)r|=(e&1<<2*n)>>n;return r}!function(e){e[e.POINT=0]="POINT",e[e.LINESTRING=1]="LINESTRING",e[e.POLYGON=2]="POLYGON",e[e.MULTIPOINT=3]="MULTIPOINT",e[e.MULTILINESTRING=4]="MULTILINESTRING",e[e.MULTIPOLYGON=5]="MULTIPOLYGON"}(zc||(zc={})),function(e){e[e.POINT=0]="POINT",e[e.LINESTRING=1]="LINESTRING",e[e.POLYGON=2]="POLYGON"}(Fc||(Fc={})),function(e){e[e.MORTON=0]="MORTON",e[e.VEC_2=1]="VEC_2",e[e.VEC_3=2]="VEC_3"}(Bc||(Bc={}));class Th{createPoint(e){return[[e]]}createMultiPoint(e){return e.map((e=>[e]))}createLineString(e){return[e]}createMultiLineString(e){return e}createPolygon(e,t){return[e].concat(t)}createMultiPolygon(e){return e.flat()}}function kh(e){const r=new Array(e.numGeometries);let n=1,i=1,s=1,o=0;const a=new Th;let l=0,u=0;const c=e.mortonSettings,h=e.topologyVector,p=h.geometryOffsets,f=h.partOffsets,d=h.ringOffsets,y=e.vertexOffsets,m=e.containsPolygonGeometry(),g=e.vertexBuffer;for(let h=0;h<e.numGeometries;h++){const x=e.geometryType(h);if(x===zc.POINT){if(y&&0!==y.length)if(e.vertexBufferType===Bc.VEC_2){const e=2*y[u++],n=new t(g[e],g[e+1]);r[o++]=a.createPoint(n)}else{const e=Ah(g[y[u++]],c.numBits,c.coordinateShift),n=new t(e.x,e.y);r[o++]=a.createPoint(n)}else{const e=new t(g[l++],g[l++]);r[o++]=a.createPoint(e)}p&&s++,f&&n++,d&&i++}else if(x===zc.MULTIPOINT){const e=p[s]-p[s-1];s++;const n=new Array(e);if(y&&0!==y.length){for(let r=0;r<e;r++){const e=2*y[u++];n[r]=new t(g[e],g[e+1])}r[o++]=a.createMultiPoint(n)}else{for(let r=0;r<e;r++){const e=g[l++],i=g[l++];n[r]=new t(e,i)}r[o++]=a.createMultiPoint(n)}}else if(x===zc.LINESTRING){let t,h=0;m?(h=d[i]-d[i-1],i++):h=f[n]-f[n-1],n++,y&&0!==y.length?(t=e.vertexBufferType===Bc.VEC_2?zh(g,y,u,h,!1):Fh(g,y,u,h,!1,c),u+=h):(t=Ph(g,l,h,!1),l+=2*h),r[o++]=a.createLineString(t),p&&s++}else if(x===zc.POLYGON){const t=f[n]-f[n-1];n++;const h=new Array(t-1);let m=d[i]-d[i-1];if(i++,y&&0!==y.length){const t=e.vertexBufferType===Bc.VEC_2?Mh(g,y,u,m):Dh(g,y,u,m,0,c);u+=m;for(let t=0;t<h.length;t++)m=d[i]-d[i-1],i++,h[t]=e.vertexBufferType===Bc.VEC_2?Mh(g,y,u,m):Dh(g,y,u,m,0,c),u+=m;r[o++]=a.createPolygon(t,h)}else{const e=Eh(g,l,m);l+=2*m;for(let e=0;e<h.length;e++)m=d[i]-d[i-1],i++,h[e]=Eh(g,l,m),l+=2*m;r[o++]=a.createPolygon(e,h)}p&&s++}else if(x===zc.MULTILINESTRING){const t=p[s]-p[s-1];s++;const h=new Array(t);if(y&&0!==y.length){for(let r=0;r<t;r++){let t=0;m?(t=d[i]-d[i-1],i++):t=f[n]-f[n-1],n++;const s=e.vertexBufferType===Bc.VEC_2?zh(g,y,u,t,!1):Fh(g,y,u,t,!1,c);h[r]=s,u+=t}r[o++]=a.createMultiLineString(h)}else{for(let e=0;e<t;e++){let t=0;m?(t=d[i]-d[i-1],i++):t=f[n]-f[n-1],n++,h[e]=Ph(g,l,t,!1),l+=2*t}r[o++]=a.createMultiLineString(h)}}else{if(x!==zc.MULTIPOLYGON)throw new Error("The specified geometry type is currently not supported.");{const t=p[s]-p[s-1];s++;const h=new Array(t);let m=0;if(y&&0!==y.length){for(let r=0;r<t;r++){const t=f[n]-f[n-1];n++;const s=new Array(t-1);m=d[i]-d[i-1],i++;const o=e.vertexBufferType===Bc.VEC_2?Mh(g,y,u,m):Dh(g,y,u,m,0,c);u+=m;for(let t=0;t<s.length;t++)m=d[i]-d[i-1],i++,s[t]=e.vertexBufferType===Bc.VEC_2?Mh(g,y,u,m):Dh(g,y,u,m,0,c),u+=m;h[r]=a.createPolygon(o,s)}r[o++]=a.createMultiPolygon(h)}else{for(let e=0;e<t;e++){const t=f[n]-f[n-1];n++;const r=new Array(t-1);m=d[i]-d[i-1],i++;const s=Eh(g,l,m);l+=2*m;for(let e=0;e<r.length;e++){const t=d[i]-d[i-1];i++,r[e]=Eh(g,l,t),l+=2*t}h[e]=a.createPolygon(s,r)}r[o++]=a.createMultiPolygon(h)}}}}return r}function Eh(e,t,r){return Ph(e,t,r,!0)}function Mh(e,t,r,n){return zh(e,t,r,n,!0)}function Dh(e,t,r,n,i,s){return Fh(e,t,r,n,!0,s)}function Ph(e,r,n,i){const s=new Array(i?n+1:n);for(let i=0;i<2*n;i+=2)s[i/2]=new t(e[r+i],e[r+i+1]);return i&&(s[s.length-1]=s[0]),s}function zh(e,r,n,i,s){const o=new Array(s?i+1:i);for(let s=0;s<2*i;s+=2){const i=2*r[n+s/2];o[s/2]=new t(e[i],e[i+1])}return s&&(o[o.length-1]=o[0]),o}function Fh(e,r,n,i,s,o){const a=new Array(s?i+1:i);for(let s=0;s<i;s++){const i=Ah(e[r[n+s]],o.numBits,o.coordinateShift);a[s]=new t(i.x,i.y)}return s&&(a[a.length-1]=a[0]),a}class Bh{_vertexBufferType;_topologyVector;_vertexOffsets;_vertexBuffer;_mortonSettings;constructor(e,t,r,n,i){this._vertexBufferType=e,this._topologyVector=t,this._vertexOffsets=r,this._vertexBuffer=n,this._mortonSettings=i}get vertexBufferType(){return this._vertexBufferType}get topologyVector(){return this._topologyVector}get vertexOffsets(){return this._vertexOffsets}get vertexBuffer(){return this._vertexBuffer}*[Symbol.iterator](){const e=kh(this);let t=0;for(;t<this.numGeometries;)yield{coordinates:e[t],type:this.geometryType(t)},t++}getSimpleEncodedVertex(e){const t=this.vertexOffsets?2*this.vertexOffsets[e]:2*e;return[this.vertexBuffer[t],this.vertexBuffer[t+1]]}getVertex(e){if(this.vertexOffsets&&this.mortonSettings){const t=Ah(this.vertexBuffer[this.vertexOffsets[e]],this.mortonSettings.numBits,this.mortonSettings.coordinateShift);return[t.x,t.y]}const t=this.vertexOffsets?2*this.vertexOffsets[e]:2*e;return[this.vertexBuffer[t],this.vertexBuffer[t+1]]}getGeometries(){return kh(this)}get mortonSettings(){return this._mortonSettings}}class Ch extends Bh{_numGeometries;_geometryType;constructor(e,t,r,n,i,s,o){super(r,n,i,s,o),this._numGeometries=e,this._geometryType=t}geometryType(e){return this._geometryType}get numGeometries(){return this._numGeometries}containsPolygonGeometry(){return this._geometryType===zc.POLYGON||this._geometryType===zc.MULTIPOLYGON}containsSingleGeometryType(){return!0}}class Vh extends Bh{_geometryTypes;constructor(e,t,r,n,i,s){super(e,r,n,i,s),this._geometryTypes=t}geometryType(e){return this._geometryTypes[e]}get numGeometries(){return this._geometryTypes.length}containsPolygonGeometry(){for(let e=0;e<this.numGeometries;e++)if(this.geometryType(e)===zc.POLYGON||this.geometryType(e)===zc.MULTIPOLYGON)return!0;return!1}containsSingleGeometryType(){return!1}}class Lh{_triangleOffsets;_indexBuffer;_vertexBuffer;_topologyVector;constructor(e,t,r,n){this._triangleOffsets=e,this._indexBuffer=t,this._vertexBuffer=r,this._topologyVector=n}get triangleOffsets(){return this._triangleOffsets}get indexBuffer(){return this._indexBuffer}get vertexBuffer(){return this._vertexBuffer}get topologyVector(){return this._topologyVector}getGeometries(){if(!this._topologyVector)throw new Error("Cannot convert GpuVector to coordinates without topology information");const e=new Array(this.numGeometries),r=this._topologyVector,n=r.partOffsets,i=r.ringOffsets,s=r.geometryOffsets;let o=0,a=1,l=1,u=1;for(let r=0;r<this.numGeometries;r++)switch(this.geometryType(r)){case zc.POLYGON:{const c=n[a]-n[a-1];a++;const h=[];for(let e=0;e<c;e++){const e=i[l]-i[l-1];l++;const r=[];for(let n=0;n<e;n++){const e=this._vertexBuffer[o++],n=this._vertexBuffer[o++];r.push(new t(e,n))}r.length>0&&r.push(r[0]),h.push(r)}e[r]=h,s&&u++}break;case zc.MULTIPOLYGON:{const c=s[u]-s[u-1];u++;const h=[];for(let e=0;e<c;e++){const e=n[a]-n[a-1];a++;for(let r=0;r<e;r++){const e=i[l]-i[l-1];l++;const r=[];for(let n=0;n<e;n++){const e=this._vertexBuffer[o++],n=this._vertexBuffer[o++];r.push(new t(e,n))}r.length>0&&r.push(r[0]),h.push(r)}}e[r]=h}}return e}[Symbol.iterator](){return null}}function Oh(e,t,r,n,i,s){return new Rh(e,t,r,n,i,s)}class Rh extends Lh{_numGeometries;_geometryType;constructor(e,t,r,n,i,s){super(r,n,i,s),this._numGeometries=e,this._geometryType=t}geometryType(e){return this._geometryType}get numGeometries(){return this._numGeometries}containsSingleGeometryType(){return!0}}function Nh(e,t,r,n,i){return new $h(e,t,r,n,i)}class $h extends Lh{_geometryTypes;constructor(e,t,r,n,i){super(t,r,n,i),this._geometryTypes=e}geometryType(e){return this._geometryTypes[e]}get numGeometries(){return this._geometryTypes.length}containsSingleGeometryType(){return!1}}function Uh(e,t,r,n,i){const s=uh(e,r);let o=null,a=null,l=null,u=null,c=null,h=null,p=null,f=null;if(bh(s,n,e,r)===Pc.CONST){const i=dh(e,r,s,!1);for(let n=0;n<t-1;n++){const t=uh(e,r);switch(t.physicalStreamType){case kc.LENGTH:switch(t.logicalStreamType.lengthType){case Dc.GEOMETRIES:o=ph(e,r,t);break;case Dc.PARTS:a=ph(e,r,t);break;case Dc.RINGS:l=ph(e,r,t);break;case Dc.TRIANGLES:p=ph(e,r,t)}break;case kc.OFFSET:switch(t.logicalStreamType.offsetType){case Mc.VERTEX:u=hh(e,r,t,!1);break;case Mc.INDEX:f=hh(e,r,t,!1)}break;case kc.DATA:Ec.VERTEX===t.logicalStreamType.dictionaryType?c=hh(e,r,t,!0):(h={numBits:t.numBits,coordinateShift:t.coordinateShift},c=hh(e,r,t,!1))}}return null!==f?null!=o||null!=a?Oh(n,i,p,f,c,new Sh(o,a,l)):Oh(n,i,p,f,c):null===h?function(e,t,r,n,i){return new Ch(e,t,Bc.VEC_2,r,n,i)}(n,i,new Sh(o,a,l),u,c):function(e,t,r,n,i,s){return new Ch(e,t,Bc.MORTON,r,n,i,s)}(n,i,new Sh(o,a,l),u,c,h)}const d=hh(e,r,s,!1);for(let n=0;n<t-1;n++){const t=uh(e,r);switch(t.physicalStreamType){case kc.LENGTH:switch(t.logicalStreamType.lengthType){case Dc.GEOMETRIES:o=hh(e,r,t,!1);break;case Dc.PARTS:a=hh(e,r,t,!1);break;case Dc.RINGS:l=hh(e,r,t,!1);break;case Dc.TRIANGLES:p=ph(e,r,t)}break;case kc.OFFSET:switch(t.logicalStreamType.offsetType){case Mc.VERTEX:u=hh(e,r,t,!1);break;case Mc.INDEX:f=hh(e,r,t,!1)}break;case kc.DATA:Ec.VERTEX===t.logicalStreamType.dictionaryType?c=hh(e,r,t,!0):(h={numBits:t.numBits,coordinateShift:t.coordinateShift},c=hh(e,r,t,!1))}}return null!==f&&null===a?Nh(d,p,f,c):(null!==o?(o=qh(d,o,2),null!==a&&null!==l?(a=Gh(d,o,a,!1),l=function(e,t,r,n){const i=new Int32Array(r[r.length-1]+1);let s=0;i[0]=s;let o=1,a=1,l=0;for(let u=0;u<e.length;u++){const c=e[u],h=t[u+1]-t[u];if(0!==c&&3!==c)for(let e=0;e<h;e++){const e=r[o]-r[o-1];o++;for(let t=0;t<e;t++)s=i[a++]=s+n[l++]}else for(let e=0;e<h;e++)i[a++]=++s,o++}return i}(d,o,a,l)):null!==a&&(a=function(e,t,r){const n=new Int32Array(t[t.length-1]+1);let i=0;n[0]=i;let s=1,o=0;for(let a=0;a<e.length;a++){const l=e[a],u=t[a+1]-t[a];if(4===l||1===l)for(let e=0;e<u;e++)i=n[s++]=i+r[o++];else for(let e=0;e<u;e++)n[s++]=++i}return n}(d,o,a))):null!==a&&null!==l?(a=qh(d,a,1),l=Gh(d,a,l,!0)):null!==a&&(a=qh(d,a,0)),null!==f?Nh(d,p,f,c,new Sh(o,a,l)):null===h?function(e,t,r,n){return new Vh(Bc.VEC_2,e,t,r,n)}(d,new Sh(o,a,l),u,c):function(e,t,r,n,i){return new Vh(Bc.MORTON,e,t,r,n,i)}(d,new Sh(o,a,l),u,c,h))}function qh(e,t,r){const n=new Int32Array(e.length+1);let i=0;n[0]=i;let s=0;for(let o=0;o<e.length;o++)i=n[o+1]=i+(e[o]>r?t[s++]:1);return n}function Gh(e,t,r,n){const i=new Int32Array(t[t.length-1]+1);let s=0;i[0]=s;let o=1,a=0;for(let l=0;l<e.length;l++){const u=e[l],c=t[l+1]-t[l];if(5===u||2===u||n&&(4===u||1===u))for(let e=0;e<c;e++)s=i[o++]=s+r[a++];else for(let e=0;e<c;e++)i[o++]=++s}return i}class jh extends $c{dataVector;constructor(e,t,r){super(e,t.getBuffer(),r),this.dataVector=t}getValueFromBuffer(e){return this.dataVector.get(e)}}class Xh extends Uc{getValueFromBuffer(e){return this.dataBuffer[e]}}class Yh extends $c{constructor(e,t,r){super(e,BigInt64Array.of(t),r)}getValueFromBuffer(e){return this.dataBuffer[0]}}function Zh(e,t,r){return Hh(e,Math.ceil(t/8),r)}function Hh(e,t,r){const n=new Uint8Array(t);let i=0;for(;i<t;){const t=e[r.increment()];if(t<=127){const s=t+3,o=e[r.increment()],a=i+s;n.fill(o,i,a),i=a}else{const s=256-t;for(let t=0;t<s;t++)n[i++]=e[r.increment()]}}return n}const Wh=new TextDecoder;function Jh(e,t,r){return r-t>=12?Wh.decode(e.subarray(t,r)):function(e,t,r){let n="",i=t;for(;i<r;){const t=e[i];let s,o,a,l=null,u=t>239?4:t>223?3:t>191?2:1;if(i+u>r)break;1===u?t<128&&(l=t):2===u?(s=e[i+1],128==(192&s)&&(l=(31&t)<<6|63&s,l<=127&&(l=null))):3===u?(s=e[i+1],o=e[i+2],128==(192&s)&&128==(192&o)&&(l=(15&t)<<12|(63&s)<<6|63&o,(l<=2047||l>=55296&&l<=57343)&&(l=null))):4===u&&(s=e[i+1],o=e[i+2],a=e[i+3],128==(192&s)&&128==(192&o)&&128==(192&a)&&(l=(15&t)<<18|(63&s)<<12|(63&o)<<6|63&a,(l<=65535||l>=1114112)&&(l=null))),null===l?(l=65533,u=1):l>65535&&(l-=65536,n+=String.fromCharCode(l>>>10&1023|55296),l=56320|1023&l),n+=String.fromCharCode(l),i+=u}return n}(e,t,r)}class Kh extends $c{offsetBuffer;constructor(e,t,r,n){super(e,r,n),this.offsetBuffer=t}}class Qh extends Kh{textEncoder;constructor(e,t,r,n){super(e,t,r,n??t.length-1),this.textEncoder=new TextEncoder}getValueFromBuffer(e){return Jh(this.dataBuffer,this.offsetBuffer[e],this.offsetBuffer[e+1])}}class ep extends Kh{indexBuffer;textEncoder;constructor(e,t,r,n,i){super(e,r,n,i??t.length),this.indexBuffer=t,this.indexBuffer=t,this.textEncoder=new TextEncoder}getValueFromBuffer(e){const t=this.indexBuffer[e];return Jh(this.dataBuffer,this.offsetBuffer[t],this.offsetBuffer[t+1])}}class tp extends Kh{indexBuffer;symbolOffsetBuffer;symbolTableBuffer;textEncoder;symbolLengthBuffer;lengthBuffer;decodedDictionary;constructor(e,t,r,n,i,s,o){super(e,r,n,o),this.indexBuffer=t,this.symbolOffsetBuffer=i,this.symbolTableBuffer=s,this.textEncoder=new TextEncoder}getValueFromBuffer(e){null==this.decodedDictionary&&(null==this.symbolLengthBuffer&&(this.symbolLengthBuffer=this.offsetToLengthBuffer(this.symbolOffsetBuffer),this.lengthBuffer=this.offsetToLengthBuffer(this.offsetBuffer)),this.decodedDictionary=function(e,t,r){const n=[],i=new Array(t.length).fill(0);for(let e=1;e<t.length;e++)i[e]=i[e-1]+t[e-1];for(let s=0;s<r.length;s++)if(255===r[s])n.push(r[++s]);else{const o=t[r[s]],a=i[r[s]];for(let t=0;t<o;t++)n.push(e[a+t])}return new Uint8Array(n)}(this.symbolTableBuffer,this.symbolLengthBuffer,this.dataBuffer));const t=this.indexBuffer[e];return Jh(this.decodedDictionary,this.offsetBuffer[t],this.offsetBuffer[t+1])}offsetToLengthBuffer(e){const t=new Uint32Array(e.length-1);let r=e[0];for(let n=1;n<e.length;n++){const i=e[n];t[n-1]=i-r,r=i}return t}}function rp(e,t,r,n,i,s){return"scalarType"===r.type?function(e,t,r,n,i,s){let o=null,a=0;if(0===e)return null;if(s.nullable){const e=uh(t,r);a=e.numValues;const n=r.get(),i=Zh(t,a,r);r.set(n+e.byteLength),o=new ch(i,e.numValues)}const l=o??n;switch(i.physicalType){case 4:case 3:return function(e,t,r,n,i){const s=uh(e,t),o=bh(s,i,e,t),a=3===n.physicalType;if(o===Pc.FLAT){const n=np(i)?vh(e,t,s,a,i):hh(e,t,s,a);return new qc(r.name,n,i)}if(o===Pc.SEQUENCE){const n=yh(e,t,s);return new Xc(r.name,n[0],n[1],s.numRleValues)}{const n=dh(e,t,s,a);return new Yc(r.name,n,i)}}(t,r,s,i,l);case 9:return function(e,t,r,n,i){let s=null,o=null,a=null,l=null,u=null,c=null,h=null,p=null;for(let e=0;e<n;e++){const e=uh(t,r);if(0!==e.byteLength)switch(e.physicalStreamType){case kc.PRESENT:{const n=Zh(t,e.numValues,r);c=new ch(n,e.numValues);break}case kc.OFFSET:o=null!=i||null!=c?vh(t,r,e,!1,i??c):hh(t,r,e,!1);break;case kc.LENGTH:{const n=ph(t,r,e);Dc.DICTIONARY===e.logicalStreamType.lengthType?s=n:Dc.SYMBOL===e.logicalStreamType.lengthType?l=n:h=n;break}case kc.DATA:{const n=t.subarray(r.get(),r.get()+e.byteLength);r.add(e.byteLength);const i=e.logicalStreamType.dictionaryType;Ec.FSST===i?u=n:Ec.SINGLE===i||Ec.SHARED===i?a=n:Ec.NONE===i&&(p=n);break}}}return function(e,t,r,n,i,s,o){return t?new tp(e,r,n,i,s,t,o):null}(e,u,o,s,a,l,i??c)??function(e,t,r,n,i){return t?i?new ep(e,r,n,t,i):new ep(e,r,n,t):null}(e,a,o,s,i??c)??function(e,t,r,n,i){if(!t||!r)return null;if(n)return i?new ep(e,n,t,r,i):new ep(e,n,t,r);if(i&&i.size()!==t.length-1){const n=new Int32Array(i.size());let s=0;for(let e=0;e<i.size();e++)n[e]=i.get(e)?s++:0;return new ep(e,n,t,r,i)}return i?new Qh(e,t,r,i):new Qh(e,t,r)}(e,h,p,o,i??c)}(s.name,t,r,s.nullable?e-1:e,o);case 0:return function(e,t,r,n,i){const s=uh(e,t),o=s.numValues,a=t.get(),l=np(i)?function(e,t,r,n){const i=Hh(e,Math.ceil(t/8),r),s=new ch(i,t),o=n.size(),a=new ch(new Uint8Array(o),o);let l=0;for(let e=0;e<n.size();e++){const t=!!n.get(e)&&s.get(l++);a.set(e,t)}return a.getBuffer()}(e,o,t,i):Zh(e,o,t);t.set(a+s.byteLength);const u=new ch(l,o);return new jh(r.name,u,i)}(t,r,s,0,l);case 6:case 5:return function(e,t,r,n,i){const s=uh(e,t),o=bh(s,n,e,t),a=5===i.physicalType;if(o===Pc.FLAT){const i=np(n)?function(e,t,r,n,i){return function(e,t,r,n){switch(t.logicalLevelTechnique1){case Ic.DELTA:return t.logicalLevelTechnique2===Ic.RLE&&(e=ih(e,t.runs,t.numRleValues)),function(e,t){const r=new BigInt64Array(e.size());let n=0;e.get(0)?(r[0]=e.get(0)?t[0]>>1n^-(1n&t[0]):0n,n=1):r[0]=0n;let i=1;for(;i!=r.length;++i)r[i]=e.get(i)?r[i-1]+(t[n]>>1n^-(1n&t[n++])):r[i-1];return r}(n,e);case Ic.RLE:return function(e,t,r,n){const i=t;return r?function(e,t,r){const n=new BigInt64Array(e.size());let i=0;for(let s=0;s<r;s++){const o=Number(t[s]);let a=t[s+r];a=a>>1n^-(1n&a);for(let t=i;t<i+o;t++)e.get(t)?n[t]=a:(n[t]=0n,i++);i+=o}return n}(n,e,i.runs):function(e,t,r){const n=new BigInt64Array(e.size());let i=0;for(let s=0;s<r;s++){const o=Number(t[s]),a=t[s+r];for(let t=i;t<i+o;t++)e.get(t)?n[t]=a:(n[t]=0n,i++);i+=o}return n}(n,e,i.runs)}(e,t,r,n);case Ic.NONE:return e=r?function(e,t){const r=new BigInt64Array(e.size());let n=0,i=0;for(;i!=r.length;++i)if(e.get(i)){const e=t[n++];r[i]=e>>1n^-(1n&e)}else r[i]=0n;return r}(n,e):function(e,t){const r=new BigInt64Array(e.size());let n=0,i=0;for(;i!=r.length;++i)r[i]=e.get(i)?t[n++]:0n;return r}(n,e),e;default:throw new Error("The specified Logical level technique is not supported")}}(Jc(e,t,r.numValues),r,n,i)}(e,t,s,a,n):gh(e,t,s,a);return new wh(r.name,i,n)}if(o===Pc.SEQUENCE){const n=mh(e,t,s);return new _h(r.name,n[0],n[1],s.numRleValues)}{const i=xh(e,t,s,a);return new Yh(r.name,i,n)}}(t,r,s,l,i);case 7:return function(e,t,r,n){const i=uh(e,t),s=np(n)?function(e,t,r,n){const i=t.get(),s=i+n*Float32Array.BYTES_PER_ELEMENT,o=new Uint8Array(e.subarray(i,s)).buffer,a=new Float32Array(o);t.set(s);const l=r.size(),u=new Float32Array(l);let c=0;for(let e=0;e<l;e++)u[e]=r.get(e)?a[c++]:0;return u}(e,t,n,i.numValues):function(e,t,r){const n=t.get(),i=n+r*Float32Array.BYTES_PER_ELEMENT,s=new Uint8Array(e.subarray(n,i)).buffer,o=new Float32Array(s);return t.set(i),o}(e,t,i.numValues);return new Xh(r.name,s,n)}(t,r,s,l);case 8:return function(e,t,r,n){const i=uh(e,t),s=np(n)?function(e,t,r,n){const i=t.get(),s=i+n*Float64Array.BYTES_PER_ELEMENT,o=new Uint8Array(e.subarray(i,s)).buffer,a=new Float64Array(o);t.set(s);const l=r.size(),u=new Float64Array(l);let c=0;for(let e=0;e<l;e++)u[e]=r.get(e)?a[c++]:0;return u}(e,t,n,i.numValues):function(e,t,r){const n=t.get(),i=n+r*Float64Array.BYTES_PER_ELEMENT,s=new Uint8Array(e.subarray(n,i)).buffer,o=new Float64Array(s);return t.set(i),o}(e,t,i.numValues);return new Gc(r.name,s,n)}(t,r,s,l);default:throw new Error(`The specified data type for the field is currently not supported: ${i}`)}}(n,e,t,i,r.scalarType,r):1!=n?null:function(e,t,r,n){let i=null,s=null,o=null,a=null,l=!1;for(;!l;){const r=uh(e,t);switch(r.physicalStreamType){case kc.LENGTH:Dc.DICTIONARY===r.logicalStreamType.lengthType?i=ph(e,t,r):o=ph(e,t,r);break;case kc.DATA:Ec.SINGLE===r.logicalStreamType.dictionaryType||Ec.SHARED===r.logicalStreamType.dictionaryType?(s=e.subarray(t.get(),t.get()+r.byteLength),l=!0):a=e.subarray(t.get(),t.get()+r.byteLength),t.add(r.byteLength)}}const u=r.complexType.children,c=[];let h=0;for(const l of u){const u=Wc(e,t,1)[0];if(0==u)continue;const p=`${r.name}${"default"===l.name?"":":"+l.name}`;if(2!==u||"scalarField"!==l.type||9!==l.scalarField.physicalType)throw new Error("Currently only optional string fields are implemented for a struct.");const f=uh(e,t),d=Zh(e,f.numValues,t),y=uh(e,t),m=y.decompressedCount!==n?vh(e,t,y,!1,new ch(d,f.numValues)):hh(e,t,y,!1);c[h++]=a?new tp(p,m,i,s,o,a,new ch(d,f.numValues)):new ep(p,m,i,s,new ch(d,f.numValues))}return c}(e,t,r,i)}function np(e){return e instanceof ch}function ip(e){if("id"===e.name)return!1;if("scalarType"===e.type){const t=e.scalarType;if("physicalType"===t.type)switch(t.physicalType){case 0:case 1:case 2:case 3:case 4:case 5:case 6:case 7:case 8:default:return!1;case 9:return!0}else if("logicalType"===t.type)return!1}else if("complexType"===e.type){const t=e.complexType;if("physicalType"===t.type)switch(t.physicalType){case 0:case 1:return!0;default:return!1}}return console.warn("Unexpected column type in hasStreamCount",e),!1}const sp=new TextDecoder;function op(e,t){const r=Wc(e,t,1)[0];if(0===r)return"";const n=t.get(),i=e.subarray(n,n+r);return t.add(r),sp.decode(i)}function ap(e,t){const r=Wc(e,t,1)[0]>>>0,n=!!(4&r),i=!!(2&r),s=Wc(e,t,1)[0]>>>0,o={};if(1&r&&(o.nullable=!0),i){const i={};if(n?(i.type="logicalType",i.logicalType=s):(i.type="physicalType",i.physicalType=s),8&r){const r=Wc(e,t,1)[0]>>>0;i.children=new Array(r);for(let n=0;n<r;n++)i.children[n]=ap(e,t)}o.type="complexField",o.complexField=i}else{const e={};n?(e.type="logicalType",e.logicalType=s):(e.type="physicalType",e.physicalType=s),o.type="scalarField",o.scalarField=e}return o}function lp(e,t){const r=Wc(e,t,1)[0]>>>0,n=function(e){switch(e){case 0:case 1:case 2:case 3:{const t={};t.nullable=!!(1&e),t.columnScope=0;const r={};return r.physicalType=e>1?6:4,r.type="physicalType",t.scalarType=r,t.type="scalarType",t}case 4:{const e={nullable:!1,columnScope:0},t={type:"physicalType",physicalType:0};return e.type="complexType",e.complexType=t,e}case 30:{const e={nullable:!1,columnScope:0},t={type:"physicalType",physicalType:1};return e.type="complexType",e.complexType=t,e}default:return function(e){let t=null;switch(e){case 10:case 11:t=0;break;case 12:case 13:t=1;break;case 14:case 15:t=2;break;case 16:case 17:t=3;break;case 18:case 19:t=4;break;case 20:case 21:t=5;break;case 22:case 23:t=6;break;case 24:case 25:t=7;break;case 26:case 27:t=8;break;case 28:case 29:t=9;break;default:return null}const r={};r.nullable=!!(1&e),r.columnScope=0;const n={type:"physicalType"};return n.physicalType=t,r.type="scalarType",r.scalarType=n,r}(e)}}(r);if(!n)throw new Error(`Unsupported column type code: ${r}`);if(function(e){return e>=10}(r)?n.name=op(e,t):r>=0&&r<=3?n.name="id":4===r&&(n.name="geometry"),function(e){return 30===e}(r)){const r=Wc(e,t,1)[0]>>>0,i=n.complexType;i.children=new Array(r);for(let n=0;n<r;n++)i.children[n]=ap(e,t)}return n}function up(e,t){const r={featureTables:[]},n={};n.name=op(e,t);const i=Wc(e,t,1)[0]>>>0,s=Wc(e,t,1)[0]>>>0;n.columns=new Array(s);for(let r=0;r<s;r++)n.columns[r]=lp(e,t);return r.featureTables.push(n),[r,i]}function cp(e,t,r,n,i,s,o=!1){const a=t.scalarType.physicalType,l=bh(i,s,e,r);if(4===a)switch(l){case Pc.FLAT:{const t=hh(e,r,i,!1);return new qc(n,t,s)}case Pc.SEQUENCE:{const t=yh(e,r,i);return new Xc(n,t[0],t[1],i.numRleValues)}case Pc.CONST:{const t=dh(e,r,i,!1);return new Yc(n,t,s)}}else switch(l){case Pc.FLAT:{if(o){const t=function(e,t,r,n){const i=function(e,t,r){const n=new Float64Array(t);for(let i=0;i<t;i++)n[i]=Kc(e,r);return n}(e,r.numValues,t);return function(e,t,r){switch(t.logicalLevelTechnique1){case Ic.DELTA:return t.logicalLevelTechnique2===Ic.RLE&&(e=sh(e,t.runs,t.numRleValues)),function(e){e[0]=e[0]%2==1?(e[0]+1)/-2:e[0]/2;const t=e.length/4*4;let r=1;if(t>=4)for(;r<t-4;r+=4){const t=e[r],n=e[r+1],i=e[r+2],s=e[r+3];e[r]=(t%2==1?(t+1)/-2:t/2)+e[r-1],e[r+1]=(n%2==1?(n+1)/-2:n/2)+e[r],e[r+2]=(i%2==1?(i+1)/-2:i/2)+e[r+1],e[r+3]=(s%2==1?(s+1)/-2:s/2)+e[r+2]}for(;r!=e.length;++r)e[r]=(e[r]%2==1?(e[r]+1)/-2:e[r]/2)+e[r-1]}(e),e;case Ic.RLE:return function(e,t,r){return r?function(e,t,r){const n=new Float64Array(r);let i=0;for(let r=0;r<t;r++){const s=e[r];let o=e[r+t];o=o%2==1?(o+1)/-2:o/2,n.fill(o,i,i+s),i+=s}return n}(e,t.runs,t.numRleValues):sh(e,t.runs,t.numRleValues)}(e,t,r);case Ic.NONE:return e;default:throw new Error(`The specified Logical level technique is not supported: ${t.logicalLevelTechnique1}`)}}(i,r,n)}(e,r,i,!1);return new Gc(n,t,s)}const t=gh(e,r,i,!1);return new wh(n,t,s)}case Pc.SEQUENCE:{const t=mh(e,r,i);return new _h(n,t[0],t[1],i.numRleValues)}case Pc.CONST:{const t=xh(e,r,i,!1);return new Yh(n,t,s)}}throw new Error("Vector type not supported for id column.")}class hp{constructor(e,t){var r;switch(this._featureData=e,this.properties=this._featureData.properties||{},null===(r=this._featureData.geometry)||void 0===r?void 0:r.type){case zc.POINT:case zc.MULTIPOINT:this.type=1;break;case zc.LINESTRING:case zc.MULTILINESTRING:this.type=2;break;case zc.POLYGON:case zc.MULTIPOLYGON:this.type=3;break;default:this.type=0}this.extent=t,this.id=Number(this._featureData.id)}loadGeometry(){const e=[];for(const r of this._featureData.geometry.coordinates){const n=[];for(const e of r)n.push(new t(e.x,e.y));e.push(n)}return e}}class pp{constructor(e){this.features=[],this.featureTable=e,this.name=e.name,this.extent=e.extent,this.version=2,this.features=e.getFeatures(),this.length=this.features.length}feature(e){return new hp(this.features[e],this.extent)}}class fp{constructor(e){this.layers={};const t=function(e,t,r=!0){const n=new Hc(0),i=[];for(;n.get()<e.length;){const t=Wc(e,n,1)[0]>>>0,s=n.get()+t;if(s>e.length)throw new Error(`Block overruns tile: ${s} > ${e.length}`);if(1!=Wc(e,n,1)[0]>>>0){n.set(s);continue}const o=up(e,n),a=o[1],l=o[0].featureTables[0];let u=null,c=null;const h=[];let p=0;for(const t of l.columns){const i=t.name;if("id"===i){let s=null;if(t.nullable){const t=uh(e,n),r=n.get(),i=Zh(e,t.numValues,n);n.set(r+t.byteLength),s=new ch(i,t.numValues)}const o=uh(e,n);p=o.decompressedCount,u=cp(e,t,n,i,o,s??p,r)}else if("geometry"===i){const t=Wc(e,n,1)[0];if(0===p){const t=n.get();p=uh(e,n).decompressedCount,n.set(t)}c=Uh(e,t,n,p)}else{const r=ip(t)?Wc(e,n,1)[0]:1;if(0===r&&"scalarType"===t.type)continue;const i=rp(e,n,t,r,p);if(i)if(Array.isArray(i))for(const e of i)h.push(e);else h.push(i)}}const f=new Zc(l.name,c,u,h,a);i.push(f),n.set(s)}return i}(new Uint8Array(e));this.layers=t.reduce(((e,t)=>Object.assign(Object.assign({},e),{[t.name]:new pp(t)})),{})}}class dp{constructor(){this.minX=1/0,this.maxX=-1/0,this.minY=1/0,this.maxY=-1/0}extend(e){return this.minX=Math.min(this.minX,e.x),this.minY=Math.min(this.minY,e.y),this.maxX=Math.max(this.maxX,e.x),this.maxY=Math.max(this.maxY,e.y),this}expandBy(e){return this.minX-=e,this.minY-=e,this.maxX+=e,this.maxY+=e,(this.minX>this.maxX||this.minY>this.maxY)&&(this.minX=1/0,this.maxX=-1/0,this.minY=1/0,this.maxY=-1/0),this}shrinkBy(e){return this.expandBy(-e)}map(e){const r=new dp;return r.extend(e(new t(this.minX,this.minY))),r.extend(e(new t(this.maxX,this.minY))),r.extend(e(new t(this.minX,this.maxY))),r.extend(e(new t(this.maxX,this.maxY))),r}static fromPoints(e){const t=new dp;for(const r of e)t.extend(r);return t}contains(e){return e.x>=this.minX&&e.x<=this.maxX&&e.y>=this.minY&&e.y<=this.maxY}empty(){return this.minX>this.maxX}width(){return this.maxX-this.minX}height(){return this.maxY-this.minY}covers(e){return!this.empty()&&!e.empty()&&e.minX>=this.minX&&e.maxX<=this.maxX&&e.minY>=this.minY&&e.maxY<=this.maxY}intersects(e){return!this.empty()&&!e.empty()&&e.minX<=this.maxX&&e.maxX>=this.minX&&e.minY<=this.maxY&&e.maxY>=this.minY}}class yp{constructor(e,t){this.feature=e,this.type=e.type,this.properties=e.tags?e.tags:{},this.extent=t,"id"in e&&("string"==typeof e.id?this.id=parseInt(e.id,10):"number"!=typeof e.id||isNaN(e.id)||(this.id=e.id))}loadGeometry(){const e=[],r=1===this.feature.type?[this.feature.geometry]:this.feature.geometry;for(const n of r){const r=[];for(const e of n)r.push(new t(e[0],e[1]));e.push(r)}return e}}const mp="_geojsonTileLayer";class gp{constructor(e,t){this.layers={[mp]:this},this.name=mp,this.version=t?t.version:1,this.extent=t?t.extent:4096,this.length=e.length,this.features=e}feature(e){return new yp(this.features[e],this.extent)}}function xp(e,t){t.writeVarintField(15,e.version||1),t.writeStringField(1,e.name||""),t.writeVarintField(5,e.extent||4096);const r={keys:[],values:[],keycache:{},valuecache:{}};for(let n=0;n<e.length;n++)r.feature=e.feature(n),t.writeMessage(2,vp,r);const n=r.keys;for(const e of n)t.writeStringField(3,e);const i=r.values;for(const e of i)t.writeMessage(4,Ap,e)}function vp(e,t){if(!e.feature)return;const r=e.feature;void 0!==r.id&&t.writeVarintField(1,r.id),t.writeMessage(2,bp,e),t.writeVarintField(3,r.type),t.writeMessage(4,Sp,r)}function bp(e,t){for(const r in e.feature?.properties){let n=e.feature.properties[r],i=e.keycache[r];if(null==n)continue;void 0===i&&(e.keys.push(r),i=e.keys.length-1,e.keycache[r]=i),t.writeVarint(i),"string"!=typeof n&&"boolean"!=typeof n&&"number"!=typeof n&&(n=JSON.stringify(n));const s=typeof n+":"+n;let o=e.valuecache[s];void 0===o&&(e.values.push(n),o=e.values.length-1,e.valuecache[s]=o),t.writeVarint(o)}}function wp(e,t){return(t<<3)+(7&e)}function _p(e){return e<<1^e>>31}function Sp(e,t){const r=e.loadGeometry(),n=e.type;let i=0,s=0;for(const o of r){let r=1;1===n&&(r=o.length),t.writeVarint(wp(1,r));const a=3===n?o.length-1:o.length;for(let e=0;e<a;e++){1===e&&1!==n&&t.writeVarint(wp(2,a-1));const r=o[e].x-i,l=o[e].y-s;t.writeVarint(_p(r)),t.writeVarint(_p(l)),i+=r,s+=l}3===e.type&&t.writeVarint(wp(7,1))}}function Ap(e,t){const r=typeof e;"string"===r?t.writeStringField(1,e):"boolean"===r?t.writeBooleanField(7,e):"number"===r&&(e%1!=0?t.writeDoubleField(3,e):e<0?t.writeSVarintField(6,e):t.writeVarintField(5,e))}class Ip{constructor(e,t){this.tileID=e,this.x=e.canonical.x,this.y=e.canonical.y,this.z=e.canonical.z,this.grid=new T(p,16,0),this.grid3D=new T(p,16,0),this.featureIndexArray=new Zs,this.promoteId=t}insert(e,t,r,n,i,s){const o=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(r,n,i);const a=s?this.grid3D:this.grid;for(let e=0;e<t.length;e++){const r=t[e],n=[1/0,1/0,-1/0,-1/0];for(let e=0;e<r.length;e++){const t=r[e];n[0]=Math.min(n[0],t.x),n[1]=Math.min(n[1],t.y),n[2]=Math.max(n[2],t.x),n[3]=Math.max(n[3],t.y)}n[0]<p&&n[1]<p&&n[2]>=0&&n[3]>=0&&a.insert(o,n[0],n[1],n[2],n[3])}}loadVTLayers(){return this.vtLayers||(this.vtLayers="mlt"!==this.encoding?new $l(new zu(this.rawTileData)).layers:new fp(this.rawTileData).layers,this.sourceLayerCoder=new Rc(this.vtLayers?Object.keys(this.vtLayers).sort():[mp])),this.vtLayers}query(e,r,n,i){this.loadVTLayers();const s=e.params,o=p/e.tileSize/e.scale,a=hn(s.filter,s.globalState),l=e.queryGeometry,u=e.queryPadding*o,c=dp.fromPoints(l),h=this.grid.query(c.minX-u,c.minY-u,c.maxX+u,c.maxY+u),f=dp.fromPoints(e.cameraQueryGeometry).expandBy(u),d=this.grid3D.query(f.minX,f.minY,f.maxX,f.maxY,((r,n,i,s)=>function(e,r,n,i,s){for(const t of e)if(r<=t.x&&n<=t.y&&i>=t.x&&s>=t.y)return!0;const o=[new t(r,n),new t(r,s),new t(i,s),new t(i,n)];if(e.length>2)for(const t of o)if(aa(e,t))return!0;for(let t=0;t<e.length-1;t++)if(la(e[t],e[t+1],o))return!0;return!1}(e.cameraQueryGeometry,r-u,n-u,i+u,s+u)));for(const e of d)h.push(e);h.sort(kp);const y={};let m;for(let t=0;t<h.length;t++){const u=h[t];if(u===m)continue;m=u;const c=this.featureIndexArray.get(u);let p=null;this.loadMatchingFeature(y,c.bucketIndex,c.sourceLayerIndex,c.featureIndex,a,s.layers,s.availableImages,r,n,i,((t,r,n)=>(p||(p=Yo(t)),r.queryIntersectsFeature({queryGeometry:l,feature:t,featureState:n,geometry:p,zoom:this.z,transform:e.transform,pixelsToTileUnits:o,pixelPosMatrix:e.pixelPosMatrix,unwrappedTileID:this.tileID.toUnwrapped(),getElevation:e.getElevation}))))}return y}loadMatchingFeature(e,t,r,n,i,s,o,a,l,u,c){const h=this.bucketLayerIDs[t];if(s&&!h.some((e=>s.has(e))))return;const p=this.sourceLayerCoder.decode(r),f=this.vtLayers[p].feature(n);if(i.needGeometry){const e=Zo(f,!0);if(!i.filter(new Gi(this.tileID.overscaledZ),e,this.tileID.canonical))return}else if(!i.filter(new Gi(this.tileID.overscaledZ),f))return;const y=this.getId(f,p);for(let t=0;t<h.length;t++){const r=h[t];if(s&&!s.has(r))continue;const i=a[r];if(!i)continue;let p={};y&&u&&(p=u.getState(i.sourceLayer||mp,y));const m=d({},l[r]);m.paint=Tp(m.paint,i.paint,f,p,o),m.layout=Tp(m.layout,i.layout,f,p,o);const g=!c||c(f,i,p);if(!g)continue;const x=new Nc(f,this.z,this.x,this.y,y);x.layer=m;let v=e[r];void 0===v&&(v=e[r]=[]),v.push({featureIndex:n,feature:x,intersectionZ:g})}}lookupSymbolFeatures(e,t,r,n,i,s,o,a){const l={};this.loadVTLayers();const u=hn(i.filterSpec,i.globalState);for(const i of e)this.loadMatchingFeature(l,r,n,i,u,s,o,a,t);return l}hasLayer(e){for(const t of this.bucketLayerIDs)for(const r of t)if(e===r)return!0;return!1}getId(e,t){var r;let n=e.id;return this.promoteId&&(n=e.properties["string"==typeof this.promoteId?this.promoteId:this.promoteId[t]],"boolean"==typeof n&&(n=Number(n)),void 0===n&&(null===(r=e.properties)||void 0===r?void 0:r.cluster)&&this.promoteId&&(n=Number(e.properties.cluster_id))),n}}function Tp(e,t,r,n,i){return y(e,((e,s)=>{const o=t instanceof es?t.get(s):null;return o&&o.evaluate?o.evaluate(r,n,i):o}))}function kp(e,t){return t-e}pi("FeatureIndex",Ip,{omit:["rawTileData","sourceLayerCoder"]});class Ep{constructor(e,t){this.keyCache={},e&&this.replace(e,t)}replace(e,t){this._layerConfigs={},this._layers={},this.update(e,[],t)}update(e,t,r){for(const t of e){this._layerConfigs[t.id]=t;const e=this._layers[t.id]=Oc(t,r);e._featureFilter=hn(e.filter,r),this.keyCache[t.id]&&delete this.keyCache[t.id]}for(const e of t)delete this.keyCache[e],delete this._layerConfigs[e],delete this._layers[e];this.familiesBySource={};const n=function(e,t){const r={};for(let n=0;n<e.length;n++){const i=t&&t[e[n].id]||bn(e[n]);t&&(t[e[n].id]=i);let s=r[i];s||(s=r[i]=[]),s.push(e[n])}const n=[];for(const e in r)n.push(r[e]);return n}(Object.values(this._layerConfigs),this.keyCache);for(const e of n){const t=e.map((e=>this._layers[e.id])),r=t[0];if(r.isHidden())continue;const n=r.source||"";let i=this.familiesBySource[n];i||(i=this.familiesBySource[n]={});const s=r.sourceLayer||mp;let o=i[s];o||(o=i[s]=[]),o.push(t)}}}class Mp extends t{constructor(e,t,r,n){super(e,t),this.angle=r,void 0!==n&&(this.segment=n)}clone(){return new Mp(this.x,this.y,this.angle,this.segment)}}function Dp(e,t,r,n,i){if(void 0===t.segment||0===r)return!0;let s=t,o=t.segment+1,a=0;for(;a>-r/2;){if(o--,o<0)return!1;a-=e[o].dist(s),s=e[o]}a+=e[o].dist(e[o+1]),o++;const l=[];let u=0;for(;a<r/2;){const t=e[o],r=e[o+1];if(!r)return!1;let s=e[o-1].angleTo(t)-t.angleTo(r);for(s=Math.abs((s+3*Math.PI)%(2*Math.PI)-Math.PI),l.push({distance:a,angleDelta:s}),u+=s;a-l[0].distance>n;)u-=l.shift().angleDelta;if(u>i)return!1;o++,a+=t.dist(r)}return!0}function Pp(e){let t=0;for(let r=0;r<e.length-1;r++)t+=e[r].dist(e[r+1]);return t}function zp(e,t,r){return e?.6*t*r:0}function Fp(e,t){return Math.max(e?e.right-e.left:0,t?t.right-t.left:0)}function Bp(e,t,r,n,i,s){const o=zp(r,i,s),a=Fp(r,n)*s;let l=0;const u=Pp(e)/2;for(let r=0;r<e.length-1;r++){const n=e[r],i=e[r+1],s=n.dist(i);if(l+s>u){const c=(u-l)/s,h=ft.number(n.x,i.x,c),p=ft.number(n.y,i.y,c),f=new Mp(h,p,i.angleTo(n),r);return f._round(),!o||Dp(e,f,a,o,t)?f:void 0}l+=s}}function Cp(e,t,r,n,i,s,o,a,l){const u=zp(n,s,o),c=Fp(n,i),h=c*o,p=0===e[0].x||e[0].x===l||0===e[0].y||e[0].y===l;return t-h<t/4&&(t=h+t/4),Vp(e,p?t/2*a%t:(c/2+2*s)*o*a%t,t,u,r,h,p,!1,l)}function Vp(e,t,r,n,i,s,o,a,l){const u=s/2,c=Pp(e);let h=0,p=t-r,f=[];for(let t=0;t<e.length-1;t++){const o=e[t],a=e[t+1],d=o.dist(a),y=a.angleTo(o);for(;p+r<h+d;){p+=r;const m=(p-h)/d,g=ft.number(o.x,a.x,m),x=ft.number(o.y,a.y,m);if(g>=0&&g<l&&x>=0&&x<l&&p-u>=0&&p+u<=c){const r=new Mp(g,x,y,t);r._round(),n&&!Dp(e,r,s,n,i)||f.push(r)}}h+=d}return a||f.length||o||(f=Vp(e,h/2,r,n,i,s,o,!0,l)),f}function Lp(e,t,r,n,i,s){let o=Op(e,t,r,i,0);return o=Op(o,t,n,s,1),o}function Op(e,t,r,n,i){switch(t){case 1:return function(e,t,r,n){const i=[];for(const s of e)for(const e of s){const s=0===n?e.x:e.y;s>=t&&s<=r&&i.push([e])}return i}(e,r,n,i);case 2:return Np(e,r,n,i,!1);case 3:return Np(e,r,n,i,!0)}return[]}function Rp(e,r,n,i,s){const o=0===i?$p:Up;let a=[];const l=[];for(let t=0;t<e.length-1;t++){const u=e[t],c=e[t+1],h=0===i?u.x:u.y,p=0===i?c.x:c.y;let f=!1;h<r?p>r&&a.push(o(u,c,r)):h>n?p<n&&a.push(o(u,c,n)):a.push(u),p<r&&h>=r&&(a.push(o(u,c,r)),f=!0),p>n&&h<=n&&(a.push(o(u,c,n)),f=!0),!s&&f&&(l.push(a),a=[])}const u=e.length-1,c=0===i?e[u].x:e[u].y;return c>=r&&c<=n&&a.push(e[u]),s&&a.length>0&&!a[0].equals(a[a.length-1])&&a.push(new t(a[0].x,a[0].y)),a.length>0&&l.push(a),l}function Np(e,t,r,n,i){const s=[];for(const o of e){const e=Rp(o,t,r,n,i);e.length>0&&s.push(...e)}return s}function $p(e,r,n){return new t(n,e.y+(n-e.x)/(r.x-e.x)*(r.y-e.y))}function Up(e,r,n){return new t(e.x+(n-e.y)/(r.y-e.y)*(r.x-e.x),n)}function qp(e,r,n,i){const s=[],o=e.image,a=o.pixelRatio,l=o.paddedRect.w-2,u=o.paddedRect.h-2;let c={x1:e.left,y1:e.top,x2:e.right,y2:e.bottom};const h=o.stretchX||[[0,l]],p=o.stretchY||[[0,u]],f=(e,t)=>e+t[1]-t[0],d=h.reduce(f,0),y=p.reduce(f,0),m=l-d,g=u-y;let x=0,v=d,b=0,w=y,_=0,S=m,A=0,I=g;if(o.content&&i){const t=o.content,r=t[2]-t[0],n=t[3]-t[1];(o.textFitWidth||o.textFitHeight)&&(c=nc(e)),x=Gp(h,0,t[0]),b=Gp(p,0,t[1]),v=Gp(h,t[0],t[2]),w=Gp(p,t[1],t[3]),_=t[0]-x,A=t[1]-b,S=r-v,I=n-w}const T=c.x1,k=c.y1,E=c.x2-T,M=c.y2-k,D=(e,i,s,l)=>{const u=Xp(e.stretch-x,v,E,T),c=Yp(e.fixed-_,S,e.stretch,d),h=Xp(i.stretch-b,w,M,k),p=Yp(i.fixed-A,I,i.stretch,y),f=Xp(s.stretch-x,v,E,T),m=Yp(s.fixed-_,S,s.stretch,d),g=Xp(l.stretch-b,w,M,k),D=Yp(l.fixed-A,I,l.stretch,y),P=new t(u,h),z=new t(f,h),F=new t(f,g),B=new t(u,g),C=new t(c/a,p/a),V=new t(m/a,D/a),L=r*Math.PI/180;if(L){const e=Math.sin(L),t=Math.cos(L),r=[t,-e,e,t];P._matMult(r),z._matMult(r),B._matMult(r),F._matMult(r)}const O=e.stretch+e.fixed,R=i.stretch+i.fixed;return{tl:P,tr:z,bl:B,br:F,tex:{x:o.paddedRect.x+1+O,y:o.paddedRect.y+1+R,w:s.stretch+s.fixed-O,h:l.stretch+l.fixed-R},writingMode:void 0,glyphOffset:[0,0],sectionIndex:0,pixelOffsetTL:C,pixelOffsetBR:V,minFontScaleX:S/a/E,minFontScaleY:I/a/M,isSDF:n}};if(i&&(o.stretchX||o.stretchY)){const e=jp(h,m,d),t=jp(p,g,y);for(let r=0;r<e.length-1;r++){const n=e[r],i=e[r+1];for(let e=0;e<t.length-1;e++)s.push(D(n,t[e],i,t[e+1]))}}else s.push(D({fixed:0,stretch:-1},{fixed:0,stretch:-1},{fixed:0,stretch:l+1},{fixed:0,stretch:u+1}));return s}function Gp(e,t,r){let n=0;for(const i of e)n+=Math.max(t,Math.min(r,i[1]))-Math.max(t,Math.min(r,i[0]));return n}function jp(e,t,r){const n=[{fixed:-1,stretch:0}];for(const[t,r]of e){const e=n[n.length-1];n.push({fixed:t-e.stretch,stretch:e.stretch}),n.push({fixed:t-e.stretch,stretch:e.stretch+(r-t)})}return n.push({fixed:t+1,stretch:r}),n}function Xp(e,t,r,n){return e/t*r+n}function Yp(e,t,r,n){return e-t*r/n}pi("Anchor",Mp);class Zp{constructor(e,r,n,i,s,o,a,l,u,c){var h;if(this.boxStartIndex=e.length,u){let e=o.top,t=o.bottom;const r=o.collisionPadding;r&&(e-=r[1],t+=r[3]);let n=t-e;n>0&&(n=Math.max(10,n),this.circleDiameter=n)}else{const u=(null===(h=o.image)||void 0===h?void 0:h.content)&&(o.image.textFitWidth||o.image.textFitHeight)?nc(o):{x1:o.left,y1:o.top,x2:o.right,y2:o.bottom};u.y1=u.y1*a-l[0],u.y2=u.y2*a+l[2],u.x1=u.x1*a-l[3],u.x2=u.x2*a+l[1];const p=o.collisionPadding;if(p&&(u.x1-=p[0]*a,u.y1-=p[1]*a,u.x2+=p[2]*a,u.y2+=p[3]*a),c){const e=new t(u.x1,u.y1),r=new t(u.x2,u.y1),n=new t(u.x1,u.y2),i=new t(u.x2,u.y2),s=c*Math.PI/180;e._rotate(s),r._rotate(s),n._rotate(s),i._rotate(s),u.x1=Math.min(e.x,r.x,n.x,i.x),u.x2=Math.max(e.x,r.x,n.x,i.x),u.y1=Math.min(e.y,r.y,n.y,i.y),u.y2=Math.max(e.y,r.y,n.y,i.y)}e.emplaceBack(r.x,r.y,u.x1,u.y1,u.x2,u.y2,n,i,s)}this.boxEndIndex=e.length}}class Hp{constructor(e=[],t=(e,t)=>e<t?-1:e>t?1:0){if(this.data=e,this.length=this.data.length,this.compare=t,this.length>0)for(let e=(this.length>>1)-1;e>=0;e--)this._down(e)}push(e){this.data.push(e),this._up(this.length++)}pop(){if(0===this.length)return;const e=this.data[0],t=this.data.pop();return--this.length>0&&(this.data[0]=t,this._down(0)),e}peek(){return this.data[0]}_up(e){const{data:t,compare:r}=this,n=t[e];for(;e>0;){const i=e-1>>1,s=t[i];if(r(n,s)>=0)break;t[e]=s,e=i}t[e]=n}_down(e){const{data:t,compare:r}=this,n=this.length>>1,i=t[e];for(;e<n;){let n=1+(e<<1);const s=n+1;if(s<this.length&&r(t[s],t[n])<0&&(n=s),r(t[n],i)>=0)break;t[e]=t[n],e=n}t[e]=i}}function Wp(e,r=1,n=!1){const i=dp.fromPoints(e[0]),s=Math.min(i.width(),i.height());let o=s/2;const a=new Hp([],Jp),{minX:l,minY:u,maxX:c,maxY:h}=i;if(0===s)return new t(l,u);for(let t=l;t<c;t+=s)for(let r=u;r<h;r+=s)a.push(new Kp(t+o,r+o,o,e));let p=function(e){let t=0,r=0,n=0;const i=e[0];for(let e=0,s=i.length,o=s-1;e<s;o=e++){const s=i[e],a=i[o],l=s.x*a.y-a.x*s.y;r+=(s.x+a.x)*l,n+=(s.y+a.y)*l,t+=3*l}return new Kp(r/t,n/t,0,e)}(e),f=a.length;for(;a.length;){const t=a.pop();(t.d>p.d||!p.d)&&(p=t,n&&console.log("found best %d after %d probes",Math.round(1e4*t.d)/1e4,f)),t.max-p.d<=r||(o=t.h/2,a.push(new Kp(t.p.x-o,t.p.y-o,o,e)),a.push(new Kp(t.p.x+o,t.p.y-o,o,e)),a.push(new Kp(t.p.x-o,t.p.y+o,o,e)),a.push(new Kp(t.p.x+o,t.p.y+o,o,e)),f+=4)}return n&&(console.log(`num probes: ${f}`),console.log(`best distance: ${p.d}`)),p.p}function Jp(e,t){return t.max-e.max}function Kp(e,r,n,i){this.p=new t(e,r),this.h=n,this.d=function(e,t){let r=!1,n=1/0;for(let i=0;i<t.length;i++){const s=t[i];for(let t=0,i=s.length,o=i-1;t<i;o=t++){const i=s[t],a=s[o];i.y>e.y!=a.y>e.y&&e.x<(a.x-i.x)*(e.y-i.y)/(a.y-i.y)+i.x&&(r=!r),n=Math.min(n,sa(e,i,a))}}return(r?1:-1)*Math.sqrt(n)}(this.p,i),this.max=this.d+this.h*Math.SQRT2}var Qp;!function(e){e[e.center=1]="center",e[e.left=2]="left",e[e.right=3]="right",e[e.top=4]="top",e[e.bottom=5]="bottom",e[e["top-left"]=6]="top-left",e[e["top-right"]=7]="top-right",e[e["bottom-left"]=8]="bottom-left",e[e["bottom-right"]=9]="bottom-right"}(Qp||(Qp={}));const ef=Number.POSITIVE_INFINITY;function tf(e,t){return t[1]!==ef?function(e,t,r){let n=0,i=0;switch(t=Math.abs(t),r=Math.abs(r),e){case"top-right":case"top-left":case"top":i=r-7;break;case"bottom-right":case"bottom-left":case"bottom":i=7-r}switch(e){case"top-right":case"bottom-right":case"right":n=-t;break;case"top-left":case"bottom-left":case"left":n=t}return[n,i]}(e,t[0],t[1]):function(e,t){let r=0,n=0;t<0&&(t=0);const i=t/Math.SQRT2;switch(e){case"top-right":case"top-left":n=i-7;break;case"bottom-right":case"bottom-left":n=7-i;break;case"bottom":n=7-t;break;case"top":n=t-7}switch(e){case"top-right":case"bottom-right":r=-i;break;case"top-left":case"bottom-left":r=i;break;case"left":r=t;break;case"right":r=-t}return[r,n]}(e,t[0])}function rf(e,t,r){var n;const i=e.layout,s=null===(n=i.get("text-variable-anchor-offset"))||void 0===n?void 0:n.evaluate(t,{},r);if(s){const e=s.values,t=[];for(let r=0;r<e.length;r+=2){const n=t[r]=e[r],i=e[r+1].map((e=>e*vu));n.startsWith("top")?i[1]-=7:n.startsWith("bottom")&&(i[1]+=7),t[r+1]=i}return new Ce(t)}const o=i.get("text-variable-anchor");if(o){let n;n=void 0!==e._unevaluatedLayout.getValue("text-radial-offset")?[i.get("text-radial-offset").evaluate(t,{},r)*vu,ef]:i.get("text-offset").evaluate(t,{},r).map((e=>e*vu));const s=[];for(const e of o)s.push(e,tf(e,n));return new Ce(s)}return null}function nf(e){var t;e.bucket.createArrays(),e.bucket.tilePixelRatio=p/(512*e.bucket.overscaling),e.bucket.compareText={},e.bucket.iconsNeedLinear=!1;const r=e.bucket.layers[0],n=r.layout,i=r._unevaluatedLayout._values,s={layoutIconSize:i["icon-size"].possiblyEvaluate(new Gi(e.bucket.zoom+1),e.canonical),layoutTextSize:i["text-size"].possiblyEvaluate(new Gi(e.bucket.zoom+1),e.canonical),textMaxSize:i["text-size"].possiblyEvaluate(new Gi(18))};if("composite"===e.bucket.textSizeData.kind){const{minZoom:t,maxZoom:r}=e.bucket.textSizeData;s.compositeTextSizes=[i["text-size"].possiblyEvaluate(new Gi(t),e.canonical),i["text-size"].possiblyEvaluate(new Gi(r),e.canonical)]}if("composite"===e.bucket.iconSizeData.kind){const{minZoom:t,maxZoom:r}=e.bucket.iconSizeData;s.compositeIconSizes=[i["icon-size"].possiblyEvaluate(new Gi(t),e.canonical),i["icon-size"].possiblyEvaluate(new Gi(r),e.canonical)]}const o=n.get("text-line-height")*vu,a="viewport"!==n.get("text-rotation-alignment")&&"point"!==n.get("symbol-placement"),l=n.get("text-keep-upright"),u=n.get("text-size");for(const i of e.bucket.features){const c=n.get("text-font").evaluate(i,{},e.canonical).join(","),h=u.evaluate(i,{},e.canonical),p=s.layoutTextSize.evaluate(i,{},e.canonical),f=s.layoutIconSize.evaluate(i,{},e.canonical),d={horizontal:{},vertical:void 0},y=i.text;let m,g=[0,0];if(y){const t=y.toString(),s=n.get("text-letter-spacing").evaluate(i,{},e.canonical)*vu,u=Bi(t)?s:0,f=n.get("text-anchor").evaluate(i,{},e.canonical),m=rf(r,i,e.canonical);if(!m){const t=n.get("text-radial-offset").evaluate(i,{},e.canonical);g=t?tf(f,[t*vu,ef]):n.get("text-offset").evaluate(i,{},e.canonical).map((e=>e*vu))}let x=a?"center":n.get("text-justify").evaluate(i,{},e.canonical);const v="point"===n.get("symbol-placement")?n.get("text-max-width").evaluate(i,{},e.canonical)*vu:1/0,b=()=>{e.bucket.allowVerticalPlacement&&Fi(t)&&(d.vertical=Zu(y,e.glyphMap,e.glyphPositions,e.imagePositions,c,v,o,f,"left",u,g,Yu.vertical,!0,p,h))};if(!a&&m){const t=new Set;if("auto"===x)for(let e=0;e<m.values.length;e+=2)t.add(sf(m.values[e]));else t.add(x);let r=!1;for(const n of t)if(!d.horizontal[n])if(r)d.horizontal[n]=d.horizontal[0];else{const t=Zu(y,e.glyphMap,e.glyphPositions,e.imagePositions,c,v,o,"center",n,u,g,Yu.horizontal,!1,p,h);t&&(d.horizontal[n]=t,r=1===t.positionedLines.length)}b()}else{"auto"===x&&(x=sf(f));const r=Zu(y,e.glyphMap,e.glyphPositions,e.imagePositions,c,v,o,f,x,u,g,Yu.horizontal,!1,p,h);r&&(d.horizontal[x]=r),b(),Fi(t)&&a&&l&&(d.vertical=Zu(y,e.glyphMap,e.glyphPositions,e.imagePositions,c,v,o,f,x,u,g,Yu.vertical,!1,p,h))}}let v=!1;if(i.icon&&i.icon.name){const t=e.imageMap[i.icon.name];t&&(m=rc(e.imagePositions[i.icon.name],n.get("icon-offset").evaluate(i,{},e.canonical),n.get("icon-anchor").evaluate(i,{},e.canonical)),v=!!t.sdf,void 0===e.bucket.sdfIcons?e.bucket.sdfIcons=v:e.bucket.sdfIcons!==v&&x("Style sheet warning: Cannot mix SDF and non-SDF icons in one buffer"),(t.pixelRatio!==e.bucket.pixelRatio||0!==n.get("icon-rotate").constantOr(1))&&(e.bucket.iconsNeedLinear=!0))}const b=lf(d.horizontal)||d.vertical;(t=e.bucket).iconsInText||(t.iconsInText=!!b&&b.iconsInText),(b||m)&&of(e.bucket,i,d,m,e.imageMap,s,p,f,g,v,e.canonical,e.subdivisionGranularity)}e.showCollisionBoxes&&e.bucket.generateCollisionDebugBuffers()}function sf(e){switch(e){case"right":case"top-right":case"bottom-right":return"right";case"left":case"top-left":case"bottom-left":return"left"}return"center"}function of(e,r,n,i,s,o,a,l,u,c,h,f){let d=o.textMaxSize.evaluate(r,{});void 0===d&&(d=a);const y=e.layers[0].layout,m=y.get("icon-offset").evaluate(r,{},h),g=lf(n.horizontal),v=a/24,b=e.tilePixelRatio*v,w=e.tilePixelRatio*d/24,_=e.tilePixelRatio*l,S=e.tilePixelRatio*y.get("symbol-spacing"),A=y.get("text-padding")*e.tilePixelRatio,I=function(e,t,r,n=1){const i=e.get("icon-padding").evaluate(t,{},r),s=i&&i.values;return[s[0]*n,s[1]*n,s[2]*n,s[3]*n]}(y,r,h,e.tilePixelRatio),T=y.get("text-max-angle")/180*Math.PI,k="viewport"!==y.get("text-rotation-alignment")&&"point"!==y.get("symbol-placement"),E="map"===y.get("icon-rotation-alignment")&&"point"!==y.get("symbol-placement"),M=y.get("symbol-placement"),D=S/2,P=y.get("icon-text-fit");let z;i&&"none"!==P&&(e.allowVerticalPlacement&&n.vertical&&(z=ic(i,n.vertical,P,y.get("icon-text-fit-padding"),m,v)),g&&(i=ic(i,g,P,y.get("icon-text-fit-padding"),m,v)));const F=h?f.line.getGranularityForZoomLevel(h.z):1,B=(t,l)=>{l.x<0||l.x>=p||l.y<0||l.y>=p||function(e,t,r,n,i,s,o,a,l,u,c,h,p,f,d,y,m,g,v,b,w,_,S,A,I){const T=e.addToLineVertexArray(t,r);let k,E,M,D,P=0,z=0,F=0,B=0,C=-1,V=-1;const L={};let O=Ao("");if(e.allowVerticalPlacement&&n.vertical){const e=a.layout.get("text-rotate").evaluate(w,{},A)+90;M=new Zp(l,t,u,c,h,n.vertical,p,f,d,e),o&&(D=new Zp(l,t,u,c,h,o,m,g,d,e))}if(i){const r=a.layout.get("icon-rotate").evaluate(w,{}),n="none"!==a.layout.get("icon-text-fit"),s=qp(i,r,S,n),p=o?qp(o,r,S,n):void 0;E=new Zp(l,t,u,c,h,i,m,g,!1,r),P=4*s.length;const f=e.iconSizeData;let d=null;"source"===f.kind?(d=[sc*a.layout.get("icon-size").evaluate(w,{})],d[0]>oc&&x(`${e.layerIds[0]}: Value for "icon-size" is >= 255. Reduce your "icon-size".`)):"composite"===f.kind&&(d=[sc*_.compositeIconSizes[0].evaluate(w,{},A),sc*_.compositeIconSizes[1].evaluate(w,{},A)],(d[0]>oc||d[1]>oc)&&x(`${e.layerIds[0]}: Value for "icon-size" is >= 255. Reduce your "icon-size".`)),e.addSymbols(e.icon,s,d,b,v,w,Yu.none,t,T.lineStartIndex,T.lineLength,-1,A),C=e.icon.placedSymbolArray.length-1,p&&(z=4*p.length,e.addSymbols(e.icon,p,d,b,v,w,Yu.vertical,t,T.lineStartIndex,T.lineLength,-1,A),V=e.icon.placedSymbolArray.length-1)}const R=Object.keys(n.horizontal);for(const r of R){const i=n.horizontal[r];if(!k){O=Ao(i.text);const e=a.layout.get("text-rotate").evaluate(w,{},A);k=new Zp(l,t,u,c,h,i,p,f,d,e)}const o=1===i.positionedLines.length;if(F+=af(e,t,i,s,a,d,w,y,T,n.vertical?Yu.horizontal:Yu.horizontalOnly,o?R:[r],L,C,_,A),o)break}n.vertical&&(B+=af(e,t,n.vertical,s,a,d,w,y,T,Yu.vertical,["vertical"],L,V,_,A));const N=k?k.boxStartIndex:e.collisionBoxArray.length,$=k?k.boxEndIndex:e.collisionBoxArray.length,U=M?M.boxStartIndex:e.collisionBoxArray.length,q=M?M.boxEndIndex:e.collisionBoxArray.length,G=E?E.boxStartIndex:e.collisionBoxArray.length,j=E?E.boxEndIndex:e.collisionBoxArray.length,X=D?D.boxStartIndex:e.collisionBoxArray.length,Y=D?D.boxEndIndex:e.collisionBoxArray.length;let Z=-1;const H=(e,t)=>e&&e.circleDiameter?Math.max(e.circleDiameter,t):t;Z=H(k,Z),Z=H(M,Z),Z=H(E,Z),Z=H(D,Z);const W=Z>-1?1:0;W&&(Z*=I/vu),e.glyphOffsetArray.length>=yc.MAX_GLYPHS&&x("Too many glyphs being rendered in a tile. See https://github.com/mapbox/mapbox-gl-js/issues/2907"),void 0!==w.sortKey&&e.addToSortKeyRanges(e.symbolInstances.length,w.sortKey);const J=rf(a,w,A),[K,Q]=function(e,t){const r=e.length,n=null==t?void 0:t.values;if((null==n?void 0:n.length)>0)for(let t=0;t<n.length;t+=2){const r=n[t+1];e.emplaceBack(Qp[n[t]],r[0],r[1])}return[r,e.length]}(e.textAnchorOffsets,J);e.symbolInstances.emplaceBack(t.x,t.y,L.right>=0?L.right:-1,L.center>=0?L.center:-1,L.left>=0?L.left:-1,L.vertical||-1,C,V,O,N,$,U,q,G,j,X,Y,u,F,B,P,z,W,0,p,Z,K,Q)}(e,l,t,n,i,s,z,e.layers[0],e.collisionBoxArray,r.index,r.sourceLayerIndex,e.index,b,[A,A,A,A],k,u,_,I,E,m,r,o,c,h,a)};if("line"===M)for(const s of function(e,r,n,i,s){const o=[];for(let r=0;r<e.length;r++){const n=e[r];let a;for(let e=0;e<n.length-1;e++){let r=n[e],l=n[e+1];r.x<0&&l.x<0||(r.x<0?r=new t(0,r.y+(0-r.x)/(l.x-r.x)*(l.y-r.y))._round():l.x<0&&(l=new t(0,r.y+(0-r.x)/(l.x-r.x)*(l.y-r.y))._round()),r.y<0&&l.y<0||(r.y<0?r=new t(r.x+(0-r.y)/(l.y-r.y)*(l.x-r.x),0)._round():l.y<0&&(l=new t(r.x+(0-r.y)/(l.y-r.y)*(l.x-r.x),0)._round()),r.x>=i&&l.x>=i||(r.x>=i?r=new t(i,r.y+(i-r.x)/(l.x-r.x)*(l.y-r.y))._round():l.x>=i&&(l=new t(i,r.y+(i-r.x)/(l.x-r.x)*(l.y-r.y))._round()),r.y>=s&&l.y>=s||(r.y>=s?r=new t(r.x+(s-r.y)/(l.y-r.y)*(l.x-r.x),s)._round():l.y>=s&&(l=new t(r.x+(s-r.y)/(l.y-r.y)*(l.x-r.x),s)._round()),a&&r.equals(a[a.length-1])||(a=[r],o.push(a)),a.push(l)))))}}return o}(r.geometry,0,0,p,p)){const t=Sl(s,F),r=Cp(t,S,T,n.vertical||g,i,24,w,e.overscaling,p);for(const n of r)g&&uf(e,g.text,D,n)||B(t,n)}else if("line-center"===M){for(const e of r.geometry)if(e.length>1){const t=Sl(e,F),r=Bp(t,T,n.vertical||g,i,24,w);r&&B(t,r)}}else if("Polygon"===r.type)for(const e of Kt(r.geometry,0)){const t=Wp(e,16);B(Sl(e[0],F,!0),new Mp(t.x,t.y,0))}else if("LineString"===r.type)for(const e of r.geometry){const t=Sl(e,F);B(t,new Mp(t[0].x,t[0].y,0))}else if("Point"===r.type)for(const e of r.geometry)for(const t of e)B([t],new Mp(t.x,t.y,0))}function af(e,r,n,i,s,o,a,l,u,c,h,p,f,d,y){const m=function(e,r,n,i,s,o,a,l){const u=i.layout.get("text-rotate").evaluate(o,{})*Math.PI/180,c=[];for(const e of r.positionedLines)for(const i of e.positionedGlyphs){if(!i.rect)continue;const o=i.rect||{};let h=4,p=!0,f=1,d=0;const y=(s||l)&&i.vertical,m=i.metrics.advance*i.scale/2;if(l&&r.verticalizable&&(d=e.lineOffset/2-(i.imageName?-(vu-i.metrics.width*i.scale)/2:(i.scale-1)*vu)),i.imageName){const e=a[i.imageName];p=e.sdf,f=e.pixelRatio,h=1/f}const g=s?[i.x+m,i.y]:[0,0];let x=s?[0,0]:[i.x+m+n[0],i.y+n[1]-d],v=[0,0];y&&(v=x,x=[0,0]);const b=i.metrics.isDoubleResolution?2:1,w=(i.metrics.left-h)*i.scale-m+x[0],_=(-i.metrics.top-h)*i.scale+x[1],S=w+o.w/b*i.scale/f,A=_+o.h/b*i.scale/f,I=new t(w,_),T=new t(S,_),k=new t(w,A),E=new t(S,A);if(y){const e=new t(-m,m- -17),r=-Math.PI/2,n=12-m,s=new t(22-n,-(i.imageName?n:0)),o=new t(...v);I._rotateAround(r,e)._add(s)._add(o),T._rotateAround(r,e)._add(s)._add(o),k._rotateAround(r,e)._add(s)._add(o),E._rotateAround(r,e)._add(s)._add(o)}if(u){const e=Math.sin(u),t=Math.cos(u),r=[t,-e,e,t];I._matMult(r),T._matMult(r),k._matMult(r),E._matMult(r)}const M=new t(0,0),D=new t(0,0);c.push({tl:I,tr:T,bl:k,br:E,tex:o,writingMode:r.writingMode,glyphOffset:g,sectionIndex:i.sectionIndex,isSDF:p,pixelOffsetTL:M,pixelOffsetBR:D,minFontScaleX:0,minFontScaleY:0})}return c}(0,n,l,s,o,a,i,e.allowVerticalPlacement),g=e.textSizeData;let v=null;"source"===g.kind?(v=[sc*s.layout.get("text-size").evaluate(a,{})],v[0]>oc&&x(`${e.layerIds[0]}: Value for "text-size" is >= 255. Reduce your "text-size".`)):"composite"===g.kind&&(v=[sc*d.compositeTextSizes[0].evaluate(a,{},y),sc*d.compositeTextSizes[1].evaluate(a,{},y)],(v[0]>oc||v[1]>oc)&&x(`${e.layerIds[0]}: Value for "text-size" is >= 255. Reduce your "text-size".`)),e.addSymbols(e.text,m,v,l,o,a,c,r,u.lineStartIndex,u.lineLength,f,y);for(const t of h)p[t]=e.text.placedSymbolArray.length-1;return 4*m.length}function lf(e){for(const t in e)return e[t];return null}function uf(e,t,r,n){const i=e.compareText;if(t in i){const e=i[t];for(let t=e.length-1;t>=0;t--)if(n.dist(e[t])<r)return!0}else i[t]=[];return i[t].push(n),!1}class cf{constructor(e){const t={},r=[];for(const n in e){const i=e[n],s=t[n]={};for(const e in i){const t=i[+e];if(!t||0===t.bitmap.width||0===t.bitmap.height)continue;const n={x:0,y:0,w:t.bitmap.width+2,h:t.bitmap.height+2};r.push(n),s[e]={rect:n,metrics:t.metrics}}}const{w:n,h:i}=Gu(r),s=new Ma({width:n||1,height:i||1});for(const r in e){const n=e[r];for(const e in n){const i=n[+e];if(!i||0===i.bitmap.width||0===i.bitmap.height)continue;const o=t[r][e].rect;Ma.copy(i.bitmap,s,{x:0,y:0},{x:o.x+1,y:o.y+1},i.bitmap)}}this.image=s,this.positions=t}}function hf(e,t,r){var n=2*Math.PI*6378137/256/Math.pow(2,r);return[e*n-2*Math.PI*6378137/2,t*n-2*Math.PI*6378137/2]}pi("GlyphAtlas",cf);const pf=6371008.8;class ff{constructor(e,t){if(isNaN(e)||isNaN(t))throw new Error(`Invalid LngLat object: (${e}, ${t})`);if(this.lng=+e,this.lat=+t,this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90")}wrap(){return new ff(function(e,t){const r=((e-t)%360+360)%360+t;return r===t?180:r}(this.lng,-180),this.lat)}toArray(){return[this.lng,this.lat]}toString(){return`LngLat(${this.lng}, ${this.lat})`}distanceTo(e){const t=Math.PI/180,r=this.lat*t,n=e.lat*t,i=Math.sin(r)*Math.sin(n)+Math.cos(r)*Math.cos(n)*Math.cos((e.lng-this.lng)*t);return pf*Math.acos(Math.min(i,1))}static convert(e){if(e instanceof ff)return e;if(Array.isArray(e)&&(2===e.length||3===e.length))return new ff(Number(e[0]),Number(e[1]));if(!Array.isArray(e)&&"object"==typeof e&&null!==e)return new ff(Number("lng"in e?e.lng:e.lon),Number(e.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]")}}const df=2*Math.PI*pf;function yf(e){return df*Math.cos(e*Math.PI/180)}function mf(e){return 360/Math.PI*Math.atan(Math.exp((180-360*e)*Math.PI/180))-90}class gf{constructor(e,t,r=0){this.x=+e,this.y=+t,this.z=+r}static fromLngLat(e,t=0){const r=ff.convert(e);return new gf((180+r.lng)/360,(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+r.lat*Math.PI/360)))/360,function(e,t){return e/yf(t)}(t,r.lat))}toLngLat(){return new ff(360*this.x-180,mf(this.y))}toAltitude(){return this.z*yf(mf(this.y))}meterInMercatorCoordinateUnits(){return 1/df*(e=mf(this.y),1/Math.cos(e*Math.PI/180));var e}}class xf{constructor(e,t,r){if(!function(e,t,r){return!(e<0||e>25||r<0||r>=Math.pow(2,e)||t<0||t>=Math.pow(2,e))}(e,t,r))throw new Error(`x=${t}, y=${r}, z=${e} outside of bounds. 0<=x<${Math.pow(2,e)}, 0<=y<${Math.pow(2,e)} 0<=z<=25 `);this.z=e,this.x=t,this.y=r,this.key=wf(0,e,e,t,r)}equals(e){return this.z===e.z&&this.x===e.x&&this.y===e.y}url(e,t,r){const n=(s=this.y,o=this.z,a=hf(256*(i=this.x),256*(s=Math.pow(2,o)-s-1),o),l=hf(256*(i+1),256*(s+1),o),a[0]+","+a[1]+","+l[0]+","+l[1]);var i,s,o,a,l;const u=function(e,t,r){let n,i="";for(let s=e;s>0;s--)n=1<<s-1,i+=(t&n?1:0)+(r&n?2:0);return i}(this.z,this.x,this.y);return e[(this.x+this.y)%e.length].replace(/{prefix}/g,(this.x%16).toString(16)+(this.y%16).toString(16)).replace(/{z}/g,String(this.z)).replace(/{x}/g,String(this.x)).replace(/{y}/g,String("tms"===r?Math.pow(2,this.z)-this.y-1:this.y)).replace(/{ratio}/g,t>1?"@2x":"").replace(/{quadkey}/g,u).replace(/{bbox-epsg-3857}/g,n)}isChildOf(e){const t=this.z-e.z;return t>0&&e.x===this.x>>t&&e.y===this.y>>t}getTilePoint(e){const r=Math.pow(2,this.z);return new t((e.x*r-this.x)*p,(e.y*r-this.y)*p)}toString(){return`${this.z}/${this.x}/${this.y}`}}class vf{constructor(e,t){this.wrap=e,this.canonical=t,this.key=wf(e,t.z,t.z,t.x,t.y)}}class bf{constructor(e,t,r,n,i){if(this.terrainRttPosMatrix32f=null,e<r)throw new Error(`overscaledZ should be >= z; overscaledZ = ${e}; z = ${r}`);this.overscaledZ=e,this.wrap=t,this.canonical=new xf(r,+n,+i),this.key=wf(t,e,r,n,i)}clone(){return new bf(this.overscaledZ,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)}equals(e){return this.overscaledZ===e.overscaledZ&&this.wrap===e.wrap&&this.canonical.equals(e.canonical)}scaledTo(e){if(e>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${e}; overscaledZ = ${this.overscaledZ}`);const t=this.canonical.z-e;return e>this.canonical.z?new bf(e,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new bf(e,this.wrap,e,this.canonical.x>>t,this.canonical.y>>t)}isOverscaled(){return this.overscaledZ>this.canonical.z}calculateScaledKey(e,t){if(e>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${e}; overscaledZ = ${this.overscaledZ}`);const r=this.canonical.z-e;return e>this.canonical.z?wf(this.wrap*+t,e,this.canonical.z,this.canonical.x,this.canonical.y):wf(this.wrap*+t,e,e,this.canonical.x>>r,this.canonical.y>>r)}isChildOf(e){if(e.wrap!==this.wrap)return!1;if(this.overscaledZ-e.overscaledZ<=0)return!1;if(0===e.overscaledZ)return this.overscaledZ>0;const t=this.canonical.z-e.canonical.z;return!(t<0)&&e.canonical.x===this.canonical.x>>t&&e.canonical.y===this.canonical.y>>t}children(e){if(this.overscaledZ>=e)return[new bf(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const t=this.canonical.z+1,r=2*this.canonical.x,n=2*this.canonical.y;return[new bf(t,this.wrap,t,r,n),new bf(t,this.wrap,t,r+1,n),new bf(t,this.wrap,t,r,n+1),new bf(t,this.wrap,t,r+1,n+1)]}isLessThan(e){return this.wrap<e.wrap||!(this.wrap>e.wrap)&&(this.overscaledZ<e.overscaledZ||!(this.overscaledZ>e.overscaledZ)&&(this.canonical.x<e.canonical.x||!(this.canonical.x>e.canonical.x)&&this.canonical.y<e.canonical.y))}wrapped(){return new bf(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y)}unwrapTo(e){return new bf(this.overscaledZ,e,this.canonical.z,this.canonical.x,this.canonical.y)}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z)}toUnwrapped(){return new vf(this.wrap,this.canonical)}toString(){return`${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`}getTilePoint(e){return this.canonical.getTilePoint(new gf(e.x-this.wrap,e.y))}}function wf(e,t,r,n,i){(e*=2)<0&&(e=-1*e-1);const s=1<<r;return(s*s*e+s*i+n).toString(36)+r.toString(36)+t.toString(36)}pi("CanonicalTileID",xf),pi("OverscaledTileID",bf,{omit:["terrainRttPosMatrix32f"]});class _f{constructor(e){this.tileID=new bf(e.tileID.overscaledZ,e.tileID.wrap,e.tileID.canonical.z,e.tileID.canonical.x,e.tileID.canonical.y),this.uid=e.uid,this.zoom=e.zoom,this.pixelRatio=e.pixelRatio,this.tileSize=e.tileSize,this.source=e.source,this.overscaling=this.tileID.overscaleFactor(),this.showCollisionBoxes=e.showCollisionBoxes,this.collectResourceTiming=!!e.collectResourceTiming,this.returnDependencies=!!e.returnDependencies,this.promoteId=e.promoteId,this.inFlightDependencies=[]}parse(t,r,n,i,s){return e(this,void 0,void 0,(function*(){this.status="parsing",this.data=t,this.collisionBoxArray=new Os;const e=new Rc(Object.keys(t.layers).sort()),o=new Ip(this.tileID,this.promoteId);o.bucketLayerIDs=[];const a={},l={featureIndex:o,iconDependencies:{},patternDependencies:{},glyphDependencies:{},dashDependencies:{},availableImages:n,subdivisionGranularity:s},u=r.familiesBySource[this.source];for(const r in u){const i=t.layers[r];if(!i)continue;1===i.version&&x(`Vector tile source "${this.source}" layer "${r}" does not use vector tile spec v2 and therefore may have some rendering errors.`);const s=e.encode(r),c=[];for(let e=0;e<i.length;e++){const t=i.feature(e),n=o.getId(t,r);c.push({feature:t,id:n,index:e,sourceLayerIndex:s})}for(const e of u[r]){const t=e[0];t.source!==this.source&&x(`layer.source = ${t.source} does not equal this.source = ${this.source}`),t.isHidden(this.zoom,!0)||(Sf(e,this.zoom,n),(a[t.id]=t.createBucket({index:o.bucketLayerIDs.length,layers:e,zoom:this.zoom,pixelRatio:this.pixelRatio,overscaling:this.overscaling,collisionBoxArray:this.collisionBoxArray,sourceLayerIndex:s,sourceID:this.source})).populate(c,l,this.tileID.canonical),o.bucketLayerIDs.push(e.map((e=>e.id))))}}const c=y(l.glyphDependencies,(e=>Object.keys(e).map(Number)));this.inFlightDependencies.forEach((e=>null==e?void 0:e.abort())),this.inFlightDependencies=[];let h=Promise.resolve({});if(Object.keys(c).length){const e=new AbortController;this.inFlightDependencies.push(e),h=i.sendAsync({type:"GG",data:{stacks:c,source:this.source,tileID:this.tileID,type:"glyphs"}},e)}const p=Object.keys(l.iconDependencies);let f=Promise.resolve({});if(p.length){const e=new AbortController;this.inFlightDependencies.push(e),f=i.sendAsync({type:"GI",data:{icons:p,source:this.source,tileID:this.tileID,type:"icons"}},e)}const d=Object.keys(l.patternDependencies);let m=Promise.resolve({});if(d.length){const e=new AbortController;this.inFlightDependencies.push(e),m=i.sendAsync({type:"GI",data:{icons:d,source:this.source,tileID:this.tileID,type:"patterns"}},e)}const g=l.dashDependencies;let v=Promise.resolve({});if(Object.keys(g).length){const e=new AbortController;this.inFlightDependencies.push(e),v=i.sendAsync({type:"GDA",data:{dashes:g}},e)}const[b,w,_,S]=yield Promise.all([h,f,m,v]),A=new cf(b),I=new Xu(w,_);for(const e in a){const t=a[e];t instanceof yc?(Sf(t.layers,this.zoom,n),nf({bucket:t,glyphMap:b,glyphPositions:A.positions,imageMap:w,imagePositions:I.iconPositions,showCollisionBoxes:this.showCollisionBoxes,canonical:this.tileID.canonical,subdivisionGranularity:l.subdivisionGranularity})):t.hasDependencies&&(t instanceof kl||t instanceof jl||t instanceof ou)&&(Sf(t.layers,this.zoom,n),t.addFeatures(l,this.tileID.canonical,I.patternPositions,S))}return this.status="done",{buckets:Object.values(a).filter((e=>!e.isEmpty())),featureIndex:o,collisionBoxArray:this.collisionBoxArray,glyphAtlasImage:A.image,imageAtlas:I,dashPositions:S,glyphMap:this.returnDependencies?b:null,iconMap:this.returnDependencies?w:null,glyphPositions:this.returnDependencies?A.positions:null}}))}}function Sf(e,t,r){const n=new Gi(t);for(const t of e)t.recalculate(n,r)}class Af{constructor(e){this.maxEntries=e,this.map=new Map}get(e){const t=this.map.get(e);return void 0!==t&&(this.map.delete(e),this.map.set(e,t)),t}set(e,t){if(this.map.has(e))this.map.delete(e);else if(this.map.size>=this.maxEntries){const e=this.map.keys().next().value;this.map.delete(e)}this.map.set(e,t)}clear(){this.map.clear()}}var If,Tf,kf;!function(e){e.create="create",e.load="load",e.fullLoad="fullLoad"}(If||(If={}));class Ef{constructor(e){this._marks={start:[e.url,"start"].join("#"),end:[e.url,"end"].join("#"),measure:e.url.toString()},performance.mark(this._marks.start)}finish(){performance.mark(this._marks.end);let e=performance.getEntriesByName(this._marks.measure);return 0===e.length&&(performance.measure(this._marks.measure,this._marks.start,this._marks.end),e=performance.getEntriesByName(this._marks.measure),performance.clearMarks(this._marks.start),performance.clearMarks(this._marks.end),performance.clearMeasures(this._marks.measure)),e}}class Mf{constructor(e,t,r,n,i){this.type=e,this.properties=r||{},this.extent=i,this.pointsArray=t,this.id=n}loadGeometry(){return this.pointsArray.map((e=>e.map((e=>new t(e.x,e.y)))))}}class Df{constructor(e,t,r){this.version=2,this._myFeatures=e,this.name=t,this.length=e.length,this.extent=r}feature(e){return this._myFeatures[e]}}class Pf{constructor(){this.layers={}}addLayer(e){this.layers[e.name]=e}}function zf(e){let t=function(e){const t=new zu;return function(e,t){for(const r in e.layers)t.writeMessage(3,xp,e.layers[r])}(e,t),t.finish()}(e);return 0===t.byteOffset&&t.byteLength===t.buffer.byteLength||(t=new Uint8Array(t)),{vectorTile:e,rawData:t.buffer}}function Ff(e,t,r){const{extent:n}=e,i=Math.pow(2,r.z-t.z),s=(r.x-t.x*i)*n,o=(r.y-t.y*i)*n,a=[];for(let t=0;t<e.length;t++){const r=e.feature(t);let l=r.loadGeometry();for(const e of l)for(const t of e)t.x=t.x*i-s,t.y=t.y*i-o;const u=128;l=Lp(l,r.type,-u,-u,n+u,n+u),0!==l.length&&a.push(new Mf(r.type,l,r.properties,r.id,n))}return new Df(a,e.name,n)}class Bf{constructor(e,t,r){this.actor=e,this.layerIndex=t,this.availableImages=r,this.fetching={},this.loading={},this.loaded={},this.overzoomedTileResultCache=new Af(1e3)}loadVectorTile(t,r){return e(this,void 0,void 0,(function*(){const e=yield((e,t)=>ci(d(e,{type:"arrayBuffer"}),t))(t.request,r);try{return{vectorTile:"mlt"!==t.encoding?new $l(new zu(e.data)):new fp(e.data),rawData:e.data,cacheControl:e.cacheControl,expires:e.expires}}catch(r){const n=new Uint8Array(e.data);let i=`Unable to parse the tile at ${t.request.url}, `;throw i+=31===n[0]&&139===n[1]?"please make sure the data is not gzipped and that you have configured the relevant header in the server":`got error: ${r.message}`,new Error(i)}}))}loadTile(t){return e(this,void 0,void 0,(function*(){const{uid:e,overzoomParameters:r}=t;r&&(t.request=r.overzoomRequest);const n=!!(t&&t.request&&t.request.collectResourceTiming)&&new Ef(t.request),i=new _f(t);this.loading[e]=i;const s=new AbortController;i.abort=s;try{const o=yield this.loadVectorTile(t,s);if(delete this.loading[e],!o)return null;if(r){const e=this._getOverzoomTile(t,o.vectorTile);o.rawData=e.rawData,o.vectorTile=e.vectorTile}const a=o.rawData,l={};o.expires&&(l.expires=o.expires),o.cacheControl&&(l.cacheControl=o.cacheControl);const u={};if(n){const e=n.finish();e&&(u.resourceTiming=JSON.parse(JSON.stringify(e)))}i.vectorTile=o.vectorTile;const c=i.parse(o.vectorTile,this.layerIndex,this.availableImages,this.actor,t.subdivisionGranularity);this.loaded[e]=i,this.fetching[e]={rawTileData:a,cacheControl:l,resourceTiming:u};try{const e=yield c;return d({rawTileData:a.slice(0),encoding:t.encoding},e,l,u)}finally{delete this.fetching[e]}}catch(t){throw delete this.loading[e],i.status="done",this.loaded[e]=i,t}}))}_getOverzoomTile(e,t){const{tileID:r,source:n,overzoomParameters:i}=e,{maxZoomTileID:s}=i,o=`${s.key}_${r.key}`,a=this.overzoomedTileResultCache.get(o);if(a)return a;const l=new Pf,u=this.layerIndex.familiesBySource[n];for(const e in u){const n=t.layers[e];if(!n)continue;const i=Ff(n,s,r.canonical);i.length>0&&l.addLayer(i)}const c=zf(l);return this.overzoomedTileResultCache.set(o,c),c}reloadTile(t){return e(this,void 0,void 0,(function*(){const e=t.uid;if(!this.loaded||!this.loaded[e])throw new Error("Should not be trying to reload a tile that was never loaded or has been removed");const r=this.loaded[e];if(r.showCollisionBoxes=t.showCollisionBoxes,"parsing"===r.status){const n=yield r.parse(r.vectorTile,this.layerIndex,this.availableImages,this.actor,t.subdivisionGranularity);let i;if(this.fetching[e]){const{rawTileData:r,cacheControl:s,resourceTiming:o}=this.fetching[e];delete this.fetching[e],i=d({rawTileData:r.slice(0),encoding:t.encoding},n,s,o)}else i=n;return i}if("done"===r.status&&r.vectorTile)return r.parse(r.vectorTile,this.layerIndex,this.availableImages,this.actor,t.subdivisionGranularity)}))}abortTile(t){return e(this,void 0,void 0,(function*(){const e=this.loading,r=t.uid;e&&e[r]&&e[r].abort&&(e[r].abort.abort(),delete e[r])}))}removeTile(t){return e(this,void 0,void 0,(function*(){this.loaded&&this.loaded[t.uid]&&delete this.loaded[t.uid]}))}}class Cf{constructor(){this.loaded={}}loadTile(t){return e(this,void 0,void 0,(function*(){const{uid:r,encoding:n,rawImageData:i,redFactor:s,greenFactor:o,blueFactor:u,baseShift:c}=t,h=i.width+2,p=i.height+2,f=w(i)?new Da({width:h,height:p},yield function(t,r,n,i,s){return e(this,void 0,void 0,(function*(){if(function(){if(null==l&&(l=!1,null==a&&(a="undefined"!=typeof OffscreenCanvas&&new OffscreenCanvas(1,1).getContext("2d")&&"function"==typeof createImageBitmap),a)){const e=5,t=new OffscreenCanvas(e,e).getContext("2d",{willReadFrequently:!0});if(t){for(let r=0;r<e*e;r++){const n=4*r;t.fillStyle=`rgb(${n},${n+1},${n+2})`,t.fillRect(r%e,Math.floor(r/e),1,1)}const r=t.getImageData(0,0,e,e).data;for(let t=0;t<e*e*4;t++)if(t%4!=3&&r[t]!==t){l=!0;break}}}return l||!1}())try{return yield function(t,r,n,i,s){return e(this,void 0,void 0,(function*(){if("undefined"==typeof VideoFrame)throw new Error("VideoFrame not supported");const e=new VideoFrame(t,{timestamp:0});try{const o=null==e?void 0:e.format;if(!o||!o.startsWith("BGR")&&!o.startsWith("RGB"))throw new Error(`Unrecognized format ${o}`);const a=o.startsWith("BGR"),l=new Uint8ClampedArray(i*s*4);if(yield e.copyTo(l,function(e,t,r,n,i){const s=4*Math.max(-t,0),o=(Math.max(0,r)-r)*n*4+s,a=4*n,l=Math.max(0,t),u=Math.max(0,r);return{rect:{x:l,y:u,width:Math.min(e.width,t+n)-l,height:Math.min(e.height,r+i)-u},layout:[{offset:o,stride:a}]}}(t,r,n,i,s)),a)for(let e=0;e<l.length;e+=4){const t=l[e];l[e]=l[e+2],l[e+2]=t}return l}finally{e.close()}}))}(t,r,n,i,s)}catch(e){}return function(e,t,r,n,i){const s=e.width,o=e.height;_&&S||(_=new OffscreenCanvas(s,o),S=_.getContext("2d",{willReadFrequently:!0})),_.width=s,_.height=o,S.drawImage(e,0,0,s,o);const a=S.getImageData(t,r,n,i);return S.clearRect(0,0,s,o),a.data}(t,r,n,i,s)}))}(i,-1,-1,h,p)):i,d=new Ra(r,f,n,s,o,u,c);return this.loaded=this.loaded||{},this.loaded[r]=d,d}))}removeTile(e){const t=this.loaded,r=e.uid;t&&t[r]&&delete t[r]}}var Vf=function(){if(kf)return Tf;function e(e,r){if(0!==e.length){t(e[0],r);for(var n=1;n<e.length;n++)t(e[n],!r)}}function t(e,t){for(var r=0,n=0,i=0,s=e.length,o=s-1;i<s;o=i++){var a=(e[i][0]-e[o][0])*(e[o][1]+e[i][1]),l=r+a;n+=Math.abs(r)>=Math.abs(a)?r-l+a:a-l+r,r=l}r+n>=0!=!!t&&e.reverse()}return kf=1,Tf=function t(r,n){var i,s=r&&r.type;if("FeatureCollection"===s)for(i=0;i<r.features.length;i++)t(r.features[i],n);else if("GeometryCollection"===s)for(i=0;i<r.geometries.length;i++)t(r.geometries[i],n);else if("Feature"===s)t(r.geometry,n);else if("Polygon"===s)e(r.coordinates,n);else if("MultiPolygon"===s)for(i=0;i<r.coordinates.length;i++)e(r.coordinates[i],n);return r}}(),Lf=r(Vf);const Of=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class Rf{static from(e){if(!(e instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[t,r]=new Uint8Array(e,0,2);if(219!==t)throw new Error("Data does not appear to be in a KDBush format.");const n=r>>4;if(1!==n)throw new Error(`Got v${n} data when expected v1.`);const i=Of[15&r];if(!i)throw new Error("Unrecognized array type.");const[s]=new Uint16Array(e,2,1),[o]=new Uint32Array(e,4,1);return new Rf(o,s,i,e)}constructor(e,t=64,r=Float64Array,n){if(isNaN(e)||e<0)throw new Error(`Unpexpected numItems value: ${e}.`);this.numItems=+e,this.nodeSize=Math.min(Math.max(+t,2),65535),this.ArrayType=r,this.IndexArrayType=e<65536?Uint16Array:Uint32Array;const i=Of.indexOf(this.ArrayType),s=2*e*this.ArrayType.BYTES_PER_ELEMENT,o=e*this.IndexArrayType.BYTES_PER_ELEMENT,a=(8-o%8)%8;if(i<0)throw new Error(`Unexpected typed array class: ${r}.`);n&&n instanceof ArrayBuffer?(this.data=n,this.ids=new this.IndexArrayType(this.data,8,e),this.coords=new this.ArrayType(this.data,8+o+a,2*e),this._pos=2*e,this._finished=!0):(this.data=new ArrayBuffer(8+s+o+a),this.ids=new this.IndexArrayType(this.data,8,e),this.coords=new this.ArrayType(this.data,8+o+a,2*e),this._pos=0,this._finished=!1,new Uint8Array(this.data,0,2).set([219,16+i]),new Uint16Array(this.data,2,1)[0]=t,new Uint32Array(this.data,4,1)[0]=e)}add(e,t){const r=this._pos>>1;return this.ids[r]=r,this.coords[this._pos++]=e,this.coords[this._pos++]=t,r}finish(){const e=this._pos>>1;if(e!==this.numItems)throw new Error(`Added ${e} items when expected ${this.numItems}.`);return Nf(this.ids,this.coords,this.nodeSize,0,this.numItems-1,0),this._finished=!0,this}range(e,t,r,n){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:i,coords:s,nodeSize:o}=this,a=[0,i.length-1,0],l=[];for(;a.length;){const u=a.pop()||0,c=a.pop()||0,h=a.pop()||0;if(c-h<=o){for(let o=h;o<=c;o++){const a=s[2*o],u=s[2*o+1];a>=e&&a<=r&&u>=t&&u<=n&&l.push(i[o])}continue}const p=h+c>>1,f=s[2*p],d=s[2*p+1];f>=e&&f<=r&&d>=t&&d<=n&&l.push(i[p]),(0===u?e<=f:t<=d)&&(a.push(h),a.push(p-1),a.push(1-u)),(0===u?r>=f:n>=d)&&(a.push(p+1),a.push(c),a.push(1-u))}return l}within(e,t,r){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:n,coords:i,nodeSize:s}=this,o=[0,n.length-1,0],a=[],l=r*r;for(;o.length;){const u=o.pop()||0,c=o.pop()||0,h=o.pop()||0;if(c-h<=s){for(let r=h;r<=c;r++)Gf(i[2*r],i[2*r+1],e,t)<=l&&a.push(n[r]);continue}const p=h+c>>1,f=i[2*p],d=i[2*p+1];Gf(f,d,e,t)<=l&&a.push(n[p]),(0===u?e-r<=f:t-r<=d)&&(o.push(h),o.push(p-1),o.push(1-u)),(0===u?e+r>=f:t+r>=d)&&(o.push(p+1),o.push(c),o.push(1-u))}return a}}function Nf(e,t,r,n,i,s){if(i-n<=r)return;const o=n+i>>1;$f(e,t,o,n,i,s),Nf(e,t,r,n,o-1,1-s),Nf(e,t,r,o+1,i,1-s)}function $f(e,t,r,n,i,s){for(;i>n;){if(i-n>600){const o=i-n+1,a=r-n+1,l=Math.log(o),u=.5*Math.exp(2*l/3),c=.5*Math.sqrt(l*u*(o-u)/o)*(a-o/2<0?-1:1);$f(e,t,r,Math.max(n,Math.floor(r-a*u/o+c)),Math.min(i,Math.floor(r+(o-a)*u/o+c)),s)}const o=t[2*r+s];let a=n,l=i;for(Uf(e,t,n,r),t[2*i+s]>o&&Uf(e,t,n,i);a<l;){for(Uf(e,t,a,l),a++,l--;t[2*a+s]<o;)a++;for(;t[2*l+s]>o;)l--}t[2*n+s]===o?Uf(e,t,n,l):(l++,Uf(e,t,l,i)),l<=r&&(n=l+1),r<=l&&(i=l-1)}}function Uf(e,t,r,n){qf(e,r,n),qf(t,2*r,2*n),qf(t,2*r+1,2*n+1)}function qf(e,t,r){const n=e[t];e[t]=e[r],e[r]=n}function Gf(e,t,r,n){const i=e-r,s=t-n;return i*i+s*s}const jf={minZoom:0,maxZoom:16,minPoints:2,radius:40,extent:512,nodeSize:64,log:!1,generateId:!1,reduce:null,map:e=>e},Xf=Math.fround||(Yf=new Float32Array(1),e=>(Yf[0]=+e,Yf[0]));var Yf;class Zf{constructor(e){this.options=Object.assign(Object.create(jf),e),this.trees=new Array(this.options.maxZoom+1),this.stride=this.options.reduce?7:6,this.clusterProps=[]}load(e){const{log:t,minZoom:r,maxZoom:n}=this.options;t&&console.time("total time");const i=`prepare ${e.length} points`;t&&console.time(i),this.points=e;const s=[];for(let t=0;t<e.length;t++){const r=e[t];if(!r.geometry)continue;const[n,i]=r.geometry.coordinates,o=Xf(Jf(n)),a=Xf(Kf(i));s.push(o,a,1/0,t,-1,1),this.options.reduce&&s.push(0)}let o=this.trees[n+1]=this._createTree(s);t&&console.timeEnd(i);for(let e=n;e>=r;e--){const r=+Date.now();o=this.trees[e]=this._createTree(this._cluster(o,e)),t&&console.log("z%d: %d clusters in %dms",e,o.numItems,+Date.now()-r)}return t&&console.timeEnd("total time"),this}getClusters(e,t){let r=((e[0]+180)%360+360)%360-180;const n=Math.max(-90,Math.min(90,e[1]));let i=180===e[2]?180:((e[2]+180)%360+360)%360-180;const s=Math.max(-90,Math.min(90,e[3]));if(e[2]-e[0]>=360)r=-180,i=180;else if(r>i){const e=this.getClusters([r,n,180,s],t),o=this.getClusters([-180,n,i,s],t);return e.concat(o)}const o=this.trees[this._limitZoom(t)],a=o.range(Jf(r),Kf(s),Jf(i),Kf(n)),l=o.data,u=[];for(const e of a){const t=this.stride*e;u.push(l[t+5]>1?Hf(l,t,this.clusterProps):this.points[l[t+3]])}return u}getChildren(e){const t=this._getOriginId(e),r=this._getOriginZoom(e),n="No cluster with the specified id.",i=this.trees[r];if(!i)throw new Error(n);const s=i.data;if(t*this.stride>=s.length)throw new Error(n);const o=this.options.radius/(this.options.extent*Math.pow(2,r-1)),a=i.within(s[t*this.stride],s[t*this.stride+1],o),l=[];for(const t of a){const r=t*this.stride;s[r+4]===e&&l.push(s[r+5]>1?Hf(s,r,this.clusterProps):this.points[s[r+3]])}if(0===l.length)throw new Error(n);return l}getLeaves(e,t,r){const n=[];return this._appendLeaves(n,e,t=t||10,r=r||0,0),n}getTile(e,t,r){const n=this.trees[this._limitZoom(e)],i=Math.pow(2,e),{extent:s,radius:o}=this.options,a=o/s,l=(r-a)/i,u=(r+1+a)/i,c={features:[]};return this._addTileFeatures(n.range((t-a)/i,l,(t+1+a)/i,u),n.data,t,r,i,c),0===t&&this._addTileFeatures(n.range(1-a/i,l,1,u),n.data,i,r,i,c),t===i-1&&this._addTileFeatures(n.range(0,l,a/i,u),n.data,-1,r,i,c),c.features.length?c:null}getClusterExpansionZoom(e){let t=this._getOriginZoom(e)-1;for(;t<=this.options.maxZoom;){const r=this.getChildren(e);if(t++,1!==r.length)break;e=r[0].properties.cluster_id}return t}_appendLeaves(e,t,r,n,i){const s=this.getChildren(t);for(const t of s){const s=t.properties;if(s&&s.cluster?i+s.point_count<=n?i+=s.point_count:i=this._appendLeaves(e,s.cluster_id,r,n,i):i<n?i++:e.push(t),e.length===r)break}return i}_createTree(e){const t=new Rf(e.length/this.stride|0,this.options.nodeSize,Float32Array);for(let r=0;r<e.length;r+=this.stride)t.add(e[r],e[r+1]);return t.finish(),t.data=e,t}_addTileFeatures(e,t,r,n,i,s){for(const o of e){const e=o*this.stride,a=t[e+5]>1;let l,u,c;if(a)l=Wf(t,e,this.clusterProps),u=t[e],c=t[e+1];else{const r=this.points[t[e+3]];l=r.properties;const[n,i]=r.geometry.coordinates;u=Jf(n),c=Kf(i)}const h={type:1,geometry:[[Math.round(this.options.extent*(u*i-r)),Math.round(this.options.extent*(c*i-n))]],tags:l};let p;p=a||this.options.generateId?t[e+3]:this.points[t[e+3]].id,void 0!==p&&(h.id=p),s.features.push(h)}}_limitZoom(e){return Math.max(this.options.minZoom,Math.min(Math.floor(+e),this.options.maxZoom+1))}_cluster(e,t){const{radius:r,extent:n,reduce:i,minPoints:s}=this.options,o=r/(n*Math.pow(2,t)),a=e.data,l=[],u=this.stride;for(let r=0;r<a.length;r+=u){if(a[r+2]<=t)continue;a[r+2]=t;const n=a[r],c=a[r+1],h=e.within(a[r],a[r+1],o),p=a[r+5];let f=p;for(const e of h){const r=e*u;a[r+2]>t&&(f+=a[r+5])}if(f>p&&f>=s){let e,s=n*p,o=c*p,d=-1;const y=(r/u<<5)+(t+1)+this.points.length;for(const n of h){const l=n*u;if(a[l+2]<=t)continue;a[l+2]=t;const c=a[l+5];s+=a[l]*c,o+=a[l+1]*c,a[l+4]=y,i&&(e||(e=this._map(a,r,!0),d=this.clusterProps.length,this.clusterProps.push(e)),i(e,this._map(a,l)))}a[r+4]=y,l.push(s/f,o/f,1/0,y,-1,f),i&&l.push(d)}else{for(let e=0;e<u;e++)l.push(a[r+e]);if(f>1)for(const e of h){const r=e*u;if(!(a[r+2]<=t)){a[r+2]=t;for(let e=0;e<u;e++)l.push(a[r+e])}}}}return l}_getOriginId(e){return e-this.points.length>>5}_getOriginZoom(e){return(e-this.points.length)%32}_map(e,t,r){if(e[t+5]>1){const n=this.clusterProps[e[t+6]];return r?Object.assign({},n):n}const n=this.points[e[t+3]].properties,i=this.options.map(n);return r&&i===n?Object.assign({},i):i}}function Hf(e,t,r){return{type:"Feature",id:e[t+3],properties:Wf(e,t,r),geometry:{type:"Point",coordinates:[(n=e[t],360*(n-.5)),Qf(e[t+1])]}};var n}function Wf(e,t,r){const n=e[t+5],i=n>=1e4?`${Math.round(n/1e3)}k`:n>=1e3?Math.round(n/100)/10+"k":n,s=e[t+6],o=-1===s?{}:Object.assign({},r[s]);return Object.assign(o,{cluster:!0,cluster_id:e[t+3],point_count:n,point_count_abbreviated:i})}function Jf(e){return e/360+.5}function Kf(e){const t=Math.sin(e*Math.PI/180),r=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return r<0?0:r>1?1:r}function Qf(e){const t=(180-360*e)*Math.PI/180;return 360*Math.atan(Math.exp(t))/Math.PI-90}function ed(e,t,r,n){let i=n;const s=t+(r-t>>1);let o,a=r-t;const l=e[t],u=e[t+1],c=e[r],h=e[r+1];for(let n=t+3;n<r;n+=3){const t=td(e[n],e[n+1],l,u,c,h);if(t>i)o=n,i=t;else if(t===i){const e=Math.abs(n-s);e<a&&(o=n,a=e)}}i>n&&(o-t>3&&ed(e,t,o,n),e[o+2]=i,r-o>3&&ed(e,o,r,n))}function td(e,t,r,n,i,s){let o=i-r,a=s-n;if(0!==o||0!==a){const l=((e-r)*o+(t-n)*a)/(o*o+a*a);l>1?(r=i,n=s):l>0&&(r+=o*l,n+=a*l)}return o=e-r,a=t-n,o*o+a*a}function rd(e,t,r,n){const i={type:t,geom:r},s={id:null==e?null:e,type:i.type,geometry:i.geom,tags:n,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0};switch(i.type){case"Point":case"MultiPoint":case"LineString":nd(s,i.geom);break;case"Polygon":nd(s,i.geom[0]);break;case"MultiLineString":for(const e of i.geom)nd(s,e);break;case"MultiPolygon":for(const e of i.geom)nd(s,e[0])}return s}function nd(e,t){for(let r=0;r<t.length;r+=3)e.minX=Math.min(e.minX,t[r]),e.minY=Math.min(e.minY,t[r+1]),e.maxX=Math.max(e.maxX,t[r]),e.maxY=Math.max(e.maxY,t[r+1])}function id(e,t){const r=[];switch(e.type){case"FeatureCollection":for(let n=0;n<e.features.length;n++)sd(r,e.features[n],t,n);break;case"Feature":sd(r,e,t);break;default:sd(r,{geometry:e,properties:void 0},t)}return r}function sd(e,t,r,n){if(!t.geometry)return;if("GeometryCollection"===t.geometry.type){for(const i of t.geometry.geometries)sd(e,{id:t.id,geometry:i,properties:t.properties},r,n);return}const i=t.geometry.coordinates;if(!i?.length)return;const s=Math.pow(r.tolerance/((1<<r.maxZoom)*r.extent),2);let o=t.id;switch(r.promoteId?o=t.properties?.[r.promoteId]:r.generateId&&(o=n||0),t.geometry.type){case"Point":{const r=[];return od(t.geometry.coordinates,r),void e.push(rd(o,t.geometry.type,r,t.properties))}case"MultiPoint":{const r=[];for(const e of t.geometry.coordinates)od(e,r);return void e.push(rd(o,t.geometry.type,r,t.properties))}case"LineString":{const r=[];return ad(t.geometry.coordinates,r,s,!1),void e.push(rd(o,t.geometry.type,r,t.properties))}case"MultiLineString":{if(r.lineMetrics){for(const r of t.geometry.coordinates){const n=[];ad(r,n,s,!1),e.push(rd(o,"LineString",n,t.properties))}return}const n=[];return ld(t.geometry.coordinates,n,s,!1),void e.push(rd(o,t.geometry.type,n,t.properties))}case"Polygon":{const r=[];return ld(t.geometry.coordinates,r,s,!0),void e.push(rd(o,t.geometry.type,r,t.properties))}case"MultiPolygon":{const r=[];for(const e of t.geometry.coordinates){const t=[];ld(e,t,s,!0),r.push(t)}return void e.push(rd(o,t.geometry.type,r,t.properties))}default:throw new Error("Input data is not a valid GeoJSON object.")}}function od(e,t){t.push(ud(e[0]),cd(e[1]),0)}function ad(e,t,r,n){let i,s,o=0;for(let r=0;r<e.length;r++){const a=ud(e[r][0]),l=cd(e[r][1]);t.push(a,l,0),r>0&&(o+=n?(i*l-a*s)/2:Math.sqrt(Math.pow(a-i,2)+Math.pow(l-s,2))),i=a,s=l}const a=t.length-3;t[2]=1,r>0&&ed(t,0,a,r),t[a+2]=1,t.size=Math.abs(o),t.start=0,t.end=t.size}function ld(e,t,r,n){for(let i=0;i<e.length;i++){const s=[];ad(e[i],s,r,n),t.push(s)}}function ud(e){return e/360+.5}function cd(e){const t=Math.sin(e*Math.PI/180),r=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return r<0?0:r>1?1:r}function hd(e,t,r,n,i,s,o,a){if(n/=t,s>=(r/=t)&&o<n)return e;if(o<r||s>=n)return null;const l=[];for(const t of e){const e=0===i?t.minX:t.minY,s=0===i?t.maxX:t.maxY;if(e>=r&&s<n)l.push(t);else if(!(s<r||e>=n))switch(t.type){case"Point":case"MultiPoint":{const e=[];if(pd(t.geometry,e,r,n,i),!e.length)continue;l.push(rd(t.id,3===e.length?"Point":"MultiPoint",e,t.tags));continue}case"LineString":{const e=[];if(fd(t.geometry,e,r,n,i,!1,a.lineMetrics),!e.length)continue;if(a.lineMetrics){for(const r of e)l.push(rd(t.id,t.type,r,t.tags));continue}if(e.length>1){l.push(rd(t.id,"MultiLineString",e,t.tags));continue}l.push(rd(t.id,t.type,e[0],t.tags));continue}case"MultiLineString":{const e=[];if(yd(t.geometry,e,r,n,i,!1),!e.length)continue;if(1===e.length){l.push(rd(t.id,"LineString",e[0],t.tags));continue}l.push(rd(t.id,t.type,e,t.tags));continue}case"Polygon":{const e=[];if(yd(t.geometry,e,r,n,i,!0),!e.length)continue;l.push(rd(t.id,t.type,e,t.tags));continue}case"MultiPolygon":{const e=[];for(const s of t.geometry){const t=[];yd(s,t,r,n,i,!0),t.length&&e.push(t)}if(!e.length)continue;l.push(rd(t.id,t.type,e,t.tags));continue}}}return l.length?l:null}function pd(e,t,r,n,i){for(let s=0;s<e.length;s+=3){const o=e[s+i];o>=r&&o<=n&&md(t,e[s],e[s+1],e[s+2])}}function fd(e,t,r,n,i,s,o){let a=dd(e);const l=0===i?gd:xd;let u,c,h=e.start;for(let p=0;p<e.length-3;p+=3){const f=e[p],d=e[p+1],y=e[p+2],m=e[p+3],g=e[p+4],x=0===i?f:d,v=0===i?m:g;let b=!1;o&&(u=Math.sqrt(Math.pow(f-m,2)+Math.pow(d-g,2))),x<r?v>r&&(c=l(a,f,d,m,g,r),o&&(a.start=h+u*c)):x>n?v<n&&(c=l(a,f,d,m,g,n),o&&(a.start=h+u*c)):md(a,f,d,y),v<r&&x>=r&&(c=l(a,f,d,m,g,r),b=!0),v>n&&x<=n&&(c=l(a,f,d,m,g,n),b=!0),!s&&b&&(o&&(a.end=h+u*c),t.push(a),a=dd(e)),o&&(h+=u)}let p=e.length-3;const f=e[p],d=e[p+1],y=0===i?f:d;y>=r&&y<=n&&md(a,f,d,e[p+2]),p=a.length-3,s&&p>=3&&(a[p]!==a[0]||a[p+1]!==a[1])&&md(a,a[0],a[1],a[2]),a.length&&t.push(a)}function dd(e){const t=[];return t.size=e.size,t.start=e.start,t.end=e.end,t}function yd(e,t,r,n,i,s){for(const o of e)fd(o,t,r,n,i,s,!1)}function md(e,t,r,n){e.push(t,r,n)}function gd(e,t,r,n,i,s){const o=(s-t)/(n-t);return md(e,s,r+(i-r)*o,1),o}function xd(e,t,r,n,i,s){const o=(s-r)/(i-r);return md(e,t+(n-t)*o,s,1),o}function vd(e,t){const r=t.buffer/t.extent;let n=e;const i=hd(e,1,-1-r,r,0,-1,2,t),s=hd(e,1,1-r,2+r,0,-1,2,t);return i||s?(n=hd(e,1,-r,1+r,0,-1,2,t)||[],i&&(n=bd(i,1).concat(n)),s&&(n=n.concat(bd(s,-1))),n):n}function bd(e,t){const r=[];for(const n of e)switch(n.type){case"Point":case"MultiPoint":case"LineString":{const e=wd(n.geometry,t);r.push(rd(n.id,n.type,e,n.tags));continue}case"MultiLineString":case"Polygon":{const e=[];for(const r of n.geometry)e.push(wd(r,t));r.push(rd(n.id,n.type,e,n.tags));continue}case"MultiPolygon":{const e=[];for(const r of n.geometry){const n=[];for(const e of r)n.push(wd(e,t));e.push(n)}r.push(rd(n.id,n.type,e,n.tags));continue}}return r}function wd(e,t){const r=[];r.size=e.size,void 0!==e.start&&(r.start=e.start,r.end=e.end);for(let n=0;n<e.length;n+=3)r.push(e[n]+t,e[n+1],e[n+2]);return r}function _d(e,t){if(e.transformed)return e;const r=1<<e.z,n=e.x,i=e.y;for(const s of e.features){if(1===s.type){const e=[];for(let o=0;o<s.geometry.length;o+=2)e.push(Sd(s.geometry[o],s.geometry[o+1],t,r,n,i));s.geometry=e;continue}const e=[];for(const o of s.geometry){const s=[];for(let e=0;e<o.length;e+=2)s.push(Sd(o[e],o[e+1],t,r,n,i));e.push(s)}s.geometry=e}return e.transformed=!0,e}function Sd(e,t,r,n,i,s){return[Math.round(r*(e*n-i)),Math.round(r*(t*n-s))]}function Ad(e,t,r,n,i){const s=t===i.maxZoom?0:i.tolerance/((1<<t)*i.extent),o={features:[],numPoints:0,numSimplified:0,numFeatures:e.length,source:null,x:r,y:n,z:t,transformed:!1,minX:2,minY:1,maxX:-1,maxY:0};for(const t of e)Id(o,t,s,i);return o}function Id(e,t,r,n){e.minX=Math.min(e.minX,t.minX),e.minY=Math.min(e.minY,t.minY),e.maxX=Math.max(e.maxX,t.maxX),e.maxY=Math.max(e.maxY,t.maxY);let i,s=t.tags||null;switch(t.type){case"Point":case"MultiPoint":{const r=[];for(let n=0;n<t.geometry.length;n+=3)r.push(t.geometry[n],t.geometry[n+1]),e.numPoints++,e.numSimplified++;if(!r.length)return;i={type:1,tags:s,geometry:r};break}case"LineString":{const o=[];if(Td(o,t.geometry,e,r,!1,!1),!o.length)return;if(n.lineMetrics){s={};for(const e in t.tags)s[e]=t.tags[e];s.mapbox_clip_start=t.geometry.start/t.geometry.size,s.mapbox_clip_end=t.geometry.end/t.geometry.size}i={type:2,tags:s,geometry:o};break}case"MultiLineString":case"Polygon":{const n=[];for(let i=0;i<t.geometry.length;i++)Td(n,t.geometry[i],e,r,"Polygon"===t.type,0===i);if(!n.length)return;i={type:"Polygon"===t.type?3:2,tags:s,geometry:n};break}case"MultiPolygon":{const n=[];for(let i=0;i<t.geometry.length;i++){const s=t.geometry[i];for(let t=0;t<s.length;t++)Td(n,s[t],e,r,!0,0===t)}if(!n.length)return;i={type:3,tags:s,geometry:n};break}}null!==t.id&&(i.id=t.id),e.features.push(i)}function Td(e,t,r,n,i,s){const o=n*n;if(n>0&&t.size<(i?o:n))return void(r.numPoints+=t.length/3);const a=[];for(let e=0;e<t.length;e+=3)(0===n||t[e+2]>o)&&(r.numSimplified++,a.push(t[e],t[e+1])),r.numPoints++;i&&function(e,t){let r=0;for(let t=0,n=e.length,i=n-2;t<n;i=t,t+=2)r+=(e[t]-e[i])*(e[t+1]+e[i+1]);if(r>0===t)for(let t=0,r=e.length;t<r/2;t+=2){const n=e[t],i=e[t+1];e[t]=e[r-2-t],e[t+1]=e[r-1-t],e[r-2-t]=n,e[r-1-t]=i}}(a,s),e.push(a)}function kd(e,t,r){const n=!!t.newGeometry,i=t.removeAllProperties||t.removeProperties?.length>0||t.addOrUpdateProperties?.length>0;if(n){let n=id({type:"FeatureCollection",features:[{type:"Feature",id:e.id,geometry:t.newGeometry,properties:i?Ed(e.tags,t):e.tags}]},r);return n=vd(n,r),n[0]}if(i){const r={...e};return r.tags=Ed(r.tags,t),r}return null}function Ed(e,t){if(t.removeAllProperties)return{};const r={...e||{}};if(t.removeProperties)for(const e of t.removeProperties)delete r[e];if(t.addOrUpdateProperties)for(const{key:e,value:n}of t.addOrUpdateProperties)r[e]=n;return r}const Md={maxZoom:14,indexMaxZoom:5,indexMaxPoints:1e5,tolerance:3,extent:4096,buffer:64,lineMetrics:!1,promoteId:null,generateId:!1,updateable:!1,debug:0};class Dd{options;tiles;tileCoords;stats={};total=0;source;constructor(e,t){const r=(t=this.options=Object.assign({},Md,t)).debug;if(r&&console.time("preprocess data"),t.maxZoom<0||t.maxZoom>24)throw new Error("maxZoom should be in the 0-24 range");if(t.promoteId&&t.generateId)throw new Error("promoteId and generateId cannot be used together.");let n=id(e,t);this.tiles={},this.tileCoords=[],r&&(console.timeEnd("preprocess data"),console.log("index: maxZoom: %d, maxPoints: %d",t.indexMaxZoom,t.indexMaxPoints),console.time("generate tiles"),this.stats={},this.total=0),n=vd(n,t),n.length&&this.splitTile(n,0,0,0),t.updateable&&(this.source=n),r&&(n.length&&console.log("features: %d, points: %d",this.tiles[0].numFeatures,this.tiles[0].numPoints),console.timeEnd("generate tiles"),console.log("tiles generated:",this.total,JSON.stringify(this.stats)))}splitTile(e,t,r,n,i,s,o){const a=[e,t,r,n],l=this.options,u=l.debug;for(;a.length;){n=a.pop(),r=a.pop(),t=a.pop(),e=a.pop();const c=1<<t,h=Pd(t,r,n);let p=this.tiles[h];if(!p&&(u>1&&console.time("creation"),p=this.tiles[h]=Ad(e,t,r,n,l),this.tileCoords.push({z:t,x:r,y:n,id:h}),u)){u>1&&(console.log("tile z%d-%d-%d (features: %d, points: %d, simplified: %d)",t,r,n,p.numFeatures,p.numPoints,p.numSimplified),console.timeEnd("creation"));const e=`z${t}`;this.stats[e]=(this.stats[e]||0)+1,this.total++}if(p.source=e,null==i){if(t===l.indexMaxZoom||p.numPoints<=l.indexMaxPoints)continue}else{if(t===l.maxZoom||t===i)continue;if(null!=i){const e=i-t;if(r!==s>>e||n!==o>>e)continue}}if(p.source=null,!e.length)continue;u>1&&console.time("clipping");const f=.5*l.buffer/l.extent,d=.5-f,y=.5+f,m=1+f;let g=null,x=null,v=null,b=null;const w=hd(e,c,r-f,r+y,0,p.minX,p.maxX,l),_=hd(e,c,r+d,r+m,0,p.minX,p.maxX,l);w&&(g=hd(w,c,n-f,n+y,1,p.minY,p.maxY,l),x=hd(w,c,n+d,n+m,1,p.minY,p.maxY,l)),_&&(v=hd(_,c,n-f,n+y,1,p.minY,p.maxY,l),b=hd(_,c,n+d,n+m,1,p.minY,p.maxY,l)),u>1&&console.timeEnd("clipping"),a.push(g||[],t+1,2*r,2*n),a.push(x||[],t+1,2*r,2*n+1),a.push(v||[],t+1,2*r+1,2*n),a.push(b||[],t+1,2*r+1,2*n+1)}}getTile(e,t,r){e=+e,t=+t,r=+r;const n=this.options,{extent:i,debug:s}=n;if(e<0||e>24)return null;const o=1<<e,a=Pd(e,t=t+o&o-1,r);if(this.tiles[a])return _d(this.tiles[a],i);s>1&&console.log("drilling down to z%d-%d-%d",e,t,r);let l,u=e,c=t,h=r;for(;!l&&u>0;)u--,c>>=1,h>>=1,l=this.tiles[Pd(u,c,h)];return l?.source?(s>1&&(console.log("found parent tile z%d-%d-%d",u,c,h),console.time("drilling down")),this.splitTile(l.source,u,c,h,e,t,r),s>1&&console.timeEnd("drilling down"),this.tiles[a]?_d(this.tiles[a],i):null):null}invalidateTiles(e){const t=this.options,{debug:r}=t;let n=1/0,i=-1/0,s=1/0,o=-1/0;for(const t of e)n=Math.min(n,t.minX),i=Math.max(i,t.maxX),s=Math.min(s,t.minY),o=Math.max(o,t.maxY);const a=t.buffer/t.extent,l=new Set;for(const t in this.tiles){const u=this.tiles[t],c=1<<u.z,h=(u.x-a)/c,p=(u.x+1+a)/c,f=(u.y-a)/c,d=(u.y+1+a)/c;if(i<h||n>=p||o<f||s>=d)continue;let y=!1;for(const t of e)if(t.maxX>=h&&t.minX<p&&t.maxY>=f&&t.minY<d){y=!0;break}if(y){if(r){r>1&&console.log("invalidate tile z%d-%d-%d (features: %d, points: %d, simplified: %d)",u.z,u.x,u.y,u.numFeatures,u.numPoints,u.numSimplified);const e=`z${u.z}`;this.stats[e]=(this.stats[e]||0)-1,this.total--}delete this.tiles[t],l.add(t)}}l.size&&(this.tileCoords=this.tileCoords.filter((e=>!l.has(e.id))))}updateData(e){const t=this.options,r=t.debug;if(!t.updateable)throw new Error("to update tile geojson `updateable` option must be set to true");const{affected:n,source:i}=function(e,t,r){const n=function(e){return e?{removeAll:e.removeAll,remove:new Set(e.remove||[]),add:new Map(e.add?.map((e=>[e.id,e]))),update:new Map(e.update?.map((e=>[e.id,e])))}:{remove:new Set,add:new Map,update:new Map}}(t);let i=[];if(n.removeAll&&(i=e,e=[]),n.remove.size||n.add.size){const t=[];for(const r of e){const{id:e}=r;(n.remove.has(e)||n.add.has(e))&&t.push(r)}if(t.length){i.push(...t);const r=new Set(t.map((e=>e.id)));e=e.filter((e=>!r.has(e.id)))}if(n.add.size){let t=id({type:"FeatureCollection",features:Array.from(n.add.values())},r);t=vd(t,r),i.push(...t),e.push(...t)}}if(n.update.size)for(const[t,s]of n.update){const n=e.findIndex((e=>e.id===t));if(-1===n)continue;const o=e[n],a=kd(o,s,r);a&&(i.push(o,a),e[n]=a)}return{affected:i,source:e}}(this.source,e,t);if(!n.length)return;this.source=i,r>1&&(console.log("invalidating tiles"),console.time("invalidating")),this.invalidateTiles(n),r>1&&console.timeEnd("invalidating");const[s,o,a]=[0,0,0],l=Ad(this.source,s,o,a,this.options);l.source=this.source;const u=Pd(s,o,a);if(this.tiles[u]=l,this.tileCoords.push({z:s,x:o,y:a,id:u}),r){const e=`z${s}`;this.stats[e]=(this.stats[e]||0)+1,this.total++}}}function Pd(e,t,r){return 32*((1<<e)*r+t)+e}function zd(e,t){return t?e.properties[t]:e.id}function Fd(e,t){const r=new Map;if(null==e)return r;if(null==e.type)return r;if("Feature"===e.type){const n=zd(e,t);if(null==n)return;return r.set(n,e),r}if("FeatureCollection"===e.type){const n=new Set;for(const i of e.features){const e=zd(i,t);if(null==e)return;if(n.has(e))return;n.add(e),r.set(e,i)}return r}}class Bd extends Bf{constructor(e,t,r,n=Cd){super(e,t,r),this._dataUpdateable=new Map,this._createGeoJSONIndex=n}loadVectorTile(t,r){return e(this,void 0,void 0,(function*(){const e=t.tileID.canonical;if(!this._geoJSONIndex)throw new Error("Unable to parse the data into a cluster or geojson");const r=this._geoJSONIndex.getTile(e.z,e.x,e.y);return r?zf(new gp(r.features,{version:2,extent:p})):null}))}loadData(t){return e(this,void 0,void 0,(function*(){var e;null===(e=this._pendingRequest)||void 0===e||e.abort();const r=this._startPerformance(t);this._pendingRequest=new AbortController;try{(!this._pendingData||t.request||t.data||t.dataDiff)&&(this._pendingData=this.loadAndProcessGeoJSON(t,this._pendingRequest));const e=yield this._pendingData;this._geoJSONIndex=this._createGeoJSONIndex(e,t),this.loaded={};const n={};return t.request&&(n.data=e),this._finishPerformance(r,t,n),n}catch(e){if(delete this._pendingRequest,ni(e))return{abandoned:!0};throw e}}))}_startPerformance(e){var t;if(null===(t=null==e?void 0:e.request)||void 0===t?void 0:t.collectResourceTiming)return new Ef(e.request)}_finishPerformance(e,t,r){if(!e)return;const n=e.finish();n&&(r.resourceTiming={},r.resourceTiming[t.source]=JSON.parse(JSON.stringify(n)))}getData(){return e(this,void 0,void 0,(function*(){return this._pendingData}))}reloadTile(e){const t=this.loaded;return t&&t[e.uid]?super.reloadTile(e):this.loadTile(e)}loadAndProcessGeoJSON(t,r){return e(this,void 0,void 0,(function*(){let e;if(t.request?e=yield this.loadGeoJSONFromUrl(t.request,t.promoteId,r):t.data?e=this._loadGeoJSONFromObject(t.data,t.promoteId):t.dataDiff&&(e=this._loadGeoJSONFromDiff(t.dataDiff,t.promoteId,t.source)),delete this._pendingRequest,"object"!=typeof e)throw new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`);return Lf(e,!0),t.filter&&(e=this._filterGeoJSON(e,t.filter)),e}))}loadGeoJSONFromUrl(t,r,n){return e(this,void 0,void 0,(function*(){const e=yield((e,t)=>ci(d(e,{type:"json"}),t))(t,n);return this._dataUpdateable=Fd(e.data,r),e.data}))}_loadGeoJSONFromObject(e,t){return this._dataUpdateable=Fd(e,t),e}_loadGeoJSONFromDiff(e,t,r){if(!this._dataUpdateable)throw new Error(`Cannot update existing geojson data in ${r}`);!function(e,t,r){var n,i;const s=[];if(t.removeAll)e.clear();else if(t.remove)for(const r of t.remove){const t=e.get(r);t&&(s.push(t.geometry),e.delete(r))}if(t.add)for(const n of t.add){const t=zd(n,r);if(null==t)continue;const i=e.get(t);i&&s.push(i.geometry),s.push(n.geometry),e.set(t,n)}if(t.update)for(const r of t.update){const t=e.get(r.id);if(!t)continue;const o=!!r.newGeometry,a=r.removeAllProperties||(null===(n=r.removeProperties)||void 0===n?void 0:n.length)>0||(null===(i=r.addOrUpdateProperties)||void 0===i?void 0:i.length)>0;if(!o&&!a)continue;s.push(t.geometry);const l=Object.assign({},t);if(e.set(r.id,l),o&&(s.push(r.newGeometry),l.geometry=r.newGeometry),a){if(l.properties=r.removeAllProperties?{}:Object.assign({},l.properties||{}),r.removeProperties)for(const e of r.removeProperties)delete l.properties[e];if(r.addOrUpdateProperties)for(const{key:e,value:t}of r.addOrUpdateProperties)l.properties[e]=t}}}(this._dataUpdateable,e,t);const n=Array.from(this._dataUpdateable.values());return this._toFeatureCollection(n)}_filterGeoJSON(e,t){const r=en(t,{type:"boolean","property-type":"data-driven",overridable:!1,transition:!1});if("error"===r.result)throw new Error(r.value.map((e=>`${e.key}: ${e.message}`)).join(", "));const n=e.features.filter((e=>r.value.evaluate({zoom:0},e)));return this._toFeatureCollection(n)}_toFeatureCollection(e){return{type:"FeatureCollection",features:e}}removeSource(t){return e(this,void 0,void 0,(function*(){this._pendingRequest&&this._pendingRequest.abort()}))}getClusterExpansionZoom(e){return this._geoJSONIndex.getClusterExpansionZoom(e.clusterId)}getClusterChildren(e){return this._geoJSONIndex.getChildren(e.clusterId)}getClusterLeaves(e){return this._geoJSONIndex.getLeaves(e.clusterId,e.limit,e.offset)}}function Cd(e,t){return t.cluster?new Zf(function({superclusterOptions:e,clusterProperties:t}){if(!t||!e)return e;const r={},n={},i={accumulated:null,zoom:0},s={properties:null},o=Object.keys(t);for(const e of o){const[i,s]=t[e],o=en(s),a=en("string"==typeof i?[i,["accumulated"],["get",e]]:i);r[e]=o.value,n[e]=a.value}return e.map=e=>{s.properties=e;const t={};for(const e of o)t[e]=r[e].evaluate(i,s);return t},e.reduce=(e,t)=>{s.properties=t;for(const t of o)i.accumulated=e[t],e[t]=n[t].evaluate(i,s)},e}(t)).load(e.features):function(e,t){return new Dd(e,t)}(e,t.geojsonVtOptions)}class Vd{constructor(t){this.self=t,this.actor=new bi(t),this.layerIndexes={},this.availableImages={},this.workerSources={},this.demWorkerSources={},this.externalWorkerSourceTypes={},this.globalStates=new Map,this.self.registerWorkerSource=(e,t)=>{if(this.externalWorkerSourceTypes[e])throw new Error(`Worker source with name "${e}" already registered.`);this.externalWorkerSourceTypes[e]=t},this.self.addProtocol=si,this.self.removeProtocol=oi,this.self.registerRTLTextPlugin=e=>{qi.setMethods(e)},this.actor.registerMessageHandler("LDT",((e,t)=>this._getDEMWorkerSource(e,t.source).loadTile(t))),this.actor.registerMessageHandler("RDT",((t,r)=>e(this,void 0,void 0,(function*(){this._getDEMWorkerSource(t,r.source).removeTile(r)})))),this.actor.registerMessageHandler("GCEZ",((t,r)=>e(this,void 0,void 0,(function*(){return this._getWorkerSource(t,r.type,r.source).getClusterExpansionZoom(r)})))),this.actor.registerMessageHandler("GCC",((t,r)=>e(this,void 0,void 0,(function*(){return this._getWorkerSource(t,r.type,r.source).getClusterChildren(r)})))),this.actor.registerMessageHandler("GCL",((t,r)=>e(this,void 0,void 0,(function*(){return this._getWorkerSource(t,r.type,r.source).getClusterLeaves(r)})))),this.actor.registerMessageHandler("LD",((e,t)=>this._getWorkerSource(e,t.type,t.source).loadData(t))),this.actor.registerMessageHandler("GD",((e,t)=>this._getWorkerSource(e,t.type,t.source).getData())),this.actor.registerMessageHandler("LT",((e,t)=>this._getWorkerSource(e,t.type,t.source).loadTile(t))),this.actor.registerMessageHandler("RT",((e,t)=>this._getWorkerSource(e,t.type,t.source).reloadTile(t))),this.actor.registerMessageHandler("AT",((e,t)=>this._getWorkerSource(e,t.type,t.source).abortTile(t))),this.actor.registerMessageHandler("RMT",((e,t)=>this._getWorkerSource(e,t.type,t.source).removeTile(t))),this.actor.registerMessageHandler("RS",((t,r)=>e(this,void 0,void 0,(function*(){if(!this.workerSources[t]||!this.workerSources[t][r.type]||!this.workerSources[t][r.type][r.source])return;const e=this.workerSources[t][r.type][r.source];delete this.workerSources[t][r.type][r.source],void 0!==e.removeSource&&e.removeSource(r)})))),this.actor.registerMessageHandler("RM",(t=>e(this,void 0,void 0,(function*(){delete this.layerIndexes[t],delete this.availableImages[t],delete this.workerSources[t],delete this.demWorkerSources[t],this.globalStates.delete(t)})))),this.actor.registerMessageHandler("SR",((t,r)=>e(this,void 0,void 0,(function*(){this.referrer=r})))),this.actor.registerMessageHandler("SRPS",((e,t)=>this._syncRTLPluginState(e,t))),this.actor.registerMessageHandler("IS",((t,r)=>e(this,void 0,void 0,(function*(){this.self.importScripts(r)})))),this.actor.registerMessageHandler("SI",((e,t)=>this._setImages(e,t))),this.actor.registerMessageHandler("UL",((t,r)=>e(this,void 0,void 0,(function*(){this._getLayerIndex(t).update(r.layers,r.removedIds,this._getGlobalState(t))})))),this.actor.registerMessageHandler("UGS",((t,r)=>e(this,void 0,void 0,(function*(){const e=this._getGlobalState(t);for(const t in r)e[t]=r[t]})))),this.actor.registerMessageHandler("SL",((t,r)=>e(this,void 0,void 0,(function*(){this._getLayerIndex(t).replace(r,this._getGlobalState(t))}))))}_getGlobalState(e){let t=this.globalStates.get(e);return t||(t={},this.globalStates.set(e,t)),t}_setImages(t,r){return e(this,void 0,void 0,(function*(){this.availableImages[t]=r;for(const e in this.workerSources[t]){const n=this.workerSources[t][e];for(const e in n)n[e].availableImages=r}}))}_syncRTLPluginState(t,r){return e(this,void 0,void 0,(function*(){return yield qi.syncState(r,this.self.importScripts)}))}_getAvailableImages(e){let t=this.availableImages[e];return t||(t=[]),t}_getLayerIndex(e){let t=this.layerIndexes[e];return t||(t=this.layerIndexes[e]=new Ep),t}_getWorkerSource(e,t,r){if(this.workerSources[e]||(this.workerSources[e]={}),this.workerSources[e][t]||(this.workerSources[e][t]={}),!this.workerSources[e][t][r]){const n={sendAsync:(t,r)=>(t.targetMapId=e,this.actor.sendAsync(t,r))};switch(t){case"vector":this.workerSources[e][t][r]=new Bf(n,this._getLayerIndex(e),this._getAvailableImages(e));break;case"geojson":this.workerSources[e][t][r]=new Bd(n,this._getLayerIndex(e),this._getAvailableImages(e));break;default:this.workerSources[e][t][r]=new this.externalWorkerSourceTypes[t](n,this._getLayerIndex(e),this._getAvailableImages(e))}}return this.workerSources[e][t][r]}_getDEMWorkerSource(e,t){return this.demWorkerSources[e]||(this.demWorkerSources[e]={}),this.demWorkerSources[e][t]||(this.demWorkerSources[e][t]=new Cf),this.demWorkerSources[e][t]}}return b(self)&&(self.worker=new Vd(self)),Vd}();
//# sourceMappingURL=maplibre-gl-csp-worker.js.map
