const API_BASE_URL = 'http://localhost:8090';

export interface VisitSchedule {
  id: number;
  user_id: string;
  property_id: number;
  status: 'pending' | 'admin_approved' | 'seller_approved' | 'admin_rejected' | 'seller_rejected' | 'approved' | 'rejected' | 'scheduled' | 'confirmed' | 'completed' | 'cancelled' | 'rescheduled';
  created_at: string;
  updated_at: string;
  full_name: string;
  email: string;
  mobile: string;
  preferred_contact: string;
  buyer_type: string;
  preferred_date: string;
  preferred_time: string;
  alternate_date?: string;
  alternate_time?: string;
  number_of_visitors: number;
  visit_mode: string;
  pickup_assistance: boolean;
  visit_reason: string;
  comments: string;
  id_document?: string;
  property_title: string;
  property_address: string;
  property_city: string;
}

export interface VisitSchedulesResponse {
  visits: VisitSchedule[];
  total_count: number;
  page: number;
  limit: number;
}

export const getAdminVisitSchedules = async (
  page: number = 1,
  limit: number = 10,
  status?: string
): Promise<VisitSchedulesResponse> => {
  const token = localStorage.getItem('access_token');
  const params = new URLSearchParams({
    page: page.toString(),
    limit: limit.toString(),
    ...(status && { status })
  });

  const response = await fetch(`${API_BASE_URL}/api/admin/visit-schedules?${params}`, {
    headers: {
      'Authorization': `Bearer ${token}`,
      'Content-Type': 'application/json'
    }
  });

  if (!response.ok) throw new Error('Failed to fetch visit schedules');
  return response.json();
};

export const approveVisitSchedule = async (visitId: number): Promise<VisitSchedule> => {
  const token = localStorage.getItem('access_token');
  
  const response = await fetch(`${API_BASE_URL}/api/admin/visit-schedules/${visitId}/approve`, {
    method: 'POST',
    headers: {
      'Authorization': `Bearer ${token}`,
      'Content-Type': 'application/json'
    }
  });

  if (!response.ok) throw new Error('Failed to approve visit schedule');
  return response.json();
};

export const rejectVisitSchedule = async (visitId: number): Promise<VisitSchedule> => {
  const token = localStorage.getItem('access_token');
  
  const response = await fetch(`${API_BASE_URL}/api/admin/visit-schedules/${visitId}/reject`, {
    method: 'POST',
    headers: {
      'Authorization': `Bearer ${token}`,
      'Content-Type': 'application/json'
    }
  });

  if (!response.ok) throw new Error('Failed to reject visit schedule');
  return response.json();
};