const API_BASE = 'http://localhost:8090/api';

const getHeaders = () => {
  const token = localStorage.getItem('access_token');
  return {
    'Content-Type': 'application/json',
    ...(token && { 'Authorization': `Bearer ${token}` })
  };
};

export const agreementsApi = {
  getTemplates: async (templateType?: string) => {
    const url = templateType 
      ? `${API_BASE}/agreements/templates?template_type=${templateType}`
      : `${API_BASE}/agreements/templates`;
    const response = await fetch(url, { headers: getHeaders() });
    if (!response.ok) throw new Error('Failed to fetch templates');
    return response.json();
  },

  create: async (data: any) => {
    const response = await fetch(`${API_BASE}/agreements/`, {
      method: 'POST',
      headers: getHeaders(),
      body: JSON.stringify(data)
    });
    if (!response.ok) throw new Error('Failed to create agreement');
    return response.json();
  },

  list: async (params?: any) => {
    const queryParams = new URLSearchParams(params).toString();
    const response = await fetch(`${API_BASE}/agreements/?${queryParams}`, {
      headers: getHeaders()
    });
    if (!response.ok) throw new Error('Failed to fetch agreements');
    return response.json();
  },

  getById: async (id: string) => {
    const response = await fetch(`${API_BASE}/agreements/${id}`, {
      headers: getHeaders()
    });
    if (!response.ok) throw new Error('Failed to fetch agreement');
    return response.json();
  },

  approve: async (id: string, data: { status: string; comments?: string }) => {
    const response = await fetch(`${API_BASE}/agreements/${id}/approve`, {
      method: 'POST',
      headers: getHeaders(),
      body: JSON.stringify(data)
    });
    if (!response.ok) throw new Error('Failed to approve agreement');
    return response.json();
  },

  getApprovals: async (id: string) => {
    const response = await fetch(`${API_BASE}/agreements/${id}/approvals`, {
      headers: getHeaders()
    });
    if (!response.ok) throw new Error('Failed to fetch approvals');
    return response.json();
  }
};
