import axios from 'axios';

const API_BASE_URL = import.meta.env.VITE_API_BASE_URL || 'http://localhost:8090';

export interface ARAsset {
  id: string;
  name: string;
  category: string;
  sub_category: string | null;
  storage_key: string;
  file_url: string;
  default_scale: number[];
  real_world_unit: string;
  real_width: number;
  real_height: number;
  real_depth: number;
  placement_type: 'floor' | 'wall' | 'ceiling' | 'tabletop' | 'floating';
  thumbnail_url: string | null;
  rotation_locked: boolean;
  is_active: boolean;
  created_at: string;
}

export const arAssetsApi = {
  getAll: async (category?: string): Promise<ARAsset[]> => {
    const params = category ? { category } : {};
    const response = await axios.get(`${API_BASE_URL}/api/ar/assets`, { params });
    return response.data;
  },

  getById: async (id: string): Promise<ARAsset> => {
    const response = await axios.get(`${API_BASE_URL}/api/ar/assets/${id}`);
    return response.data;
  }
};
