import { api } from './client';

export interface BuyerRecommendationRequest {
  budget: number;
  city?: string;
  locality: string;
  min_size: number;
  max_size: number;
  property_types?: string[];
  listing_types?: string[];
  radius_km?: number;
  bedrooms?: string;
  bathrooms?: string;
  furnishing?: string;
  age_of_property?: string;
  possession?: string;
  facing?: string;
  parking?: string;
  gated_community?: string;
  amenities?: string[];
  include_facilities?: boolean;
  include_locality_intel?: boolean;
}

export interface FacilityItem {
  name?: string;
  category?: string;
  latitude?: number;
  longitude?: number;
  distance_km?: number;
}

export interface FacilityGroup {
  category: string;
  count: number;
  items: FacilityItem[];
}

export interface MapTileConfig {
  primary: string;
  fallback_1: string;
  fallback_2: string;
  attribution: string;
}

export interface PropertySummary {
  id?: number;
  title?: string;
  city?: string;
  locality?: string;
  property_type?: string;
  listing_type?: string;
  price?: number;
  size_sqft?: number;
  latitude?: number;
  longitude?: number;
  amenities?: string[];
  distance_km?: number;
  score?: number;
}

export interface RecommendationGroup {
  property_type: string;
  count: number;
  properties: PropertySummary[];
}

export interface RecommendationsBlock {
  total_count: number;
  groups: RecommendationGroup[];
  radius_used?: number | null;
  radius_requested?: number | null;
  search_expanded?: boolean;
  expansion_message?: string | null;
}

export interface BuyerRecommendationResponse {
  input: Record<string, any>;
  matched_locality: {
    input_locality: string;
    matched_locality?: string | null;
    match_type: string;
    candidate_localities: string[];
    zone?: string | null;
    latitude?: number | null;
    longitude?: number | null;
  };
  affordability_current: {
    label: string;
    is_affordable: boolean;
    avg_psf?: number | null;
    max_affordable_area?: number | null;
    min_budget_needed?: number | null;
    budget_gap?: number | null;
  };
  affordability_future: {
    label: string;
    is_affordable: boolean;
    avg_psf?: number | null;
    max_affordable_area?: number | null;
    min_budget_needed?: number | null;
    budget_gap?: number | null;
  };
  market_forecast: {
    current_psf?: number | null;
    predicted_future_psf?: number | null;
    appreciation_rate?: number | null;
    forecast_status?: string | null;
  };
  exact_results: RecommendationsBlock;
  nearby_results: RecommendationsBlock;
  reason_if_no_match?: string | null;
  locality_intel?: {
    avg_price_per_sqft?: number | null;
    min_price_per_sqft?: number | null;
    max_price_per_sqft?: number | null;
    demand_level?: string | null;
    supply_level?: string | null;
    rental_yield?: number | null;
    total_properties?: number | null;
    trend?: string | null;
  } | null;
  facilities: FacilityGroup[];
  map_tile_config?: MapTileConfig | null;
  rag_summary: string[];
  generated_at: string;
}

export async function fetchBuyerRecommendations(
  payload: BuyerRecommendationRequest
): Promise<BuyerRecommendationResponse> {
  const response = await api.post<BuyerRecommendationResponse>('/buyer-recommendations/', payload);
  return response.data;
}
