import axios from 'axios';

const API_URL = 'http://localhost:8090/api/user-account';

export interface EmailChangeRequest {
  new_email: string;
}

export interface EmailChangeResponse {
  success: boolean;
  message: string;
}

export const changeEmail = async (newEmail: string): Promise<EmailChangeResponse> => {
  const token = localStorage.getItem('token');
  const response = await axios.post<EmailChangeResponse>(
    `${API_URL}/change-email`,
    { new_email: newEmail },
    { headers: { Authorization: `Bearer ${token}` } }
  );
  return response.data;
};

export const verifyEmailChange = async (token: string): Promise<EmailChangeResponse> => {
  const response = await axios.post<EmailChangeResponse>(
    `${API_URL}/verify-email`,
    { token }
  );
  return response.data;
};
