const API_BASE = 'http://localhost:8090/api';

const getHeaders = () => {
  const token = localStorage.getItem('access_token');
  return {
    'Content-Type': 'application/json',
    ...(token && { 'Authorization': `Bearer ${token}` })
  };
};

export const escrowApi = {
  create: async (data: any) => {
    const response = await fetch(`${API_BASE}/escrow/`, {
      method: 'POST',
      headers: getHeaders(),
      body: JSON.stringify(data)
    });
    if (!response.ok) throw new Error('Failed to create escrow');
    return response.json();
  },

  list: async (params?: any) => {
    const queryParams = new URLSearchParams(params).toString();
    const response = await fetch(`${API_BASE}/escrow/?${queryParams}`, {
      headers: getHeaders()
    });
    if (!response.ok) throw new Error('Failed to fetch escrow accounts');
    return response.json();
  },

  getById: async (id: string) => {
    const response = await fetch(`${API_BASE}/escrow/${id}`, {
      headers: getHeaders()
    });
    if (!response.ok) throw new Error('Failed to fetch escrow');
    return response.json();
  },

  deposit: async (id: string, data: { amount: number; payment_method: string; transaction_id?: string }) => {
    const response = await fetch(`${API_BASE}/escrow/${id}/deposit`, {
      method: 'POST',
      headers: getHeaders(),
      body: JSON.stringify(data)
    });
    if (!response.ok) throw new Error('Failed to deposit to escrow');
    return response.json();
  },

  release: async (id: string, data: { release_to: string; amount?: number; reason: string }) => {
    const response = await fetch(`${API_BASE}/escrow/${id}/release`, {
      method: 'POST',
      headers: getHeaders(),
      body: JSON.stringify(data)
    });
    if (!response.ok) throw new Error('Failed to release escrow');
    return response.json();
  },

  refund: async (id: string, reason: string) => {
    const response = await fetch(`${API_BASE}/escrow/${id}/refund?reason=${encodeURIComponent(reason)}`, {
      method: 'POST',
      headers: getHeaders()
    });
    if (!response.ok) throw new Error('Failed to refund escrow');
    return response.json();
  },

  approve: async (id: string) => {
    const response = await fetch(`${API_BASE}/escrow/${id}/approve`, {
      method: 'POST',
      headers: getHeaders()
    });
    if (!response.ok) throw new Error('Failed to approve escrow');
    return response.json();
  },

  reject: async (id: string, reason: string) => {
    const response = await fetch(`${API_BASE}/escrow/${id}/reject`, {
      method: 'POST',
      headers: getHeaders(),
      body: JSON.stringify({ reason })
    });
    if (!response.ok) throw new Error('Failed to reject escrow');
    return response.json();
  }
};
