// src/api/legalAiApi.ts

export interface LegalQuestionRequest {
  question: string;
  property_type?: string;
  location?: string;
  user_id?: string;
}

export interface LegalAdviceResponse {
  success: boolean;
  advice: string;
  question: string;
  model_used: string;
}

export const legalAiApi = {
  askLegalQuestion: async (data: LegalQuestionRequest): Promise<LegalAdviceResponse> => {
    try {
      console.log('🤖 Sending legal AI request:', data);
      
      const response = await fetch('/api/legal-ai/ask-legal-question', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
          'Accept': 'application/json',
        },
        body: JSON.stringify(data),
        mode: 'cors',
        credentials: 'omit'
      });

      console.log('📥 Legal AI response status:', response.status, response.statusText);

      if (response.ok) {
        const result = await response.json();
        console.log('✅ Legal AI success:', result);
        
        // Convert **text** to <strong>text</strong>
        if (result.advice) {
          result.advice = result.advice.replace(/\*\*(.*?)\*\*/g, '<strong>$1</strong>');
        }
        
        return result;
      } else {
        const errorText = await response.text();
        console.error('❌ Legal AI API Error:', response.status, errorText);
        throw new Error(`API Error: ${response.status} - ${errorText}`);
      }
    } catch (error) {
      console.error('❌ Legal AI Network Error:', error);
      throw error; // Re-throw to let the component handle it
    }
  }
};