import axios from 'axios';

const API_BASE_URL = import.meta.env.VITE_API_BASE_URL || 'http://localhost:8090';

export const ownerKYCApi = {
  uploadKYCDocument: async (file: File, docType: string, userId: string) => {
    const formData = new FormData();
    formData.append('file', file);
    formData.append('doc_type', docType);
    formData.append('user_id', userId);

    const token = localStorage.getItem('token') || localStorage.getItem('access_token');
    
    try {
      const response = await axios.post(`${API_BASE_URL}/api/owner-kyc/upload-document`, formData, {
        headers: {
          'Authorization': `Bearer ${token}`,
          'Content-Type': 'multipart/form-data'
        }
      });
      
      return { success: true, data: response.data };
    } catch (error: any) {
      throw new Error(error.response?.data?.detail || 'Upload failed');
    }
  },

  submitKYC: async (formData: any) => {
    const token = localStorage.getItem('token') || localStorage.getItem('access_token');
    
    try {
      const response = await axios.post(`${API_BASE_URL}/api/owner-kyc/submit`, formData, {
        headers: {
          'Authorization': `Bearer ${token}`,
          'Content-Type': 'application/json'
        }
      });
      
      return response.data;
    } catch (error: any) {
      throw new Error(error.response?.data?.detail || 'Submission failed');
    }
  }
};