import axios from 'axios';

const API_BASE = import.meta.env.VITE_API_BASE || 'http://localhost:8090';

const getAuthHeaders = () => {
  const token = localStorage.getItem('sellerToken') || localStorage.getItem('agentToken');
  return token ? { 'Authorization': `Bearer ${token}` } : {};
};

export const pricingApi = {
  generateRecommendation: async (propertyId: number) => {
    const response = await axios.post(`${API_BASE}/api/pricing/recommendation/${propertyId}`, {}, {
      headers: getAuthHeaders()
    });
    return response.data;
  },

  getRecommendations: async (propertyId: number, limit = 10) => {
    const response = await axios.get(`${API_BASE}/api/pricing/recommendation/${propertyId}`, {
      params: { limit },
      headers: getAuthHeaders()
    });
    return response.data;
  },

  acceptRecommendation: async (recommendationId: number) => {
    const response = await axios.post(`${API_BASE}/api/pricing/recommendation/${recommendationId}/accept`, {}, {
      headers: getAuthHeaders()
    });
    return response.data;
  },

  rejectRecommendation: async (recommendationId: number, reason: string) => {
    const response = await axios.post(`${API_BASE}/api/pricing/recommendation/${recommendationId}/reject`, {
      reason
    }, {
      headers: getAuthHeaders()
    });
    return response.data;
  },

  getSellerRecommendations: async (sellerId: number) => {
    const response = await axios.get(`${API_BASE}/api/pricing/seller/${sellerId}/recommendations`, {
      headers: getAuthHeaders()
    });
    return response.data;
  },

  getBuyerInsights: async (propertyId: number) => {
    const response = await axios.get(`${API_BASE}/api/pricing/property/${propertyId}/buyer-insights`, {
      headers: getAuthHeaders()
    });
    return response.data;
  }
};
