const API_BASE = 'http://localhost:8090/api';

// Public API calls (no authentication required)
export const adminMarketTrendsApi = {
  getPlatformOverview: async () => {
    const response = await fetch(`${API_BASE}/admin_market_trends/platform-overview`, {
      method: 'GET',
      headers: {
        'Content-Type': 'application/json'
      }
    });
    
    if (!response.ok) {
      throw new Error(`Failed to fetch platform overview: ${response.status}`);
    }
    
    return response.json();
  },

  getCityTrends: async () => {
    const response = await fetch(`${API_BASE}/admin_market_trends/city-trends`, {
      method: 'GET',
      headers: {
        'Content-Type': 'application/json'
      }
    });
    
    if (!response.ok) {
      throw new Error(`Failed to fetch city trends: ${response.status}`);
    }
    
    return response.json();
  },

  getDemandSupplyAnalysis: async () => {
    const response = await fetch(`${API_BASE}/admin_market_trends/demand-supply-analysis`, {
      method: 'GET',
      headers: {
        'Content-Type': 'application/json'
      }
    });
    
    if (!response.ok) {
      throw new Error(`Failed to fetch demand supply analysis: ${response.status}`);
    }
    
    return response.json();
  }
};