import { api } from '../client';

export interface UserPreferences {
  id?: number;
  user_id: number;
  budget_min?: number;
  budget_max?: number;
  location?: string[];
  property_types?: string[];
  bedrooms?: string;
  bathrooms?: string;
  timeline?: string;
  purpose?: string;
  furnishing?: string;
  parking?: string;
  amenities?: string[];
  floor_preference?: string;
  facing?: string;
  age_of_property?: string;
  possession?: string;
  created_at?: string;
  updated_at?: string;
}

export const userPreferencesAPI = {
  // Create user preferences
  create: async (preferences: Omit<UserPreferences, 'id' | 'created_at' | 'updated_at'>): Promise<UserPreferences> => {
    const response = await api.post('/user/preferences/', preferences);
    return response.data;
  },

  // Update user preferences
  update: async (preferences: Omit<UserPreferences, 'created_at' | 'updated_at'>): Promise<UserPreferences> => {
    const response = await api.put('/user/preferences/', preferences);
    return response.data;
  },

  // Get user preferences
  get: async (userId: number): Promise<UserPreferences | null> => {
    try {
      const response = await api.get(`/user/preferences/?user_id=${userId}`);
      return response.data;
    } catch (error: any) {
      if (error.response?.status === 404) {
        return null;
      }
      throw error;
    }
  }
};