const API_BASE = import.meta.env.VITE_API_BASE || 'http://localhost:8090/api';

export interface VisitSchedule {
  id: number;
  user_id: string;
  property_id: number;
  status: 'pending' | 'approved' | 'rejected' | 'scheduled' | 'confirmed' | 'completed' | 'cancelled' | 'rescheduled';
  created_at: string;
  updated_at: string;
  full_name: string;
  email: string;
  mobile: string;
  preferred_contact: string;
  buyer_type: string;
  preferred_date: string;
  preferred_time: string;
  alternate_date: string;
  alternate_time: string;
  number_of_visitors: number;
  visit_mode: string;
  pickup_assistance: boolean;
  visit_reason: string;
  comments: string;
  id_document: string;
  property_title: string;
  property_address: string;
  property_city: string;
}

export interface VisitScheduleResponse {
  visits: VisitSchedule[];
  total_count: number;
  page: number;
  limit: number;
}

export const visitScheduleAPI = {
  async getUserVisitSchedules(
    userId: string, 
    page = 1, 
    limit = 10, 
    status?: string
  ): Promise<VisitScheduleResponse> {
    const params = new URLSearchParams({
      user_id: userId,
      page: page.toString(),
      limit: limit.toString()
    });
    
    if (status) {
      params.append('status', status);
    }
    
    const response = await fetch(`${API_BASE}/visit-schedules/?${params}`);
    if (!response.ok) throw new Error('Failed to fetch visit schedules');
    return response.json();
  }
};