const API_BASE = 'http://localhost:8090/api';

export interface WishlistProperty {
  id: string;
  property_id: number;
  saved_at: string;
  property?: {
    id: number;
    title: string;
    location: string;
    beds: number;
    baths: number;
    area: string;
    price: string;
    imageUrl?: string;
    isUrgent?: boolean;
    isBidding?: boolean;
  };
}

export const wishlistAPI = {
  async getWishlist(userId: string): Promise<WishlistProperty[]> {
    const response = await fetch(`${API_BASE}/user-dashboard/wishlist?user_id=${userId}`);
    if (!response.ok) throw new Error('Failed to fetch wishlist');
    return response.json();
  },

  async addToWishlist(userId: string, propertyId: number): Promise<string> {
    const response = await fetch(`${API_BASE}/user-dashboard/wishlist/${propertyId}?user_id=${userId}`, {
      method: 'POST'
    });
    if (!response.ok) throw new Error('Failed to add to wishlist');
    return response.json();
  },

  async removeFromWishlist(userId: string, propertyId: number): Promise<string> {
    const response = await fetch(`${API_BASE}/user-dashboard/wishlist/${propertyId}?user_id=${userId}`, {
      method: 'DELETE'
    });
    if (!response.ok) throw new Error('Failed to remove from wishlist');
    return response.json();
  }
};