import React from 'react';
import { Clock, CheckCircle, XCircle, AlertTriangle } from 'lucide-react';

interface AdminApprovalNoticeProps {
  status?: 'pending' | 'approved' | 'rejected' | 'under_review';
  className?: string;
  showIcon?: boolean;
}

export const AdminApprovalNotice: React.FC<AdminApprovalNoticeProps> = ({ 
  status = 'pending', 
  className = '',
  showIcon = true 
}) => {
  const getStatusConfig = () => {
    switch (status) {
      case 'approved':
        return {
          icon: CheckCircle,
          bgColor: 'bg-green-50',
          borderColor: 'border-green-200',
          iconColor: 'text-green-600',
          textColor: 'text-green-800',
          title: 'Property Approved',
          message: 'Your property has been approved and is now live on the platform.'
        };
      case 'rejected':
        return {
          icon: XCircle,
          bgColor: 'bg-red-50',
          borderColor: 'border-red-200',
          iconColor: 'text-red-600',
          textColor: 'text-red-800',
          title: 'Property Rejected',
          message: 'Your property listing has been rejected. Please check your email for details and resubmit after making necessary changes.'
        };
      case 'under_review':
        return {
          icon: AlertTriangle,
          bgColor: 'bg-yellow-50',
          borderColor: 'border-yellow-200',
          iconColor: 'text-yellow-600',
          textColor: 'text-yellow-800',
          title: 'Under Review',
          message: 'Your property is currently being reviewed by our team. This may take 24-48 hours.'
        };
      default: // pending
        return {
          icon: Clock,
          bgColor: 'bg-blue-50',
          borderColor: 'border-blue-200',
          iconColor: 'text-blue-600',
          textColor: 'text-blue-800',
          title: 'Pending Admin Approval',
          message: 'Your property has been submitted and is awaiting admin approval. You will be notified once it\'s reviewed.'
        };
    }
  };

  const config = getStatusConfig();
  const Icon = config.icon;

  return (
    <div className={`${config.bgColor} ${config.borderColor} border rounded-lg p-4 ${className}`}>
      <div className="flex items-start">
        {showIcon && (
          <Icon className={`w-5 h-5 ${config.iconColor} mt-0.5 mr-3 flex-shrink-0`} />
        )}
        <div className="flex-1">
          <h4 className={`text-sm font-semibold ${config.textColor} mb-1`}>
            {config.title}
          </h4>
          <p className={`text-sm ${config.textColor}`}>
            {config.message}
          </p>
        </div>
      </div>
    </div>
  );
};

export default AdminApprovalNotice;