import React, { useState } from "react";
import { Routes, Route, useNavigate } from "react-router-dom";
import { QueryClient, QueryClientProvider } from "@tanstack/react-query";
import Sidebar from "./agent-dashboard/Sidebar";
import Header from "./agent-dashboard/Header";
import Dashboard from "./agent-dashboard/Dashboard";
import PropertyListings from "./agent-dashboard/PropertyListings";
import ScheduleVisits from "./agent-dashboard/ScheduleVisits";
import CommissionSummary from "./agent-dashboard/CommissionSummary";
import Settings from "./agent-dashboard/Settings";
import Analytics from "./agent-dashboard/Analytics";
import Reports from "./agent-dashboard/Reports";
import Clients from "./agent-dashboard/Clients";
import SupportCenter from "./agent-dashboard/SupportCenter";
import WishlistFavorites from "./agent-dashboard/WishlistFavorites";
import SavedProperties from "./agent-dashboard/SavedProperties";
import Campaigns from "./agent-dashboard/Campaigns";
import Negotiations from "./agent-dashboard/Negotiations";
import NegotiationDetail from "./agent-dashboard/NegotiationDetail";
import { NRIAssistanceAgentEnhanced } from "./agent-dashboard/NRIAssistanceAgentEnhanced";
import { AgentPropertyAnalytics } from "./agent-dashboard/AgentPropertyAnalytics";
import OwnerListingPackages from "./buyer-dashboard/OwnerListingPackages";
import BuyerWallet from "./buyer-dashboard/BuyerWallet";
import MarketAnalysis from "./agent-dashboard/MarketAnalysis";
import DynamicPricing from "./agent-dashboard/DynamicPricing";

import InquiryManagement from "./agent-dashboard/InquiryManagement";
import PropertyVisitRequests from "./agent-dashboard/PropertyVisitRequests";
import AnalyticsMarketInsights from "./agent-dashboard/AnalyticsMarketInsights";

import { PropertyProvider } from "./agent-dashboard/PropertyContext";
import { PricePrediction } from "../pages/price-prediction/PricePrediction";
import { AgentSystemHealth } from "./agent-dashboard/AgentSystemHealth";

const queryClient = new QueryClient({
  defaultOptions: {
    queries: {
      refetchOnWindowFocus: false,
      staleTime: Infinity,
      retry: false,
    },
  },
});

const AgentDashboard: React.FC = () => {
  const navigate = useNavigate();
  const [sidebarCollapsed, setSidebarCollapsed] = useState(false);

  const handleScheduleVisit = () => {
    navigate("/agent/dashboard/visits");
  };

  const handleSidebarToggle = (collapsed: boolean) => {
    setSidebarCollapsed(collapsed);
  };

  return (
    <QueryClientProvider client={queryClient}>
      <PropertyProvider>
        <div className="min-h-screen bg-gray-50">
          <Sidebar collapsed={sidebarCollapsed} onToggle={handleSidebarToggle} />
          <div
            className="min-h-screen bg-gray-50"
            style={{ marginLeft: sidebarCollapsed ? "80px" : "256px" }}
          >
            <Header />
            <main className="p-8">
            <Routes>
              <Route index element={<Dashboard />} />
              <Route
                path="properties"
                element={
                  <PropertyListings onScheduleVisit={handleScheduleVisit} />
                }
              />
              <Route path="campaigns" element={<Campaigns />} />
              <Route path="listing-packages" element={<OwnerListingPackages />} />
              <Route path="saved" element={<SavedProperties />} />
              <Route path="price-prediction" element={<PricePrediction />} />
              <Route path="dynamic-pricing" element={<DynamicPricing />} />
              <Route path="negotiations" element={<Negotiations />} />
              <Route path="negotiation/:id" element={<NegotiationDetail />} />
              <Route path="nri-assistance" element={<NRIAssistanceAgentEnhanced />} />

              <Route path="inquiries" element={<InquiryManagement />} />
              <Route path="visits" element={<ScheduleVisits />} />
              <Route path="reports" element={<Reports />} />
              <Route path="property-analytics" element={<AgentPropertyAnalytics />} />
              <Route path="market-analysis" element={<MarketAnalysis />} />
              <Route path="analytics" element={<AnalyticsMarketInsights />} />
              <Route path="system-health" element={<AgentSystemHealth />} />

              <Route path="earnings" element={<CommissionSummary />} />
              <Route path="wallet" element={<BuyerWallet />} />
              <Route path="profile" element={<Settings />} />
              <Route path="support" element={<SupportCenter />} />
            </Routes>
            </main>
          </div>
        </div>
      </PropertyProvider>
    </QueryClientProvider>
  );
};

export default AgentDashboard;