import React from 'react';
import { useCompare } from '../context/CompareContext';

interface CompareButtonProps {
  propertyId: number;
  variant?: 'card' | 'detail';
}

export const CompareButton: React.FC<CompareButtonProps> = ({ propertyId, variant = 'card' }) => {
  const { isInCompare, addToCompare, removeFromCompare } = useCompare();
  const inCompare = isInCompare(propertyId);

  const handleClick = (e: React.MouseEvent) => {
    e.preventDefault();
    e.stopPropagation();
    if (inCompare) {
      removeFromCompare(propertyId);
    } else {
      addToCompare(propertyId);
    }
  };

  if (variant === 'detail') {
    return (
      <button
        onClick={handleClick}
        className={`px-6 py-3 rounded-lg font-semibold transition-colors flex items-center gap-2 ${
          inCompare
            ? 'bg-green-600 text-white hover:bg-green-700'
            : 'bg-gray-100 text-gray-700 hover:bg-gray-200'
        }`}
      >
        <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2" />
        </svg>
        {inCompare ? 'Added to Compare' : 'Add to Compare'}
      </button>
    );
  }

  return (
    <button
      onClick={handleClick}
      className={`p-2 rounded-lg transition-colors ${
        inCompare
          ? 'bg-green-100 text-green-600 hover:bg-green-200'
          : 'bg-gray-100 text-gray-600 hover:bg-gray-200'
      }`}
      title={inCompare ? 'Remove from compare' : 'Add to compare'}
    >
      <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
        <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2" />
      </svg>
    </button>
  );
};
