import { Button } from "./ui/button";
import { Separator } from "./ui/separator";
import { Facebook, Twitter, Instagram, Linkedin, Youtube, Mail, Phone, MapPin } from "lucide-react";
import logoImage from "../assets/logo.jpg";
import { useNavigate } from "react-router-dom";

export function Footer() {
  const navigate = useNavigate();

  const handleLinkClick = (link: string) => {
    if (link === "About Us") {
      navigate("/about");
    } else if (link === "Contact") {
      navigate("/contact");
    } else if (link === "Privacy Policy") {
      navigate("/privacy-policy");
    } else if (link === "Government Guidelines") {
      navigate("/legal-guidelines");
    } else if (link === "Help Center") {
      navigate("/help-center");
    } else if (link === "Property Search") {
      navigate("/properties");
    } else if (link === "EMI Calculator") {
      navigate("/emi-calculator");
    } else if (link === "+91-8068447416") {
      window.open("tel:+918068447416", "_self");
    } else if (link === "mailto:info@newagelandindia.com") {
      window.open("mailto:info@newagelandindia.com", "_self");
    }
  };

  const footerSections = [
    {
      title: "Company",
      links: ["About Us", "Contact"],
    },
    {
      title: "Tools",
      links: ["EMI Calculator", "Property Search"],
    },
    {
      title: "Support",
      links: ["Help Center", "Privacy Policy", "Government Guidelines"],
    },
  ];

  const cities = [
    "Mumbai", "Delhi", "Bangalore", "Chennai", "Hyderabad", "Pune"
  ];

  const socialLinks = [
    { icon: Facebook, href: "https://www.facebook.com/profile.php?id=61573148077738", name: "Facebook" },
    { icon: Twitter, href: "https://x.com/Alstonair_25", name: "Twitter" },
    { icon: Instagram, href: "https://www.instagram.com/alstonair/", name: "Instagram" },
    { icon: Linkedin, href: "https://www.linkedin.com/company/alstonair-technologies-private-limited/", name: "LinkedIn" },
  ];

  return (
    <footer className="bg-gray-900 text-white">
      {/* Main Footer Content */}
      <div className="w-full px-4 sm:px-6 lg:px-8 py-12">
        <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 max-w-7xl">
          {/* Left Side - NAL India Branding */}
          <div>
            <div className="flex items-center mb-4">
              <div className="w-16 h-16 rounded-lg border-2 border-white flex items-center justify-center mr-4">
                <img
                  src={logoImage}
                  alt="NAL Logo"
                  className="w-12 h-12 rounded object-cover"
                />
              </div>
              <div>
                <h2 className="text-3xl font-bold text-white mb-1">NAL India</h2>
                <div className="flex items-center text-blue-400 text-lg">
                  <span className="mr-2">by</span>
                  <a 
                    href="https://alstonair.com/" 
                    target="_blank" 
                    rel="noopener noreferrer"
                    className="flex items-center hover:text-blue-300 transition-colors underline"
                  >
                    <img 
                      src="/Black.png" 
                      alt="Alstonair Logo" 
                      className="w-6 h-6 mr-2"
                    />
                    Alstonair Technologies
                  </a>
                </div>
              </div>
            </div>
            
            <p className="text-gray-300 text-lg leading-relaxed mb-6">
              India's most trusted property verification and real estate platform. 
              Empowering property decisions with AI-powered document verification 
              and comprehensive market insights.
            </p>
            
            {/* Contact Information */}
            <div className="flex flex-col sm:flex-row gap-4 mb-4">
              <a href="tel:+918068447416" className="flex items-center text-gray-400 hover:text-white transition-colors">
                <Phone className="w-4 h-4 mr-2" />
                <span>+91-8068447416</span>
              </a>
              <a href="mailto:info@nglindia.com" className="flex items-center text-gray-400 hover:text-white transition-colors">
                <Mail className="w-4 h-4 mr-2" />
                <span>info@nglindia.com</span>
              </a>
            </div>
            
            <div className="flex items-start text-gray-400 text-sm mb-4">
              <MapPin className="w-4 h-4 mr-2 mt-0.5 flex-shrink-0" />
              <div>
                <p>#28 Third floor MCHS Layout</p>
                <p>KV Jayaram Road, Jakkur</p>
                <p>Bangalore 560064, India</p>
              </div>
            </div>
            
            {/* Social Media Links */}
            <div className="flex space-x-4">
              {socialLinks.map((social, index) => {
                const getBackgroundColor = (name: string) => {
                  switch (name) {
                    case 'Facebook': return 'bg-blue-600 hover:bg-blue-700';
                    case 'Twitter': return 'bg-sky-500 hover:bg-sky-600';
                    case 'Instagram': return 'bg-gradient-to-r from-purple-500 to-pink-500 hover:from-purple-600 hover:to-pink-600';
                    case 'LinkedIn': return 'bg-blue-700 hover:bg-blue-800';
                    default: return 'bg-gray-600 hover:bg-gray-700';
                  }
                };
                
                return (
                  <a
                    key={index}
                    href={social.href}
                    target="_blank"
                    rel="noopener noreferrer"
                    className={`w-10 h-10 rounded-full flex items-center justify-center transition-all transform hover:scale-110 ${getBackgroundColor(social.name)}`}
                    aria-label={social.name}
                  >
                    <social.icon className="w-5 h-5 text-white" />
                  </a>
                );
              })}
            </div>
          </div>

          {/* Right Side - Footer Links */}
          <div className="grid grid-cols-3 gap-8">
            {footerSections.map((section, index) => (
              <div key={index}>
                <h3 className="font-semibold text-white text-base mb-4">{section.title}</h3>
                <ul className="space-y-2">
                  {section.links.map((link, linkIndex) => (
                    <li key={linkIndex}>
                      <a
                        href="#"
                        className="text-gray-400 hover:text-white transition-colors text-sm cursor-pointer"
                        onClick={(e) => {
                          e.preventDefault();
                          handleLinkClick(link);
                        }}
                      >
                        {link}
                      </a>
                    </li>
                  ))}
                </ul>
              </div>
            ))}
          </div>
        </div>
      </div>

      {/* Bottom Bar */}
      <div className="bg-gray-950 border-t border-gray-800">
        <div className="w-full px-4 sm:px-6 lg:px-8 py-3">
          <div className="flex flex-col md:flex-row items-center justify-between">


            <div className="flex flex-col md:flex-row items-center space-y-1 md:space-y-0 md:space-x-4 text-xs text-gray-400">
              <span>© 2025 NAL India by Alstonair Technologies. All rights reserved.</span>
              <div className="flex space-x-3">
                <a href="#" className="hover:text-white transition-colors">
                  Privacy
                </a>
                <a href="#" className="hover:text-white transition-colors">
                  Terms
                </a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </footer>
  );
}