// Minimal HeatmapLayer component
import React from 'react';

interface HeatmapLayerProps {
  center: { lat: number; lng: number };
  data: Array<{ lat: number; lng: number; value: number }>;
  layerType: string;
  gradient: string[];
  radius: number;
  opacity: number;
  height: string;
}

export const HeatmapLayer: React.FC<HeatmapLayerProps> = ({ 
  center, 
  data, 
  layerType, 
  height 
}) => {
  return (
    <div 
      style={{ height, width: '100%' }} 
      className="bg-gray-100 rounded-lg flex items-center justify-center"
    >
      <div className="text-center text-gray-500">
        <div className="text-sm">Heatmap Layer: {layerType}</div>
        <div className="text-xs">{data.length} data points</div>
      </div>
    </div>
  );
};