import { Card, CardContent } from "./ui/card";
import { Button } from "./ui/button";
import { Badge } from "./ui/badge";
import { Eye, Camera, Smartphone, Play, ArrowRight } from "lucide-react";
import { useNavigate } from "react-router-dom";
import { ScrollFadeIn, ScrollStagger, ScrollStaggerItem } from './ui/ScrollAnimation';


export function ImmersiveExperience() {
  const navigate = useNavigate();

  const handleVirtualTourClick = () => {
    window.open('https://momento360.com/e/u/da0fdbd2a76b4437be1c76d7ee3ff7b9?utm_campaign=embed&utm_source=other&heading=-383.89&pitch=-22.25&field-of-view=75&size=medium&display-plan=true', '_blank');
  };

  const handleARWalkthroughClick = () => {
    navigate('/ar-viewer');
  };

  const handleDroneViewClick = () => {
    navigate('/aerial-view');
  };

  const handleNALStoriesClick = () => {
    navigate('/nal-stories');
  };

  const experiences = [
    {
      title: "360° Virtual Tours",
      description: "Step inside properties from anywhere in the world with our immersive 360° virtual tours. Navigate through rooms, zoom in on details, and get a true feel of the space as if you were physically there. Perfect for remote buyers and initial property screening.",
      icon: Eye,
      image: "https://images.unsplash.com/photo-1560448204-e02f11c3d0e2?w=800&q=80",
      color: "bg-[#0056D2]",
    },
    {
      title: "AR Walkthrough",
      description: "Transform empty spaces into your dream home using augmented reality. Visualize furniture placement, experiment with different color schemes, and see how your belongings would look in real-time. Make confident decisions before you buy or rent.",
      icon: Smartphone,
      image: "https://images.unsplash.com/photo-1622979135225-d2ba269cf1ac?w=800&q=80",
      color: "bg-[#00BFA6]",
    },
    {
      title: "Drone View",
      description: "Get a bird's eye perspective of properties and their surroundings with professional drone footage. Explore the neighborhood, assess proximity to amenities, understand traffic patterns, and evaluate the overall location from an aerial viewpoint.",
      icon: Camera,
      image: "https://images.unsplash.com/photo-1473968512647-3e447244af8f?w=800&q=80",
      color: "bg-purple-600",
    },
    {
      title: "NAL Stories",
      description: "Watch authentic video stories from property owners, residents, and real estate experts. Get insider insights, hear genuine reviews, and discover what makes each property unique through engaging short-form video content.",
      icon: Play,
      image: "https://images.unsplash.com/photo-1560518883-ce09059eeffa?w=800&q=80",
      color: "bg-orange-600",
    },
  ];

  return (
    <section className="py-16 bg-white">
      <div className="w-full px-4 sm:px-6 lg:px-8">
        <ScrollFadeIn>
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">Immersive Property Experience</h2>
            <p className="text-gray-600 max-w-2xl mx-auto">
              Explore properties like never before with cutting-edge technology and immersive experiences
            </p>
          </div>
        </ScrollFadeIn>

        <ScrollStagger className="grid grid-cols-1 md:grid-cols-2 gap-8" staggerDelay={0.15}>
          {experiences.map((experience, index) => (
            <ScrollStaggerItem key={index}>
              <Card key={index} className="group overflow-hidden hover:shadow-xl transition-all duration-300">
              <div className="relative">
                <img
                  src={experience.image}
                  alt={experience.title}
                  className="w-full h-48 object-cover group-hover:scale-105 transition-transform duration-300"
                />
                <div className="absolute inset-0 bg-black/40 group-hover:bg-black/30 transition-colors"></div>
                
                <div className="absolute top-4 left-4">
                  <div className={`${experience.color} p-2 rounded-lg`}>
                    <experience.icon className="w-5 h-5 text-white" />
                  </div>
                </div>
                
                <div className="absolute top-4 right-4">
                  <Badge className="bg-white/90 text-gray-900">New</Badge>
                </div>
                
                <div className="absolute inset-0 flex items-center justify-center opacity-0 group-hover:opacity-100 transition-opacity">
                  <Button 
                    size="lg" 
                    className="bg-white text-gray-900 hover:bg-white/90"
                    onClick={index === 0 ? handleVirtualTourClick : index === 1 ? handleARWalkthroughClick : index === 2 ? handleDroneViewClick : index === 3 ? handleNALStoriesClick : undefined}
                  >
                    <Play className="w-5 h-5 mr-2" />
                    Experience Now
                  </Button>
                </div>
              </div>
              
              <CardContent className="p-6">
                <h3 className="text-xl font-semibold text-gray-900 mb-2">
                  {experience.title}
                </h3>
                <p className="text-gray-600 text-sm leading-relaxed">{experience.description}</p>
              </CardContent>
            </Card>
            </ScrollStaggerItem>
          ))}
        </ScrollStagger>


      </div>
    </section>
  );
}