import React from 'react';
import { PropertyCard } from './PropertyCard';
import { Property } from '../data/properties';

const ListingScoreDemo: React.FC = () => {
  // Sample properties with different levels of completeness
  const demoProperties: Property[] = [
    {
      id: "demo-1",
      title: "Luxury 4BHK Villa with Premium Amenities - Fully Detailed Listing",
      price: "₹2.5 Cr",
      location: "Whitefield, Bangalore",
      beds: 4,
      baths: 4,
      area: "2,800 sq ft",
      image: "https://images.unsplash.com/photo-1600596542815-ffad4c1539a9?w=400",
      images: [
        "https://images.unsplash.com/photo-1600596542815-ffad4c1539a9?w=400",
        "https://images.unsplash.com/photo-1560448204-e02f11c3d0e2?w=400",
        "https://images.unsplash.com/photo-1613977257363-707ba9348227?w=400",
        "https://images.unsplash.com/photo-1600607687939-ce8a6c25118c?w=400",
        "https://images.unsplash.com/photo-1600585154340-be6161a56a0c?w=400"
      ],
      verified: true,
      riblScore: "A+",
      description: "Stunning 4BHK villa with modern architecture, premium finishes, and world-class amenities. Located in the heart of Whitefield with excellent connectivity to IT parks and international airport. Features include modular kitchen, marble flooring, private garden, and 24/7 security. Perfect for families seeking luxury living with all modern conveniences.",
      amenities: [
        "Swimming Pool", "Gymnasium", "24/7 Security", "Covered Parking", 
        "Landscaped Gardens", "Clubhouse", "Children's Play Area", "Power Backup",
        "Water Treatment Plant", "CCTV Surveillance", "Intercom Facility", "Lift"
      ],
      nearbyPlaces: [
        { name: "ITPL Tech Park", distance: "2 km", type: "business" },
        { name: "Phoenix MarketCity", distance: "3 km", type: "shopping" },
        { name: "Columbia Asia Hospital", distance: "1.5 km", type: "hospital" }
      ],
      priceHistory: [
        { month: "Jan", price: 2.3 },
        { month: "Feb", price: 2.4 },
        { month: "Mar", price: 2.5 }
      ],
      agent: {
        name: "Rajesh Kumar",
        rating: 4.8,
        experience: "10 years",
        phone: "+91 98765 43210",
        image: "https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=150&h=150&fit=crop&crop=face"
      },
      specifications: {
        propertyType: "Villa",
        facing: "North-East",
        floor: "Ground + 2 Floors",
        totalFloors: "3 Floors",
        age: "Ready to Move",
        furnishing: "Semi-Furnished",
        parking: 3
      },
      legalInfo: {
        approvals: ["RERA Approved", "Bank Loan Available", "Clear Title", "Khata Certificate"],
        rera: "PRM/KA/RERA/1251/446/PR/010119/002060",
        ownership: "Freehold"
      }
    },
    {
      id: "demo-2",
      title: "2BHK Apartment - Good Details",
      price: "₹85 L",
      location: "Koramangala, Bangalore",
      beds: 2,
      baths: 2,
      area: "1,200 sq ft",
      image: "https://images.unsplash.com/photo-1560448204-e02f11c3d0e2?w=400",
      images: [
        "https://images.unsplash.com/photo-1560448204-e02f11c3d0e2?w=400",
        "https://images.unsplash.com/photo-1600596542815-ffad4c1539a9?w=400"
      ],
      verified: true,
      riblScore: "A",
      description: "Well-maintained 2BHK apartment in prime Koramangala location with good connectivity and basic amenities.",
      amenities: ["Security", "Parking", "Lift", "Power Backup"],
      nearbyPlaces: [
        { name: "Forum Mall", distance: "1 km", type: "shopping" }
      ],
      priceHistory: [
        { month: "Jan", price: 0.8 }
      ],
      agent: {
        name: "Priya Sharma",
        rating: 4.5,
        experience: "5 years",
        phone: "+91 98765 43211",
        image: "https://images.unsplash.com/photo-1494790108755-2616b612b786?w=150&h=150&fit=crop&crop=face"
      },
      specifications: {
        propertyType: "Apartment",
        facing: "South",
        floor: "5th Floor",
        totalFloors: "10 Floors",
        age: "5-10 years",
        furnishing: "Semi-Furnished",
        parking: 1
      },
      legalInfo: {
        approvals: ["RERA Approved"],
        rera: "PRM/KA/RERA/1251/446/PR/010119/002061",
        ownership: "Freehold"
      }
    },
    {
      id: "demo-3",
      title: "Basic Flat",
      price: "₹45 L",
      location: "Bangalore",
      beds: 1,
      baths: 1,
      area: "600 sq ft",
      image: "https://images.unsplash.com/photo-1600585154340-be6161a56a0c?w=400",
      images: ["https://images.unsplash.com/photo-1600585154340-be6161a56a0c?w=400"],
      verified: true,
      riblScore: "B",
      description: "Basic apartment.",
      amenities: ["Security"],
      nearbyPlaces: [],
      priceHistory: [],
      agent: {
        name: "Agent",
        rating: 4.0,
        experience: "2 years",
        phone: "+91 98765 43212",
        image: ""
      },
      specifications: {
        propertyType: "Apartment",
        facing: "",
        floor: "",
        totalFloors: "",
        age: "",
        furnishing: "",
        parking: 0
      },
      legalInfo: {
        approvals: [],
        rera: "",
        ownership: ""
      }
    },
    {
      id: "demo-4",
      title: "Incomplete Listing",
      price: "₹30 L",
      location: "City",
      beds: 1,
      baths: 1,
      area: "500 sq ft",
      image: "",
      images: [],
      verified: false,
      riblScore: "C",
      description: "",
      amenities: [],
      nearbyPlaces: [],
      priceHistory: [],
      agent: {
        name: "",
        rating: 0,
        experience: "",
        phone: "",
        image: ""
      },
      specifications: {
        propertyType: "",
        facing: "",
        floor: "",
        totalFloors: "",
        age: "",
        furnishing: "",
        parking: 0
      },
      legalInfo: {
        approvals: [],
        rera: "",
        ownership: ""
      }
    }
  ];

  return (
    <div className="max-w-7xl mx-auto px-4 py-8">
      <div className="text-center mb-8">
        <h2 className="text-3xl font-bold text-gray-900 mb-4">
          Dynamic Listing Score System
        </h2>
        <p className="text-lg text-gray-600 max-w-3xl mx-auto">
          Our intelligent scoring system evaluates property listings based on completeness of information. 
          More details = higher score = better visibility for your property.
        </p>
      </div>

      <div className="mb-8 bg-blue-50 p-6 rounded-lg">
        <h3 className="text-xl font-semibold text-gray-900 mb-4">How Listing Scores Work:</h3>
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 text-sm">
          <div className="bg-green-100 p-3 rounded">
            <div className="font-semibold text-green-800">80-100 Points</div>
            <div className="text-green-700">Excellent - Complete listing with all details, multiple photos, legal docs</div>
          </div>
          <div className="bg-blue-100 p-3 rounded">
            <div className="font-semibold text-blue-800">60-79 Points</div>
            <div className="text-blue-700">Good - Most details filled, some photos, basic documentation</div>
          </div>
          <div className="bg-yellow-100 p-3 rounded">
            <div className="font-semibold text-yellow-800">40-59 Points</div>
            <div className="text-yellow-700">Average - Basic details, few photos, missing some info</div>
          </div>
          <div className="bg-red-100 p-3 rounded">
            <div className="font-semibold text-red-800">0-39 Points</div>
            <div className="text-red-700">Incomplete - Missing critical details, no photos, poor documentation</div>
          </div>
        </div>
      </div>

      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        {demoProperties.map((property) => (
          <PropertyCard
            key={property.id}
            id={property.id}
            title={property.title}
            location={property.location}
            beds={property.beds}
            baths={property.baths}
            area={property.area}
            price={property.price}
            imageUrl={property.image}
            propertyData={property}
          />
        ))}
      </div>

      <div className="mt-8 bg-gray-50 p-6 rounded-lg">
        <h3 className="text-xl font-semibold text-gray-900 mb-4">Scoring Factors:</h3>
        <div className="grid grid-cols-1 md:grid-cols-2 gap-6 text-sm">
          <div>
            <h4 className="font-semibold text-gray-800 mb-2">Basic Information (20 points)</h4>
            <ul className="text-gray-600 space-y-1">
              <li>• Detailed title (5 pts)</li>
              <li>• Comprehensive description (5 pts)</li>
              <li>• Clear pricing (5 pts)</li>
              <li>• Bedroom/bathroom count (5 pts)</li>
            </ul>
          </div>
          <div>
            <h4 className="font-semibold text-gray-800 mb-2">Property Details (25 points)</h4>
            <ul className="text-gray-600 space-y-1">
              <li>• Area measurements (5 pts)</li>
              <li>• Property specifications (15 pts)</li>
              <li>• Additional details (5 pts)</li>
            </ul>
          </div>
          <div>
            <h4 className="font-semibold text-gray-800 mb-2">Media & Visuals (20 points)</h4>
            <ul className="text-gray-600 space-y-1">
              <li>• Multiple high-quality photos (10 pts)</li>
              <li>• Primary image (4 pts)</li>
              <li>• Videos/virtual tours (6 pts)</li>
            </ul>
          </div>
          <div>
            <h4 className="font-semibold text-gray-800 mb-2">Legal & Documentation (10 points)</h4>
            <ul className="text-gray-600 space-y-1">
              <li>• RERA certification (4 pts)</li>
              <li>• Legal approvals (3 pts)</li>
              <li>• Ownership documents (3 pts)</li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  );
};

export default ListingScoreDemo;