// Example usage of LoadingDots component throughout your app

import React, { useState } from 'react';
import { LoadingDots, useLoadingDots } from './LoadingDots';

// Method 1: Direct component usage
export const ExampleComponent1 = () => {
  const [isLoading, setIsLoading] = useState(false);

  const handleAction = async () => {
    setIsLoading(true);
    // Your async operation
    await new Promise(resolve => setTimeout(resolve, 2000));
    setIsLoading(false);
  };

  return (
    <div>
      <button onClick={handleAction}>Start Loading</button>
      <LoadingDots isVisible={isLoading} />
    </div>
  );
};

// Method 2: Using the hook (recommended)
export const ExampleComponent2 = () => {
  const { isLoading, showLoading, hideLoading, LoadingComponent } = useLoadingDots();

  const handleAction = async () => {
    showLoading();
    // Your async operation
    await new Promise(resolve => setTimeout(resolve, 2000));
    hideLoading();
  };

  return (
    <div>
      <button onClick={handleAction}>Start Loading</button>
      <LoadingComponent />
    </div>
  );
};

// Method 3: With auto-hide after delay
export const ExampleComponent3 = () => {
  const [isLoading, setIsLoading] = useState(false);

  const handleAction = () => {
    setIsLoading(true);
    // LoadingDots will auto-hide after 800ms
  };

  return (
    <div>
      <button onClick={handleAction}>Start Loading</button>
      <LoadingDots 
        isVisible={isLoading} 
        onComplete={() => setIsLoading(false)} 
      />
    </div>
  );
};

// Method 4: For form submissions
export const FormExample = () => {
  const { isLoading, showLoading, hideLoading, LoadingComponent } = useLoadingDots();

  const handleSubmit = async (e: React.FormEvent) => {
    e.preventDefault();
    showLoading();
    
    try {
      // Your form submission logic
      await fetch('/api/submit', { method: 'POST' });
    } finally {
      hideLoading();
    }
  };

  return (
    <form onSubmit={handleSubmit}>
      <input type="text" placeholder="Enter data" />
      <button type="submit">Submit</button>
      <LoadingComponent />
    </form>
  );
};