import React from 'react';
import { MapPin, X } from 'lucide-react';

interface LocationPermissionModalProps {
  isOpen: boolean;
  onAllow: () => void;
  onCancel: () => void;
}

export function LocationPermissionModal({ isOpen, onAllow, onCancel }: LocationPermissionModalProps) {
  if (!isOpen) return null;

  return (
    <div className="fixed inset-0 z-50 flex items-center justify-center">
      {/* Backdrop */}
      <div 
        className="absolute inset-0 bg-black/40 backdrop-blur-sm"
        onClick={onCancel}
      />
      
      {/* Modal */}
      <div className="relative bg-white rounded-2xl shadow-2xl max-w-md w-full mx-4 p-8 animate-in fade-in-0 zoom-in-95 duration-200">
        {/* Close button */}
        <button
          onClick={onCancel}
          className="absolute top-4 right-4 p-2 text-gray-400 hover:text-gray-600 transition-colors rounded-lg hover:bg-gray-100"
        >
          <X className="w-5 h-5" />
        </button>

        {/* Icon and Title */}
        <div className="text-center mb-6">
          <div className="inline-flex items-center justify-center w-16 h-16 bg-gradient-to-br from-[#0056D2] to-[#00BFA6] rounded-full mb-4">
            <MapPin className="w-8 h-8 text-white" />
          </div>
          <h2 className="text-2xl font-semibold text-gray-900 mb-2">
            Enable Location Access
          </h2>
        </div>

        {/* Description */}
        <p className="text-gray-600 text-center leading-relaxed mb-8">
          Allow NAL India to use your location to find verified properties near you. 
          Your location data is used only for this purpose and never stored.
        </p>

        {/* Buttons */}
        <div className="flex flex-col gap-3">
          <button
            onClick={onAllow}
            className="w-full bg-[#0056D2] hover:bg-[#0056D2]/90 text-white font-medium py-3.5 px-6 rounded-xl transition-all duration-200 hover:shadow-lg hover:shadow-[#0056D2]/25"
          >
            Allow Access
          </button>
          <button
            onClick={onCancel}
            className="w-full bg-gray-100 hover:bg-gray-200 text-gray-700 font-medium py-3.5 px-6 rounded-xl transition-colors duration-200"
          >
            Cancel
          </button>
        </div>

        {/* Trust indicator */}
        <div className="flex items-center justify-center gap-2 mt-6 text-xs text-gray-500">
          <div className="w-2 h-2 bg-green-500 rounded-full"></div>
          <span>Secure & Privacy Protected</span>
        </div>
      </div>
    </div>
  );
}