import React, { useState } from 'react';
import { useMediaUpload } from '../hooks/useMediaUpload';

export const MediaUploadExample: React.FC<{ propertyId: string }> = ({ propertyId }) => {
  const { uploading, progress, uploadImages, uploadVideos, uploadDocuments } = useMediaUpload();
  const [selectedFiles, setSelectedFiles] = useState<File[]>([]);

  const handleImageUpload = async () => {
    if (selectedFiles.length === 0) return;
    
    const result = await uploadImages(propertyId, selectedFiles);
    
    if (result.success) {
      console.log('Images uploaded:', result.images);
      setSelectedFiles([]);
    } else {
      console.error('Upload failed:', result.error);
    }
  };

  return (
    <div className="p-4 border rounded-lg">
      <h3 className="text-lg font-semibold mb-4">Upload Media</h3>
      
      <input
        type="file"
        multiple
        accept="image/*"
        onChange={(e) => setSelectedFiles(Array.from(e.target.files || []))}
        className="mb-4"
      />
      
      <button
        onClick={handleImageUpload}
        disabled={uploading || selectedFiles.length === 0}
        className="px-4 py-2 bg-blue-600 text-white rounded disabled:opacity-50"
      >
        {uploading ? `Uploading... ${progress}%` : 'Upload Images'}
      </button>
      
      {selectedFiles.length > 0 && (
        <div className="mt-4">
          <p>Selected files: {selectedFiles.length}</p>
          <ul className="text-sm text-gray-600">
            {selectedFiles.map((file, index) => (
              <li key={index}>{file.name}</li>
            ))}
          </ul>
        </div>
      )}
    </div>
  );
};