import { Card, CardContent, CardHeader, CardTitle } from "./ui/card";
import { FileText, TrendingUp, Shield, MapPin, MessageCircle, CreditCard, Award } from "lucide-react";
import { ScrollFadeIn, ScrollStagger, ScrollStaggerItem } from './ui/ScrollAnimation';

export function NALServices() {
  const features = [
    {
      title: "Instant Document Verification",
      description: "AI-powered verification with government API integration for authentic property documents.",
      icon: FileText,
      iconColor: "text-white",
    },
    {
      title: "Real-Time Valuation",
      description: "Get Fair Market Value (FMV) and Urgent Sale Value (USV) based on latest market trends.",
      icon: TrendingUp,
      iconColor: "text-white",
    },
    {
      title: "Verified Properties",
      description: "Every listing undergoes rigorous verification to ensure complete transparency.",
      icon: Shield,
      iconColor: "text-white",
    },
    {
      title: "Location Intelligence",
      description: "Interactive heatmaps showing demand, price trends, and neighborhood insights.",
      icon: MapPin,
      iconColor: "text-white",
    },
    {
      title: "Smart Communication",
      description: "WhatsApp integration and AI chatbot for instant query resolution.",
      icon: MessageCircle,
      iconColor: "text-gray-900",
    },
    {
      title: "Secure Payments",
      description: "Book with confidence using our secure payment gateway with token protection.",
      icon: CreditCard,
      iconColor: "text-white",
    },
  ];

  return (
    <section className="py-16 bg-gray-50">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <ScrollFadeIn>
          <div className="text-center mb-12">
            <h2 className="text-4xl font-bold text-gray-900 mb-3 flex items-center justify-center gap-3">
              <Award className="w-10 h-10 text-[#0056D2]" />
              Why Choose NAL
            </h2>
            <h3 className="text-xl font-semibold text-gray-700 mb-4">Trust-First Platform Features</h3>
            <p className="text-base text-gray-600 max-w-3xl mx-auto">
              We've reimagined real estate with cutting-edge technology to bring you complete peace of mind.
            </p>
          </div>
        </ScrollFadeIn>

        <ScrollStagger className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6" staggerDelay={0.1}>
          {features.map((feature, index) => (
            <ScrollStaggerItem key={index}>
              <Card className="group relative overflow-hidden hover:shadow-lg transition-all duration-300 h-full bg-white border border-gray-200 rounded-2xl p-6">
                <CardHeader className="p-0 mb-4">
                  {/* Icon with gradient background and effects */}
                  <div className={`${feature.bgColor ? 'bg-gradient-to-br from-teal-500 to-teal-600 shadow-lg shadow-teal-500/30' : 'bg-[#0056D2] shadow-md'} w-16 h-16 rounded-2xl flex items-center justify-center mb-4 group-hover:scale-110 group-hover:shadow-xl transition-all duration-300`}>
                    <feature.icon 
                      className={`w-8 h-8 ${feature.iconColor} drop-shadow-md`} 
                      fill={feature.fillIcon ? "currentColor" : "none"}
                      strokeWidth={feature.fillIcon ? 0 : 2.5}
                    />
                  </div>
                  
                  <CardTitle className="text-xl font-bold text-gray-900 mb-2">
                    {feature.title}
                  </CardTitle>
                </CardHeader>
                
                <CardContent className="p-0">
                  <p className="text-gray-600 text-sm leading-relaxed">
                    {feature.description}
                  </p>
                </CardContent>
              </Card>
            </ScrollStaggerItem>
          ))}
        </ScrollStagger>
      </div>
    </section>
  );
}