import { Navigate } from 'react-router-dom';
// this component doesnt allow to post unless logged in
interface ProtectedRouteProps {
  children: React.ReactNode;
}

export function ProtectedRoute({ children }: ProtectedRouteProps) {
  const accessToken = localStorage.getItem('access_token');
  
  if (!accessToken) {
    return <Navigate to="/signup" replace />;
  }
  
  return <>{children}</>;
}