  const handleSaveSearch = async () => {
    try {
      console.log('Save search clicked');
      console.log('Current filters:', filters);
      
      // Get user ID from localStorage or context
      const userId = localStorage.getItem('userId') || localStorage.getItem('user_id') || 'anonymous';
      
      if (userId === 'anonymous') {
        alert('Please login to save searches for email alerts.');
        return;
      }
      
      // Prepare search data with proper structure
      const searchData = {
        user_id: userId,
        query: filters.search || '',
        filters: {
          city: filters.city || '',
          locality: Array.isArray(filters.locality) ? filters.locality : (filters.locality ? [filters.locality] : []),
          property_type: filters.property_type || '',
          listing_type: filters.listing_type || '',
          bedrooms: filters.bedrooms || '',
          bathrooms: filters.bathrooms || '',
          min_price: filters.min_price || null,
          max_price: filters.max_price || null,
          furnishing: filters.furnishing || '',
          amenities: Array.isArray(filters.amenities) ? filters.amenities : (filters.amenities ? [filters.amenities] : []),
          state: filters.state || 'Karnataka'
        },
        location: filters.city || (Array.isArray(filters.locality) ? filters.locality[0] : filters.locality) || ''
      };
      
      console.log('Sending search data:', searchData);
      
      // Make API call to save search - FIXED: use correct API endpoint
      const response = await fetch('http://localhost:8000/api/search-history/', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify(searchData)
      });
      
      if (response.ok) {
        const result = await response.json();
        console.log('Search saved successfully:', result);
        alert('Search saved! You will receive email notifications when matching properties are posted.');
      } else {
        const error = await response.text();
        console.error('Failed to save search:', response.status, error);
        alert('Failed to save search. Please try again.');
      }
    } catch (error) {
      console.error('Error saving search:', error);
      alert('Error saving search. Please try again.');
    }
  };