// Example: How to integrate BuyerMarketSnapshot into Property Detail Page

import React from 'react';
import { BuyerMarketSnapshot } from './buyer-dashboard/BuyerMarketSnapshot';

interface PropertyDetailPageProps {
  property: {
    id: string;
    title: string;
    price: number;
    locality: string;
    city: string;
  };
}

export const PropertyDetailPage: React.FC<PropertyDetailPageProps> = ({ property }) => {
  return (
    <div className="property-detail-page">
      {/* Property Header */}
      <div className="property-header">
        <h1 className="text-2xl font-bold">{property.title}</h1>
        <div className="property-price text-3xl font-bold text-green-600">
          ₹{(property.price / 100000).toFixed(1)}L
        </div>
      </div>

      {/* 🎯 CRITICAL: Insert BuyerMarketSnapshot immediately below price */}
      <BuyerMarketSnapshot 
        propertyPrice={property.price}
        locality={property.locality}
        city={property.city}
        variant="full"
      />

      {/* Rest of property details */}
      <div className="property-details">
        <div className="property-images">
          {/* Property images */}
        </div>
        
        <div className="property-info">
          {/* Property specifications */}
        </div>
        
        <div className="property-description">
          {/* Property description */}
        </div>
      </div>
    </div>
  );
};

// Example: Integration in Buyer Dashboard (Optional)
export const BuyerDashboardOverview: React.FC = () => {
  const recentlyViewedProperty = {
    price: 7500000,
    locality: "Whitefield",
    city: "Bangalore"
  };

  return (
    <div className="dashboard-overview">
      <h2>Dashboard Overview</h2>
      
      {/* Other dashboard content */}
      
      {/* Optional: Show market snapshot for recently viewed property */}
      <div className="recent-market-context">
        <h3>Recent Property Context</h3>
        <BuyerMarketSnapshot 
          propertyPrice={recentlyViewedProperty.price}
          locality={recentlyViewedProperty.locality}
          city={recentlyViewedProperty.city}
          variant="summary"
        />
      </div>
    </div>
  );
};