import React, { useEffect, useState } from 'react';
import { recaptchaService } from '../services/recaptchaService';

interface RecaptchaProviderProps {
  children: React.ReactNode;
}

export const RecaptchaProvider: React.FC<RecaptchaProviderProps> = ({ children }) => {
  const [isLoaded, setIsLoaded] = useState(false);

  useEffect(() => {
    const initRecaptcha = async () => {
      try {
        await recaptchaService.initialize();
        setIsLoaded(true);
      } catch (error) {
        console.warn('reCAPTCHA initialization failed:', error);
        setIsLoaded(true); // Continue without reCAPTCHA
      }
    };

    initRecaptcha();
  }, []);

  return (
    <>
      {children}
      {/* Disabled reCAPTCHA provider */}
      {/* {recaptchaService.isEnabled() && (
        <div 
          className="grecaptcha-badge" 
          style={{ 
            position: 'fixed', 
            bottom: '20px', 
            right: '20px', 
            zIndex: 1000 
          }}
        />
      )} */}
    </>
  );
};

export default RecaptchaProvider;