import { Card, CardContent, CardHeader, CardTitle } from "./ui/card";
import { Button } from "./ui/button";
import { Badge } from "./ui/badge";
import { Plus, FileCheck, Edit } from "lucide-react";
import { useNavigate } from "react-router-dom";
import { ScrollFadeIn, ScrollScale } from './ui/ScrollAnimation';

export function SellersAgents() {
  const navigate = useNavigate();


  return (
    <section className="py-16 bg-[#F5F5F5]">
      <div className="w-full px-4 sm:px-6 lg:px-8">
        <ScrollFadeIn>
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">For Sellers & Agents</h2>
            <p className="text-gray-600 max-w-2xl mx-auto">
              Powerful tools and services to help you sell properties faster and manage your real estate business efficiently
            </p>
          </div>
        </ScrollFadeIn>

        {/* Main CTA */}
        <ScrollScale delay={0.2}>
          <div className="mb-12">
          <Card className="bg-[#0056D2] text-white overflow-hidden">
            <CardContent className="p-8 md:p-12">
              <div className="grid grid-cols-1 md:grid-cols-2 gap-8 items-center">
                <div>
                  <h3 className="text-3xl font-bold mb-4">Post Your Property for FREE</h3>
                  <p className="text-white/90 mb-6 text-lg">
                    List your property in minutes and reach millions of verified buyers across India
                  </p>
                  <div className="flex flex-col sm:flex-row gap-4">
                    <Button size="lg" className="bg-white text-[#0056D2] hover:bg-white/90 flex-1" onClick={() => navigate('/list-property')}>
                      <Plus className="w-5 h-5 mr-2" />
                      Post Property Free
                    </Button>
                    <Button size="lg" className="bg-white text-[#0056D2] hover:bg-white/90 flex-1">
                      <Edit className="w-5 h-5 mr-2" />
                      Manage Listings
                    </Button>
                  </div>
                </div>
                
                <div className="grid grid-cols-2 gap-4">
                  <div className="bg-white/10 rounded-lg p-4 text-center">
                    <div className="text-2xl font-bold">5M+</div>
                    <div className="text-white/80 text-sm">Active Buyers</div>
                  </div>
                  <div className="bg-white/10 rounded-lg p-4 text-center">
                    <div className="text-2xl font-bold">30 Days</div>
                    <div className="text-white/80 text-sm">Avg. Sale Time</div>
                  </div>
                  <div className="bg-white/10 rounded-lg p-4 text-center">
                    <div className="text-2xl font-bold">₹0</div>
                    <div className="text-white/80 text-sm">Listing Fee</div>
                  </div>
                  <div className="bg-white/10 rounded-lg p-4 text-center">
                    <div className="text-2xl font-bold">99%</div>
                    <div className="text-white/80 text-sm">Success Rate</div>
                  </div>
                </div>
              </div>
            </CardContent>
          </Card>
        </div>
        </ScrollScale>




      </div>
    </section>
  );
}