import React, { useState, useEffect } from 'react';
import { RefreshCw } from 'lucide-react';

interface CaptchaProps {
  onVerify: (isValid: boolean) => void;
}

export function Captcha({ onVerify }: CaptchaProps) {
  const [captchaText, setCaptchaText] = useState('');
  const [userInput, setUserInput] = useState('');

  const generateCaptcha = () => {
    const chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*';
    let result = '';
    for (let i = 0; i < 6; i++) {
      result += chars.charAt(Math.floor(Math.random() * chars.length));
    }
    setCaptchaText(result);
    setUserInput('');
    onVerify(false);
  };

  useEffect(() => {
    generateCaptcha();
  }, []);

  useEffect(() => {
    onVerify(userInput === captchaText);
  }, [userInput, captchaText, onVerify]);

  return (
    <div>
      <label style={{ display: 'block', fontSize: '14px', color: '#4a5568', fontWeight: '600', marginBottom: '8px' }}>
        Security Verification
      </label>
      <div style={{ display: 'flex', gap: '8px', marginBottom: '8px' }}>
        <div style={{
          flex: 1,
          backgroundColor: '#f8fafc',
          border: '2px dashed #e2e8f0',
          borderRadius: '12px',
          padding: '12px',
          textAlign: 'center',
          fontFamily: 'monospace',
          fontSize: '18px',
          fontWeight: 'bold',
          color: '#1a202c',
          userSelect: 'none',
          letterSpacing: '4px'
        }}>
          {captchaText}
        </div>
        <button
          type="button"
          onClick={generateCaptcha}
          style={{
            padding: '12px',
            border: '2px solid #e2e8f0',
            borderRadius: '12px',
            backgroundColor: '#ffffff',
            cursor: 'pointer',
            color: '#4a5568',
            transition: 'all 0.2s',
            display: 'flex',
            alignItems: 'center',
            justifyContent: 'center'
          }}
          title="Refresh captcha"
        >
          <RefreshCw size={16} />
        </button>
      </div>
      <input
        type="text"
        value={userInput}
        onChange={(e) => setUserInput(e.target.value)}
        style={{
          width: '100%',
          height: '56px',
          backgroundColor: '#f8fafc',
          border: `2px solid ${userInput === captchaText && userInput ? '#22c55e' : '#e2e8f0'}`,
          borderRadius: '12px',
          outline: 'none',
          fontSize: '16px',
          color: '#1a202c',
          fontWeight: '500',
          padding: '0 16px',
          letterSpacing: '2px',
          textAlign: 'center'
        }}
        placeholder="Enter the code above"
        maxLength={6}
        required
      />
    </div>
  );
}