import React from 'react';
import { Navigate } from 'react-router-dom';

interface UserRouteProps {
  children: React.ReactNode;
}

export const UserRoute: React.FC<UserRouteProps> = ({ children }) => {
  const accessToken = localStorage.getItem('access_token');
  const isRoleSwitching = sessionStorage.getItem('original_login_role');
  const currentPath = window.location.pathname;
  
  console.log('🔍 UserRoute Debug:', {
    currentPath,
    accessToken: accessToken ? 'EXISTS' : 'MISSING',
    isRoleSwitching: isRoleSwitching ? 'YES' : 'NO',
    tokenLength: accessToken?.length || 0,
    localStorage: Object.keys(localStorage),
    timestamp: new Date().toISOString()
  });
  
  // Allow access if role switching is active
  if (isRoleSwitching) {
    console.log('✅ UserRoute: Role switching active, allowing access to:', currentPath);
    return <>{children}</>;
  }
  
  if (!accessToken) {
    console.log('❌ UserRoute: No access token, redirecting to login from:', currentPath);
    return <Navigate to="/login" replace />;
  }
  
  console.log('✅ UserRoute: Access token found, allowing access to:', currentPath);
  return <>{children}</>;
};