import React from 'react';

interface WinnerAnnouncementProps {
  session: any;
  currentBid: any;
  winnerName?: string;
}

export const WinnerAnnouncement: React.FC<WinnerAnnouncementProps> = ({
  session,
  currentBid,
  winnerName
}) => {
  if (!session || session.status !== 'completed') {
    return null;
  }

  const formatCurrency = (amount: number) => {
    if (amount >= 10000000) return `₹${(amount / 10000000).toFixed(1)} Cr`;
    if (amount >= 100000) return `₹${(amount / 100000).toFixed(1)} L`;
    return `₹${amount.toLocaleString()}`;
  };

  const finalAmount = currentBid?.bid_amount || session.current_highest_bid || 0;
  const displayWinnerName = winnerName || currentBid?.full_name || 'Anonymous Bidder';

  return (
    <div className="bg-gradient-to-r from-green-50 to-emerald-50 border-2 border-green-200 rounded-xl p-6 mb-6">
      <div className="text-center">
        <div className="text-4xl mb-3">🏆</div>
        <h2 className="text-2xl font-bold text-green-800 mb-2">
          Auction Completed!
        </h2>
        <div className="text-lg text-green-700 mb-4">
          <span className="font-semibold">SOLD</span> to <span className="font-bold">{displayWinnerName}</span>
        </div>
        <div className="text-3xl font-bold text-green-600">
          {formatCurrency(finalAmount)}
        </div>
        <p className="text-sm text-green-600 mt-2">
          Final winning bid amount
        </p>
      </div>
    </div>
  );
};