import React from 'react';
import { MapPin, Building, AlertTriangle, CheckCircle } from 'lucide-react';

interface ZoningBadgeProps {
  zoneType?: string;
  complianceStatus?: boolean;
  className?: string;
  size?: 'sm' | 'md' | 'lg';
}

export const ZoningBadge: React.FC<ZoningBadgeProps> = ({
  zoneType,
  complianceStatus,
  className = '',
  size = 'sm'
}) => {
  const getZoneColor = (zone: string) => {
    const colors: Record<string, string> = {
      'residential': 'bg-green-100 text-green-800 border-green-200',
      'commercial': 'bg-blue-100 text-blue-800 border-blue-200',
      'industrial': 'bg-orange-100 text-orange-800 border-orange-200',
      'mixed_use': 'bg-purple-100 text-purple-800 border-purple-200',
      'agricultural': 'bg-yellow-100 text-yellow-800 border-yellow-200'
    };
    return colors[zone?.toLowerCase()] || 'bg-gray-100 text-gray-800 border-gray-200';
  };

  const getSizeClasses = () => {
    switch (size) {
      case 'sm':
        return 'px-2 py-1 text-xs';
      case 'md':
        return 'px-3 py-1.5 text-sm';
      case 'lg':
        return 'px-4 py-2 text-base';
      default:
        return 'px-2 py-1 text-xs';
    }
  };

  if (!zoneType && complianceStatus === undefined) {
    return null;
  }

  return (
    <div className={`inline-flex items-center border rounded-full font-medium ${getZoneColor(zoneType || '')} ${getSizeClasses()} ${className}`}>
      {complianceStatus !== undefined && (
        <span className="mr-1">
          {complianceStatus ? (
            <CheckCircle className="w-3 h-3" />
          ) : (
            <AlertTriangle className="w-3 h-3" />
          )}
        </span>
      )}
      <span className="uppercase tracking-wide">
        {zoneType ? zoneType.replace('_', ' ') : 'Zoning'}
      </span>
    </div>
  );
};