import React, { useState } from 'react';
import { PaymentsTab } from './PaymentsTab';
import { SubscriptionsTab } from './SubscriptionsTab';
import { CreditCard, Users } from 'lucide-react';

export function BillingDashboard() {
  const [activeTab, setActiveTab] = useState<'payments' | 'subscriptions'>('payments');

  return (
    <div className="space-y-6">
      <div className="bg-white shadow-sm border border-gray-200 rounded-lg px-6 py-4">
        <h1 className="text-2xl font-bold text-gray-900">Billing & Subscriptions</h1>
        <p className="text-gray-600 mt-1">Manage payments, subscriptions, and revenue analytics</p>
      </div>

      <div className="bg-white shadow-sm border border-gray-200 rounded-lg">
        <div className="border-b border-gray-200">
          <div className="flex">
            <button
              onClick={() => setActiveTab('payments')}
              className={`flex items-center gap-2 px-6 py-4 font-medium transition-colors relative ${
                activeTab === 'payments'
                  ? 'text-blue-600 border-b-2 border-blue-600'
                  : 'text-gray-600 hover:text-gray-900'
              }`}
            >
              <CreditCard className="w-5 h-5" />
              Payments
            </button>
            <button
              onClick={() => setActiveTab('subscriptions')}
              className={`flex items-center gap-2 px-6 py-4 font-medium transition-colors relative ${
                activeTab === 'subscriptions'
                  ? 'text-blue-600 border-b-2 border-blue-600'
                  : 'text-gray-600 hover:text-gray-900'
              }`}
            >
              <Users className="w-5 h-5" />
              Subscriptions
            </button>
          </div>
        </div>

        <div className="p-6">
          {activeTab === 'payments' ? <PaymentsTab /> : <SubscriptionsTab />}
        </div>
      </div>
    </div>
  );
}
