import React from "react";
import { Card, CardContent, CardHeader, CardTitle } from "../ui/card";
import { Button } from "../ui/button";
import { Badge } from "../ui/badge";
import { 
  Download, FileClock, FileCheck, FileX, ShieldAlert, AlertTriangle
} from "lucide-react";

export function DocumentVerification() {
  return (
    <div className="space-y-6">
      {/* Document Verification Header */}
      <div className="flex items-center justify-between">
        <h1 className="text-2xl font-bold text-gray-900">Document Verification Oversight</h1>
        <div className="flex items-center gap-2">
          <Button variant="outline" size="sm">
            <Download className="w-4 h-4 mr-1" />
            Export Report
          </Button>
        </div>
      </div>

      {/* KPI Cards */}
      <div className="grid grid-cols-1 md:grid-cols-4 gap-4">
        <Card>
          <CardContent className="p-4">
            <div className="flex items-center justify-between">
              <div>
                <p className="text-sm text-gray-600">Pending Docs</p>
                <p className="text-2xl font-bold text-yellow-600">156</p>
              </div>
              <FileClock className="w-8 h-8 text-yellow-500" />
            </div>
          </CardContent>
        </Card>
        <Card>
          <CardContent className="p-4">
            <div className="flex items-center justify-between">
              <div>
                <p className="text-sm text-gray-600">Approved Docs</p>
                <p className="text-2xl font-bold text-green-600">2,847</p>
              </div>
              <FileCheck className="w-8 h-8 text-green-500" />
            </div>
          </CardContent>
        </Card>
        <Card>
          <CardContent className="p-4">
            <div className="flex items-center justify-between">
              <div>
                <p className="text-sm text-gray-600">Rejected Docs</p>
                <p className="text-2xl font-bold text-red-600">89</p>
              </div>
              <FileX className="w-8 h-8 text-red-500" />
            </div>
          </CardContent>
        </Card>
        <Card>
          <CardContent className="p-4">
            <div className="flex items-center justify-between">
              <div>
                <p className="text-sm text-gray-600">Escalations</p>
                <p className="text-2xl font-bold text-orange-600">23</p>
              </div>
              <ShieldAlert className="w-8 h-8 text-orange-500" />
            </div>
          </CardContent>
        </Card>
      </div>

      {/* Alert Banner */}
      <div className="bg-yellow-50 border border-yellow-200 rounded-lg p-4">
        <div className="flex items-center">
          <AlertTriangle className="w-5 h-5 text-yellow-600 mr-2" />
          <p className="text-yellow-800 font-medium">
            20% of documents pending more than 48 hours
          </p>
        </div>
      </div>

      {/* Document Queue Table */}
      <Card>
        <CardHeader>
          <CardTitle>Document Verification Queue</CardTitle>
        </CardHeader>
        <CardContent>
          <div className="overflow-x-auto">
            <table className="w-full">
              <thead className="bg-gray-50">
                <tr>
                  <th className="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">User</th>
                  <th className="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Property ID</th>
                  <th className="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Doc Type</th>
                  <th className="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Upload Date</th>
                  <th className="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                  <th className="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                </tr>
              </thead>
              <tbody className="bg-white divide-y divide-gray-200">
                <tr>
                  <td className="px-4 py-4 whitespace-nowrap text-sm font-medium text-gray-900">John Doe</td>
                  <td className="px-4 py-4 whitespace-nowrap text-sm text-gray-500">#P001</td>
                  <td className="px-4 py-4 whitespace-nowrap text-sm text-gray-500">Sale Deed</td>
                  <td className="px-4 py-4 whitespace-nowrap text-sm text-gray-500">2024-01-20</td>
                  <td className="px-4 py-4 whitespace-nowrap">
                    <Badge className="bg-yellow-100 text-yellow-800">Pending</Badge>
                  </td>
                  <td className="px-4 py-4 whitespace-nowrap text-sm font-medium">
                    <div className="flex gap-2">
                      <Button variant="ghost" size="sm" className="text-green-600">Approve</Button>
                      <Button variant="ghost" size="sm" className="text-red-600">Reject</Button>
                      <Button variant="ghost" size="sm" className="text-orange-600">Flag</Button>
                    </div>
                  </td>
                </tr>
                <tr>
                  <td className="px-4 py-4 whitespace-nowrap text-sm font-medium text-gray-900">Jane Smith</td>
                  <td className="px-4 py-4 whitespace-nowrap text-sm text-gray-500">#P002</td>
                  <td className="px-4 py-4 whitespace-nowrap text-sm text-gray-500">Khata</td>
                  <td className="px-4 py-4 whitespace-nowrap text-sm text-gray-500">2024-01-19</td>
                  <td className="px-4 py-4 whitespace-nowrap">
                    <Badge className="bg-green-100 text-green-800">Approved</Badge>
                  </td>
                  <td className="px-4 py-4 whitespace-nowrap text-sm font-medium">
                    <Button variant="ghost" size="sm">View</Button>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
        </CardContent>
      </Card>
    </div>
  );
}