import React, { useState } from 'react';
import TaxSettingsTable from '../../finance/TaxSettingsTable';

const TaxSettingsPage: React.FC = () => {
    const [rates, setRates] = useState([
        { id: '1', region: 'US-CA', name: 'California Sales Tax', percentage: 7.25, is_active: true },
        { id: '2', region: 'IN-KA', name: 'GST (Karnataka)', percentage: 18.00, is_active: true },
        { id: '3', region: 'GLOBAL', name: 'International VAT', percentage: 0.00, is_active: false },
    ]);

    const handleEdit = (rate: any) => console.log('Edit', rate);
    const handleDelete = (id: string) => console.log('Delete', id);
    const handleToggle = (id: string) => {
        setRates(rates.map(r => r.id === id ? { ...r, is_active: !r.is_active } : r));
    };
    const handleAdd = () => console.log('Add Rate');

    return (
        <div className="p-6 space-y-6 bg-gray-50 min-h-screen">
            <div className="flex justify-between items-center mb-6">
                <div>
                    <h1 className="text-2xl font-bold text-gray-900">Tax Settings</h1>
                    <p className="text-sm text-gray-500">Configure tax rates for different regions.</p>
                </div>
            </div>

            <div className="max-w-4xl">
                <TaxSettingsTable
                    rates={rates}
                    onEdit={handleEdit}
                    onDelete={handleDelete}
                    onToggle={handleToggle}
                    onAdd={handleAdd}
                />
            </div>
        </div>
    );
};

export default TaxSettingsPage;
